/****************************************************************************
**
**  Name:  ldrprog.h
**
**  Description:
**     This is the header file to support the Loader Progress Indicator
**     and Load Information dialogs.  It's mostly from the Microsoft
**     Developer's Network CD example, under the name "zYzgauge".  
**
**  Status:  PRELIMINARY | CODED | REVIEWED | TESTED
**
**  $Log:   S:/tbird/mt2_186/loader/ldrprog.h_v  $
** 
**    Rev 1.1   26 Feb 1997 11:49:50   Judy
** 
**    Rev 1.0   14 Jun 1996 17:25:50   Judy
** Initial revision.
** 
**    Rev 1.0   18 May 1994 16:59:04   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/loader/ldrprog.h_v   1.1   26 Feb 1997 11:49:50   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LDRPROG__
#define __LDRPROG__

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef __LDROBJ__
#include "ldrobj.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/* bilingual... */
#ifdef RC_INVOKED
    #define RCID(id)    id
#else
    #define RCID(id)    MAKEINTRESOURCE(id)
#endif

#define TG_RANGE     100     /* some reasonable range for control*/

#define DLGLOADFILE       201
#define DLGMODULE         202
#define DLGBYTES          203
#define DLGMODULES        204
#define DLGSYMBOLS        205
#define DLGLINES          219
#define DLGBYTESLOADED    206
#define DLGMODULESLOADED  207
#define DLGSYMBOLSLOADED  208
#define DLGSTARTPC        209
#define DLGSTACKBASE      210
#define DLGSTACKSIZE      211
#define DLGSTARTPCNUM     212
#define DLGSTACKBASENUM   213
#define DLGSTACKSIZENUM   214
#define DLGTYPESLOADED    216
#define DLGFUNCSLOADED    218
#define DLGLINESLOADED    220

#define ID_PROGRESS_INC   424
#define ID_PROGRESS_DONE  425
#define ID_PROGRESS_GO    426

/* misc. defines */
#define ICON_TESTG           RCID(10)

#define MENU_TESTG           RCID(20)
#define IDM_TEST_TEST           100
#define IDM_TEST_EXIT           104


/* for the progress dialog box--the gauge control id */
#define DLG_PROGRESS         RCID(500)
#define DLG_TESTG_NAME       "500"
#define IDD_GAUGE            200
#define DLG_LDRINFO          RCID(501)

/* more misc. defines */
#define TG_WINDOW_WIDTH      400
#define TG_WINDOW_HEIGHT     200

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {   

// Export Functions
BOOL FAR PASCAL EXPORT LdrProgressDlgProc(HANDLE, WORD, WORD, LONG lParam);
BOOL FAR PASCAL EXPORT LdrInfoDlgProc(HANDLE, WORD, WORD, LONG);

// Local Function
RETCODE LdrProgressDialog(HWND, FP_LOADPROC);

}
#endif

#endif /* __LDRPROG__ */
/******************************** E O F *************************************/


