/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the PROC.DLL
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_186/proc/libmain.c_v  $
** 
**    Rev 1.0   16 Dec 1996 15:28:08   Judy
** Initial revision.
   
      Rev 1.1   06 May 1993 07:17:14   doug
   add demo version support
   
      Rev 1.0   22 Jul 1992 11:06:12   brucea
   Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/proc/libmain.c_v   1.0   16 Dec 1996 15:28:08   Judy  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

/* Handle of the DLL instance */
PRIVATE HANDLE hLib;

#define MODULE_NAME "proc.dll"

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the BKPTEXEC.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    /* initialize successfully */
    hLib = hInstance;

    ErrInitDLL(MODULE_PROC, MODULE_NAME);  /* set up for error text */

    return(TRUE);
}


/******************************** E O F ***********************************/
