/****************************************************************************
**
**  Name:  symblext.cpp
**
**  Description:
**     Contains Symbol Extended function definitions which handle bulk-data
**     access. 
**
**  Status:  PRELIMINARY | CODED | REVIEWED | TESTED
**
**  $Log:   S:/tbird/mt2_186/symbol/symblext.cpv  $
** 
**    Rev 1.1   26 Feb 1997 11:43:24   Judy
** 
**    Rev 1.1   14 Jan 1997 15:31:46   Judy
** No change.
** 
**    Rev 1.0   14 Jun 1996 16:42:12   Judy
** Initial revision.
** 
**    Rev 1.0   20 Jun 1994 10:55:32   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_186/symbol/symblext.cpv   1.1   26 Feb 1997 11:43:24   Judy  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _SYMBLEXT_
#include "symblext.h"
#endif

#ifndef _LINENUM_
#include "linenum.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
//----------------------------------------------------------------------------
// Symbol Tables
extern MemPool st;       //
extern LinenumTable lt;  // defined in LINENUM.CPP
extern TABLE_OFFSET rootOffset;

//----------------------------------------------------------------------------
// Symbol Statistics 
extern U32 symbolStat[]; // defined in SYMADD.CPP

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
//-----------------------------------------------------------------------------
// SymGetSymStats
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetSymStats(U16 FAR* numModules, U32 FAR* numFunctions, U32 FAR*
               numPublicLabels, U32 FAR* numUserLabels) {
   *numModules      = symbolStat[SYM_MODULE];
   *numFunctions    = symbolStat[SYM_FUNCTION];
   *numPublicLabels = symbolStat[SYM_PUBLIC_LABEL];
   *numUserLabels   = symbolStat[SYM_USER_DEFINED_LABEL];
   return GOOD;
}


//-----------------------------------------------------------------------------
// SymGetSiblingSymbols
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetSiblingSymbols(SYM_DESCRIPTOR      symDesc,
                     SYM_TYPE_TYPE       basicSymType,
                     U16                 numRequested,
                     SYM_DESCRIPTOR FAR* symDescArray,
                     U16 FAR*            numReturned) {

   SYM_DESCRIPTOR headDesc = symDesc;
   HPU8 ptr;

   // Check for valid symbol type currently support by this routine
   if (!((basicSymType == SYM_MODULE) ||
         ((basicSymType == SYM_FUNCTION) && (symDesc != NULL_SYMBOL)) ||
         (basicSymType == SYM_PUBLIC_LABEL) ||
         (basicSymType == SYM_USER_DEFINED_LABEL)))
      return ER_INVALID_SYM_DESCRIPTOR;

   // Process each type of symbol
   switch(basicSymType) {
      case SYM_MODULE :
         // Get the list of modules from it head list
         RETCODE err;
         if ((symDesc == NULL_SYMBOL) &&
             ((err = SymGetModuleListHead(&headDesc)) != GOOD))
            return err;
         break;

      case SYM_PUBLIC_LABEL :
      case SYM_USER_DEFINED_LABEL:
         if (symDesc == NULL_SYMBOL) {
            ptr = st.GetHugeDataPtr(rootOffset);
            headDesc = ((COMMON_BLOCK_HEADER *)ptr)->list.labelListOffset;
         }
         break;
   }

   // make sure the headDesc is ok
   if (!UtilIsValidSymDescriptor(headDesc))
      return ER_INVALID_SYM_DESCRIPTOR;

   ptr = st.GetHugeDataPtr(headDesc);
   *numReturned = 0;

   // whether the numReturned count is excluding the input symbol
   // only count if the symDesc == NULL_SYMBOL
   if (symDesc == NULL_SYMBOL) {
     symDescArray[(*numReturned)] = headDesc;
     ++(*numReturned);
   }
    
   // Retrieve the list of siblings from the headDesc
   SYM_DESCRIPTOR nextSym;
   while (((nextSym = ((COMMON_BLOCK_HEADER *)ptr)->symHeader.symSiblingOffset)
          != NULL_SYMBOL) && ((*numReturned) < numRequested)) {
      symDescArray[(*numReturned)] = nextSym;
      ++(*numReturned);
      ptr = st.GetHugeDataPtr(nextSym);
   }        
   return GOOD;      
}

//-----------------------------------------------------------------------------
// SymGetChildSymbolsOfModule
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetChildSymbolsOfModule(SYM_DESCRIPTOR      moduleDesc,
                           SYM_TYPE_TYPE       basicSymType,
                           U16                 numRequested,
                           SYM_DESCRIPTOR FAR* symDescArray,
                           U16 FAR*            numReturned) {
   RETCODE err;
   SYM_TYPE_TYPE  childType;
   SYM_DESCRIPTOR childDesc, nextChild;

   *numReturned = 0;
   // retrieve the first child <basicSymType> of the <moduleDesc> 
   if ((err = SymGetSymbolChild(moduleDesc, &childType, &childDesc)) != GOOD)
      return err;

   // return error if there is no child in <moduleDesc>
   if (childDesc == NULL_SYMBOL)
      return ER_SYMBOL_NOT_FOUND;

   // traverse the child list until we get the head of <basicSymType>
   while ((childType != basicSymType) && (childDesc != NULL_SYMBOL)) {
      if ((err = SymGetSymbolSibling(childDesc, &childType, &nextChild))
          != GOOD)
         return err;
      childDesc = nextChild;
   }

   // return error if childType is not what we are looking for
   if ((childDesc == NULL_SYMBOL) || (childType != basicSymType))
      return ER_SYMBOL_NOT_FOUND;

   // Save the first child descriptor to list
   symDescArray[0] = childDesc;
   ++(numReturned);

   // call to retrieve the rest of the requested list - increment the array
   U16 count;
   if ((err = SymGetSiblingSymbols(childDesc, basicSymType, numRequested-1,
           (symDescArray+1), &count)) != GOOD)
      return err;

   // update the numReturned with the count
   (*numReturned) += count;

   return GOOD;
}


//-----------------------------------------------------------------------------
// SymGetLineNumbersOfModule
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetLineNumbersOfModule(SYM_DESCRIPTOR          moduleDesc,
                          U16                     numRequested,
                          LINENUM_DESCRIPTOR FAR* lineDescArray,
                          U16 FAR*                numReturned) {

   RETCODE err;
   LINENUM_DESCRIPTOR firstIndex;
   
   *numReturned = 0;
   // test for valid module desc 
   if (!UtilIsValidSymDescriptor(moduleDesc))
      return ER_ADDRESS_NOT_FOUND;

   // Get the first line number index of <moduleDesc>
   if ((err = GetLinenumFirstIndex(moduleDesc, &firstIndex)) != GOOD)
      return err;

   // Save the first index and get the rest
   lineDescArray[0] = firstIndex;
   ++(*numReturned);

   // retrieve the rest of the numRequested line indexes
   U16 count;
   if ((err = SymGetLineNumbersList(moduleDesc, firstIndex, numRequested-1,
          (lineDescArray+1), &count)) != GOOD)
      return err;

   // update the numReturned with the count
   (*numReturned) += count;

   return GOOD;
}

//-----------------------------------------------------------------------------
// SymGetLineNumbersList
//-----------------------------------------------------------------------------
RETCODE EXPORT
SymGetLineNumbersList(SYM_DESCRIPTOR          moduleDesc,
                      LINENUM_DESCRIPTOR      startLineDesc,
                      U16                     numRequested,
                      LINENUM_DESCRIPTOR FAR* lineDescArray,
                      U16 FAR*                numReturned) {

   // call the LinenumTable::GetLineNumbersList() to do the work
   return lt.GetLineNumbersList(moduleDesc,
                                startLineDesc,
                                numRequested,
                                lineDescArray,
                                numReturned);
} 

/********************************** E O F ***********************************/
