/****************************************************************************
**
**  Name:  VARIEEE.H
**
**  Description:  Bitmasks, definitions, to support formatting of IEEE
**    floating point types.
**
**
**  Status:  PRELIMINARY 
**
**  $Log:   S:/tbird/mt2_186/varsrv/varieee.h_v  $
** 
**    Rev 1.0   16 Dec 1996 14:48:10   Judy
** Initial revision.
** 
**    Rev 1.7   16 May 1995 09:43:40   nghia
** Revised format for readability.
** 
**    Rev 1.6   15 Mar 1995 10:10:06   marilyn
** Updated interface to ConvertLongDouble.
** 
**    Rev 1.5   28 Nov 1994 10:05:44   marilyn
** Added X86 floating point support.
** 
**    Rev 1.4   23 Mar 1993 13:44:52   courtney
** Corrected prototype of LongDouble68To86 (U8 *).
** 
**    Rev 1.3   23 Mar 1993 13:16:52   doug
** enable prototype for long double
** 
**    Rev 1.2   16 Mar 1993 14:55:24   courtney
** Added masks for long double display.
** 
**    Rev 1.1   08 Mar 1993 16:43:22   courtney
** Modified max number of characters allowed for entry of floating
** point values, from a ridiculously large number based on number of
** bits, to a more reasonable sized based on 'nibbles' entered.
** 
**    Rev 1.0   26 Feb 1993 16:24:34   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_186/varsrv/varieee.h_v   1.0   16 Dec 1996 14:48:10   Judy  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <float.h>

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define _VARIEEE_

/* Bitmasks for extracting floating point number in IEEE format */
#define FP_SIGN_MASK        0x80000000UL
#define FP_EXPONENT_MASK    0x7F800000UL
#define FP_MANTISSA_MASK    0x007FFFFFUL
#define FP_EXP_BIAS         0x007F
#define FP_LOWBYTE          0x000000FFUL

/* Bitmasks for extracting double in IEEE format (64-bit) */
#define D_SIGN_MASK         0x80
#define D_EXP1_MASK         0x7F
#define D_EXP2_MASK         0xF0
#define D_MANT1_MASK        0x0F
#define D_EXP_BIAS          0x000003FFUL
#define D_NULL_MASK         0x00

/* Bitmasks for extracting long double in IEEE format (96-bit) */
#define LD_SIGN_MASK        0x80
#define LD_EXP1_MASK        0x7F
#define LD_EXP2_MASK        0xFE
#define LD_MANT1_MASK       0x01
#define LD_EXP_BIAS         0x00003FFFUL
#define LD_NULL_MASK        D_NULL_MASK

// Bitmasks for extracting long long double in IEEE format (128-bit) 
// !!! not yet implemented 

// Bitmasks for extracting fast float (Motorola) (32-bit) 
// !!! not yet implmented 

/* Definitions for display format width */
#define F_EXP_DIG          4  // exponent digits with sign 
#define F_DISPLAY          4  // display characters: '.', 'E', trail 'F', null
// Note: for IEEE floats, format precision is:
// 6       +   4       +  4  = 14
#define F_DISPLAY_DIG  FLT_DIG + F_EXP_DIG + F_DISPLAY

#define D_EXP_DIG          5  // exponent digits with sign 
#define D_DISPLAY          4  // display characters: '.', 'E', trail 'D', null
// Note: for IEEE doubles, format precision is:
// 15      +   5       +  4  = 24
#define D_DISPLAY_DIG  DBL_DIG + D_EXP_DIG + D_DISPLAY

// Note: for IEEE doubles, format precision is:
// 19      +   5       +  4  = 28
#define LD_DISPLAY_DIG LDBL_DIG + D_EXP_DIG + D_DISPLAY

                        /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**************************************************************************
**
** ConvertFloat32
**
** Description: Convert buffer containing 32-bit float
**    into value for display (in 8086 byte order)
**
** Parameters:
**    input:
**       U32 x: buffer containing float data
**    output:
**       float *fpValue: float value returned (in 8086 byte order)
**
** Returns:
**    GOOD
**
***************************************************************************/
RETCODE ConvertFloat32(U32 x, float *fpValue);

/**************************************************************************
**
** ConvertDouble64
**
** Description: Convert buffer containing 64-bit double
**    into value for display (in 8086 byte order)
**
** Parameters:
**    input:
**       U8 *x: input buffer
**    output:
**       double *dValue: double value in 8086 byte order
**
** Returns:
**    GOOD
**
***************************************************************************/
RETCODE ConvertDouble64(U8 *x, double *dValue);


/**************************************************************************
**
** ConvertLongDouble
**
** Description: Convert 80 or 96 bit buffer long double
**    into value for display (in 8086 byte order)
**
** Parameters:
**    input:
**       U8 *x: input buffer
**       U32 extendedSize: input buffer size
**    output:
**       long double *dValue: long double value in 8086 byte order
**
** Returns:
**    GOOD
**
***************************************************************************/
RETCODE ConvertLongDouble(U8 *x, U32 extendedSize, long double *ldValue);


/******************************** E O F ***********************************/
