/* class comment */!!

inherit(Window, #SpaPresenter, nil, 2, nil)!!

now(class(SpaPresenter))!!

/* 8/2/1996 9:44 
  Open a new Spa Presenter. 
  Example: open(PeriphPresenter);
*/
Def open(self)
{
   /* the Spa presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(SpaPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a spa window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
   if not(exists(self))
      if not(TheSpaPresenter:=new(SpaPresenter,nil,nil,
            "Spa",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheSpaPresenter));
      setHWnd(TheSpaPresenter,openSpaWindow(SpaLibClass$Inst,
            nil, nil));
      show(TheSpaPresenter,SW_SHOW);
   endif;
   ^TheSpaPresenter;

} !!

/* 8/2/1996 9:43 */

Def exists(self | handle)
{
   if TheSpaPresenter
      handle := existsSpaWindow(SpaLibClass$Inst);
      if handle 
         setHWnd(TheSpaPresenter,handle)
      else
         TheSpaPresenter := nil;
      endif;
   endif;
   ^TheSpaPresenter;
}!!

/* 8/2/1996 9:40 */

Def openWithPosAndState(self, sizeRect, showVal | newHWnd )
{ 
   /* the Spa presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(SpaPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a spa window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
  if not(exists(self))
      if not(TheSpaPresenter := new(SpaPresenter, nil, nil,
            "Spa",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheSpaPresenter));
      if ((newHWnd := openSpaWindow(SpaLibClass$Inst,
            sizeRect, WS_OVERLAPPEDWINDOW)) <> nil) then
         setHWnd(TheSpaPresenter,newHWnd);
         show(TheSpaPresenter,showVal);
      else
         ^nil;
      endif;
   endif;
   ^TheSpaPresenter; 
}!!

now(SpaPresenter)!!

/* 8/2/1996 9:48 */

Def close(self)
{ 
   if (exists(class(self)))
      closeSpaWindow(SpaLibClass$Inst);
      TheSpaPresenter := nil;
   endif;
   ^GOOD;
}!!

/* 8/2/1996 9:47 
 get the location rect of the window and save it to the ini file 
*/
Def saveWindowPos(self keyName| isIconic layout windRect)
{
  if (hWnd = 0)
    ^clearLayoutEntry(Window, asString(keyName));
  endif;    
  /* Save Layout for Spa window:
  ** if the window is an icon - use the previous saved layout
  **    if there is no previous saved lay out set to 0 for default size
  ** else
  **    Get the current window  position to save.
  */

  /* IsIconic returns nonzero if self is minimized */
  if (Call IsIconic(hWnd) = 0) then
    isIconic := 0;
    /* get the location of the current window position */
    Call GetWindowRect(hWnd, windRect := new(Rect));
    if (width(windRect)=0 cand height(windRect)=0)
       isIconic := 2;
    endif;
  else
    /* force the nonzero return to be 1 */
    isIconic := 1;
    if not(windRect := getPos(PreLauncher, asString(keyName))) then
      windRect := init(new(Rect),0,0,0,0);
    endif;      
  endif;

  if (windRect) then   
    layout := new(String, 18);
    if (isIconic = 2)
       layout := " ";
    else
       layout := asString(left(windRect)) + "," + asString(top(windRect)) +
            "," + asString(right(windRect)) + "," +
            asString(bottom(windRect)) + "," + asString(isIconic);
    endif;        
    saveProfileEntry(TheProfileInfoObj, "DefaultLayout", keyName, layout);
  endif;  
  ^GOOD; 
}!!