/* class comment */!!

inherit(Dialog, #MemTestDialog, nil, 2, nil)!!

now(class(MemTestDialog))!!

/* 3/8/1995 9:58 */
Def open(self | dlg)
{
  dlg := new(self);
  setHelpEntry(dlg, HE_DLGR_MEM_SEARCH); /* default */
  ^dlg;
}!!

now(MemTestDialog)!!

/* 3/8/1995 9:58 */
Def setValues(self, newValues)
{
  values := newValues;
  
  ^0;
}
!!

/* 3/8/1995 9:57 */
Def setHelpEntry(self, helpEntry)
{
   hlpEntry := helpEntry;
}!!

/* 3/8/1995 9:57 */
Def initDialog(self, wp, lp)
{
  /* place initial values */
  registerF1Help(CLIULibraryClass$Inst, HI_DLGR_MEM_SEARCH,
     getHWnd(self), hlpEntry);
  if values[0]
    setItemText(self, DLG_MEM_FROM, values[0]);
  endif;
  if values[1]
    setItemText(self, DLG_MEM_TO, values[1]);
  endif;
  if values[2]
    setItemText(self, DLG_MEM_PATTERN, values[2]);
  endif;
  
  /* set item focus */  
  ^1;  /* informs Windows to set focus to tab stop 1 */
}
!!

/* 3/8/1995 9:56 */
Def getValues(self)
{
  ^values;
}
!!

/* 3/8/1995 9:55 */
Def command(self, wp, lp | s1 s2 index)
{
  select
    case wp == IDCANCEL and high(lp) = 0 is
      end(self, IDCANCEL);
    endCase
    case wp == IDHELP 
      is contextNumber(TheHelpObject, hWnd, hlpEntry);
    endCase
    case wp == IDOK and high(lp)= 0 is
      s1 := peelBlanks(getItemText(self, DLG_MEM_FROM));
      if (s1  = "")
        displayFormattedError(ErrorTextLibClass$Inst, 
           ER_ADDRESS_MISSING, FORCE_POPUP, "From", nil, nil);
        setItemFocus(self, DLG_MEM_FROM);
        ^0;
      endif;
      if not(getSymbolicOffset(AddressLibClass$Inst, s1))
        setItemFocus(self, DLG_MEM_FROM);
        ^0;
      endif;
      s2 := peelBlanks(getItemText(self, DLG_MEM_TO));
      if (s2 = "")
        displayFormattedError(ErrorTextLibClass$Inst, 
           ER_ADDRESS_MISSING, FORCE_POPUP, "To", nil, nil);
        setItemFocus(self, DLG_MEM_TO);
        ^0;
      endif;
      if not(getSymbolicOffset(AddressLibClass$Inst, s2))
        setItemFocus(self, DLG_MEM_TO);
        ^0;
      endif;
      
      /* input is acceptable; save previously obtained values, end */
      values[0] := s1;
      values[1] := s2;
      end(self, IDOK);
    endCase
  endSelect;
  ^0;
}!!