/* Event server library */!!

inherit(ProvidedLibs, #EventLib, #(initialized), 2, nil)!!

setClassVars(EventLib, #())!!

now(class(EventLib))!!

/* semiPRIVATE - only called via require(). */
Def provide(self, path)
{ 
  ^initialize( new(self:ancestor), path )
}
!!

now(EventLib)!!

/* 11/14/1996 11:07 */

Def freeEvent(self)
{
    if pcallLock(self)
    then
      break("freeevent");
      lastError := pcall( procs[#EVTFREEEVENT]);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;

}!!

/* 7/29/1996 13:50 */

Def existsEventWindow(self | hWndPtr)
{
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      lastError := pcall( procs[#EVTEXISTSWINDOW], hWndPtr);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    if (longAt(hWndPtr, 0) <> 0)
       ^longAt(hWndPtr, 0);
    endif;
    ^nil;
}!!

/* 7/29/1996 13:50 */

Def openEventWindow(self, rect, style |hWndPtr)
{ 
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      if (rect <> nil)
         lastError := pcall( procs[#EVTOPENWINDOW], 0, left(rect),
              top(rect), width(rect), height(rect), style, 0, hWndPtr);
      else
         lastError := pcall( procs[#EVTOPENWINDOW], 0, 0,
              0, 0, 0, style, 0, hWndPtr);
      endif;
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
    endif;
    /* 04/18/94 - Nghia - only return nil no handle or critical error */
    if ((lastError = ER_PP_WIN_CREATE_FAIL) cor
        (longAt(hWndPtr, 0) = 0)) then
      ^nil;
    endif;
    ^longAt(hWndPtr, 0);

}!!

/* 7/29/1996 13:50 */

Def closeEventWindow(self)
{
    if pcallLock(self)
    then
      lastError := pcall( procs[#EVTCLOSEWINDOW]);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    TheEventPresenter := nil;
    ^TheEventPresenter;
}!!

/* PRIVATE */
Def addImportProcs(self)
{
  add( self, #INITCSERVER, 1, #(0, 0) ) ;
  add( self, #EVTOPENEVENT, 1, #(1, 1) ) ;
  add( self, #EVTCLOSEEVENT, 1, #(1) ) ;
  add( self, #EVTRESTOREEVENTS, 1, #(1) ) ;
  add( self, #EVTSAVEASEVENTS, 1, #(1) ) ;
  add( self, #EVTSETACTIVEEVENT, 1, #(1, 1) ) ;
  add( self, #EVTGETACTIVEEVENT, 1, #(1, 1, 0) ) ;
  add( self, #EVTCLEAREVENT, 1, #(1) ) ;
  add( self, #EVTDELETEEVENT, 1, #(1) ) ;
  add( self, #EVTDELETEALLEVENTS, 1, nil ) ;
  add( self, #EVTSETACTIVEFIELD, 1, #(1, 1) ) ;
  add( self, #EVTGETACTIVEFIELD, 1, #(1, 1, 0) ) ;
  add( self, #EVTSETNOTCONDITION, 1, #(1, 0) ) ;
  add( self, #EVTGETNOTCONDITION, 1, #(1, 1) ) ;
  add( self, #EVTSETENDFUNCTION, 1, #(1, 0) ) ;
  add( self, #EVTGETENDFUNCTION, 1, #(1, 1) ) ;
  add( self, #EVTSETEND, 1, #(1, 1) ) ;
  add( self, #EVTGETEND, 1, #(1, 1, 0) ) ;
  add( self, #EVTSETMASK, 1, #(1, 1) ) ;
  add( self, #EVTGETMASK, 1, #(1, 1, 0) ) ;
  add( self, #EVTSETSTART, 1, #(1, 1) ) ;
  add( self, #EVTGETSTART, 1, #(1, 1, 0) ) ;
  add( self, #EVTSETSTARTANDMASK, 1, #(1, 1) ) ;
  add( self, #EVTGETSTARTANDMASK, 1, #(1, 1, 0) ) ;
  add( self, #EVTNUMDEFINEDEVENTS, 1, #(1, 1) ) ;
  add( self, #EVTGETNEXTEVENT, 1, #(1, 1, 0) ) ;
  add( self, #EVTOPENWINDOW,   1, #(0, 0, 0, 0, 0, 1, 1, 1) ) ;
  add( self, #EVTCLOSEWINDOW,  1, nil ) ;
  add( self, #EVTEXISTSWINDOW, 1, #(1) ) ;
  add( self, #EVTFREEEVENT,  1, nil ) ;
}!!

/* PUBLIC -- create a event instance */
Def eventOpen(self, templateName | aEvent, rc, descriptorPtr) 
{ 
  aEvent := new( Event ) ;
  descriptorPtr := new( Struct, 4 ) ;
  
  if pcallLock(self)
  then
    rc := pcall(procs[#EVTOPENEVENT], descriptorPtr, templateName) ;
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  
  if (rc <> 0)
  then
    ^nil ;
  endif ;
  
  setDescriptor( aEvent, longAt(descriptorPtr, 0) );
  setProcs( aEvent, procs(self) ) ;
  
  ^aEvent
}!!

/* PRIVATE 
   Open and initialize trigger server library & load trigger dll
*/
Def initialize(self, path)
{ 
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;
   ^self ;
}
!!

/* EventLib Class Initialization Code */
