/****************************************************************************
**
**  Name:  dq306.c
**
**  Description:
**     This is a dequeuer for Motorola 68306
**
**
**  Status:
**
**
**  $Header:
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _DAD_SERVER_
#include "dasm.h"
#endif

#ifndef _DAD_DEFINE_
#include "daddef.h"
#endif

#ifndef _DQ306_
#include "dq306.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

//#ifndef _STRING_
//#include "strlib.h"
//#endif

#ifndef _SSHARED_
#include "sshared.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _SDNUM_
#include "sdnum.h"
#endif


#ifndef _TRACE_
#include "trace.h"
#endif

#ifndef __STDIO_H
#include <stdio.h>
#endif

#ifndef __DOS_H
#include <dos.h>
#endif

#include "string.h"

                        /****************************
                         *                          *
                         *     DEFINITIONS          *
                         *                          *
                         ****************************/
#define MAX_READ_FRAME_LEN   0x40 // Read 64 frames data each times.
                        /****************************
                         *                          *
                         *     EXTERNALS            *
                         *                          *
                         ****************************/

extern HANDLE cliServerHandle;

                        /****************************
                         *                          *
                         *     LOCAL VARIABLES      *
                         *                          *
                         ****************************/
//U8 *spaceString[] = {"","UW",  "",  "",  "","SW",  "","AK",
//                     "","UR",  "","UP",  "","SR","SP",  ""};

S8 spaceString[][11] = {"","Data write",  "",  "",  "","Data write",  "","CPU",
                        "","Data read ",  "","UP",  "","Data read ","SP", "CPU"};
PROBE_TYPE gProcessor;

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

/////////////////////// Temporal function of trace //////////////////////////
/** no use **
VOID OutputStringToFile(LPSTR buffer,U16 textLen){
FILE *fStream;

   fStream = fopen("dqstring.log","w");
   fwrite(buffer, textLen, 1, fStream);
   fclose(fStream);
}
** no use **/
                        /****************************
                         *                          *
                         *     EXECUTABLE           *
                         *                          *
                         ****************************/


/****************************************************************************
**
** Name:  AdddqStateTable
**
****************************************************************************/
RETCODE AddDqStateTable(DESCRIPTOR dqStateId,S32 startReadFrame) {
DQ_STATE *dqState;
U32 numGotten;
U16 lp;
RETCODE err;
LPSTR buffer;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   TrcReadFrameSet(dqState->traceId,startReadFrame);
   for (lp = 0; lp < MAX_FRAME_NO; lp++)
      dqState->frameArray[lp].frameNo = 0x7fffffffl;
   if ((err = TrcTraceReadRaw(dqState->traceId,64L,(U32 far *)&numGotten,
             &buffer)) != GOOD) return(err);
   for (lp = 0; lp < numGotten; lp++) {
      _fmemcpy(&(dqState->frameArray[lp]),
             (buffer+lp*TRACE_FRAME_WIDTH),TRACE_FRAME_WIDTH);
   }
   TFree(buffer);
   TrcReadFrameSet(dqState->traceId,startReadFrame);
   dqState->frameStart = dqState->frameArray[0].frameNo;
   dqState->frameEnd = dqState->frameArray[(U16)(numGotten - 1)].frameNo;
   return(GOOD);
}

/****************************************************************************
**
** Name:  CreatedqStateTable // Create Dis-continue Table
**
****************************************************************************/
RETCODE CreateDqStateTable (DESCRIPTOR dqStateId) {
DQ_STATE  *dqState;
S32 curFrame;
U16 tempBuffId;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   TrcReadBufferGet(dqState->traceId,(U16 FAR *)&tempBuffId); // read current buffer ID
   dqState->traceBufId = tempBuffId; // read current buffer ID
   TrcReadFrameGet(dqState->traceId,&curFrame);
   AddDqStateTable(dqStateId,curFrame);

   return(GOOD);
}

/****************************************************************************
**
** Name:  DestroydqStateTable // Create
**
****************************************************************************/
RETCODE DestroyDqStateTable(DESCRIPTOR id) {
DQ_STATE *dqState;
RETCODE err;

   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   if ((err = TFree((LPSTR)dqState)) != GOOD)
      return err;
   return(GOOD);
}

/****************************************************************************
**
** Name:  CheckSpaceType
**
****************************************************************************/
RETCODE CheckSpaceType(SPACE_TYPE spaceType, U16 fcPin) {
   switch (spaceType) {
      case S_PROGRAM :
         if ((fcPin == F_SP) | (fcPin == F_UP)) return(GOOD);
         break;
      case S_DATA :
         if ((fcPin == F_UD) | (fcPin == F_SD) | (fcPin == F_CPU))
            return(GOOD);
         break;
      case S_DONT_CARE :
         return(GOOD);
      default :
         return(!GOOD);
   }
   return(!GOOD);
}
/****************************************************************************
**
** Name:  SkipTraceFrame
**
****************************************************************************/
RETCODE SkipTraceFrame
        (DESCRIPTOR dqStateId,
         S8 frameLen,
         S32 startSkipFrame,
         SPACE_TYPE spaceType){
DQ_STATE FAR *dqState;
U16 curOffset;
U8 count = 0;
U16 traceBuf;
S32 oldest, newest, trig;
RETCODE err;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadBufferGet(dqState->traceId,&traceBuf);
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);

   if ((traceBuf != dqState->traceBufId) ||  // different buffer ID.
       (startSkipFrame < dqState->frameStart)||
       (startSkipFrame > dqState->frameEnd)) { 
      AddDqStateTable(dqStateId,startSkipFrame);
      dqState->traceBufId = traceBuf;
   }
   curOffset = (U16)(startSkipFrame - dqState->frameStart);

   count = 0;
   if (frameLen > 0) {
      do {
         if (CheckSpaceType
             (spaceType, dqState->frameArray[curOffset].fcPin) == GOOD)
            count++;
         curOffset++;
         if (dqState->frameArray[curOffset].frameNo >= dqState->frameEnd) {
            AddDqStateTable(dqStateId,dqState->frameEnd);
            curOffset = 0;
         }
         if (dqState->frameArray[curOffset].frameNo >= newest)
            break;
      }while (count < frameLen);
      TrcReadFrameSet(dqState->traceId,dqState->frameArray[curOffset].frameNo);
      DadSetDqOffset(dqStateId,0);
   }
   else {
      do {
         if (CheckSpaceType
             (spaceType, dqState->frameArray[(U16)curOffset].fcPin) == GOOD)
            count++;
         curOffset--;
         if (dqState->frameArray[curOffset].frameNo <= dqState->frameStart) {
            if ((dqState->frameStart-64) < oldest) {
               dqState->frameStart = oldest;
               curOffset = dqState->frameStart-oldest;
            }
            else {
               dqState->frameStart -=64;
               curOffset = 63;
            }
            AddDqStateTable(dqStateId,dqState->frameStart);
         }
         if (dqState->frameArray[curOffset].frameNo <= oldest)
            break;
      }while (count < frameLen);
      TrcReadFrameSet(dqState->traceId,dqState->frameArray[curOffset].frameNo);
      DadSetDqOffset(dqStateId,0);
   }
   return(GOOD);


}

/****************************************************************************
**
** Name:  ReadTraceFrame
**
****************************************************************************/
RETCODE ReadTraceFrame
        (DESCRIPTOR dqStateId,
         S8 frameLen,
         S32 startReadFrame,
         DQ_FRAME *dqFrame,
         SPACE_TYPE spaceType,
         U8 *count){
DQ_STATE FAR *dqState;
U16 curOffset;
U8 frameCount;
U16 traceBuf;
S32 oldest, newest, trig;
RETCODE err;

   *count = 0;
   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadBufferGet(dqState->traceId,&traceBuf);
   _fmemset(dqFrame,0x7f,sizeof(DQ_FRAME)); /* initialize struct */
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);

   if ((startReadFrame < dqState->frameStart)||
       (startReadFrame > dqState->frameEnd)) 
      AddDqStateTable(dqStateId,startReadFrame);
   curOffset = (U16)(startReadFrame - dqState->frameStart);
   *count = frameCount = 0;
   do {
      if (CheckSpaceType
          (spaceType, dqState->frameArray[curOffset].fcPin) == GOOD) {
         if ( (dqFrame->addr[0] != dqState->frameArray[curOffset].addr - 2)
              && (*count == 1) )
            *count = 0; /* remove 1st up/sp frame, if first two frame isn't cnontigous */ 
         dqFrame->frameNo[*count] = dqState->frameArray[curOffset].frameNo;
         dqFrame->addr[*count] = dqState->frameArray[curOffset].addr;
         dqFrame->data[*count] = dqState->frameArray[curOffset].data;
         dqFrame->fcPin[*count] = dqState->frameArray[curOffset].fcPin;
         dqFrame->rwPin[*count] = dqState->frameArray[curOffset].rwPin;
         dqFrame->dsPin[*count] = dqState->frameArray[curOffset].dsPin;
         (*count)++;
      }
      frameCount++;
      curOffset++;
      if (dqState->frameArray[curOffset].frameNo >= dqState->frameEnd) {
         AddDqStateTable(dqStateId,dqState->frameEnd); // read trace frames from hardware.
         curOffset = 0;
      }
      if (startReadFrame+frameCount >= newest)
         return(GOOD); // not find enough program frame.
   }while ((*count < frameLen) && (frameCount < MAX_READ_FRAME_LEN));
   return(GOOD);
}

/****************************************************************************
**
** Name:  ReadInstDataAndAddress
**
****************************************************************************/
RETCODE ReadInstDataAndAddress(DESCRIPTOR dqStateId,DQ_FRAME FAR *dqFrame,
                               U8 FAR *count) {
DQ_STATE FAR *dqState;
S32 curFrame;
RETCODE status;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadFrameGet(dqState->traceId,&curFrame);
   status = ReadTraceFrame(dqStateId,MAX_INST_LEN + 2,curFrame,
                           dqFrame,S_PROGRAM,count);
   return(status);
}

/****************************************************************************
**
** Name:  CheckInterrupt
**
****************************************************************************/
INST_TYPE CheckInterrupt(DESCRIPTOR dqStateId, S32 nextFrame) {
DQ_FRAME dqFrame;
U8 count;

   ReadTraceFrame(dqStateId,6,nextFrame,&dqFrame,S_DATA,&count);

   if ((dqFrame.rwPin[0] == 0) &&
       (dqFrame.fcPin[1] == F_CPU) &&
       (dqFrame.rwPin[2] == 0) &&
       (dqFrame.rwPin[3] == 0) &&
       (dqFrame.rwPin[4] == 1) &&
       (dqFrame.rwPin[5] == 1))
       return(HW_INT);
   else return(NORMAL_INST);

}
/****************************************************************************
**
** Name:  PrintRemainsFrame
**
****************************************************************************/
RETCODE PrintRemainsFrame(DESCRIPTOR dqStateId,
                       S32 startFrame,S32 endFrame, LPSTR string) {
S32 offset;
U16 lp;
DQ_FRAME printFrame;
S8 strPos;
LPSTR tempBuff,spaceBuff;
U8 count;

   if ((tempBuff = TMalloc(80)) == NULL) return(ER_OUT_OF_MEMORY);
   if ((spaceBuff = TMalloc(20)) == NULL) {
      TFree(tempBuff);
      return(ER_OUT_OF_MEMORY);
   }
   offset = endFrame - startFrame;
   for (lp = 0; lp < offset; lp++, startFrame++){
      ReadTraceFrame(dqStateId,1,startFrame,&printFrame,S_DONT_CARE,&count);
      strPos = ((printFrame.rwPin[0] << 3) & 0x8) + printFrame.fcPin[0];
      _fmemcpy(spaceBuff,spaceString[strPos],sizeof(spaceString[strPos]));
      if ((printFrame.fcPin[0] == 1) ||
          (printFrame.fcPin[0] == 5) ||
          (printFrame.fcPin[0] == 7) ) {
         wsprintf(tempBuff," %7ld  ", printFrame.frameNo[0]);
         lstrcat((LPSTR)string,(LPSTR)tempBuff);
         if (gProcessor == M68306_MP)
            wsprintf(tempBuff,"%08lX    ", printFrame.addr[0]);
         else
            wsprintf(tempBuff,"%06lX    ", printFrame.addr[0]);
         lstrcat((LPSTR)string,(LPSTR)tempBuff);
         wsprintf(tempBuff,"%s: ", spaceBuff);
         lstrcat((LPSTR)string,(LPSTR)tempBuff);
         switch (printFrame.dsPin[0] & 3) {
            case 0 : //Word
               wsprintf(tempBuff,"%04X\r\n", printFrame.data[0]);
               break;
            case 1 : // High Byte
               wsprintf(tempBuff,"%02X\r\n", (U8)(printFrame.data[0] >> 8));
               break;
            case 2 : // Low Byte
               wsprintf(tempBuff,"%02X\r\n", (U8)printFrame.data[0]);
               break;
            case 3 : // Low Byte
               wsprintf(tempBuff,"????\r\n");
         }
         lstrcat((LPSTR)string,(LPSTR)tempBuff);
      }
   }
   TFree(tempBuff);
   TFree(spaceBuff);
   return(GOOD);
}

/****************************************************************************
**
** Name:  DqInst
**
****************************************************************************/
RETCODE DqInst(DESCRIPTOR id,U32 *numInst,S32 FAR *startFrame,
               S32 FAR *endFrame, LPSTR *buffer, LPSTR *buffIndex, U16 *indexLen) {
BOOLEAN dasmSym;
U16 trcBuffer,lp;
DASM_INFO dasmInfo;
S32 oldest,newest,trig,nextFrame;
U32 numFrames;
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame;
RETCODE status;
LPSTR bufferPtr;
U8 count,tempBuffer[80];

   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   if ((status = TrcFrameDisplayModeSet(dqState->traceId,TRIGGER_ALIGN))
         != GOOD) 
      return(status);
   
   if ((status = DadGetDasmSymbol(&dasmSym)) != GOOD)  
      return(status);
   
   if ((status=TrcNumFramesGet(dqState->traceId, &numFrames))!=GOOD) 
      return(status);
   
   if ( !numFrames ) 
      return(ER_DQ_NO_FRAMES_AVAILABLE); /* no frames just get out! */

/*
** Retrieve information about trace buffer limits and requested range
*/
   
   if ((status = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(status);
   
//   if ((status = TrcReadFrameGet(dqState->traceId, &firstFrame)) != GOOD) 
//      return(status);
   
   if ((status = TrcReadBufferGet(dqState->traceId, &trcBuffer)) != GOOD) 
      return(status);
   
   dasmInfo.bytesUsed = 0;
   *indexLen = 0;
   nextFrame = *startFrame;
   bufferPtr = *buffer;
   status = GOOD;
   for ( lp = 0; nextFrame < *endFrame; ) {
      if (ReadInstDataAndAddress(id,&dqFrame,&count) != GOOD) {
         status = ER_DQ_NO_FRAMES_AVAILABLE;
         break;
      }
      if (!lp) {
         if (dqFrame.frameNo[0] == 0x7f7f7f7fl) { // no frame data
            *startFrame = *endFrame = 0;
            *numInst = 0;
            return(GOOD); // maybe return another error. Allen
         }
         else *startFrame = dqFrame.frameNo[0]; // start frame at first inst.
      }

      buffIndex[lp++] = bufferPtr + lstrlen(bufferPtr);
      wsprintf(tempBuffer," %7ld  ",dqFrame.frameNo[0]);
      lstrcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);
      if (gProcessor == M68306_MP)
         wsprintf(tempBuffer,"%08lX", dqFrame.addr[0]);
      else
         wsprintf(tempBuffer,"%06lX", dqFrame.addr[0]);
      lstrcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);

      if (TraceBufInst((U16 FAR *)dqFrame.data,dqFrame.addr[0],
                       dasmSym,bufferPtr,&dasmInfo,count*2) != GOOD) break;
      else {
         (*indexLen)++;
         wsprintf(bufferPtr+lstrlen(bufferPtr),"\r\n");
         if (dasmInfo.bytesUsed)
            nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
         else
            nextFrame = dqFrame.frameNo[1];
         //Read the instruction that numbers of R/W cycle
         switch (dasmInfo.instType) {
            case MODIFY_SR :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case BRANCH :
            case TRAP :
            case ILLEGAL :
            case RETURN :
            case TRANSFER_INST :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            default :
               // if (nextFrame > newest) break;
               if (CheckInterrupt(id,nextFrame) == HW_INT) {
               // if prev inst length =2 then delete prev inst
               }
               break;
         }
         {
             // put frameNo address data status.
             // put dasm inst string.

             // bufferPtr,tempBuffer,dqFrame); // out the executed instruction.
         }

         if (nextFrame > newest) break;
         if (nextFrame > (dqFrame.frameNo[0]+1) ) 
            PrintRemainsFrame(id,dqFrame.frameNo[0]+1,nextFrame,bufferPtr);
         
         TrcReadFrameSet(dqState->traceId,nextFrame);
      }
   }
   if (lp < *numInst) *numInst = lp;
   *endFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 - 1];
   
   return(status);

}

/****************************************************************************
**
** Name:  DadForwardDqInst
**
****************************************************************************/
RETCODE EXPORT DadForwardDqInst(DESCRIPTOR id,U32 numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen) {

U32 instNo = numInst;
S32 curFrame,oldest,newest,trig;
DQ_STATE FAR *dqState;
RETCODE status;
LPSTR buffIndex[100],tempBuffer;
U16 indexLen = 0,bufferDepth;

   *textLen = 0;
   ProcReturnSpecificProcessor(&gProcessor);
   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   if ((status = TrcReadFrameGet(dqState->traceId, &curFrame)) != GOOD)
      return(status);
   if ((status = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(status);

   bufferDepth = 80 * numInst * 2;
   if ((tempBuffer = TMalloc(bufferDepth)) == NULL)
      return(ER_OUT_OF_MEMORY);
   _fmemset(tempBuffer,'\0',bufferDepth); /* initialize string */

   *startFrame = curFrame;
   if ((*endFrame = curFrame + numInst * 2) > newest)
      *endFrame = newest;
   if ((status = DqInst(id,&instNo,startFrame,endFrame,&tempBuffer,buffIndex,&indexLen))
         != GOOD) {
      TFree(tempBuffer);
      return(status);
   }

   if ((status = TrcReadFrameSet(dqState->traceId, curFrame)) != GOOD) {
      TFree(tempBuffer);
      return(status);
   }
   
   if (instNo == 0) {
      *textLen = 0;
      *tempBuffer = NULL;
      *startFrame = *endFrame = curFrame;
   } else {
      *textLen = lstrlen(tempBuffer);
   }
   if ((*buffer = TMalloc(*textLen+1)) == NULL)
      return(ER_OUT_OF_MEMORY);
   _fmemcpy(*buffer,tempBuffer,*textLen+1);
   TFree(tempBuffer);

   //OutputStringToFile(*buffer,*textLen);

   return(GOOD);

}

/****************************************************************************
**
** Name:  SearchTermination
**
****************************************************************************/
//RETCODE SearchTermination(LPSTR *headPtr,LPSTR tempBuff, S32 curFrame,
//                          U32 numInst,S32 FAR *startFrame, S32 FAR *endFrame,
//                          LPSTR *buffIndex,U16 *indexLen){
//S32 firstFrame,secondFrame;
//U16 lp;
//
//   lp = 0;
//   while(indexLen > lp) {
//      sscanf(buffIndex[lp]," %ld",&firstFrame);
//      sscanf(buffIndex[lp+1]," %ld",&secondFrame);
//      if (curFrame == firstFrame) break;
//      else if((firstFrame < curFrame) && (secondFrame > curFrame)) break;
//      lp++;
//   };
//   if ((indexLen- lp) > numInst) {
//      buffIndex[lp+numInst] = 0;
//      sscanf(buffIndex[lp+numInst-1]," %ld",endFrame);
//   }
//   else
//      sscanf(&(buffIndex[indexLen - lp])," %ld",endFrame);
//   _fmemcpy(tempBuff,buffIndex[lp],lstrlen(buffIndex[lp]));
//   *(tempBuff+ lstrlen(buffIndex[lp])) = 0;
//   //*textLen = lstrlen(tempBuff);
//   sscanf(tempBuff," %ld",startFrame);
//   *headPtr = tempBuff;



//S8 far *frameStr;
//S8 far *tempPtr;
//LPSTR endPtr;
//LPSTR nullPtr;
//U16 lp,cutLen;
//S32 lp2;
//   if ((frameStr = TMalloc(10)) == NULL) return(ER_OUT_OF_MEMORY);
//   for (lp2 = (curFrame+1); lp2 > (curFrame - 11); lp2--){
//      wsprintf(frameStr," %5d  ",lp2);
//      endPtr = _fstrstr(tempBuff,frameStr);
//      if (endPtr != NULL) {
//         nullPtr = _fstrchr(endPtr,'\r\n');
//         *nullPtr = 0;
//         *endFrame = curFrame;
//         break;
//      }
//      else {
//         //search end frame
//      }
//   }
//
//   lp = 0;
//   tempPtr = tempBuff;
//   while (tempPtr != NULL){
//      tempPtr++;
//      tempPtr = _fstrstr(tempPtr,"us");
//      lp++;
//   };
//
//   tempPtr = tempBuff;
//   if (lp > numInst) {
//      cutLen = lp - (U16)numInst;
//      for (lp = 0; lp < cutLen; lp++) {
//         tempPtr++;
//         tempPtr = _fstrstr(tempPtr,"us");
//      }
//      tempPtr -= 17;
//   }
//   *headPtr = tempPtr;
//   sscanf(tempPtr," %ld",startFrame);
//
//   TFree(frameStr);
//
//}
/****************************************************************************
**
** Name:  DadBackwardDqInst
**
****************************************************************************/
RETCODE EXPORT DadBackwardDqInst(DESCRIPTOR id,U32 numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen) {
U32 instNo = numInst;
S32 curFrame;
DQ_STATE FAR *dqState;
RETCODE status;
LPSTR tempBuffer;
S32 oldest,newest,trig;
LPSTR buffIndex[100];
U16 indexLen;
U16 bufferDepth;

   ProcReturnSpecificProcessor(&gProcessor);
   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   if ((status = TrcReadFrameGet(dqState->traceId, &curFrame)) != GOOD)
      return(status);
   
   if ((status = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(status);

   if ((*startFrame = curFrame - numInst*2) < oldest)
      *startFrame = oldest;
   if ((status = TrcReadFrameSet(dqState->traceId, *startFrame)) != GOOD)
      return(status);
   *endFrame = curFrame;
   
   bufferDepth = 80 * numInst * 2;
   if ((tempBuffer = TMalloc(bufferDepth)) == NULL)
      return(ER_OUT_OF_MEMORY);
   _fmemset(tempBuffer,'\0',bufferDepth); /* initialize string */
   
   if ((status = DqInst(id,&instNo,startFrame,endFrame,&tempBuffer,
         buffIndex,&indexLen)) != GOOD) {
      TFree(tempBuffer);
      return(status);
   }
  
   if ((status = TrcReadFrameSet(dqState->traceId, curFrame)) != GOOD) {
      TFree(tempBuffer);
      return(status);
   }
   if (curFrame == *startFrame) { 
     *textLen = 0;
     *tempBuffer = NULL;
   } else {
      *textLen = lstrlen(tempBuffer);
   }
   if ((*buffer = TMalloc(*textLen+1)) == NULL)
      return(ER_OUT_OF_MEMORY);
   _fmemcpy(*buffer,tempBuffer,*textLen+1);
   TFree(tempBuffer);
   return(GOOD);
}

/****************************************************************************
**
**  DadDqFlush
**
****************************************************************************/
#pragma argsused
RETCODE EXPORT DadDqFlush(DESCRIPTOR id) {
   return(GOOD);
}

