/****************************************************************************
**
**  Name:  patch.c
**
**  Description:
**     Routines needed to interface to test fixture for the dasm and asm.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcm306/dad32/patch.c_v  $
** 
**    Rev 1.0   07 Sep 1995 10:16:58   gene
** Initial revision.
** 
**    Rev 1.2   23 Jun 1992 16:37:06   marilyn
** No changes.
** 
**    Rev 1.1   05 Mar 1992 11:39:42   mindy
** changed dummyreadmemory interface to match to memory server's.
** 
**    Rev 1.0   03 Mar 1992 10:27:28   mindy
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/dad32/patch.c_v   1.0   07 Sep 1995 10:16:58   gene  $
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "string.h"

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef __STDIO_H_
#include <stdio.h>
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/


#define CR      '\r'
#define LF      0x0A

int             dasmHandle, asmHandle, dasmInit = 0, asmInit = 0;
U8              buf[255];

/****************************************************************************
**
**  fReadStr
**
**  Status:  PRELIMINARY
**
**  Description:
**     Read a string from file to buffer
**
**  Parameters:
**     input:
**        *hFile --> the input file handle.
**     output:
**        lBuf ----> the data will be put into buffer.
**
*****************************************************************************/
RETCODE fReadStr(U16 hFile, VOID FAR *lBuf) {
   STATIC LPSTR  dBuf ; /* one line maxinum 255 char */
   STATIC U16    i ;
   i = 0 ;
   dBuf = lBuf ;
   dBuf[0] = 0 ;
   while(_lread(hFile, &dBuf[i], 1) == 1) {
      if( dBuf[i] == CR ) {
         dBuf[i] = 0;
         return(i);
      }
      if( dBuf[i] != LF ) i++;
   }
   return(NULL) ;
}

RETCODE DummyMemRead(DESCRIPTOR source, U32 length, LPU8 *buffer) {
   U16 j ;
   LPSTR cptr, bufPtr;
   *buffer = TMalloc(length+1);
   bufPtr = *buffer;
   if (dasmInit == 0) {
      dasmHandle = _lopen("dasm030.tst", OF_READ);
      if (dasmHandle < 0) { /* configuration file open RETCODE */
                        /* warning the user and use default value */
         dasmInit = -1 ;
         return(-1) ;
      }
      dasmInit = 1 ;
   }

   if (dasmInit == -1) return(1) ;
   if(fReadStr(dasmHandle, buf) == NULL) { /* not eof and no file RETCODE */
      _lclose(dasmHandle) ;
      dasmInit = -1 ;
      return(2) ; /* EOF */
   }
   cptr = strtok(buf," ,\t,\n,\r") ;
   while( cptr!= NULL ) {
      sscanf(cptr, "%x", &j) ;
      *bufPtr++ = j ;
      cptr = strtok(NULL, " ,\t,\n,\r") ;
   }
   /* just return one line at a time - since test file is made up
      of one instruction per line!
    */
   return(GOOD) ;
}

RETCODE DummyGetAsmLine(LPSTR buffer) {
   if (asmInit == 0) {
      asmHandle = _lopen("asm030.tst", OF_READ);
      if (asmHandle < 0) { /* configuration file open RETCODE */
                        /* warning the user and use default value */
         asmInit = -1 ;
         return(-1) ;
      }
      asmInit = 1 ;
   }
   if (asmInit == -1)  return(1) ;

   if(fReadStr(asmHandle, buffer) == NULL) { /* not eof and no file RETCODE */
      _lclose(asmHandle) ;
      asmInit = -1 ;
      return(2) ; /* EOF */
   }
   return(GOOD) ;
}

