                        /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "windows.h"
#include "dasm.h"
#include "trace.h"
#include "heap.h"
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
LPSTR lpszgAppName = "MAPPROC";


                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

signed long FAR PASCAL WndProc(HWND, UINT, WPARAM, LPARAM);
BOOL WndClassInit(HANDLE);

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
                   LPSTR lpszCmdLine, int cmdShow)
{
   MSG  msg;                            
   HWND hWnd;                           

   if (!hPrevInstance)                  
      if (!WndClassInit(hInstance))
         return FALSE;

   hWnd = CreateWindow(lpszgAppName,
                       lpszgAppName,
                       WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT, 0,
                       CW_USEDEFAULT, 0,
                       NULL,
                       NULL,
                       hInstance,
                       NULL);

   ShowWindow(hWnd, cmdShow); 
   UpdateWindow( hWnd);       

   while (GetMessage(&msg, NULL, 0, 0)) 
   {
      TranslateMessage(&msg);      
      DispatchMessage(&msg);       
   }

   return (int)msg.wParam;         
}

BOOL WndClassInit(HANDLE hInstance)
{
   WNDCLASS        wcDialogbxClass;

   wcDialogbxClass.hCursor       = LoadCursor( NULL, IDC_ARROW );
   wcDialogbxClass.hIcon         = LoadIcon(NULL, IDI_HAND);
   wcDialogbxClass.lpszMenuName  = NULL;
   wcDialogbxClass.lpszClassName = lpszgAppName;
   wcDialogbxClass.hbrBackground = COLOR_WINDOWFRAME;
   wcDialogbxClass.hInstance     = hInstance;
   wcDialogbxClass.style         = CS_VREDRAW | CS_HREDRAW;
   wcDialogbxClass.lpfnWndProc   = WndProc;
   wcDialogbxClass.cbClsExtra    = 0;
   wcDialogbxClass.cbWndExtra    = 0;

   if (!RegisterClass( &wcDialogbxClass ) )
      return FALSE;

   return TRUE;
}
         
signed long FAR PASCAL WndProc(HWND hWnd, UINT message,
                           WPARAM wParam, LPARAM lParam)
{
   BOOL bRetCode;
   DESCRIPTOR id,traceId;
   U32 numInst;
   S32 startFrame,endFrame,oldest,newest,trig;
   //U8  buffer[10*MAX_LINE_LENGTH];
   LPSTR  buffer;
   U16 textLen;
   U8 fileName[] = "hwtrc";
   RETCODE err;


   numInst = 70;
   bRetCode = TRUE;
   switch (message)
   {
      case WM_CREATE:          // Dialog box initialization
	 // add the test function of dqueue to here

         TrcTraceOpen((DESCRIPTOR FAR *)&traceId,(LPSTR)fileName,
                            BUS_CYCLE, TRIGGER_ALIGN);
         DadDqOpen(&id, traceId);
	 DadForwardDqInst(id,numInst,(S32 FAR *)&startFrame,
			(S32 FAR *)&endFrame, (LPSTR)buffer, (U16 FAR *)&textLen);

         break;
      case WM_COMMAND:
         switch (wParam)
         {
            default:
	       bRetCode = FALSE;
               break;
         }
          break;
      default:
	 TrcTraceOpen((DESCRIPTOR FAR *)&traceId,(LPSTR)fileName,
                            BUS_CYCLE, TRIGGER_ALIGN);
         if ((err = TrcTraceBufferInfoGet(traceId,&oldest,&newest,&trig))
             != GOOD) return(err);
         TrcReadFrameSet(traceId,oldest);

         DadDqOpen(&id, traceId);
  //	 numInst = -70;
 //	 DadBackwardDqInst(id,numInst,(S32 FAR *)&startFrame,
  //			(S32 FAR *)&endFrame, (LPSTR)buffer, (U16 FAR *)&textLen);
 	 numInst = 70;
	 DadForwardDqInst(id,numInst,(S32 FAR *)&startFrame,
			(S32 FAR *)&endFrame, (LPSTR)&buffer, (U16 FAR *)&textLen);
	 bRetCode = FALSE;
         TFree(buffer);
   }                 
   return(bRetCode);
}

/******************************** E O F ***********************************/

