/****************************************************************************
**
**  Name:  vrtxerrs.h
**
**  Description: VRTX error codes.
**
**  $Log:   S:/tbird/arcm306/inc/vrtxerrs.h_v  $
** 
**    Rev 1.0   14 Sep 1995 14:22:46   kevin
** Initial revision.
** 
**    Rev 1.0   19 Jul 1993 07:30:44   ernie
** Initial revision.
** 
**  $Header:   S:/tbird/arcm306/inc/vrtxerrs.h_v   1.0   14 Sep 1995 14:22:46   kevin  $
**
*****************************************************************************/

#define _VRTXERRS_
                        /****************************
                         *                          *
                         *       INCLUDE FILES      *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *        DEFINITIONS       *
                         *                          *
                         ****************************/
/*
Vrtx system errors from manual.  DO NOT CHANGE THIS SECTION.
*/
#define VRTX_ER_TID 0x01     /* task ID error */
#define VRTX_ER_TCB 0x02     /* no TCBs available */
#define VRTX_ER_MEM 0x03     /* no memory available */
#define VRTX_ER_NMB 0x04     /* not a memory block */
#define VRTX_ER_MIU 0x05     /* mailbox in use */
#define VRTX_ER_ZMW 0x06     /* zero message */
#define VRTX_ER_BUF 0x07     /* buffer full */
#define VRTX_ER_WTC 0x08     /* WAITC in progress */
#define VRTX_ER_ISC 0x09     /* invalid system call */
#define VRTX_ER_TMO 0x0a     /* timeout */
#define VRTX_ER_NMP 0x0b     /* no message present */
#define VRTX_ER_QID 0x0c     /* queue ID error */
#define VRTX_ER_QFL 0x0d     /* queue full */
#define VRTX_ER_PID 0x0e     /* partition ID error */
#define VRTX_ER_INI 0x0f     /* fatal initialization error */
#define VRTX_ER_NCP 0x10     /* no character present */
#define VRTX_ER_ICP 0x11     /* invalid config parameter during INIT */
#define VRTX_ER_IIP 0x12     /*invalid input parameter 0x00, PCREATE/PEXTEND*/
#define VRTX_ER_CVT 0x20     /* component vector table not present */
#define VRTX_ER_COM 0x21     /* undefined component */
#define VRTX_ER_OPC 0x22     /* undefined opcode for component */
#define VRTX_ER_NOCB 0x30    /* no control blocks available */
#define VRTX_ER_ID 0x31      /* event flag group or semaphore ID error */
#define VRTX_ER_PND 0x32     /* tasks pending on ev flag group/semaphore */
#define VRTX_ER_DEL 0x33     /* event flag group or semaphore is deleted */
#define VRTX_ER_OVF 0x34     /* event flag already set or semaphore overflow*/
#define VRTX_ER_INTERNAL 0x35            /* internal error */
#define VRTX_ER_NO_MORE_PG_DIR 0x36      /* no more page dir. entries */
#define VRTX_ER_NO_PREV_TBL_ENTRY 0x37   /* no prev. page tbl entry */
#define VRTX_ER_LAST 0x37
