/****************************************************************************
**
**  Name:  LDEBUG.H
**
**  Description:
**      Header file for Debug Part definitions/prototypes, for IEEE 695 Loader.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm306/l695/ldebug.h_v  $
** 
**    Rev 1.0   07 Sep 1995 10:32:10   gene
** Initial revision.
** 
**    Rev 1.25   30 Sep 1993 14:43:42   nghia
** Revised function prototypes to support blockSize == 0.
** 
**    Rev 1.24   23 Sep 1993 11:01:38   nghia
** Added ProcessATN16() routine and processing definitions for ATN16.
** Revised ProcessDbgAsmBlock() parameter to exclude SYM_DESCRIPTOR *, which is
** no longer used.
** 
**    Rev 1.23   23 Aug 1993 11:08:40   nghia
** Removed all #define ALTLANG.
** Revised ProcessDbgLines() to accept nextblockpos as a parameter, remove 
** unused block name.
** 
**    Rev 1.22   26 Jul 1993 17:05:38   courtney
** Added attribute type 19 (static assembler symbol), generated by
** Sierra for BB10 blocks; also global/local #define values for these.
** 
**    Rev 1.21   14 Jul 1993 11:52:26   nghia
** Revised ProcessDbgModule() and added ProcessDbgModuleOnDemand() to
** fix bug in ondemand loading.
** 
**    Rev 1.20   13 Jul 1993 15:30:52   courtney
** Removed duplicate prototype.
** 
**    Rev 1.19   13 Jul 1993 15:12:14   courtney
** New #define to support new end-function address fetch.
** 
**    Rev 1.18   13 Jul 1993 15:03:28   courtney
** Revised prototypes for asm block routines; add mod misc record type
** 55 (found in asm blocks).
** 
**    Rev 1.17   29 Jun 1993 11:47:48   courtney
** Added new pmisc type 57 definition.
** 
**    Rev 1.16   16 Jun 1993 08:31:10   mindy
** Proc types and arrays need to add toffset.  Also moved latn9 prototypes
** to lopt.h
** 
**    Rev 1.15   08 Jun 1993 13:59:26   courtney
** Added PMISC_1 (ATN62, procedure misc record type 1) for HP tools
** (Ford loadfiles contain one per function).
** 
**    Rev 1.14   06 Jun 1993 21:20:12   courtney
** Added ATN62/pmisc 80 record #defines for C++.
** 
**    Rev 1.13   19 May 1993 18:10:24   nghia
** Added ATN_DEFINE_CONST to handle ATN16 (MRI 4.3d).
** 
**    Rev 1.12   20 Apr 1993 12:33:52   courtney
** Define procedure name for C++ Xray information.
** 
**    Rev 1.11   12 Apr 1993 17:58:28   nghia
** Lined up #define, Revised Ltype.c and other prototypes to return RETCODE.
** 
**    Rev 1.10   23 Mar 1993 17:15:06   nghia
** Changed LDEBUG prototypes to return RETCODE. 
** 
**    Rev 1.9   08 Mar 1993 10:31:14   nghia
** Major cleanup and revised to used BASEWIND.H types.
** 
**    Rev 1.8   07 Oct 1992 18:52:16   courtney
** Add #defines for procedure miscellaneous types (55, 77).
** 
**    Rev 1.7   22 Jun 1992 15:42:00   courtney
** Stubbed out altlang support till it can be tested.
** 
**    Rev 1.6   01 Jun 1992 20:13:28   courtney
** Added parameters to _ProcessDbg_Types and Globals, for altlang
** support.
** 
**    Rev 1.5   07 May 1992 16:08:18   courtney
** Prototype revisions.
** 
**    Rev 1.4   20 Apr 1992 17:09:50   courtney
** Reduced value of FN_ENDADDR_OFFSET from 8 to 7, so that nested block
** end markers aren't mistaken for end-function markers.
** 
**    Rev 1.3   03 Apr 1992 15:17:30   courtney
** Add #define for stack section.
** 
**    Rev 1.2   09 Jan 1992 16:58:24   courtney
** _ProcessDbg_Module prototype now takes timestamp parameter.
** 
**    Rev 1.1   31 Dec 1991 10:53:12   courtney
** Added #defines for ATN's for processing Environment Part of 695 file.
** 
**    Rev 1.0   12 Dec 1991 13:43:02   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/l695/ldebug.h_v   1.0   07 Sep 1995 10:32:10   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LDEBUG__
#define __LDEBUG__
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef __LSYM__
#include "lsym.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/* Name of MRI procedure block containing C++ information (for Xray) */
#define XRAY_CPPNAME "__XRYCPP"

/* Begin Block types */
#define		BB_LOCAL_TYPE	 1 
#define		BB_GLOBAL_TYPE  2
#define		BB_MODULE		 3
#define		BB_EXTERN_FN	 4
#define		BB_LINE			 5
#define		BB_STATIC_FN	 6
#define		BB_ASMBLOCK		 10
#define		BB_ASMSECTION	 11
#define		BB_LIBRARY		 20

/* MACROS */
#define IS_BBFUNCTION(x)  ((x) == BB_STATIC_FN || (x) == BB_EXTERN_FN)
#define IS_ASMMODULE(x)   ((x) == BB_ASMBLOCK || (x) == BB_ASMMODULE)

/*
** NOTES: number of bytes to preserve at end of function block, if we are
** skipping over locals for ondemand loading.
** Revised to 7 from 8, to handle the case of an unnamed block immediately
**   followed by end-function (it was getting the wrong one, and out of sync).
*/

#define FN_ENDADDR_OFFSET  7
#define FN_ENDADDR_BYTES   FN_ENDADDR_OFFSET

/* ATN attribute record types */
#define ATN_AUTO           1  /* auto - stack-based var */
#define ATN_REGISTER       2  /* register var */
#define ATN_STATIC         3  /* static var */
#define ATN_EXTERN_FN      4  /* extern function */
#define ATN_EXTERN_VAR     5  /* external var */
#define ATN_LINENO         7  /* line number */
#define ATN_GLOBAL         8  /* compiler global */
#define ATN_LIFETIME       9  /* variable lifetime */
#define ATN_LOCKED_REG     10 /* locked register var */
#define ATN_DEFINE_CONST   16 /* C's #define constant */
#define ATN_STATIC_ASM     19 /* static assembly symbol */
#define ATN_CREATION_TIME  50 /* loadfile creation time, as stored */
#define ATN_CMDLINE        51 /* commandline (to linker) */
#define ATN_STATUS         52 /* execution status (of link) */
#define ATN_HOSTOS         53 /* host environment */
#define ATN_TOOL           54 /* tool used to create file */
#define ATN_COMMENT        55 /* comment string */
#define ATN_PROC_MISC      62 /* procedure miscellaneous */
#define ATN_VAR_MISC       63 /* variable miscellaneous */
#define ATN_MOD_MISC       64 /* module miscellaneous */
#define ATN_MISC_STR       65 /* module misc string */

/* types of procedure miscellaneous records (used in ATN62), also
   module miscellaneous records (used in ATN64)
*/
#define PMISC_1             1  /* procedure return address (R-label) */
#define PMISC_51           51  /* stack frame adjust */
#define MMISC_55           55  /* assembly procedure info */
#define PMISC_57           57  /* jump table description */
#define PMISC_77           77  /* undocumented (optimized code uses) */
#define PMISC_80           80  /* C++ information */

/* pmisc 80 record types (C++ information, defined in IEEE 695 Appendix F
   (MRI spec)).  Most of these (not all, see notes in handling routine
   in ldebug.c) are found in the XRAY information block, hence the name. */
#define XRAY_MBRFUNCTION   0x4d  /* 'M': member function */
#define XRAY_ARGLIST       0x42  /* 'B': default and reference arg list */
#define XRAY_SOURCEFILE    0x46  /* 'F': source file name */
#define XRAY_CLASS         0x54  /* 'T': class, C++ struct, C++ union */
#define XRAY_PMBR          0x7a  /* 'z': pointer to member */
#define XRAY_REF           0x52  /* 'R': reference var */

/* default argument masks (used by pmisc 80, type 'B') */
#define DEFARG_4BYTE       0x01
#define DEFARG_8BYTE       0x02
#define DEFARG_STR         0x03

#define STACK_SEC          "stack"     /* name of stack section */

/* Indicator for static assembler symbols (ATN19) */
#define ATN19_GLOBAL       1
#define ATN19_LOCAL        0

/* Indicator for constant definition */
#define ATN16_GLOBAL_DEF   1
#define ATN16_LOCAL_DEF    0
#define LONG_STR_256       0xDE
#define LONG_STR_MAX       0xDF

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

RETCODE ProcessDebugPart(HANDLE, BOOLEAN, U16, TIMESTAMP_TYPE *, U32 *);
RETCODE ProcessDbgTypes(HANDLE, LPSTR, U32 *);
RETCODE ProcessDbgModule(HANDLE, LPSTR, U32, U16, U32, SYM_DESCRIPTOR *,
    TIMESTAMP_TYPE *);
RETCODE ProcessDbgModuleOnDemand(HANDLE, U16, U32);
RETCODE ProcessDbgGlobals(HANDLE, U32, BOOLEAN);
RETCODE ProcessDbgFunctions(HANDLE, U16, U32, U32, LPSTR,
                            OFFSET_ADDR_RANGE_TYPE *, U32, BOOLEAN, U16);
RETCODE ProcessDbgLocals(HANDLE, U32);
RETCODE ProcessDbgLines(HANDLE, BOOLEAN, BOOLEAN, U32 *, U32 *,
                        SYM_DESCRIPTOR);
RETCODE Get695BB(HANDLE, U32 *, LPSTR, U16 *);
RETCODE PBBFunction(HANDLE, U32 *, U32 *, U32, U32 *);
RETCODE ProcessTY(HANDLE, U32 *, U32, U16 *, U16 *);
RETCODE ProcessATN(HANDLE, U16 *, U32 *, U32, U16 *);
RETCODE ProcessATN7(HANDLE, U16 *, U16 *);
RETCODE ProcessATN62(HANDLE, U32 *, U32, U16 *);
RETCODE ProcessASN(HANDLE, U16 *, U32 *);
RETCODE ProcessATN16(HANDLE, U32 *, LPSTR);
S16 PBBLineno(VOID);


/* Define in LASM.C */
RETCODE ProcessDbgAsmBlock(HANDLE, U32, LPSTR, BOOLEAN);
RETCODE StripPathString(LPSTR moduleName, LPSTR *newName);

/* Define in LTYPE.C */
RETCODE GetTypePtr(HANDLE, U32, U16, U32);
RETCODE GetTypeTypedef(HANDLE, U32, TYPE_HEADER_TYPE *, U32);
RETCODE GetTypeProc(HANDLE, U32, U32);
RETCODE GetTypeSU(HANDLE, U32, U16, U32);
RETCODE GetTypeEnum(HANDLE, U32);
RETCODE GetTypeArr(HANDLE, U32, U32, TYPE_HEADER_TYPE *);
RETCODE GetTypeBit(HANDLE, U32, TYPE_HEADER_TYPE *);
RETCODE MapTypeVoid(U32);

#endif
/****************************** EOF ****************************************/

