/****************************************************************************
**
**  Name:  LSYM.H
**
**  Description:
**      Definitions which interface the Symbol Server.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm306/l695/lsym.h_v  $
** 
**    Rev 1.1   19 Jan 1996 09:09:24   kevin
** added GetBaseType
** 
**    Rev 1.0   07 Sep 1995 10:32:26   gene
** Initial revision.
** 
**    Rev 1.9   23 Sep 1993 17:28:56   nghia
** Removed START_RANGE_NOT_SET, no longer needed.
** 
**    Rev 1.8   12 Apr 1993 16:31:20   nghia
** Revised routines to look for section information.
** Added 2 default sections - BASECODE and BASEDATA.
** 
**    Rev 1.7   23 Mar 1993 17:16:32   nghia
** Minor cleanup.
** 
**    Rev 1.6   18 Mar 1993 17:30:12   nghia
** Revised all non-standard return code to RETCODE.
** 
**    Rev 1.5   08 Mar 1993 11:04:14   nghia
** Major cleanup for names.
** 
**    Rev 1.4   07 Oct 1992 18:52:06   courtney
** Restore prototype.
** 
**    Rev 1.3   16 Jan 1992 13:59:54   courtney
** Include reference to symerror.h is back to standard include path.
** 
**    Rev 1.2   09 Jan 1992 16:45:10   courtney
** Added #defines to pass to LoadStart to indicate initial vs.
** ondemand (module) load.
** 
**    Rev 1.1   31 Dec 1991 10:50:32   courtney
** Added prototypes for new timestamp handling routines.
** 
**    Rev 1.0   12 Dec 1991 13:40:52   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/l695/lsym.h_v   1.1   19 Jan 1996 09:09:24   kevin  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LSYM__
#define __LSYM__

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef __SYMERROR__
#include "symerror.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/* boolean values for SymAddLoadStart ondemand parameter */
#define INITIAL_LOAD  0
#define MODULE_LOAD   1

#define RANGE_NOT_SET 0xffffffffL

#define SBASE_RTA  "BASE_RTACTIVATE"   /* default section for regs/autos */
#define SBASE_CODE "BASE_CODE"         /* default section for code */
#define SBASE_DATA "BASE_DATA"         /* default section for data */

/* built-in types which require size definitions - be sure they are long */
#define T695_INT		0x10L
#define T695_UNS		0x11L
#define T695_UNS_INT	0x12L

/* sizeof(int) for MRI C 68K is 4 bytes */
#define SZ_STACKPUSH_68K	4L
/* sizeof(pointer) for MRI C 68K types */
#define SZ_SMPTR68K			2L
#define SZ_LGPTR68K			4L

/* other built-in types needed */
#define T695_VOIDP		0x01L
#define T695_CODE		0x0fL

/* complex types as defined by IEEE 695 (known as 'High Level types' */
#define T695_UNKNOWN		'!'
#define T695_SMALL_PTR		'O'
#define T695_LARGE_PTR		'P'
#define T695_ENUM  			'N'
#define T695_STRUCT 		'S'
#define T695_TYPEDEF		'T'
#define T695_UNION 			'U'
#define T695_VOID			'V'		/* undocumented by 695; used by MRI C */
#define T695_PROC_SIMPLE	'X'
#define T695_ARRAY			'Z'
#define T695_BITFIELD		'g'
#define T695_PROC			'x'

#define MAX_CMDLINE         255     /* for generating tool */

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
RETCODE FindBaseIndex(U32, U16 *, BOOLEAN *);
RETCODE FindBaseCodeIndex(U16 *);
RETCODE FindBaseDataIndex(U16 *);
RETCODE FindBaseRTAIndex(U16 *);
RETCODE GetBaseType(BASE_INDEX, BASE_TYPE *);
RETCODE Get695Time(HANDLE, TIMESTAMP_TYPE *);
RETCODE GetTimestamp(HANDLE, TIMESTAMP_TYPE *);
U16 FindSecModifier(U16);
S16 DiffTimestamp(TIMESTAMP_TYPE *, TIMESTAMP_TYPE *);

#endif
/******************************** E O F ***********************************/
