/****************************************************************************
**
**  Name:  chunk.h
**
**  Description:
**     Private routines used by "heap.c" to manage 64 KB heaps.  Heap.c
**     has *no* knowledge of the internals of chunk.c
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm306/malloc/chunk.h_v  $
** 
**    Rev 1.0   07 Sep 1995 10:41:38   gene
** Initial revision.
** 
**    Rev 1.1   29 Aug 1992 16:51:48   kend
** Update for sanity checks
** 
**    Rev 1.0   19 Aug 1991 15:49:08   kend
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/malloc/chunk.h_v   1.0   07 Sep 1995 10:41:38   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _CHUNK_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/* for heap.c */
#define MAX_ALLOC_SIZE ((64 * 1024) - (7 * sizeof(unsigned long)))

#ifndef _HEAPERRS_
#include "heaperrs.h"
#endif

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/


/****************************************************************************
**
**  CFree
**
**  Description:
**     Memory deallocator.  Frees memory associated with a pointer
**     allocated via CMalloc() {see below}.
**
**     NOTA BENE:  Freeing an already Free()'ed pointer may corrupt the 
**     heap!!
**
**  Parameters:
**     input:
**	  chunkAddr:  Base address of 64KB heap/segment.
**        memoryAddr: A pointer returned by CMalloc().
**     output:
**        Success or error (see below).
**
**  Errors:
**	ER_HEAP_CORRUPT -- our data structures are garbage!
**
*****************************************************************************/

RETCODE CFree( LPSTR chunkAddr, LPSTR memoryAddr ) ;


/****************************************************************************
**
**  CMalloc
**
**  Description:
**     Memory ALLOCator.  Given numBytes less than 64K (current limit
**     is 65508), returns a long pointer to the allocated memory. 
**     Zero is returned on failure.  The memory is "locked" in the
**     Window's sense.  This routine should be used for allocating
**     small amounts of memory (incremental overhead is just over 
**     8 bytes per alloc).  It uses very few Window's handles.  There
**     will *never* be a handle associated with the returned pointer
**     {i.e. don't use GlobalHandle() on a pointer returned by this
**     routine}.
**
**     NOTA BENE:  Writing to memory outside the pointer+numBytes range 
**     will corrupt the chunk!!
**
**  Parameters:
**     input:
**	  chunkAddr:  Base address of 64KB heap/segment.
**        numBytes:   The number of bytes to allocate < (64KB - (7 * 4))
**     output:
**        return value is zero (0) or a long pointer to alloc'ed memory.
**
*****************************************************************************/

LPSTR CMalloc ( LPSTR chunkAddr, U16 numBytes ) ;



/****************************************************************************
**
**  InitChunk
**
**  Description:
**     Initializes a single 64KB heap segment "chunk".
**
**     NOTA BENE:  Call this routine before doing any of the other calls
**     in this interface (or Windows will crash)!
**
**  Parameters:
**     input:
**	  chunkAddr:  Base address of 64KB heap/segment.
**     output:
**        SUCCESS or ER_HEAP_CORRUPT
**
*****************************************************************************/

RETCODE CVerify( LPSTR chunkAddr ) ;

/****************************************************************************
**
**  InitChunk
**
**  Description:
**     Initializes a single 64KB heap segment "chunk".
**
**     NOTA BENE:  Call this routine before doing any of the other calls
**     in this interface (or Windows will crash)!
**
**  Parameters:
**     input:
**	  chunkAddr:  Base address of 64KB heap/segment.
**     output:
**        TRUE if all chunk memory is free, else FALSE.
**
*****************************************************************************/

BOOLEAN EmptyChunk_P ( LPSTR chunkAddr ) ;


/****************************************************************************
**
**  FinalizeChunk
**
**  Description:
**     Does anu cleanup associated with a single 64KB heap segment "chunk".
**
**     NOTA BENE:  All pointer alloced by CMalloc should be freed before 
**     this routine is called!
**
**  Parameters:
**     input:
**	  chunkAddr:  Base address of 64KB heap/segment.
**     output:
**        Success (always).
**
*****************************************************************************/

RETCODE FinalizeChunk ( LPSTR chunkAddr ) ;


/****************************************************************************
**
**  InitChunk
**
**  Description:
**     Initializes a single 64KB heap segment "chunk".
**
**     NOTA BENE:  Call this routine before doing any of the other calls
**     in this interface (or Windows will crash)!
**
**  Parameters:
**     input:
**	  chunkAddr:  Base address of 64KB heap/segment.
**     output:
**        Success (always)
**
*****************************************************************************/

RETCODE InitChunk ( LPSTR chunkAddr ) ;


/******************************** E O F ***********************************/
