/* This class handles both the Memory Search and Memory Fill dialogs. */!!

inherit(Dialog, #MemSearchOrFillDialog, #(values /* values for display */
hlpEntry
), 2, nil)!!

setClassVars(MemSearchOrFillDialog, #())!!

now(class(MemSearchOrFillDialog))!!

Def open(self | dlg)
{
  dlg := new(self);
  setHelpEntry(dlg, HE_DLGR_MEM_SEARCH); /* default */
  ^dlg;
}!!

now(MemSearchOrFillDialog)!!

Def setHelpEntry(self, helpEntry)
{
   hlpEntry := helpEntry;
}!!

/* 4/16/1993 11:58 */
Def initDialog(self, wp, lp)
{
  /* place initial values */
  setText(self,values[3]);
  registerF1Help(CLIULibraryClass$Inst, HI_DLGR_MEM_SEARCH,
     getHWnd(self), hlpEntry);
  if values[0]
    setItemText(self, DLG_MEM_FROM, values[0]);
  endif;
  if values[1]
    setItemText(self, DLG_MEM_TO, values[1]);
  endif;
  if values[4] = 1 cor values[4] = 3 then
    disableItem(self,DLG_MEM_PATTERN);
    disableItem(self,503);
    disableItem(self,88);
  else 
    if values[2]
      setItemText(self, DLG_MEM_PATTERN, values[2]);
    endif;
  endif;
  
  /* set item focus */  
  ^1;  /* informs Windows to set focus to tab stop 1 */
}
!!

/* 4/16/1993 11:58 */
Def getValues(self)
{
  ^values;
}
!!

/* 4/16/1993 11:58 */
Def setValues(self, newValues)
{
  values := newValues;
  
  ^0;
}
!!

Def command(self, wp, lp | s1 s2 s3 collection index)
{
  select
    case wp == IDCANCEL and high(lp) = 0 is
      end(self, IDCANCEL);
    endCase
    case wp == IDHELP 
      is contextNumber(TheHelpObject, hWnd, hlpEntry);
    endCase
    case wp == IDOK and high(lp)= 0 is
      s1 := peelBlanks(getItemText(self, DLG_MEM_FROM));
      if (s1  = "")
        displayFormattedError(ErrorTextLibClass$Inst, 
           ER_ADDRESS_MISSING, FORCE_POPUP, "From", nil, nil);
        setItemFocus(self, DLG_MEM_FROM);
        ^0;
      endif;
      if not(getSymbolicOffset(AddressLibClass$Inst, s1))
        setItemFocus(self, DLG_MEM_FROM);
        ^0;
      endif;
      s2 := peelBlanks(getItemText(self, DLG_MEM_TO));
      if (s2 = "")
        displayFormattedError(ErrorTextLibClass$Inst, 
           ER_ADDRESS_MISSING, FORCE_POPUP, "To", nil, nil);
        setItemFocus(self, DLG_MEM_TO);
        ^0;
      endif;
      if not(getSymbolicOffset(AddressLibClass$Inst, s2))
        setItemFocus(self, DLG_MEM_TO);
        ^0;
      endif;
      if values[4] <> 1 cand values[4] <> 3 then
        s3 := peelBlanks(getItemText(self, DLG_MEM_PATTERN));
        if (s3 = "")
          displayFormattedError(ErrorTextLibClass$Inst, 
              ER_PATTERN_MISSING, FORCE_POPUP, nil, nil, nil);
          setItemFocus(self, DLG_MEM_PATTERN);
          ^0;
        endif;
        collection := findStrings(" "+s3, " ");
      endif;
      
      /* validate each component */
      index := 0;
      loop
      while index < size(collection)
        if not(string2int16(collection[index]))
          setItemFocus(self, DLG_MEM_PATTERN);
          ^0;
        endif;
        index := index + 1;
      endLoop;
      
      /* input is acceptable; save previously obtained values, end */
      values[0] := s1;
      values[1] := s2;
      if values[4] <> 1 then
        values[2] := s3;
      endif;
      end(self, IDOK);
    endCase
  endSelect;
  ^0;
}
!!

