/* Dialog that pops up when user selects save as in the trace presenter under File */!!

inherit(Dialog, #TraceSaveDialog, #(
saveFmt
bufStart
bufEnd
frameStart
frameEnd
fileName
), 2, nil)!!

now(class(TraceSaveDialog))!!

Def new(self | dlg)
{
  dlg := new(self:ancestor);
  
  ^dlg;
}
!!

now(TraceSaveDialog)!!

Def command(self, wp, lp | value tracing response){ 
  select
    case wp = 301 cor wp = 302 cor wp = 303
      Call CheckDlgButton(getHWnd(self), 301, 0);
      Call CheckDlgButton(getHWnd(self), 302, 0);
      Call CheckDlgButton(getHWnd(self), 303, 0);
      Call CheckDlgButton(getHWnd(self),  wp, 1);
    endCase
    case wp == IDCANCEL
      end(self, 0);
    endCase
    case wp = IDHELP
       is contextNumber(TheHelpObject, hWnd, HE_DLGD_TRACESAV);
    endCase
    case wp == IDOK
      end(self, IDOK);
    endCase
  endSelect;
  ^0;
}!!

/* Save the control values before the dialog is destroyed. */
Def end(self, val | rc){
 rc := end(self:ancestor, val);
 if val <> 0
   if ((Call IsDlgButtonChecked(getHWnd(self), 301)) > 0) then
      saveFmt := BUS_CYCLE;
   endif;
   if ((Call IsDlgButtonChecked(getHWnd(self), 302)) > 0) then
      saveFmt := CLOCK_CYCLE;
   endif;
   if ((Call IsDlgButtonChecked(getHWnd(self), 303)) > 0) then
      saveFmt := INST_CYCLE;
   endif;
   bufStart := getItemText(self, 401);
   bufEnd := getItemText(self, 404);
   frameStart := getItemText(self, 402);
   frameEnd := getItemText(self, 405);
   fileName := getItemText(self, 101);
 endif;
 ^rc;
}!!

/* PUBLIC */
Def getEndBuffer(self | val) { 
  val := bufEnd;
  if( not(val) )
    val := asString(trcReadBufferGet(trace(parent)));
  endif;
  ^bufEnd := val;
}!!

/* PUBLIC */
Def getEndFrame(self | val){ 
  val := frameEnd;
  if( not(val) )
    val := asString(traceBufferTrigger(trace(parent))+20);
  endif;
  ^frameEnd := val;
}!!

/* PUBLIC */
Def getFileName(self | val){ 
  val := fileName;
  if( not(val) )
    val := "";
  endif;
  ^val;
}!!

/* PUBLIC */
Def getSaveFormat(self)
{ 
  ^saveFmt;
}!!

/* PUBLIC */
Def getStartBuffer(self | val){ 
  val := bufStart;
  if( not(val) )
    val := asString(trcReadBufferGet(trace(parent)));
  endif;
  ^bufStart := val;
}!!

/* PUBLIC */
Def getStartFrame(self | val){ 
  val := frameStart;
  if( not(val) )
    val := asString(traceBufferTrigger(trace(parent))-20);
  endif;
  ^frameStart := val;
}!!

Def initDialog(self, wp, lp | oneFound)
{
   if (not(fileName)) then
      fileName := "";
   endif;
   if (not(saveFmt)) then
      saveFmt := BUS_CYCLE;
   endif;
   setItemText(self, 101, fileName);  /* filename */
   if (saveFmt = BUS_CYCLE) then
      Call CheckDlgButton(getHWnd(self), 301, 1);
   else
      Call CheckDlgButton(getHWnd(self), 301, 0);
   endif;
   if (saveFmt = CLOCK_CYCLE) then
      Call CheckDlgButton(getHWnd(self), 302, 1);
   else
      Call CheckDlgButton(getHWnd(self), 302, 0);
   endif;
   if (saveFmt = INST_CYCLE) then
      Call CheckDlgButton(getHWnd(self), 303, 1);
   else
      Call CheckDlgButton(getHWnd(self), 303, 0);
   endif;
   setItemText(self, 401, getStartBuffer(self)); 
   setItemText(self, 402, getStartFrame(self)); 
   setItemText(self, 404, getEndBuffer(self)); 
   setItemText(self, 405, getEndFrame(self)); 
   ^1; /* set focus to first tabstop */
}!!

/* PUBLIC */
Def setEndFrame(self, frame){ 
  ^frameEnd := frame;
}!!

/* PUBLIC */
Def setFileName(self, file){ 
  ^fileName := file;
}!!
