/**************************************************************************
**
**  Name:  emucomm.c
**
**  Description:
**     Michelle command or data communication routines(Parallel).
**     include:
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/hfw307/arcm/emucomm.c_v  $
** 
**    Rev 1.0   11 Jan 1996 10:50:36   gene
** Initial revision.
** 
**    Rev 1.0   03 Jan 1996 13:50:44   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:47:16   gene
** Initial revision.
** 
** Initial revision.
** 
**  $Header:   S:/tbird/hfw307/arcm/emucomm.c_v   1.0   11 Jan 1996 10:50:36   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
***************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#ifndef _COMM_DATA_
#include "commdata.h"
#endif

#ifndef _LLFW_
#include "emullfw.h"
#endif

#include <conio.h>
#include <string.h>

#define CR             0x0D
#define LF             0x0A
#define LEAD_CODE      ':'
#define DMA0TC         0xffc8

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

U8 checksum,receiveBuf[MAX_BUF_SIZE];
U16 tempDmaLen;
                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/
/****************************************************************************
**
**  ReceiveByte
**
**  Description: Receive one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
U8 ReceiveByte(VOID) {
U16 dmaCount;

   dmaCount = inp(DMA0TC);
   while ((dmaCount >= tempDmaLen) && (timeOut == 0)){
      dmaCount = inp(DMA0TC);
   } /* wait for input buffer is'nt empty */
   if (!timeOut) {
      tempDmaLen--;
      return (dmaString[dmaLen-tempDmaLen-1]);
   }
   else return(NULL);
}

/****************************************************************************
**
**  TransmitByte
**
**  Description: Transmit one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID TransmitByte(U8 c) {
   if (outSize < MAX_BUF_SIZE) PutPortData(c);
   else return;
}

/****************************************************************************
**
**  CommRecover
**
**  Description: Initialize communication point and size.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID CommRecover(VOID) {
   outSize = outWrPtr = outRdPtr = 0;
}

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID ReceiveStream(VOID) {
U8 aa[4],mice[4] = {'M','I','C','E'};
S16 len;
register lp;

   for (;;) {
      SetDmaCount(4); // receive leading code and data length and checksum.
      tempDmaLen = dmaLen;
      checksum = 0;
      for (lp =0; lp < 4; lp++) {
         aa[lp] = ReceiveByte();
         if (timeOut) break;
      }
      if (timeOut) continue;
      HltWatchDog();
      for (lp = 1; lp < 4; lp++) checksum += aa[lp];
      if ((aa[0] == LEAD_CODE) && (checksum == 0)) // command length.
         len = *(U16 *)&aa[1];   /* data length */
      else if (memicmp(mice,aa,4) == 0) { // warn start
         TransmitByte(LEAD_CODE);
         continue;
      }
      else len = 512; //continue;

      checksum = 0;
      SetDmaCount(len);
      tempDmaLen = dmaLen;
      for (lp = 0; lp < len; lp++) {
         receiveBuf[lp] = ReceiveByte();
         if (timeOut) break;
         checksum += receiveBuf[lp];
      }
      if (timeOut) continue;
      HltWatchDog();
      if (checksum == 0) {
         memcpy(commandStream,&receiveBuf[0],len);
         commandStreamLen = len;
         TransmitByte(ACK);
         return;
      }
      else TransmitByte(NACK);
   }
}

/****************************************************************************
**
**  TransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
/*
   Transmit data(length + data + checksum) to communication port.
   the data format is : LENGTH(2 bytes)DATA(number of length)CHECKSUM(1 byte)
*/
VOID TransmitStream(VOID) {
register lp;
U8 highLen,lowLen,finalFlag,aa;

   checksum = 0;
   for (lp = 0; lp < outputStreamLen; lp++)
      checksum += outputStream[lp];
   outputStream[outputStreamLen] = (U8)(~checksum+1);
   outputStreamLen++;

   lowLen = LowByte(outputStreamLen);
   highLen = HighByte(outputStreamLen);
   checksum = (U8)(~(lowLen+highLen) + 1);

   for (;;) {
      CommRecover();
      TransmitByte(LEAD_CODE);
      TransmitByte(lowLen);
      TransmitByte(highLen);
      TransmitByte(checksum);
      for (lp = 0; lp < outputStreamLen; lp++)
         TransmitByte(outputStream[lp]);
      finalFlag = OFF;
      for (lp = 0; lp < 10000; lp++)
         if(outSize == 0) {
            finalFlag = ON;
            break;
         }
      if (finalFlag == OFF) {
         CommRecover();
         break;
         //return;
      }
      SetDmaCount(1);
      tempDmaLen = dmaLen;
      aa = ReceiveByte();
      if (aa == ACK) {
         HltWatchDog();
         break;
      }
      else if (aa == NACK) {
         HltWatchDog();
         continue;
      }
      else {
         HltWatchDog();
         break;
      }
   }
}
/******************************** E O F ***********************************/
