/***************************************************************************
**
**  Name:  emutrace.c
**
**  Description:
**     Michelle trace-group routines.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/hfw328/arcm/emutrace.c_v  $
** 
**    Rev 1.3   25 Jan 1996 16:13:46   gene
** added qualify trace
** 
**    Rev 1.2   17 Jan 1996 16:58:30   gene
** added qualify trace functions
** 
**    Rev 1.1   17 Jan 1996 12:56:12   gene
** modified emuclrevent(), added 0xFFFF ID for clear all bus events
** 
**    Rev 1.8   28 Dec 1995 14:47:28   kevin
** exchanged pre and post trigger operations
** 
**    Rev 1.7   19 Dec 1995 09:53:30   kevin
** fixed 'next' problem in trigger window
** 
**    Rev 1.4   15 Nov 1995 14:50:52   kevin
** modify EmuClrEvent() for clear all condition
** 
**    Rev 1.3   02 Nov 1995 10:37:30   kevin
** added a flag of violation break to emuAbort()
** 
**    Rev 1.2   12 Oct 1995 16:52:48   kevin
** added EnEmDisViol() in EmuAbort()
** 
**    Rev 1.1   11 Oct 1995 08:40:54   kevin
** added EnEmRun() into EmuGo and removed EnEmDisViol() from EmuGo()
** 
**    Rev 1.0   07 Sep 1995 10:47:30   gene
** Initial revision.
** 
** 
**  $Header:   S:/tbird/hfw328/arcm/emutrace.c_v   1.3   25 Jan 1996 16:13:46   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _EMU_EMUL_
#include "emuemul.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_LLFW_
#include "emullfw.h"
#endif

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#ifndef _TRCEVENT_
#include "trcevent.h"
#endif

#include <string.h>
#include <conio.h>
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define MK_FP(seg, ofs) ((VOID _far *) ((((U32) seg) << 16) | ((U16) ofs)))
#define MAX_BUS_EVENT_NO       8
#define MAX_EXEC_EVENT_NO      2
#define EXT_EVENT          0x400
#define TRIG_EV            0x3ff /* ev1 .. ev8, ev10, ev11*/
#define BUF_SIZE           0x800 /* 2k */
enum TC_MODE {TC_COUNT0,TC_COUNT1,TC_TIMER};
U8 phyEv[MAX_BUS_EVENT_NO];
BUS_EVENT busEvent[MAX_BUS_EVENT_NO];
EXEC_EVENT execEvent[MAX_EXEC_EVENT_NO];
U8 trigBuf[2][BUF_SIZE];
U16 tcFlag;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/
VOID SetPhyTrig(S16 runMode);

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

U16 ExchangeHighLow(U16 changeData) {
U8 highByte,lowByte;

   highByte = (U8)changeData;
   lowByte = (U8)(changeData >> 8);
   return(((U16)highByte << 8) + (U16)lowByte);

}

/****************************************************************************
**
**  AccessBusEvent
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS AccessBusEvent(ACCESS_MODE accessMode, U16 evId, BUS_EVENT *value) {
STATUS status;
U16 lp;
BUS_EVENT clrBusEvent,tempBusEvent[MAX_BUS_EVENT_NO];
U8 highByte,lowByte;


   status = GOOD;
   evId--;
   clrBusEvent.enable   = 0;
   clrBusEvent.addrSpec = 0;
   clrBusEvent.addrLow  = 0;
   clrBusEvent.addrHigh = 0;
   clrBusEvent.spareLow = 0;
   clrBusEvent.spareHigh = 0;
   clrBusEvent.dataSpec = 0;
   clrBusEvent.dataLow  = 0;
   clrBusEvent.dataHigh = 0;

   clrBusEvent.statusFlag = 1 ;// use status. 1: PowerView, 0: MICEview
   clrBusEvent.status.statusFc = 0;
   clrBusEvent.status.statusDsLow = 0;
   clrBusEvent.status.statusDsHigh = 0;
   clrBusEvent.status.statusCsLow = 0;
   clrBusEvent.status.statusCsHigh = 0;
   clrBusEvent.status2.status2Low = 0;
   clrBusEvent.status2.status2High = 0;


   status = GOOD;
   switch (accessMode) {
      case READ_ONE :
         if (busEvent[evId].statusFlag == 0)
            memcpy(value,&busEvent[evId],sizeof(BUS_EVENT));
         else {// use status
            memcpy(&tempBusEvent[evId],&busEvent[evId],sizeof(BUS_EVENT));
            busEvent[evId].dataLow =
               (U32)ExchangeHighLow((U16)busEvent[evId].dataLow);
            busEvent[evId].dataHigh =
               (U32)ExchangeHighLow((U16)busEvent[evId].dataHigh);
            memcpy(value,&busEvent[evId],sizeof(BUS_EVENT));
            memcpy(&busEvent[evId],&tempBusEvent[evId],sizeof(BUS_EVENT));
         }

         break;
      case WRITE_ONE :
         memcpy(&busEvent[evId],value,sizeof(BUS_EVENT));
         busEvent[evId].enable = 1;
         if (busEvent[evId].statusFlag == 0) // use status
            status = SetAllBusEvent(busEvent);  /* Set event */
         else {
         // highByte = (U8)busEvent[evId].dataLow;
         // lowByte = (U8)(busEvent[evId].dataLow >> 8);
         // busEvent[evId].dataLow = ((U32)highByte << 8) + (U32)lowByte;
         // highByte = (U8)busEvent[evId].dataHigh;
         // lowByte = (U8)(busEvent[evId].dataHigh >> 8);
         // busEvent[evId].dataHigh = ((U32)highByte << 8) + (U32)lowByte;

            busEvent[evId].dataLow =
               (U32)ExchangeHighLow((U16)busEvent[evId].dataLow);
            busEvent[evId].dataHigh =
               (U32)ExchangeHighLow((U16)busEvent[evId].dataHigh);

            status = SetAllBusEventP(busEvent);  /* Set event */

         }
         if (status != GOOD) busEvent[evId].enable = OFF;
         break;
      case READ_ALL :
         if (busEvent[evId].statusFlag == 0)
            memcpy(value,busEvent,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
         else {// use status
            memcpy(tempBusEvent,busEvent,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
            for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++) {
               busEvent[lp].dataLow =
                  (U32)ExchangeHighLow((U16)busEvent[lp].dataLow);
               busEvent[lp].dataHigh =
                  (U32)ExchangeHighLow((U16)busEvent[lp].dataHigh);
            }
            memcpy(value,busEvent,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
            memcpy(busEvent,tempBusEvent,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
         }
         break;
      case WRITE_ALL :
         memcpy(busEvent,value,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
         for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++) {
            if (busEvent[lp].enable == OFF)
               memcpy(&busEvent[lp],&clrBusEvent,sizeof(BUS_EVENT));
         }
         if (busEvent[0].statusFlag == 0) // use status
            status = SetAllBusEvent(busEvent);  /* Set event */
         else {status = SetAllBusEventP(busEvent);  /* Set event */
//            memcpy(&tempBusEvent[evId],&busEvent[evId],sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);

            for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++) {
               highByte = (U8)busEvent[lp].dataLow;
               lowByte = (U8)(busEvent[lp].dataLow >> 8);
               busEvent[lp].dataLow = ((U32)highByte << 8) + (U32)lowByte;
               highByte = (U8)busEvent[lp].dataHigh;
               lowByte = (U8)(busEvent[lp].dataHigh >> 8);
               busEvent[lp].dataHigh = ((U32)highByte << 8) + (U32)lowByte;
            }

            status = SetAllBusEventP(busEvent);  /* Set event */

//            memcpy(&busEvent[evId],&tempBusEvent[evId],sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
         }
         if (status != GOOD)
            for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++)
               busEvent[lp].enable = OFF;
         break;
      case CLEAR_ONE :
         memcpy(&busEvent[evId],&clrBusEvent,sizeof(BUS_EVENT));
         busEvent[evId].enable= OFF;
         if (clrBusEvent.statusFlag == 0) // use status
            status = SetAllBusEvent(busEvent);  /* Set event */
         else status = SetAllBusEventP(busEvent);  /* Set event */
         break;
      case CLEAR_ALL :
         for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++) {
            memcpy(&busEvent[lp],&clrBusEvent,sizeof(BUS_EVENT));
            busEvent[lp].enable= OFF;
         }
         if (clrBusEvent.statusFlag == 0) // use status
            status = SetAllBusEvent(busEvent);  /* Set event */
         else status = SetAllBusEventP(busEvent);  /* Set event */
         break;
   }
   return(status);
};

/****************************************************************************
**
**  TransferSpace
**
****************************************************************************/
U16 TransferSpace(U16 space) {
   switch (space) {
      case SPACE_SP :
         return(2);
         break;
      case SPACE_UP :
         return(1);
         break;
      case SPACE_DONT_CARE :
         return(0);
   }
};
/****************************************************************************
**
**  AccessExecEvent
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID AccessExecEvent(ACCESS_MODE accessMode, U16 evId, EXEC_EVENT *execData) {
U16 lp;
EXEC_EVENT clrExecEvent;

   clrExecEvent.enable = OFF;
   clrExecEvent.addr.pos = 0;
   clrExecEvent.addr.space = 0;

   switch (accessMode) {
      case READ_ONE :
         memcpy(execData,&execEvent[evId],sizeof(EXEC_EVENT));
         break;
      case WRITE_ONE :
         execData->enable = ON;
         memcpy(&execEvent[evId],execData,sizeof(EXEC_EVENT));
         execData->addr.space = TransferSpace(execData->addr.space);
         ExbpSet(execData->addr.pos,execData->addr.space,evId+1);
         AccessStatusFlag(WRITE_ONE,BKPT,&evId);
         break;
      case READ_ALL :
         memcpy(execData,execEvent,sizeof(EXEC_EVENT) * MAX_EXEC_EVENT_NO);
         break;
      case WRITE_ALL :
         memcpy(execEvent,execData,sizeof(EXEC_EVENT) * MAX_EXEC_EVENT_NO);
         for (lp = 0; lp <= 1 ; lp++) {
            execData[lp].addr.space = TransferSpace(execData[lp].addr.space);
            ExbpSet(execData[lp].addr.pos,execData[lp].addr.space,lp+1);
            if (execData[lp].enable == 0) AccessStatusFlag(CLEAR_ONE,BKPT,&lp);
            else AccessStatusFlag(WRITE_ONE,BKPT,&evId);
         }
         break;
      case CLEAR_ONE :
         memcpy(&execEvent[evId],&clrExecEvent,sizeof(EXEC_EVENT));
         AccessStatusFlag(CLEAR_ONE,BKPT,&evId);
         break;
      case CLEAR_ALL :
         for (lp = 0; lp < MAX_EXEC_EVENT_NO; lp++) {
            memcpy(&execEvent[lp],&clrExecEvent,sizeof(EXEC_EVENT));
            AccessStatusFlag(CLEAR_ONE,BKPT,&lp);
         }
         break;
   }
   //   if (errFlag) return init error or done error.
};

/****************************************************************************
**
**  AccessExecEvent
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS ReadTraceFrame(U16 frame, TRACE_DATA *frameData,U8 traceMode) {
   return(OK);
}


/****************************************************************************
**
**  ReadTraceCount
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS ReadTraceCount(TRACE_INFO *traceData) {
   return(GOOD);
};

/****************************************************************************
**
**  EmuHalt
**
**  Description: Michelle trace-group routine, to stop the target CPU.
**               Stop execution of target CPU.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        -- O.K. for Normal return
**        -- Fatal Error code return for HW emulator error :
**             BusRq, Reset, NoClock, CPU not Ready ...
**        return data -- "length" + "PC"
**
**
****************************************************************************/
VOID EmuHalt(VOID) {
STATUS status;
U32 baseReg[MAX_BASE_REG_NO];
U8 dataLen;
U32 pc;

   status = GOOD;
   StopRun();
   ClrViolFlg();
   DisEmStop();
   status = CheckViolation();
   AccessBaseReg(READ_ALL,noUse,baseReg);
   pc = baseReg[R_PC];
   OutputStatus(status,OFF);
   if (status == OK) {
      dataLen = 4;
      OutData(dataLen,&pc,ON);
   }
   OutEnd();
}

/****************************************************************************
**
**  EmuAbort
**
**  Description: Michelle trace-group routine, to abort the michelle.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data -- "length" + "PC" + "brealFlag"
**
**
****************************************************************************/
VOID EmuAbort(VOID) {
STATUS status, flgViolation=0;
U8 epFlag,goEndFlag = 0;
U16 traceBufNo,cnt0,cnt1,traceing;
U32 baseReg[MAX_BASE_REG_NO];
U32 tmpCnt;

   status = GOOD;
//   epFlag = (U8)CheckEpStop();
//   if (epFlag == ON) {
//      if (RunAndMatch()) status = CheckHwStatus();
//      if (RunAndMatch())
//         status = GOOD;
//      else status = BROKE;
//   }
//   else status = HALT_USER;
   goEndFlag = 1;
   AccessBaseReg(READ_ALL,noUse,baseReg);
//   if (status != BROKE) {
      switch (status = GoEnd(baseReg)) {
         case 0:
//            break;
         case 7:
            status = HALT_USER;
            break;
         case 1:
            status = BKPT1_HALT;
            break;
         case 2:
            status = BKPT2_HALT;
            break;
         case 3:
            status = SW_BKPT_HALT;
            break;
         case 4:
            status = TRIG_HALT;
            break;
         case 5:
            status = RBW_HALT;
            break;
         case 6:
//            status = VIOL_HALT;
//            flgViolation = CheckViolation();
//            if (flgViolation != GOOD)
//               status = HALT_USER;
            status = CheckViolation();
            break;
         case 8: // check exceptBreak
            break;
      }
      DisEmStop();
//      if (status == GOOD) {
//         flgViolation = CheckViolation();
//         if (flgViolation != GOOD)
//            status = HALT_USER;
//      }
      EnEmDisViol();
      AccessBaseReg(WRITE_ALL,noUse,baseReg);
//   }
   AccessIceFlag(WRITE_ONE,FLYING,&C_OFF);
   AccessIceFlag(WRITE_ONE,RUNNING,&C_OFF);
   AccessIceFlag(WRITE_ONE,BROKE_REASON,&status);
   Exbp1Disable();
   Exbp2Disable();
   AccessIceFlag(READ_ONE,TRACEING,&traceing);
   if (mtatExist && traceing) {
      ProgramTMANStatic(&traceBufNo,&tmpCnt);
      AccessIceFlag(WRITE_ONE,TRACEING,&C_OFF);
      cnt1 = HighWord(tmpCnt);
      cnt0 = LowWord(tmpCnt);
      AccessIceFlag(WRITE_ONE,TRACED_BUFF_NO,&traceBufNo);
      AccessIceFlag(WRITE_ONE,COUNTER1,&cnt1);
      AccessIceFlag(WRITE_ONE,COUNTER0,&cnt0);
   }
   if (exceptBreak) 
      OutputExceptReason(OFF);
   else if (flgViolation != GOOD) 
      OutputStatus(flgViolation,OFF);
   else
      OutputStatus(status,OFF);
   OutData(1,&goEndFlag,OFF);
   OutEnd();

}

/****************************************************************************
**
** EmuGo
**
**  Description: Michelle trace-group routine, to set the target CPU free
**               running. Default free running target CPU from current PC.
**
**  Parameters:
**     input:
**        mode -- int
**        addr -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        status-code = "BROKE"     --> Program broke at breakpoint.
**        status-code = "USER_HALT" --> Aborted by user.
**        status-code = "HALT"      --> Target CPU Halted.
**
**        return data -- "length" + "PC" + "brealFlag"
**
**  NOTE: The firmware should reserve an execution breakpoint to be used
**        as the temporary breakpoint implementation.
**
****************************************************************************/
U8 timeFlag,timeOver;
STATUS StartGo(S16 mode) {
U32 baseReg[MAX_BASE_REG_NO];
U16 evId,syncIn,phyTrigSet,flyFlag;
STATUS status;

   if (mtatExist) {
      //if ((mode != FREE_RUN) && (mode != TEST_RUN)) {
      if (mode == FREE_RUN /*run*/ || (mode == TEST_RUN)) {
         SetPhyTrig(mode);
         AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
      }
      else {
        AccessIceFlag(READ_ONE,PHY_TRIG_SET,&phyTrigSet);
        if (phyTrigSet == C_OFF) {
           SetPhyTrig(mode);
           AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_ON);
        }
      }
      AccessIceFlag(READ_ONE,FLYING,&flyFlag);
      if (flyFlag == C_OFF) {
         ProgramTMANTrace();
         AccessIceFlag(WRITE_ONE,TRACEING,&C_ON);
      }
   }
   AccessIceFlag(WRITE_ONE,EP_RUN,&C_OFF);
   AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_ON);
   if (mode == FREE_RUN /*run*/) {
      Exbp1Disable();
      Exbp2Disable();
   }
   else {
      if (mode == FLY_RUN) AccessIceFlag(WRITE_ONE,FLYING,&C_ON);
      evId = 0;
      AccessStatusFlag(READ_ONE,BKPT,&evId);
      if (evId) Exbp1Enable();
      else Exbp1Disable();
      evId = 1;
      AccessStatusFlag(READ_ONE,BKPT,&evId);
      if (evId) Exbp2Enable();
      else Exbp2Disable();
   }
   ClrViolFlg();
   //if (mode == TEST_RUN) EnEmDisViol(); // special for function test.
   //else EnEmRun();
   EnEmRun(); //added by Kevin  10/9/95
// removed by kevin 10/9/95   EnEmDisViol();  // temp instruction.
   AccessBaseReg(READ_ALL,noUse,baseReg);
   GoEp(baseReg);
   AccessIceFlag(WRITE_ONE,RUNNING,&C_ON);
   AccessIceFlag(WRITE_ONE,BROKE_REASON,&C_ON);
   timeOver = timeFlag = 0;
   AccessIceFlag(READ_ONE,SYNC_IN,&syncIn);
   status = GOOD;
   if (syncIn && Pending()) {
      AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_OFF);
      status = EP_PENDING;
   }
   return(status);
}

VOID EmuGo(S16 mode) {
STATUS status;

   status = StartGo(mode);
   if (exceptBreak != GOOD) OutputExceptReason(ON);
   else OutputStatus(status,ON);
}

/****************************************************************************
**
** EmuGetCpuStatus
**
**  Description: Michelle trace-group routine, to set the target CPU free
**              running. Default free running target CPU from current PC.
**               "mode" is to indicate the mode of free-running.
**               "mode" = 1 --> no temporary breakpoint is specified.
**               "mode" = 2 --> set temporary breakpoint at "addr" location
**
**  Parameters:
**     input:
**        mode -- int
**        addr -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        status-code = "BROKE"     --> Program broke at breakpoint.
**        status-code = "USER_HALT" --> Aborted by user.
**        status-code = "HALT"      --> Target CPU Halted.
**
**        return data -- "length" + "PC" + "brealFlag"
**
**  NOTE: The firmware should reserve an execution breakpoint to be used
**        as the temporary breakpoint implementation.
**
****************************************************************************/
VOID EmuGetCpuStatus(VOID) {
   STATUS status,brokeReason;
   U8 epFlag,goEndFlag = 0;
   U32 baseReg[MAX_BASE_REG_NO];
   U16 traceBufNo,cnt0,cnt1,flyFlag,syncIn,epRun,runFlag;
   U32 tmpCnt;

   status = GOOD;
   goEndFlag = 0;
   AccessIceFlag(READ_ONE,BROKE_REASON,&brokeReason);
   AccessIceFlag(READ_ONE,RUNNING,&runFlag);
   if (runFlag == OFF) {
      status = brokeReason;
      goEndFlag = 1;
   }
   else {
      AccessIceFlag(READ_ONE,FLYING,&flyFlag);
      AccessIceFlag(READ_ONE,EP_RUN,&epRun);
      AccessIceFlag(READ_ONE,SYNC_IN,&syncIn);
      if ((epRun == C_OFF) && (syncIn)) {
//         if((epFlag = (U8)CheckEpStop()) == OFF)
//            AccessIceFlag(WRITE_ONE,EP_RUN,&C_ON);
//         else status = EP_PENDING;
         if (Pending()) {
            status = EP_PENDING;
            goEndFlag = 1;
         } else {
            AccessIceFlag(WRITE_ONE,EP_RUN,&C_ON);
            AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_ON);
         }
      }
      else {
         if (!RunAndMatch()) {
            if (CheckEpStop()) {
               status = brokeReason;
               goEndFlag = 1;
            }
            else if((timeOver = CheckTimeOut()) != timeFlag) {
               if(timeOver != 0 && (U8)CheckEpStop() == OFF) {
                  SetExceptBreak();
                  status = TIME_OUT;
                  if ((exceptBreak == 1) ||  // Bus request
                      (exceptBreak == 8) ||  // Target is halted
                      (exceptBreak == 16))   // Target is reset
                     goEndFlag = 0;
                  else goEndFlag = 1;
                  timeFlag = timeOver;
               }
            }
         }
         else {
            goEndFlag = 1;
            AccessBaseReg(READ_ALL,noUse,baseReg);
            switch (status = GoEnd(baseReg)) {
               case 0:
                  break;
               case 7:
                  status = HALT_USER;
                  break;
               case 1:
                  status = BKPT1_HALT;
                  break;
               case 2:
                  status = BKPT2_HALT;
                  break;
               case 3:
                  status = SW_BKPT_HALT;
                  break;
               case 4:
                  status = TRIG_HALT;
                  break;
               case 5:
                  status = RBW_HALT;
                  break;
               case 6:
                  status = VIOL_HALT;
                  break;
               case 8: // check exceptBreak
                  break;
            }
            AccessBaseReg(WRITE_ALL,noUse,baseReg);
            DisEmStop();
            AccessIceFlag(WRITE_ONE,FLYING,&C_OFF);
            AccessIceFlag(WRITE_ONE,RUNNING,&C_OFF);
            AccessIceFlag(WRITE_ONE,BROKE_REASON,&status);
            Exbp1Disable();
            Exbp2Disable();
            if (mtatExist) {
               ProgramTMANStatic(&traceBufNo,&tmpCnt);
               AccessIceFlag(WRITE_ONE,TRACEING,&C_OFF);
               cnt1 = HighWord(tmpCnt);
               cnt0 = LowWord(tmpCnt);
               AccessIceFlag(WRITE_ONE,TRACED_BUFF_NO,&traceBufNo);
               AccessIceFlag(WRITE_ONE,COUNTER1,&cnt1);
               AccessIceFlag(WRITE_ONE,COUNTER0,&cnt0);
            }
         }
      }
   }
   if (exceptBreak) OutputExceptReason(OFF);
   else if (status == GOOD) {
      if (flyFlag) OutputStatus(CPU_FLY,OFF);
      else OutputStatus(GOOD,OFF);
   }
   else OutputStatus(status,OFF);
   OutData(1,&goEndFlag,OFF);
   OutEnd();
}

//VOID EmuGetCpuStatus(VOID) {
//STATUS status;
//U8 epFlag,goEndFlag = 0;
//U16 baseReg[MAX_BASE_REG_NO],traceBufNo,cnt0,cnt1,epRun;
//U16 flyFlag;
//U32 tmpCnt;
//
//   status = GOOD;
//   AccessIceFlag(READ_ONE,FLYING,&flyFlag);
//   AccessIceFlag(READ_ONE,EP_RUN,&epRun);
//   if (epRun == C_OFF) {
//      if((epFlag = (U8)CheckEpStop()) == OFF)
//         AccessIceFlag(WRITE_ONE,EP_RUN,&C_ON);
//      else status = EP_PENDING;
//      goEndFlag = 0;
//      if (exceptBreak) OutputExceptReason(OFF);
//      else OutputStatus(status,OFF);
//      OutData(1,&goEndFlag,OFF);
//      OutEnd();
//      return;
//   }
//   if (!RunAndMatch()) {
//      if((timeOver = CheckTimeOut()) != timeFlag) {
//         if(timeOver != 0 && (U8)CheckEpStop() == OFF) {
//            SetExceptBreak();
//            status = TIME_OUT;
//            goEndFlag = 0;
//            timeFlag = timeOver;
//         }
//      }
//   }
//   else {
//      status = CheckHwStatus();
//      if (status == USER_CC) goEndFlag = 0;
//      else {
//         goEndFlag = 1;
//         AccessBaseReg(READ_ALL,noUse,baseReg);
//         GoEnd(baseReg);
//         AccessBaseReg(WRITE_ALL,noUse,baseReg);
//         DisEmStop();
//         if (status == GOOD) status = CheckViolation();
//         AccessIceFlag(WRITE_ONE,FLYING,&C_OFF);
//         Exbp1Disable();
//         Exbp2Disable();
//         if (mtatExist) {
//            ProgramTMANStatic(&traceBufNo,&tmpCnt);
//            cnt1 = HighWord(tmpCnt);
//            cnt0 = LowWord(tmpCnt);
//            AccessIceFlag(WRITE_ONE,TRACED_BUFF_NO,&traceBufNo);
//            AccessIceFlag(WRITE_ONE,COUNTER1,&cnt1);
//            AccessIceFlag(WRITE_ONE,COUNTER0,&cnt0);
//         }
//      }
//   }
//   if (exceptBreak) OutputExceptReason(OFF);
//   else if (status == GOOD) {
//      if (flyFlag) OutputStatus(CPU_FLY,OFF);
//      else OutputStatus(GOOD,OFF);
//   }
//   else OutputStatus(status,OFF);
//   OutData(1,&goEndFlag,OFF);
//   OutEnd();
//}
//

/****************************************************************************
**
**  EmuSetEvent
**
**  Description: Michelle trace-group routine, to define a bus event.
**               Set a bus event, the "addrspec" and "dataspec" are
**               defined as followings:
**               = "0" --> address/data field is not defined
**               = "1" --> address/data field is a single value
**               = "2" --> address/data field is a range value
**               = "3" --> address/data with a mask value.
**
**               "addrhi/datahi" is a wildcard value. "0" means "don't care".
**               EX. wildcard value 0xfffffffc means bit-0 and bit-1 are
**               "don't care".
**
**  Parameters:
**     input:
**     ev_id    -- int,
**     addrspec -- unsigned int,
**     addrlo   -- unsigned long,
**     addrhi   -- unsigned long,
**     dataspec -- unsigned int,
**     datalo   -- unsigned int,
**     datahi   -- unsigned int,
**     stat     -- unsigned int,
**     count    -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetEvent(U16 evId, U8 *busEventData) {
STATUS status;
BUS_EVENT locEvent;

   status = GOOD;
   StopRun();
   memcpy(&locEvent,busEventData,sizeof(locEvent));
   status = AccessBusEvent(WRITE_ONE,evId,&locEvent);

   OutputStatus(status,ON);/* Before add other data to outputStream, len - 1 */

}

/****************************************************************************
**
**  EmuSetAllEvent
**
**  Description: Michelle trace-group routine, to define a bus event.
**               Set a bus event, the "addrspec" and "dataspec" are
**               defined as followings:
**               = "0" --> address/data field is not defined
**               = "1" --> address/data field is a single value
**               = "2" --> address/data field is a range value
**               = "3" --> address/data with a mask value.
**
**               "addrhi/datahi" is a wildcard value. "0" means "don't care".
**               EX. wildcard value 0xfffffffc means bit-0 and bit-1 are
**               "don't care".
**
**  Parameters:
**     input:
**     ev_id    -- int,
**     addrspec -- unsigned int,
**     addrlo   -- unsigned long,
**     addrhi   -- unsigned long,
**     dataspec -- unsigned int,
**     datalo   -- unsigned int,
**     datahi   -- unsigned int,
**     stat     -- unsigned int,
**     count    -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetAllEvent(U8 *busData,U8 *execData,U8 *extData) {
STATUS status;

   status = GOOD;
   if (mtatExist) AccessBusEvent(WRITE_ALL,noUse,(BUS_EVENT *)busData);
   else status = NO_TRACE_MODULE;

   AccessExecEvent(WRITE_ALL,noUse,(EXEC_EVENT *)execData);

   memcpy(&extEvent,extData,sizeof(extEvent));

   OutputStatus(status,ON);/* Before add other data to outputStream, len - 1 */
}


/***************************************************************************
**
**  EmuSetExBkpt
**
**  Description: Michelle trace-group routine, to define an execution
**               brekpoint. (Set an execution breakpoint.)
**
**  Parameters:
**     input:
**        evId --
**        addr  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetExBkpt(U16 evId, ADDR *addr) {
EXEC_EVENT execEvent;

   StopRun();
   execEvent.addr.pos = addr->pos;
   execEvent.addr.space = addr->space;
   evId -= 10;
   AccessExecEvent(WRITE_ONE,evId,&execEvent);
   AccessStatusFlag(WRITE_ONE,BKPT,&evId);

   OutputStatus(GOOD,ON);/* Before add other data to outputStream, len - 1 */

}

/***************************************************************************
**
**  EmuSetExtEvent
**
**  Description: Michelle trace-group routine, to define an execution
**               brekpoint. (Set an execution breakpoint.)
**
**  Parameters:
**     input:
**        evId --
**        addr  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetExtEvent(U16 evData) {

   AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
   extEvent = evData;
   SelectExternalTraceBit(HighByte(extEvent));
   OutputStatus(GOOD,ON);
}


/***************************************************************************
**
**  EmuClrEvent
**
**  Description: Michelle trace-group routine, to clear the setting of
**               event(s) -- bus or execution breakpoint.
**
**  Parameters:
**     input:
**        ev_id -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuClrEvent(U16 evId) {
STATUS status;

   status = GOOD;
   if (evId == 0x0) {             // clear all events
      if (mtatExist) AccessBusEvent(CLEAR_ALL,noUse,(BUS_EVENT *)&noUse);
      else status = NO_TRACE_MODULE;
      AccessExecEvent(CLEAR_ALL,noUse,(EXEC_EVENT *)&noUse);
//      extEvent = 0x0800;
//      AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
   } else if (evId == 0xFFFF) {   // clear all bus events
      if (mtatExist) AccessBusEvent(CLEAR_ALL,noUse,(BUS_EVENT *)&noUse);
      else status = NO_TRACE_MODULE;
   } else if (evId >= 1 && evId <= 8) {
           if (mtatExist) AccessBusEvent(CLEAR_ONE,evId,(BUS_EVENT *)&noUse);
           else status = NO_TRACE_MODULE;
        }
   else if (evId == 10 || evId == 11) AccessExecEvent(CLEAR_ONE,evId-10,(EXEC_EVENT *)&noUse);
   else {
      AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
      extEvent = 0x0800;
   }

   OutputStatus(status,ON);
}

/***************************************************************************
**
**  EmuGetEvent
**
**  Description: Michelle trace-group routine, to clear the setting of
**               event(s) -- bus or execution breakpoint.
**
**  Parameters:
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuGetAllEvent(VOID) {
U8 totalLen,lp;
//U8 tempEvBuff[256];
BUS_EVENT tempEvBuff[MAX_BUS_EVENT_NO];

   if (mtatExist) OutputStatus(GOOD,OFF);
   else OutputStatus(NO_TRACE_MODULE,OFF);
   totalLen = sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO +
              sizeof(EXEC_EVENT) * MAX_EXEC_EVENT_NO + sizeof(extEvent);
   OutLength(totalLen);

 AccessBusEvent(READ_ALL,noUse,tempEvBuff);
 for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++)
    OutData(sizeof(BUS_EVENT),(U8 *)(&tempEvBuff[lp]),OFF);
 //OutData(sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO,(U8)tempEvBuff,OFF);

 AccessExecEvent(READ_ALL,noUse,(EXEC_EVENT *)tempEvBuff);
 OutData(sizeof(EXEC_EVENT) * MAX_EXEC_EVENT_NO,tempEvBuff,OFF);

 OutData(sizeof(extEvent),&extEvent,OFF);

 OutData(sizeof(tcFlag),&tcFlag,OFF);

 OutData(sizeof(counter0),&counter0,OFF);

 OutData(sizeof(counter1),&counter1,OFF);

 OutEnd();

}

/***************************************************************************
**
**  EmuListTrace
**
**  Description: Michelle trace-group routine, to list raw data from the
**               trace buffer.
**               List trace buffer content in RAW data format which is
**               similar to the output of LOSTAN command in MICE-III.
**               The "frame" is the starting listing frame. If "frame" is
**               "-1", <ew MICE will return the number of frames in the
**               trace buffer.
**
**  Parameters:
**     input:
**        frame -- U16
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        list trace -- ("length" + "frame_data") *
**                      (min(256, "rest_frames_ in_trace_buffer"))
**        return count -- "length" + "number"
**
****************************************************************************/
VOID EmuListTrace(U16 traceBufId, S32 frameNo,U8 *condition) {
STATUS status;
U8 frameWidth,frameData[64*20]; // 64 frame, each frame is 20-bytes width
TRACE_HEAD traceHead;
U16 lp;
U8 tempTraceBuff[20];

   if (condition[0]) { // Qualify list has frame number (4 bytes).
      frameWidth = 20;
   }
   else {
      frameWidth = 16;
   }
   status = GOOD;
   StopRun();
   traceHead.traceBufId = traceBufId;
   traceHead.startFrame = frameNo;
   traceHead.traceform = CYCLE_TRACE;
   status = ListTraceBuffer(&traceHead,(QUALIFY_LIST *)condition, frameData);
   if (status == GOOD) {
      OutputStatus(GOOD,OFF);
      OutLength((U8)traceHead.frameLen);
      for (lp = 0; lp < traceHead.frameLen; lp++) {
         memcpy (&tempTraceBuff,frameData+lp*frameWidth,frameWidth);
         OutData(frameWidth,tempTraceBuff,OFF);
      }
      OutEnd();
   }
   else OutputStatus(status,ON);
}


/***************************************************************************
**
**  EmuSetTraceBuff
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuSetTraceBuff(U16 traceBufNum) {
STATUS status;
TRIG_LOC traceDelay;
U16 breakFull,tmpBufNum;

   status = GOOD;
   //StopRun();
   AccessIceFlag(READ_ONE,TRACE_MODE,&traceDelay);
   AccessIceFlag(READ_ONE,TRACE_BREAK,&breakFull);
   AccessIceFlag(READ_ONE,TRACE_BUFF,&tmpBufNum);
   if (traceBufNum != tmpBufNum) {
      status = ConfigTrace(traceBufNum,traceDelay,(BOOLEAN)breakFull);
      AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_OFF);
      AccessIceFlag(WRITE_ONE,TRACE_BUFF,&traceBufNum);
   }

   OutputStatus(status,ON);
}

/***************************************************************************
**
**  EmuGetTraceInfo
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuGetTraceInfo(VOID) {
U16 lastBufNo,cnt0,cnt1,traceBufNo;

   AccessIceFlag(READ_ONE,TRACED_BUFF_NO,&lastBufNo);
   AccessIceFlag(READ_ONE,COUNTER1,&cnt1);
   AccessIceFlag(READ_ONE,COUNTER0,&cnt0);
   AccessIceFlag(READ_ONE,TRACE_BUFF,&traceBufNo);

   OutputStatus(GOOD,OFF);

   OutData(sizeof(lastBufNo),&lastBufNo,OFF);

   OutData(sizeof(cnt1),&cnt1,OFF);

   OutData(sizeof(cnt0),&cnt0,OFF);

   OutData(sizeof(traceBufNo),&traceBufNo,OFF);

   OutEnd();
}

/***************************************************************************
**
**  EmuSetTraceBreak
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuSetTraceBreak(U16 breakFull) {
STATUS status;
TRIG_LOC traceDelay;
U16 traceBufNum;

   status = GOOD;
   AccessIceFlag(READ_ONE,TRACE_MODE,&traceDelay);
   AccessIceFlag(READ_ONE,TRACE_BUFF,&traceBufNum);
   AccessIceFlag(WRITE_ONE,TRACE_BREAK,&breakFull);
   status = ConfigTrace(traceBufNum,traceDelay,(BOOLEAN)breakFull);

   OutputStatus(GOOD,ON);/* Before add other data to outputStream, len - 1 */
}

/***************************************************************************
**
**  EmuGetTraceDepth
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuGetTraceDepth(U16 traceBufId) {
STATUS status;
U16 buffFill;
U8 tempDepthBuff[8];

   status = GOOD;
   AccessIceFlag(READ_ONE,BUFFER_FILL,&buffFill);
   if (buffFill == ON) {
      if (!gotTrigInfoOfTrcBuf[traceBufId])
         status = GetTrigInfoOfTrcBuf(traceBufId);
      if (status) OutputStatus(status,ON);
      else {
         OutputStatus(GOOD,OFF);
         memcpy (tempDepthBuff,&startLogFrameOfTrcBuf[traceBufId],4);
         memcpy (tempDepthBuff+4,&endLogFrameOfTrcBuf[traceBufId],4);
         OutData(8,tempDepthBuff,ON);
         OutEnd();
      }
   }
   else OutputStatus(BUFFER_EMPTY,ON);
}

/***************************************************************************
**
**  EmuClrTrig()
**
**  Description: Michelle trace-group routine, to clear the trigger setting.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuClrTrig(U16 levelNo) {
U16 lp,action[11],ev[11];;

   for (lp = 0; lp < 11; lp++)
      ev[lp] = action[lp] = 0;
   if (levelNo == 0x0) { // Clear all trigger.
      for (lp = 1; lp <= 4; lp++)
         EmuSetTrig(lp,ev,action,1);
   }
   else EmuSetTrig(levelNo,ev,action,1);
   OutputStatus(GOOD,ON);/* Before add other data to outputStream, len - 1 */
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
U16 ConvertTrigOut(U16 setData) {
U16 convData;

   //setData = 0;
   convData = (setData & maskBit) << 2;           //BREAK(0) to BRK(2)
   if (setData & (maskBit << 3)) convData |= (maskBit2 <<  3);  //TOFF(3) to TRIGH(4) and TRIGC(3)
   //convData += (setData & (maskBit <<  3)) << 1;  //TOFF(3) to TRIGH(4)
   convData |= (setData & (maskBit <<  4)) >> 1;  //NEXT(4) to TRIGC(3)
   convData |= (setData & (maskBit <<  5)) << 6;  //INC0(5) to INCR0(11)
   convData |= (setData & (maskBit <<  6)) << 3;  //RST0(6) to CLEAR0(9)
   convData |= (setData & (maskBit <<  7));       //INC1(7) to INCR1(7)
   convData |= (setData & (maskBit <<  8)) >> 3;  //RST1(8) to CLEAR1(5)
   convData |= (setData & (maskBit << 10)) >> 10; //EXTOUT(10) to SWATOFF(0)
   convData |= (setData & (maskBit << 1)) << 12; //RESET(1) to tempReset(13)
   convData |= (setData & (maskBit << 2)) << 12; //SEQ(2) to tempSeq(14)
   convData |= (setData & (maskBit << 11)) >> 1; //timer set STOP0
   return(convData);

}
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
U16 SetTrigLevel(TRIGGER *trig, U16 levelNo,S16 runMode) {
U16 tempAddr,lp,lp2,traceBufNum;
U8 extEvPin;

   for (lp = 0; lp < 13; lp++)
      trigOut[lp].addr = trigOut[lp].data = 0;

   if (tcFlag == TC_TIMER) {
      for (lp = 0; lp < (U16)EVENT_NO; lp++)
         if (!trig->ev[lp]) break;
      for (lp2 = 0; lp2 < lp; lp2++)
         if (trig->ev[lp2] == 11) { // timer setting.
            if (counter1 > 0) {    // timer > 1024
               trig->ev[lp] = 10;  // counter 0 must set inc1 active.
               trig->act[lp] = 0x80; // inc0 setting.
            }
            else trig->ev[lp2] = 10;  // move timer setting to counter0.
            trig->act[lp2] |= 0x0800; // use bit 11 to set stop0.
            break;
         }
   }

   AccessIceFlag(READ_ONE,TRACE_BUFF,&traceBufNum);
   for (lp = 0; lp < (U16)EVENT_NO; lp++) {
      if (!trig->ev[lp]) break;
      if (tempAddr = (trig->act[lp] & (maskBit << 9))) // ext trigger setting(9)
         trigOut[lp].addr = tempAddr << 1; // Set ext. trig (10)
      else trigOut[lp].addr = 0;
      if (traceBufNum == 1) trigOut[lp].data &= 0xffef; // mask NEXT.
      switch (trig->ev[lp]) {
         case 9 : // external event
            extEvPin = HighByte(extEvent);
            if (extEvPin < 8) trigOut[lp].addr = maskBit << 10;
            //trigOut[lp].addr = maskBit << 10;
            break;
         case 10 : // count 0
         case 11 : // count 1
            trigOut[lp].addr = maskBit << (trig->ev[lp]-2);
            break;
         default : // ev1 - ev8
            trigOut[lp].addr += (maskBit << (phyEv[trig->ev[lp]-1]));
      }
      trigOut[lp].data = ConvertTrigOut(trig->act[lp]);
      if ((runMode == FREE_RUN) || (runMode == TEST_RUN)) trigOut[lp].data &= 0xfffb; // mask BREAK.
   }

   return(lp);
}

/***************************************************************************
**
**  EmuGetTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuGetAllTrig(VOID) {
U8 dataLen,lp;

   OutputStatus(GOOD,OFF);
   dataLen = sizeof(TRIGGER);
   for (lp = 0; lp < TRIG_NO; lp++) {
      OutData(dataLen,&trigLevel[lp],ON);
   }
   OutEnd();
}

/***************************************************************************
**
**  EmuSetTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetTrig(U16 levelNo, U16 *events, U16 *actions,U16 mode) {
U16 traceDelay;
STATUS status;

   status = GOOD;
   AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
   levelNo--;
   if (levelNo == 0) {
      switch (mode) {
         case 0:
            traceDelay = PRE_TRIG; break;
         case 1:
            traceDelay = POST_TRIG; break;
         case 2:
            traceDelay = CENTER_TRIG; break;
      }
      AccessIceFlag(WRITE_ONE,TRACE_MODE,&traceDelay);
      trig.mode = mode;
   }
   trig.defined = ON;
   memcpy(trig.ev,events,11*2);
   memcpy(trig.act,actions,11*2);
   memcpy(&trigLevel[levelNo],&trig,sizeof(TRIGGER));
   OutputStatus(GOOD,ON);
}

/***************************************************************************
**
**  SetPhyTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID SetPhyTrig(S16 runMode) {
U16 evCount,mask2Bit,phyLevelNo,nextLevelNo,lp2;
U16 matchAddr,matchEv,matchExt;
register lp;
U8 far *run0Active;
STATUS status;
U16 levelNo,traceDelay,traceBufNum,breakFull;
U8 extHigh;

   status = GOOD;
   AccessIceFlag(READ_ONE,TRACE_MODE,&traceDelay);
   AccessIceFlag(READ_ONE,TRACE_BREAK,&breakFull);
   AccessIceFlag(READ_ONE,TRACE_BUFF,&traceBufNum);
   status = ConfigTrace(traceBufNum,traceDelay,(BOOLEAN)breakFull);
   mask2Bit = 0x3; // bit 0,1
   for (levelNo = 0; levelNo < 4; levelNo++) {
      phyLevelNo = 3 - levelNo; // inverter.
      evCount = SetTrigLevel(&trigLevel[levelNo],levelNo,runMode);
      /* If timer is set.  */
      for (lp = 0; lp < BUF_SIZE; lp++) // initing table
         trigBuf[0][lp] = trigBuf[1][lp] = 0;

      extHigh = LowByte(extEvent);
      for (lp2 = 0; lp2 < evCount; lp2++) {
         matchAddr = trigOut[lp2].addr;
         matchExt = matchAddr & EXT_EVENT;
         matchEv  = matchAddr & TRIG_EV;
         for (lp = 0; lp < BUF_SIZE; lp++) {
            if ((matchExt) && (extHigh)) { // external event high.
               if (matchEv) { // Bus ev or counter is set and external ev set.
                  if ( (((matchEv ^ lp) & matchEv) == matchEv) &&
                       ((matchExt & lp) == matchExt) ) {
                     trigBuf[1][lp] |= HighByte(trigOut[lp2].data); // High Byte
                     trigBuf[0][lp] |= LowByte(trigOut[lp2].data); // low Byte
                  }
               }
               else { // only external event setting.
                  if ((matchAddr & lp) == matchAddr) {
                     trigBuf[1][lp] |= HighByte(trigOut[lp2].data); // High Byte
                     trigBuf[0][lp] |= LowByte(trigOut[lp2].data); // low Byte
                  }
               }
            }
            else {
               if (matchAddr !=0) {
               if (((matchAddr ^ lp) & matchAddr) == matchAddr) {
                  trigBuf[1][lp] |= HighByte(trigOut[lp2].data); // High Byte
                  trigBuf[0][lp] |= LowByte(trigOut[lp2].data); // low Byte
               }
               }
            }
         }
      }

      for (lp = 0; lp < BUF_SIZE; lp++) { // inverter
         trigBuf[0][lp] = (U8)(~trigBuf[0][lp]);
         trigBuf[1][lp] = (U8)(~trigBuf[1][lp]);
      }

      if (phyLevelNo == 0) nextLevelNo = 3;
      else nextLevelNo = phyLevelNo-1;
      for (lp = 0; lp < BUF_SIZE; lp++) {
         if ((runMode != FREE_RUN) && (runMode != TEST_RUN) &&
             (runMode != NORMAL_RUN) && (!(trigBuf[0][lp] & (maskBit << 2)))) // BRK- setting and not go run.
               trigBuf[0][lp] &= 0xe7; // set TRIGH- and TRIGC- setting.
         //if (!(trigBuf[0][lp] & (mask2Bit << 3))) // both TRIGH-,TRIGC- setting
         //   trigBuf[0][lp] |= 0x08; // clear TRIGC- setting
         //if (!((trigBuf[0][lp] & (maskBit << 7)) | (trigBuf[0][lp] & (maskBit << 5)))) // both INCR1-,RST1- setting
         //   trigBuf[0][lp] |= 0x80; // clear INCR1- setting
         //if (!((trigBuf[1][lp] & (maskBit << 1)) | (trigBuf[1][lp] & (maskBit << 3)))) // both INCR0-,RST0- setting
         //   trigBuf[1][lp] |= 0x08; // clear INCR0- setting
         switch ((trigBuf[1][lp] >> 5) & mask2Bit) {// both RESET-,SEQ setting
             case 0 : // 00 seq & reset
             case 2 : // 10 reset
                trigBuf[1][lp] |= 0x60; // set level 0
                break;
             case 1 : // 01 seq
                trigBuf[1][lp] |= 0x60; // set level 0
                trigBuf[1][lp] &= ((nextLevelNo << 5)+0x9f); // set level is current level
                break;
             case 3 : // 11 no setting
                trigBuf[1][lp] |= 0x60; // set level 0
                trigBuf[1][lp] &= ((phyLevelNo << 5)+0x9f); // set level is current level
                break;
         }
      }

      status = WriteSeqRAMs((U8)levelNo,(U8 *)trigBuf);
   }

   outp(0xf346,1);
   run0Active = (U8 far *) MK_FP(0xb000, 0xbfff); // get state machine address 0 pointer
   if (tcFlag == TC_TIMER) *run0Active = 0xef; // set run0 active.
   else *run0Active = 0xff; // set run0 inactive.
}

/****************************************************************************
**
**  EmuSetTimerCounter
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetTimerCounter(U16 setFlag, U32 setData) {

   switch (setFlag) {
      case TC_COUNT0 :
         if (tcFlag ==  2) counter1 = 0;
         counter0 = (U16)(setData-1);
         break;
      case TC_COUNT1 :
         if (tcFlag ==  2) counter0 = 0;
         counter1 = (U16)(setData-1);
         break;
      case TC_TIMER :
         setData--;
         counter0 = (U16)(setData & 0x3ff);
         counter1 = (U16)(setData >> 10) & 0x3ff;
         //if (counter0 == 0) counter0 = 1;
         break;
   }
   AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
   tcFlag = setFlag;
   OutputStatus(GOOD,ON);
}

/***************************************************************************
**
**  EmuSetQualTrace()
**
**  Description: Michelle trace-group routine, to set qualify trace.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetQualTrace(U32 addr,U32 addrMask,U16 qStatus,U16 qStatusMask) {

   QualTrace(addr,addrMask,qStatus,qStatusMask);
   OutputStatus(GOOD,ON); /* always return GOOD */
}

/***************************************************************************
**
**  EmuDisableQual()
**
**  Description: Michelle trace-group routine, to disable qualify trace.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuDisableQual(VOID) {

   QualDisable();
   OutputStatus(GOOD,ON); /* always return GOOD */
}

/******************************** E O F ***********************************/
