/***************************************************************************
**
**  Name:  emuerror.c
**
**  Description:
**     Michelle error handle processing, there are 4 levels used to
**     indicate the error extent. Each level has the domain to accept
**     the error conditions.
**
**     Two-dimention array to present this error table on the sw site:
**     [0~9][0~31] <--> [level-NO][Error-NO]
**     Transfered from fw's return code <--> U16; High-byte for "level-NO"
**                                                Low-byte for "Error-NO"
**
**     NOTE: should we support multiple-error ? I'll discuss this issue
**           with Matthew to find a reasonable solution then update version
**           of this document in these few days.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcm302/mpfw_302/emuerror.c_v  $
** 
**    Rev 1.0   10 Jun 1996 08:50:30   gene
** Initial revision.
** 
**    Rev 1.1   30 Nov 1995 14:38:42   kevin
** clear excepBreak after calling outputexcept()
** 
**    Rev 1.0   07 Sep 1995 10:47:18   gene
** Initial revision.
** 
** 
**  $Header:   S:/tbird/arcm302/mpfw_302/emuerror.c_v   1.0   10 Jun 1996 08:50:30   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#include <string.h>
#include <dos.h>

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** EmuReportError
**
**  Description: report error by passing/returning an error code to host.
**               This code id included in the status field of
**               the transmiting data record.
**
**  Parameters:
**     input:
**
**
**     output:
**
**
****************************************************************************/
VOID EmuReportError(ERROR_NO errCode) {
   OutputStatus(errCode,ON);
}

/****************************************************************************
**
**  OutputError
**
**  Description: output the status of executive FW to outputStream
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutputError(COMMAND_ID cmdId, STATUS status) {
U16 typeLen;


   typeLen = sizeof(STATUS);
   memcpy (&outputStream[0],&status,typeLen);
   outputStream[typeLen] = 0x00;
   outputStreamLen = typeLen + 1;/* Output stream length */

}

/****************************************************************************
**
**  OutputExceptReason
**
**  Description: output the status of executive FW to outputStream
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutputExceptReason(BOOLEAN endData) {
U16 typeLen,errNo;

   switch (exceptBreak) {
      case 1 : /* Bus Request */
         errNo = BUS_REQUEST;
         break;
      case 2 : /* Target is not ready */
         errNo = NOT_READY;
         break;
      case 4 : /* Target can not step */
         errNo = STEP_ERROR;
         break;
      case 8 : /* Target is halted */
         errNo = MICE_HALT;
         break;
      case 16 : /* Target is reset */
         errNo = TARGET_RESET;
         break;
      case 32 : /* Target Vcc is off */
         errNo = NO_VCC;
         break;
   }
   typeLen = sizeof(U16);
   memcpy (&outputStream[0],&errNo,typeLen);
   outputStreamLen = typeLen;
   if (endData)
      outputStream[outputStreamLen++] = 0x00;/* Output stream length */
   exceptBreak = 0;
}

