/***************************************************************************
**
** File name : exec68k.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
** B. Date -- 10/29/1992 By Cheerson
**     0. Update the include files.
**
**
**
** X. Date -- 12/18/1992 By Cheerson
**    0. Delete iceGetPC() routine.
**    1. Replace the "iceGetPC()" calling of the iceRunUntil() to be
**       iceGetRegister(REG_PC,&addr).
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

//#include <ctype.h>

#ifndef _COMM_
#include "comm.h"
#endif

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG68306_DEFINE_
#include "reg68k.h"
#endif

#ifndef _ABI_EXTERNAL_
#include "abiexts.h"
#endif

#define TRC_BUFF_SIZE         1024
#define TRC_BLOCK_SIZE        64
#define TRC_ARRAY_SIZE        16 //TRC_BUFF_SIZE /TRC_BLOCK_SIZE
S8 bNo[TRC_ARRAY_SIZE];
MP_TRACE_INFO traceBuff[TRC_BUFF_SIZE];
MP_TRACE_INFO qualifyBuff[TRC_BLOCK_SIZE];
S32 oldestFrame,newestFrame;
S16 bufSeg = 0;
U16 curBuffID = 0xffff;

RETCODE GetQualifyFrame(S16 bufID, S32 startFrame, QUALIFY_LIST *cond );

/**************************************************************************
**
** Local define
**
***************************************************************************/

/**************************************************************************
**
** Local variables
**
***************************************************************************/

/**************************************************************************
**
** Externals
**
**************************************************************************/

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceClearEvent(U16 evId) {
RETCODE status;
U16 lp;
U8 varWidth;

   lp = 0;
   SaveId(CLR_EVENT,lp);

   varWidth = sizeof(evId);
   SaveVar(evId,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));

}

/**************************************************************************
**
** Name : iceStepRange()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceStepRange(ADDR addr1, ADDR addr2) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(STEP,lp);

   varWidth = sizeof(addr1);
   SaveVar(addr1,lp,varWidth);

   varWidth = sizeof(addr2);
   SaveVar(addr2,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*4);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
//   iceGetAllReg();
   return(*((U16 *)&inputStream[0]));

}      /* end of iceStepRange() */

/**************************************************************************
**
** Name : iceStepOne()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceStepOne(VOID){
U16 lp;
RETCODE status;

   lp = 0;
   SaveId(STEP_ONE,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*4);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));

}      /* end of iceStepOne() */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceAbort(VOID) {
U16 lp;
RETCODE status;

   lp = 0;
   SaveId(ABORT,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
iceStepRange(U16 addr, S16 OVER) {

unsigned long old, line_begin, line_end, l;
unsigned long oldSP;
unsigned int i;

   old = pc;
   iceGetReg(I86_REG,CS, (U32)&oldCS);
   getAdrRange(old, addr);
    line_begin=RangeAdr.low;
   line_end=RangeAdr.high;
   if (OVER) oldSP = sp;
   if (step_range(line_begin, line_end) == HALT_USER) return(HALT_USER);
   if (!(ABS86_comp_addr(pc, line_end+1))) return(OK);
   if (OVER) {
      if (oldSP == sp) return(OK);
      iceGetReg(I86_REG,CS, &l);
      if (oldCS == l) {
         l = (oldCS << 16);
         l += (getStack(sp,0) & 0xffff);
      } else l = getStack(sp,1);
      if (ABS86_comp_addr(l, line_begin) >= 0 &&
            ABS86_comp_addr(l, line_end+1) <= 0)
         skipSub(); // skip subroutine/interrupt handler
      if (ABS86_comp_addr(pc, line_begin) >= 0 &&
            ABS86_comp_addr(pc, line_end) <= 0)
         step_range(pc, line_end);
   }
   return (OK);
}
*/
/**************************************************************************
**
** Name : iceReset
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceReset(VOID){
RETCODE status;
U16 lp = 0;

   SaveId(RESET,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*(U16 *)(&inputStream[0]));

}
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetCpuStatus(U8 *goEnd) {
U16 lp;
RETCODE status;

   lp = 0;
   SaveId(GET_CPU_STATUS,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   *goEnd = inputStream[2];
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGo(U16 mode) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(GO_COMMAND,lp);

   varWidth = sizeof(mode);
   SaveVar(mode,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   for (lp = 0; lp < TRC_ARRAY_SIZE; lp++)
      bNo[lp] = 0; // clear the cache of trace data.
   curBuffID = 0xffff; // clear bufID
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetTraceBufferInfo(U16 bufID, S32 *start, S32 *end) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(GET_DEPTH,lp);
   varWidth = sizeof(bufID);
   SaveVar(bufID,lp,varWidth);
   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*8);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   //_fmemcpy(&traceDepth[bufID],&inputStream[3],sizeof(struct depth_strct));  // kkk
   _fmemcpy(start,&inputStream[3],sizeof(*start));
   _fmemcpy(end,&inputStream[3+sizeof(*start)],sizeof(*end));
   return(*((U16 *)&inputStream[0]));
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE NextRead(S16 bufID, S32 startFrame){
RETCODE status;
QUALIFY_LIST condition;
U16 lp,index,pos;
U8 varWidth;

   status = GOOD;
   condition.qFlag = OFF;
   lp = 0;
   SaveId(LIST_TRACE,lp);

   varWidth = sizeof(bufID);
   SaveVar(bufID,lp,varWidth);

   varWidth = sizeof(startFrame);
   SaveVar(startFrame,lp,varWidth);

   varWidth = sizeof(QUALIFY_LIST);
   SaveBuff(&condition,lp,varWidth);

   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*8);
   //inputStream[2] = 64;
   index = (startFrame-oldestFrame) % TRC_BUFF_SIZE;
   for(lp = 0; lp < inputStream[2]; lp++) {
      pos = lp*16 + 3;
      traceBuff[index+lp].data   = ((U16)inputStream[pos] << 8);
      traceBuff[index+lp].data  |= inputStream[pos+1];
      traceBuff[index+lp].data2  = *(U16 *)&inputStream[pos+2];
      traceBuff[index+lp].stat   = *(U16 *)&inputStream[pos+4];
      traceBuff[index+lp].tstamp = inputStream[pos+6];
      traceBuff[index+lp].spare  = inputStream[pos+7];
      traceBuff[index+lp].addr   = *(U32 *)&inputStream[pos+8];
      traceBuff[index+lp].misc   = *(U32 *)&inputStream[pos+12];
   }
   return(status);
}

RETCODE EXPORT iceGetTraceFrame(U16 bufID, S32 startFrame,QUALIFY_LIST *cond,
                                U8 *frameLen, MP_TRACE_INFO *frameData) {
S32 i, curFrame;
S32 curSeg, curOffset;
S16 lp,lp2;


   //if (curBuffID != bufID) {
   iceGetTraceBufferInfo(bufID, &oldestFrame, &newestFrame);
   //    curBuffID = bufID;
   //}
   if ((startFrame < oldestFrame) || (startFrame > newestFrame))
      return(ICE_BAD_FRAME);
   if (cond->qFlag == OFF) {
      for (lp = 0; lp < *frameLen; lp++) {
         curFrame = (startFrame+lp)-oldestFrame;
         curSeg = curFrame/TRC_BUFF_SIZE;
         curOffset = curFrame % TRC_BUFF_SIZE;
         if (bufSeg != curSeg || curBuffID != bufID) {
            curBuffID = bufID;
            bufSeg = curSeg;
            for (lp2=0;lp2 < TRC_ARRAY_SIZE; lp2++) bNo[lp2]=0;
         }
         i = curOffset/TRC_BLOCK_SIZE;
         if (!bNo[i]) {
            if (NextRead(bufID, curFrame/TRC_BLOCK_SIZE*TRC_BLOCK_SIZE+oldestFrame)
                == ICE_HALT_USER) return(ICE_HALT_USER);
            bNo[i] = 1;
         }
         memcpy(&frameData[lp], &traceBuff[curOffset],sizeof(MP_TRACE_INFO));
         if ((startFrame+lp+1) >= newestFrame) {
            *frameLen = lp+1;
            break;
         }
      }
   } else {
      GetQualifyFrame(bufID, startFrame, cond);
      memcpy(&frameData[0], &qualifyBuff[0],sizeof(MP_TRACE_INFO));
   }   
   return(GOOD);
}

RETCODE GetQualifyFrame(S16 bufID, S32 startFrame, QUALIFY_LIST *cond ){
RETCODE status;
U16 lp;
U8 varWidth;

   status = GOOD;
   lp = 0;
   SaveId(LIST_TRACE,lp);

   varWidth = sizeof(bufID);
   SaveVar(bufID,lp,varWidth);

   varWidth = sizeof(startFrame);
   SaveVar(startFrame,lp,varWidth);

   varWidth = sizeof(QUALIFY_LIST);
   SaveBuff(cond,lp,varWidth);

   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*8);
   qualifyBuff[0].frameNo = *(U32 *)&inputStream[3];
   qualifyBuff[0].data = *(U16 *)&inputStream[7];
   qualifyBuff[0].data2= *(U16 *)&inputStream[9];
   qualifyBuff[0].stat = inputStream[11];
   qualifyBuff[0].tstamp = inputStream[13];
   qualifyBuff[0].spare  = inputStream[14];
   qualifyBuff[0].addr = *(U32 *)&inputStream[15];
   qualifyBuff[0].misc = *(U32 *)&inputStream[19];
   return(status);
}


//RETCODE EXPORT iceGetTraceFrame(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLen, MP_TRACE_INFO *frameData) {
//U16 lp, l;
//U8 varWidth;
//RETCODE status;
//
//   l = (U16)*frameLen;
//   lp = 0;
//   SaveId(LIST_TRACE,lp);
//
//   varWidth = sizeof(bufID);
//   SaveVar(bufID,lp,varWidth);
//
//   varWidth = sizeof(startFrame);
//   SaveVar(startFrame,lp,varWidth);
//
//   varWidth = sizeof(QUALIFY_LIST);
//   SaveBuff(cond,lp,varWidth);
//
//   outputStream[lp++] = 0;
//
//   SendStream(outputStream,lp);
//   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*8);
//   if (status == ICE_REC_TIME_OUT) return(status);
//   *frameLen = inputStream[2];
//   if (*frameLen > l) *frameLen = l;
//   for (lp = 0; lp < *frameLen; lp++) {
//// vincent      frameData[lp].frameNo = *(U32 *)&inputStream[3+lp*13];
//      l = lp*16 + 3;
//      frameData[lp].data = ((U16)inputStream[l] << 8);
//      frameData[lp].data |= inputStream[l+1];
//      frameData[lp].stat = *(U16 *)&inputStream[l+4];
//      frameData[lp].tstamp = inputStream[l+6];
//      frameData[lp].spare   = inputStream[l+7];
//      frameData[lp].addr = *(U32 *)&inputStream[l+8];
//      frameData[lp].misc = *(U32 *)&inputStream[l+12];
//   }
//   return(*((U16 *)&inputStream[0]));
//}
//
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetEvent(U16 evId, BUS_EVENT *busEventData) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(SET_EVENT,lp);

   varWidth = sizeof(evId);
   SaveVar(evId,lp,varWidth);

   varWidth = sizeof(BUS_EVENT);
   SaveBuff(busEventData,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetAllEvents(BUS_EVENT *event_record, EXEC_EVENT *bp_record, U16 ext_record) {
U16 lp;
U8 varWidth;
RETCODE status;

   lp = 0;
   SaveId(SET_ALL_EVENT,lp);

   varWidth = sizeof(BUS_EVENT)*8;
   SaveBuff(event_record,lp,varWidth);

   varWidth = sizeof(EXEC_EVENT)*2;
   SaveBuff(bp_record,lp,varWidth);

   varWidth = sizeof(U16);
   SaveVar(ext_record,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetExtEvent(U16 evData) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(SET_EXT_EVENT,lp);

   varWidth = sizeof(evData);
   SaveVar(evData,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetEvent(BUS_EVENT *event_record, EXEC_EVENT *bp_record, U16 *ext_record,
                 U8 *cntFlag, U32 *timerRecord, U16 *counter) {
U16 lp,tempFlag,pos,dataLen,data0,data1;
RETCODE status;

   lp = 0;
   SaveId(GET_EVENT,lp);
   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);

   pos = 3;
   dataLen = sizeof(BUS_EVENT)*8;
   _fmemcpy(event_record,&inputStream[pos],dataLen);  // kkk

   pos += dataLen;
   dataLen = sizeof(EXEC_EVENT)*2;
   _fmemcpy(bp_record,&inputStream[pos],dataLen);  // kkk

   pos += dataLen;
   *ext_record = *(U16 *)(&inputStream[pos]);  // kkk

   pos += 2;
   tempFlag = *(U16 *)(&inputStream[pos]);  // kkk

   pos += 2;
   data0 = *(U16 *)(&inputStream[pos]);  // kkk

   pos += 2;
   data1 = *(U16 *)(&inputStream[pos]);  // kkk

   if (tempFlag == 2) { // timer
      *cntFlag = 4;
      *timerRecord = (data1 << 10) + data0 + 1;  // kkk
   }
   else { // counter0 ,counter1
      counter[0] = data0+1;  // kkk
      counter[1] = data1+1;  // kkk
      *cntFlag = 3;
   }
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetBP(U16 evId, ADDR addr) {
U16 lp;
RETCODE status;
U8 varWidth;

// HLFW did bias too.   evId -= 10; // ev0 - ev9 reserve for other event.
   if (addr.space == 8) addr.space = 5;
   lp = 0;
   SaveId(SET_EX_BKPT,lp);

   varWidth = sizeof(evId);
   SaveVar(evId,lp,varWidth);

   varWidth = sizeof(addr);
   SaveVar(addr,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);

   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceClearTrig(U16 levelNo) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(CLR_TRIG,lp);

   varWidth = sizeof(levelNo);
   SaveVar(levelNo,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetTrig(U16 levelNo, MP_TRIGGER *tmpTrig){
RETCODE status;
U16 lp,dataLen;
U8 varWidth;

   lp = 0;
   SaveId(SET_TRIG,lp);

   varWidth = sizeof(levelNo);
   SaveVar(levelNo,lp,varWidth);

   dataLen = sizeof(tmpTrig->evNo);
   SaveBuff(tmpTrig->evNo,lp,dataLen);

   dataLen = sizeof(tmpTrig->act);
   SaveBuff(tmpTrig->act,lp,dataLen);

   varWidth = sizeof(tmpTrig->mode);
   SaveVar(tmpTrig->mode,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));

}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetAllTrig(MP_TRIGGER *trig_record){
RETCODE status;
U16 lp,count;
U8 dataLen;

   lp = 0;
   SaveId(GET_TRIG,lp);

   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) {
      dataLen = inputStream[2];
      count = 3;
      for (lp = 0; lp < 4; lp++) {
         _fmemcpy(&trig_record[lp],&inputStream[count],dataLen);  // kkk
         trig_record[lp].defined = (trig_record[lp].evNo[0] != 0) ? 1 : 0;  // kkk
         count += (dataLen+1);  // kkk
      }
   }
   return(status);

}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetTraceInfo(U16 *lastBuff, U16 *curCNT0, U16 *curCNT1, U16 *bufNO){
RETCODE status;
U16 lp;

   lp = 0;
   SaveId(GET_LAST_BUFF,lp);

   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) {
      *lastBuff = *(U16 *)&inputStream[2] + 1;  // kkk
      *curCNT1 = *(U16 *)&inputStream[4];  // kkk
      *curCNT0 = *(U16 *)&inputStream[6];  // kkk
      *bufNO = *(U16 *)&inputStream[8];  // kkk
   }
   return(status);

}
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetTimerCounter(U16 tcFlag, U32 tcData){
RETCODE status;
U16 lp = 0;
U8 varWidth;

   if (tcFlag == 0 || tcFlag == 1) { // counter-0 & counter-1
      if ((tcData == 0) || (tcData > 1024))
         return(ICE_CNT_ERROR); //output error
   } else { // timer
      if ((tcData == 0L) || (tcData > 0x100000L))
         return(ICE_TIMER_ERROR); // output error
   }

   SaveId(SET_TIMER_COUNTER,lp);

   varWidth = sizeof(tcFlag);
   SaveVar(tcFlag,lp,varWidth);

   varWidth = sizeof(tcData);
   SaveVar(tcData,lp,varWidth);

   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));

}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetTraceBuffer(U16 traceBufNum) {
RETCODE status;
U16 lp;
U8 varWidth;

   lp = 0;
   SaveId(SET_TRACE_BUFF,lp);

   varWidth = sizeof(traceBufNum);
   SaveVar(traceBufNum,lp,varWidth);
   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);

   return(*((U16 *)&inputStream[0]));

}

RETCODE EXPORT iceGetTraceBuffer(U16 *traceBufNum) {

   *traceBufNum = 1;    //vvv
   return(GOOD);

}

RETCODE EXPORT iceGetTriggerFrame(U16 buffer, U32 *frame)
{
   *frame = (U32)0;     // vincent
   return(GOOD);
}
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetTraceBreak(U16 breakFull) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(SET_TRACE_BREAK,lp);

   varWidth = sizeof(breakFull);
   SaveVar(breakFull,lp,varWidth);
   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);

   return(*((U16 *)&inputStream[0]));

}

// the follwoing codes are new added by Vincent
RETCODE EXPORT iceIsTraceBufferFull(U16 buffer, BOOLEAN *full)
{
   *full = TRUE;
   return(ICE_OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetQualTrace(U32 addr,U32 addrMask,U16 qStatus,U16 qStatusMask) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(SET_QUAL_TRACE,lp);

   varWidth = sizeof(addr);
   SaveVar(addr,lp,varWidth);

   varWidth = sizeof(addrMask);
   SaveVar(addrMask,lp,varWidth);

   varWidth = sizeof(qStatus);
   SaveVar(qStatus,lp,varWidth);

   varWidth = sizeof(qStatusMask);
   SaveVar(qStatusMask,lp,varWidth);
   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);

   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceDisableQual(VOID) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(DISABLE_QUAL,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);

   return(*((U16 *)&inputStream[0]));
}
/**************************** End of File **********************************/
