/***************************************************************************
**
** File name : sub68k.c
**
**
**
** Changing :
**
** A. Date -- 10/22/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**

**    Include files
**
***************************************************************************/

#include <conio.h>
#include <time.h>

#ifndef _COMM_
#include "comm.h"
#endif

#ifndef _ABI_
#include "abidef.h"
#endif

#define _REG68306_DEFINE_
#include "reg68k.h"
#endif

#ifndef _ABI_GLOBAL_
#include "abiglbs.h"
#endif

U16 portAddr, portStatus;
/**************************************************************************
**
** Local define
**
***************************************************************************/

#define inportb(a)           inp(a)
#define outportb(a,b)        outp(a,b)
#define HighByte(x)          ((U8)((U16)(x) >> 8))
#define LowByte(x)           ((U8)(x))

#define   RV_RDY         1   /* status of receive ready is 00000001 */
#define   SD_RDY         2   /* status of send ready is    00000010 */

/**************************************************************************
**
** Local define
**
***************************************************************************/

VOID SendStream(U8 *stream, U16 len) ;
RETCODE EXPORT ReceiveStream(U8 *inStream, U16 *inStreamLen,U16 waitSec);

/**************************************************************************
**
** Local variables
**
***************************************************************************/

#define IO_LOOP   20000
/**************************************************************************
**
** Externals
**
**************************************************************************/

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : TransmitByte
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
VOID SetComm(U16 pData) {

   portAddr = pData;
   portStatus = pData+1;
}

/**************************************************************************
**
** Name : TransmitByte
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT TransmitByte(U8 txData) {
   if(inportb(portStatus) & SD_RDY) {
     outportb(portAddr,txData);
     return(1);
   } else return(-1);
}    /* end of TransmitByte(char txc) */

/**************************************************************************
**
** Name :  ReceiveByte
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT ReceiveByte() {
int c;

   if(inportb(portStatus)&RV_RDY) c=inportb(portAddr);
   else c = -1;
   //if (c > 0 && logFlag) writeLog(log_fid, (char)c);
   return(c);
}          /* end of ReceiverByte() */

/**************************************************************************
**
** Name : sendB()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int sendB(U8 txData) {
U16 i;
   for ( i = 0; i < IO_LOOP; i++ )
      if(inportb(portStatus) & SD_RDY) {
         outportb(portAddr,txData);
         return(GOOD);
      }
   return(-1);
}        /* end of sendB() */
/**************************************************************************
**
** Name :  receiveWait()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
receiveWait(U16 waitSec) {
U16 i;
int rxData;
time_t startTime,currentTime;

   time(&startTime);
   while (1) {
     for ( i = 0; i < IO_LOOP; i++ )
        if(inportb(portStatus) & RV_RDY) {
           rxData = inportb(portAddr);
           return(rxData);
        }
     chk_hlt();
     time(&currentTime);
     if ((currentTime - startTime) > waitSec) return(-1);
   }
}        /* end of receiveWait() */

/**************************************************************************
**
** Name : sendWait()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int sendWait(U8 txData) {
U16 i;
   while(1) {
      for ( i = 0; i < IO_LOOP; i++ )
         if(inportb(portStatus) & SD_RDY) {
            outportb(portAddr,txData);
            return(GOOD);
         }
      chk_hlt();
   }
}        /* end of sendB() */
/**************************************************************************
**
** Name : receiveB()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
int receiveB() {
int rxData;
U16 i;
   for ( i = 0; i < IO_LOOP; i++ )
      if(inportb(portStatus) & RV_RDY) {
         rxData = inportb(portAddr);
         //if (rxData > 0 && logFlag) writeLog(log_fid, (char)rxData);
         return(rxData);
      }
   return(-1);
} /* end of receiveB() */

/**************************************************************************
**
** Name : iceDiagnostic()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceDiagnostic(VOID) {
int lp=0;
RETCODE status;

   SaveId(DIAGNOSTIC,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*3);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name : iceDiagnostic()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT DiagnosticFunction(DIAG_ID diagID) {
int lp=0;
RETCODE status;

   SaveId(diagID,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*3);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (status != ICE_OK) {
      switch (diagID) {
         case MCE_MEMORY_TEST :
         case INITIAL_TEST :
            memcpy(&memFailAddress,&inputStream[3],inputStream[2]);
            break;
         case MCE_CONNECT_TEST :
            memcpy(&errorMceConnTest,&inputStream[3],sizeof(ERROR_MCE_CONN_TEST));
      }
   }
   return(status);

}

/**************************************************************************
**
** Name : iceSelfTest()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSelfTest(U16 cmdId) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(FUNCTION_TEST,lp);

   varWidth = sizeof(cmdId);
   SaveVar(cmdId,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*3);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetTimerReg(U16 regNo) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_TIMER_REG,lp);

   varWidth = sizeof(regNo);
   SaveVar(regNo,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSetAccessSize(U16 sizeFlag) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_SIZE,lp);

   varWidth = sizeof(sizeFlag);
   SaveVar(sizeFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetAccessSize(U16 *sizeFlag) {
RETCODE status;
int lp=0;

   SaveId(GET_SIZE,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) *sizeFlag = inputStream[3];
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetStatus(VOID) {
RETCODE status;
int lp;

   lp = 0;
   SaveId(GET_STAT,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSetReady(U16 readyFlag) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_READY,lp);

   varWidth = sizeof(readyFlag);
   SaveVar(readyFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetReady(U16 *readyFlag) {
RETCODE status;
int lp=0;

   SaveId(GET_READY,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) *readyFlag = inputStream[3];
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSetControl(U16 signals) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_CONTROL,lp);

   varWidth = sizeof(signals);
   SaveVar(signals,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetControl(U16 *signals) {
int lp=0;
RETCODE status;

   SaveId(GET_CONTROL,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) memcpy(signals,&inputStream[3],inputStream[2]);
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetMode(U16 *modeFlag) {
int lp;
RETCODE status;

   lp = 0;
   SaveId(GET_MODE,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) *modeFlag = inputStream[3];
//   if (status == ICE_OK) memcpy(modeFlag,&inputStream[3],inputStream[2]);
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetSync(U16 syncFlag) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_SYNC,lp);

   varWidth = sizeof(syncFlag);
   SaveVar(syncFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetSync(U16 *sync) {
int lp=0;
RETCODE status;

   SaveId(GET_SYNC,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) *sync = inputStream[3];
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetVerify(U16 verifyFlag) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_VERIFY,lp);

   varWidth = sizeof(verifyFlag);
   SaveVar(verifyFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetVerify(U16 *verifyFlag) {
int lp=0;
RETCODE status;

   SaveId(GET_VERIFY,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) *verifyFlag = inputStream[3];
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetWait(U16 count) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_WAIT,lp);

   varWidth = sizeof(count);
   SaveVar(count,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetWait(U16 *count) {
int lp=0;
RETCODE status;

   SaveId(GET_WAIT,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) *count = inputStream[3];
   return(status);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetID(U16 idFlag) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_ID,lp);

   varWidth = sizeof(idFlag);
   SaveVar(idFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*(U16 *)&inputStream[0]);

}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetID(U8 *ID_Info) {
int lp=0;
RETCODE status;

   SaveId(GET_ID,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) memcpy(ID_Info,&inputStream[3],inputStream[2]);  // kkk
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT SendAddrLen(ADDR addr, U32 len)
{
int i;
U8 temp[8];

   if (addr.space == 8) addr.space = 5;
   memcpy(temp, &addr,4);
   memcpy(temp+4, &len, 4);

   sendWait(temp[0]);
   for (i = 1; i < 8; i++)
      if (sendB(temp[i]) != GOOD) return(!GOOD);
   return(GOOD);
}

/****************************************************************************
**
**  SendStream
**
**  Description: Send command protocol to communication port.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID SendStream(U8 *stream, U16 len) {
U8 checksum,highLen,lowLen,tempData[0x512];
U16 lp,aa;

   checksum = 0;
   for (lp = 0; lp < len; lp++)
      checksum += stream[lp];
   stream[len] = (~checksum + 1);
   len++;

   lowLen = LowByte(len);
   highLen = HighByte(len);
   checksum = ~(lowLen+highLen) + 1;

   for (;;) {
      sendWait(':');
      if (sendB(lowLen) != GOOD) continue;
      if (sendB(highLen) != GOOD) continue;
      if (sendB(checksum) != GOOD) continue;
      for (lp = 0; lp < len; lp++)
         if (sendB(stream[lp]) != GOOD) continue;
      aa = receiveB();
      if (aa == ACK) return;
      else if (aa == 0xa5) {
        memcpy(tempData,stream,len);
  //    reloadFlag = 1;
        CheckFwStatus();
        linkMICE(1);  // sd186 function or supported function of third  party.
        memcpy(stream,tempData,len);
      }
   }
}

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive output command protocol to communication port.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
RETCODE EXPORT ReceiveStream(U8 *inStream, U16 *inStreamLen,U16 waitSec) {
S16 aa;
U16 len;
U8 checksum,receiveBuf[MAX_COMM_BUFF],finalFlag;
LOOP_VAR lp;

   for (;;) {
      aa = receiveWait(waitSec);
      if (aa == -1) return(ICE_REC_TIME_OUT);
      receiveBuf[0] = (U8)aa;
      finalFlag = ON;
      for(lp = 1; lp < 4; lp++)
         if ((aa = receiveB()) != -1) receiveBuf[lp] = (U8)aa;
         else {
            finalFlag = OFF;
            break;
         }
      if (finalFlag == OFF) return(GOOD); //continue; // new statement
      len = *(U16 *)&receiveBuf[1];   /* data length */
      checksum = 0;
      for(lp = 1; lp < 4; lp++) checksum+= receiveBuf[lp];
      if ((checksum == 0) && (receiveBuf[0] == ':')) {
         finalFlag = ON;
         for (lp = 0; lp < (LOOP_VAR)len; lp++) {
            if ((aa = receiveB()) != -1) receiveBuf[lp] = (U8)aa;
            else {
               finalFlag = OFF;
               break;
            }
            checksum += receiveBuf[lp];
         }
         if (finalFlag == OFF) return(GOOD); //continue; // new statement
         if (checksum == 0) {
            *inStreamLen = len;
            memcpy(inStream,&receiveBuf[0],len);
            if (sendB(ACK) != GOOD) continue;
            return(GOOD);
         }
         else if (sendB(NACK) != GOOD) continue;
      }
   }
}

/**************************** End of File **********************************/
