/****************************************************************************
**
**  Name:  extern.c
**
**  Description:
**     Dodge the 64K limit on DS by extern'ing the error array.
**
**  $Log:   S:/tbird/arcm306/errtext/extern.c_v  $
** 
**    Rev 1.0   07 Sep 1995 10:22:50   gene
** Initial revision.
** 
**    Rev 1.1   30 Mar 1994 18:50:40   STEVE
** Don't include errcodec.h.
** 
**    Rev 1.0   30 Mar 1994 18:34:22   tom
** Initial revision.
** 
**  $Header:   S:/tbird/arcm306/errtext/extern.c_v   1.0   07 Sep 1995 10:22:50   gene  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#define _ERRCODEC_       /* prevent inclusion errors */

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#include <stdio.h>
#include <string.h>

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
U32 externSize(VOID);

/*
 * LOCKED means that you can't change the error code, even if changeCodes
 * is true.
 */
#define LOCKED       1
#define UNLOCKED     2

#define ER_RC_BASE   500
#define ER_HELP_BASE 3000
#define BAD          (GOOD + 666)
#define MAX_ERRORS   1024

U32 externSize(VOID);

typedef struct {
   char * name;
   U32  code;
   char * text;
   char * helpentry;
   U16  flags; /* only LOCKED/UNLOCKED so far */
} ErrorDef;

ErrorDef huge ErrorArray[] = {
#include "mkerrors.h"
};


U32 externSize(VOID)
{
   return (sizeof(ErrorArray));
}
