/****************************************************************************
**
**  Name:  clisrv.h
**
**  Description:
**     Prototypes for registering CLI commands
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcm306/inc/clisrv.h_v  $
** 
**    Rev 1.0   07 Sep 1995 10:25:48   gene
** Initial revision.
** 
**    Rev 1.4   24 Jun 1993 09:51:16   marilyn
** Changed the prototype on InitCServer to use HWND instead of HANDLE for the
** first parameter only.  This was needed to resolve an incompatiblity between
** windows.h for 3.0 and 3.1.  In 3.0 a HWND is the same as a HANDLE, but not
** in 3.1.
** 
**    Rev 1.3   21 Jul 1992 16:41:26   tom
** Added CLI Server System Variables.
** 
**    Rev 1.2   17 Oct 1991 13:59:24   tom
** Include cli constants.
** 
**    Rev 1.1   25 Sep 1991 13:22:36   john
** Needed to change prototype so this function could be called from c++ 
** functions.
** 
**    Rev 1.0   29 Jul 1991 14:19:30   jim
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/inc/clisrv.h_v   1.0   07 Sep 1995 10:25:48   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _CLISRV_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif
#ifndef _CLICONST_
#include "cliconst.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


/*****************************************************
**
** Server data structures for communication with CLI 
**
******************************************************/

/* NOTE:  OBSOLETED BY CLI_NEW_REGISTRATION; KEPT FOR COMPATIBLITY ONLY */
/*
** Struct to be sent as global handle in message to CLI Server
** in order to register server commands.
*/

typedef struct {
	U16	target;			/* to whome addressed? */
	U16	variantCode;		/* CLI_SERVER_REGISTRATION */
	HANDLE	stringResourceHandle;	/* dll handle          */
	U16	serverNameIndex;	/* a string index      */
	U16	dllNameIndex;		/* a string index      */
	U16	numCommands;		/* number of command/syntax pairs */
	U16	commandStartIndex;	/* a string index      */
} CSERVER_REGISTRATION;


/*
**  Struct to be allocated in global handle to be sent to CLI Server with
**  string results ==> to be displayed in transcript.
*/

typedef struct {
	U16	target;			/* to whome addressed? */
	U16	variantCode;		/* CLI_SERVER_RESULTS  */
	U16	resultTextLength;	/* size of results string buffer */
	CHAR	messageText[1];	/* text buffer -- variable sized */
} CSERVER_RESULTS;


/*
**  Struct for sending global variable values to CLI Server.
**  Send message to CLI Server; hWnd is CLI Server handle, wMsg is
**  CLI_SYSTEM_VARIABLE (defined in cliconst.h), wParam is 1 if CLI Server
**  is to deallocate memory, lParam is pointer to the following structure.
*/

typedef struct {
	U16	integerValueFlag;	/* 0 if string value, !0 if integer */
	S32	integerValue;		/* if flag !0, integer value of var */
	LPSTR	variableName;		/* name of system variable */
	LPSTR	stringValue;		/* string value if flag is 0 */
} CSERVER_VARIABLE_VALUE;


/*
** Replacement for CSERVER_REGISTRATION.
** Register with the CLI Server by sending this structure as a message:
** hWnd is the CLI Server handle, wMsg is CLI_NEW_SVR_REGISTRATION
** (defined in cliconst.h), wParam is 1 if CLI Server to deallocate
** memory, and lParam pointer to the structure below.
*/

typedef struct {
	HANDLE	stringResourceHandle;	/* dll handle          */
	U16	serverNameIndex;	/* a string index      */
	U16	dllNameIndex;		/* a string index      */
	U16	numberOfCommandsIndex;	/* a string index      */
	U16	commandStartIndex;	/* a string index      */
} CSERVER_NEW_REGISTRATION;


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/


/**************************************************************************
**
** initCServer
**
** Description: Each DDL needs to call an init routine for each
**              server found in its DLL.
**
**	Parameters:
**    input:
**       cliHandle:  registration target for servers.
**       dllHandle:  handle to use in messages to tag this DLL.
** 
**    output:
**       always returns GOOD
**
***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif
RETCODE EXPORT InitCServer(HWND cliHandle, HANDLE dllHandle);
#ifdef __cplusplus
}
#endif

/******************************** E O F ***********************************/
