/****************************************************************************
**
**  Name:  EVENTS.H
**
**  Description:
**      All events used by PowerViews servers are enumerated here.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm306/inc/events.h_v  $
** 
**    Rev 1.1   11 Dec 1995 11:52:18   kevin
** added EVENT_HL_BKPTEXEC_EMUL_PENDING
** 
**    Rev 1.0   07 Sep 1995 10:25:56   gene
** Initial revision.
** 
**    Rev 1.13   05 Oct 1993 10:49:20   nghia
** Revised EVENT_CLI_CMD_COMPLETE to EVENT_CLI_COMMAND_COMPLETE (matching name)
** 
**    Rev 1.12   16 Jul 1993 15:04:48   nghia
** PIP for Stack: Added new events for Stack.
** 
**    Rev 1.11   13 Jul 1993 09:32:40   ernie
** Added event EVENT_LDR_MEMCHANGED.  This is propagated by the loader
** when loading is complete and memory was changed.  This is used by the
** memory server to flush memory caches.
** 
**    Rev 1.10   09 Jul 1993 09:47:48   marilyn
** Created new events for the Actor button bar to launch presenters selected in
** c++ modules Windows menu.  The button bar will register on these events.
** The c++ modules will propagate the events based on menu selection.
** 
**    Rev 1.9   09 Jul 1993 09:40:16   mindy
** Put back for Mindy by Marilyn.  Added one new Trace event, HEADER_CHANGED.
** 
**    Rev 1.8   09 Jun 1993 09:10:14   ernie
** Removed EVENT_LL_BKPTEXEC_*.  These are no longer used.
** 
**    Rev 1.7   02 Jun 1993 12:49:38   ernie
** Added event to notify presenters that dasm sym has changed
** 
**    Rev 1.6   08 Dec 1992 05:16:04   brucea
** Added: runaccess on and off events for bkroot
** 
**    Rev 1.5   23 Nov 1992 12:12:58   doug
** the cli command complete event is wrong in Actor (should be 50 decimal),
** but this is the easiest fix for now... we can coordinate a change to
** 50 decimal at integration
** 
**    Rev 1.4   02 Nov 1992 15:37:00   doug
** add internal CLI commands to indicate the application queue if flushed
** (ppr7166)
** 
**    Rev 1.3   06 Oct 1992 06:53:06   mindy
** added event for when number of trace buffers change
** 
**    Rev 1.2   18 Sep 1992 13:44:12   brucea
** Clarified descriptions for symbol events
** 
**    Rev 1.2   18 Sep 1992 13:31:24   brucea
** Clarified descriptions of symbol events
** 
**    Rev 1.1   08 Sep 1992 11:12:36   brucea
** Removed: EVENT_BKPTEXEC_BKPT_CHANGED        (MODULE_BREAKPOINT | 32)
** Added:   EVENT_LL_BKPTEXEC_EMUL_HUNG        (MODULE_BREAKPOINT | 52)
** 
**    Rev 1.0   03 Sep 1992 13:24:04   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arcm306/inc/events.h_v   1.1   11 Dec 1995 11:52:18   kevin  $
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _EVENTS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif
#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

                       /*********************************
                       *                                *
                       *   EVENT NOTIFICATION DEFINES   *
                       *                                *
                       *********************************/

/* Events in the id 20-29 range are supported by multiple servers/presenters.
   Specifically,
        Halted events are EVENT_xxx_HALTED, and id 20
        Edit events are EVENT_xxx_EDIT, and id 21
   Events in the 30-49 range for all other events.
   Events starting at 50 are internal (not used by more than a single
       component).
   Events starting at 0x100 are generic events supported by multiple
       servers and presenters.
*/

/* Event a callback can propagate to close the application */
#define EVENT_CLOSE_APPLICATION (MODULE_GENERIC | 30)

/*---------------------------------*/
/*            BKPT EVENTS          */
/*---------------------------------*/
#define EVENT_BKPT_HALTED       (MODULE_BREAKPOINT | 20)
#define EVENT_BKPT_EDIT         (MODULE_BREAKPOINT | 21)

/* High Level event for presenters indicating emulation started successfully*/
#define EVENT_HL_BKPTEXEC_EMUL_STARTED     (MODULE_BREAKPOINT | 30)

/* High Level event for presenters indicating emulator is being stepped but
   is not done yet */
#define EVENT_HL_BKPTEXEC_EMUL_STEPPING    (MODULE_BREAKPOINT | 31)

/* High Level event for presenters indicating emulation pending*/
#define EVENT_HL_BKPTEXEC_EMUL_PENDING     (MODULE_BREAKPOINT | 32)

#define EVENT_CPU_HALTED        (MODULE_CPU        | 20)
#define EVENT_CPU_EDIT          (MODULE_CPU        | 21)
#define EVENT_CPU_PC_EDIT       (MODULE_CPU        | 30)
#define EVENT_CPU_SP_EDIT       (MODULE_CPU        | 31)
#define EVENT_CPU_FP_EDIT       (MODULE_CPU        | 32)

#define EVENT_DASM_HALTED       (MODULE_DISASSEMBLY | 20)
#define EVENT_DASM_SYM_CHANGED  (MODULE_DISASSEMBLY | 21)

#define EVENT_LDR_STARTPC       (MODULE_LOADER_695 | 30)
#define EVENT_LDR_STACKTOP      (MODULE_LOADER_695 | 31)
#define EVENT_LDR_LOADCOMPLETE  (MODULE_LOADER_695 | 32)
#define EVENT_LDR_MEMCHANGED    (MODULE_LOADER_695 | 33)

/* generated whenever map changes... memory should be updated */
#define EVENT_MAP_EDIT          (MODULE_MAP        | 21)

#define EVENT_MEM_HALTED        (MODULE_MEMORY     | 20)
/* generated whenever any memory location(s) may have changed */
#define EVENT_MEM_EDIT          (MODULE_MEMORY     | 21)
/* events used to update src windows if memory change matches their range */
#define EVENT_MEM_MEMORY_CHANGED_SRC0_RANGE  (MODULE_MEMORY | 31)
#define EVENT_MEM_MEMORY_CHANGED_SRC1_RANGE  (MODULE_MEMORY | 32)

#define EVENT_STK_HALTED        (MODULE_STACK      | 20)
/* generated when stack frame is recalculated */
#define EVENT_STK_STACK_CHANGED    (MODULE_STACK      | 30)
/* generated when the stack alarm is tested and found to be over the limit */
#define EVENT_STK_ALARM_OVER_LIMIT (MODULE_STACK      | 31)
/* generated when the alarm conditions change */
#define EVENT_STK_ALARM_CHANGE     (MODULE_STACK      | 32)
#define EVENT_STK_ALARM_ENABLED    (MODULE_STACK      | 33)
#define EVENT_STK_ALARM_DISABLED   (MODULE_STACK      | 34)
/* generated when the HWM conditions change */
#define EVENT_STK_HWM_ENABLED      (MODULE_STACK      | 35)
#define EVENT_STK_HWM_DISABLED     (MODULE_STACK      | 36)
#define EVENT_STK_STACK_OVERFLOW   (MODULE_STACK      | 37)
#define EVENT_STK_STACK_UNDERFLOW  (MODULE_STACK      | 38) 
#define EVENT_STK_BASE_SIZE_AVAIL  (MODULE_STACK      | 39)


/*---------------------------------*/
/*          SYMBOL EVENTS          */
/*---------------------------------*/
/* generated after an initial symbol load OR when previous symbols were
   deleted followed by loading of new symbols.   The purpose of the latter
   is for presenters/servers to be able to keep existing symbol names and
   only recalculate addresses from them. */
#define EVENT_SYMBOL_INIT_LOAD  (MODULE_SYMBOLS    | 30)

/* generated after a single module's on-demand symbols are loaded */
#define EVENT_SYMBOL_ONDEMAND_LOAD (MODULE_SYMBOLS | 31)

/* generated ONLY from the removeSymbols CLI command which
   deletes symbols but does not reload symbols. */
#define EVENT_SYMBOL_DELETED    (MODULE_SYMBOLS    | 32)

/* generated whenever a base address has been changed via the CLI */
/* this is needed by any presenter or server that has stored a symbol and */
/* its address, since the address may have changed if that symbol is in the
/* group associated with the changed base */
#define EVENT_SYMBOL_BASE_CHANGED  (MODULE_SYMBOLS | 33)


#define EVENT_TRACE_CLEAR_TRACE     (MODULE_TRACE | 30)
#define EVENT_TRACE_DEBUG_EMON      (MODULE_TRACE | 31)
#define EVENT_TRACE_NEW_SUB_BUFFER  (MODULE_TRACE | 32)
#define EVENT_TRACE_TRACING_OFF     (MODULE_TRACE | 33)
#define EVENT_TRACE_TRACING_ON      (MODULE_TRACE | 34)
#define EVENT_TRACE_HEADER_CHANGED  (MODULE_TRACE | 35)

#define EVENT_TRIG_HALTED       (MODULE_TRIGGER    | 20)
#define EVENT_TRIG_TRC_BUF_NUM  (MODULE_TRIGGER    | 21)

#define EVENT_VAR_HALTED        (MODULE_VAR        | 20)
#define EVENT_VAR_EDIT          (MODULE_VAR        | 21)


/* generate an event to be sure the entire app queue is flushed of events */
#define EVENT_CLI_COMMAND_COMPLETE  (MODULE_CLI | 0x50)

/*---------------------------------*/
/*          BKROOT EVENTS          */
/*---------------------------------*/
/* used to indicate when runaccess state has been changed */
#define EVENT_BKROOT_RUNACCESS_ON  (MODULE_BKROOT | 20)
#define EVENT_BKROOT_RUNACCESS_OFF (MODULE_BKROOT | 21)


/*----------------------------------*/
/*     ACTOR LAUNCH EVENTS          */
/*----------------------------------*/
/* used by C++ presenters to inform actor buttonBarclass to launch */
/* the specific presenter                                          */
#define EVENT_LAUNCH_BKPNT         (MODULE_GENERIC | 0x100)
#define EVENT_LAUNCH_CPU           (MODULE_GENERIC | 0x101)
#define EVENT_LAUNCH_EVENT         (MODULE_GENERIC | 0x102)
#define EVENT_LAUNCH_MEM           (MODULE_GENERIC | 0x103)
#define EVENT_LAUNCH_PERI          (MODULE_GENERIC | 0x104)
#define EVENT_LAUNCH_SHELL         (MODULE_GENERIC | 0x105)
#define EVENT_LAUNCH_SOURCE        (MODULE_GENERIC | 0x106)
#define EVENT_LAUNCH_STACK         (MODULE_GENERIC | 0x107)
#define EVENT_LAUNCH_STAT          (MODULE_GENERIC | 0x108)
#define EVENT_LAUNCH_TB            (MODULE_GENERIC | 0x109)
#define EVENT_LAUNCH_TRC           (MODULE_GENERIC | 0x10a)
#define EVENT_LAUNCH_TRG           (MODULE_GENERIC | 0x10b)
#define EVENT_LAUNCH_VAR           (MODULE_GENERIC | 0x10c)

/******************************** E O F ***********************************/
