/****************************************************************************
**
**  Name:  hosterrs.h
**
**  Description:
**     Host system errors are #defined here, along with typical masks.
**
**  Status:  (PRELIMINARY | CODED)
**
**  $Log:   S:/tbird/arcm306/inc/hosterrs.h_v  $
** 
**    Rev 1.0   07 Sep 1995 10:26:02   gene
** Initial revision.
** 
**    Rev 1.43   14 Mar 1994 15:05:36   ernie
** Added MODULE_PVTEST for confidence test server
** 
**    Rev 1.42   01 Mar 1994 09:18:02   nghia
** Defined MODULE_SWATP (for the SWAT Presenter), 
** Removed MODULE_PROJECT_DEFINITION.
** 
**    Rev 1.41   06 Oct 1993 16:36:52   tom
** 8802, 8929: make entry point for loading verify info available outside mem
** 
**    Rev 1.40   20 Jul 1993 14:44:28   ron
** moved remaining system errors to mkerrors.h
** 
**    Rev 1.39   29 Jun 1993 15:37:16   steveh
** Fixed an unterminated comment
** 
**    Rev 1.38   24 Jun 1993 11:28:42   ron
** added prototype for ErrGetErrorCLI (new function for _geterror), and 
** changed the prototype for ErrDisplayFormattedError.
** 
**    Rev 1.37   24 Jun 1993 09:49:22   marilyn
** Added MODULE_PERI and bumped the MAX_MODULES to 31.  Also adjusted
** MODULE_LAST_SVR to be MODULE_PERI.
** 
**    Rev 1.36   10 Jun 1993 10:47:42   ron
** added an argument (buttonID return value) to ErrMessageBox.
** 
**    Rev 1.35   10 Jun 1993 09:13:30   ron
** added prototype for ErrMessageBox -- a function to replace errorBox in Actor
** in cases where YESNO or OKCANCEL or whatever are needed.
** 
**    Rev 1.34   03 Jun 1993 16:25:36   ron
** checkpoint (tested) of the Actor error consolidation stuff -- still need
** to merge all the server errors.
** 
**    Rev 1.33   25 May 1993 16:40:10   ron
** changes to the error severity codes: added INFORMATIVE type, added an
** INTERNAL bit, and explicit NO_ERROR code (0).
** 
**    Rev 1.32   05 May 1993 15:25:34   doug
** proc nows has error messages
** 
**    Rev 1.31   26 Apr 1993 15:47:52   tom
** Add CLIULibrary module for UNIX filename support.
** 
**    Rev 1.30   13 Apr 1993 16:47:40   nghia
** Added ER_ERRCODE_NOT_FOUND and revised ER_RESLOAD and ER_BADMODULE id values.
** Added dumy value to HANDLE_ERROR to force enum type to U16.
** 
**    Rev 1.29   03 Nov 1992 10:02:32   doug
** The message box type is passed directly to the windows MessageBox function,
** so the enumeration must match one-for-one.  Found this fixing ppr7226 when
** the retry/cancel message box type was needed (see sds/sharefw.c).
** 
**    Rev 1.28   22 Oct 1992 16:46:06   courtney
** Added macro for error text server.
** 
**    Rev 1.27   10 Sep 1992 09:42:28   courtney
** Converted the last remaining 'generic' errors to 'system' errors
** so their error number can be documented properly.
** 
**    Rev 1.26   08 Sep 1992 10:03:38   kend
** Removed EVENT_CLOSE_APPLICATION (now in "events.h")
** 
**    Rev 1.25   26 Aug 1992 15:11:48   kend
** Added EVENT_CLOSE_APPLICATION
** 
**    Rev 1.24   14 Aug 1992 17:16:58   courtney
** Added errors for use by the Error Text Server.
** 
**    Rev 1.23   11 Aug 1992 18:16:40   courtney
** Added new entry points for Error Text Server, ErrDisplayErrorEx
** (extended to handle message box style parameter and return
** button pressed by user), and ErrGetAllErrors (to dump all errors
** in server resource files - not yet implemented.
** 
**    Rev 1.22   30 Jul 1992 18:40:38   brucea
** Fixed (again): MODULE_LAST_SVR
** 
**    Rev 1.21   28 Jul 1992 09:28:08   brucea
** Capitalized macros
** 
**    Rev 1.20   19 Jun 1992 08:10:52   brucea
** Added: MODULE_BKROOT which is a DLL split off from bkptexec
**    (MODULE_BREAKPOINT)
** 
**    Rev 1.19   15 May 1992 18:33:16   brucea
** Added: #ifdef __cplusplus, etc. around error prototypes so symbol .cpp files
**    would compile and link
** 
**    Rev 1.18   14 May 1992 13:05:22   courtney
** Added E_MODNAME_OFFSET to obtain module name from string resource of
** individual servers.
** 
**    Rev 1.17   14 May 1992 12:18:32   courtney
** Defined MAX_MODULES.
** 
**    Rev 1.16   14 May 1992 11:06:08   mindy
** a) last server error number wrong
** b) no longer need specific error handling routines.
** c) added Courtney's error text registation routine.
** 
**    Rev 1.15   13 May 1992 16:41:32   mindy
** want wscom naming scheme to match other calls
** 
**    Rev 1.14   13 May 1992 15:56:28   mindy
** a) added display error routine's prototype.
** b) added wscom error support
** 
**    Rev 1.13   13 May 1992 10:28:38   courtney
** Cleanup of module id's for incorporation of error text.
** 
**    Rev 1.12   07 May 1992 11:13:40   courtney
** Added definition for Event Notification library.
** 
**    Rev 1.11   02 Apr 1992 10:16:36   brucea
** Added: generic error ER_ABORT_FROM_ESC
** 
**    Rev 1.10   27 Feb 1992 15:29:28   doug
** added map
** 
**    Rev 1.9   24 Jan 1992 16:48:32   marilyn
** Corrected spelling of E_SERERITY_MASK to E_SEVERITY_MASK.
** 
**    Rev 1.8   22 Jan 1992 12:06:58   brucea
** 
** Changed MODULE_VARIABLE_WATCHPOINT to MODULE_VAR
**
**    Rev 1.7   30 Dec 1991 14:53:06   courtney
** Added definition for Tek Hex/Extended Hex Loader Server.
** 
**    Rev 1.6   11 Dec 1991 16:14:34   courtney
** Added definition for Srecord loader server.
** 
**    Rev 1.5   06 Dec 1991 10:42:06   mindy
** added swat module and send message failed error
** 
**    Rev 1.4   15 Nov 1991 15:09:30   mindy
** added event and event template modules - also renumbered module
** numbers to clean up numbering.
** 
**    Rev 1.3   30 Oct 1991 15:34:04   tom
** Added MODULE_HL_BREAK_SERVER.
** 
**    Rev 1.2   07 Oct 1991 09:03:00   tom
** Added component ID's for all known components; removed site designations.
** 
**    Rev 1.1   05 Sep 1991 11:11:42   brucea
** added parens to #define statements.
** 
**    Rev 1.0   19 Aug 1991 15:43:34   kend
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/inc/hosterrs.h_v   1.0   07 Sep 1995 10:26:02   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _HOSTERRS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/*
 * ERROR NUMBER COMPONENTS
 */

/* Severity flag composed of bits 0..2 */
#define E_SEVERITY_MASK    0xE0000000L
#define E_NO_ERROR         0x00000000L
#define E_INFORMATIVE      0x20000000L
#define E_WARNING          0x40000000L
#define E_SEVERE           0x80000000L
#define E_FATAL            0xA0000000L
#define E_CATASTROPHIC     0xC0000000L
#define E_SEVERITYID(x) (((x) & E_SEVERITY_MASK) >> 29)

/* Internal flag is bit 3 */
#define INTERNAL_ERROR_MASK 0x10000000L
#define INTERNAL_ERROR_ON   0x10000000L
#define INTERNAL_ERROR_OFF  0x00000000L
#define INTERNAL_ERROR(x)   (((U32)(((U32)x) & INTERNAL_ERROR_MASK)) == INTERNAL_ERROR_ON)

/* detecting component id is upper 2 bytes less top 4 bits */
#define E_COMPONENT_MASK   0x0FFF0000L
#define E_MODULEID(x)  (((x) & E_COMPONENT_MASK) >> 16)

/* error number is lower 2 bytes */
#define E_ERROR_NUMBER_MASK   0x0000FFFFL
#define E_ERRORID(x)  ((x) & E_ERROR_NUMBER_MASK)

/*
 *  Module component IDs : range 0x0000..0x0FFF (left shifted)
 */

/* Windows, DOS, or generic errors */
#define MODULE_GENERIC      0x0FFF0000L
#define MODULE_SYSTEM      0x00000000L

/* server modules */
/* note: these module id's now correspond to entries in the errtext.dll
    server GetErrorText routine table.  Do not change one without a
    corresponding change to the other!
*/
#define MODULE_HEAP                   0x00010000L
#define MODULE_SYMBOLS                0x00020000L
#define MODULE_ADDRESS                0x00030000L
#define MODULE_BREAKPOINT             0x00040000L
#define MODULE_CPU                    0x00050000L
#define MODULE_DISASSEMBLY            0x00060000L
#define MODULE_EVENT                  0x00070000L
#define MODULE_EVENT_TEMPLATE         0x00080000L
#define MODULE_LOADER_695             0x00090000L
#define MODULE_GENERIC_LDR            MODULE_LOADER_695
#define MODULE_LOADER_OMF             0x000A0000L
#define MODULE_MEMORY                 0x000B0000L
#define MODULE_SHARED_DATA            0x000C0000L
#define MODULE_STACK                  0x000D0000L
#define MODULE_SWAT                   0x000E0000L
#define MODULE_TRACE                  0x000F0000L
#define MODULE_TRIGGER                0x00100000L
#define MODULE_VAR                    0x00110000L
#define MODULE_LOADER_SREC            0x00120000L
#define MODULE_LOADER_TEK             0x00130000L
#define MODULE_MAP                    0x00140000L
#define MODULE_ENLIB                  0x00150000L
#define MODULE_WSCOM                  0x00160000L
#define MODULE_BKROOT                 0x00170000L
#define MODULE_CLIULIB                0x00180000L
#define MODULE_PROC                   0x00190000L
#define MODULE_PERI                   0x001A0000L
#define MODULE_PVTEST                 0x001B0000L
#define MODULE_LAST_SVR               MODULE_PVTEST    /* note dependency
                                                        on previous line */

/* presenter modules */
#define MODULE_CLI                    0x00200000L
#define MODULE_SOURCE                 0x00300000L
#define MODULE_SWATP                  0x00400000L

#define MAX_MODULES  32    /* need to recheck size when DLL added */

#ifndef _ERRCODEC_
#include "errcodec.h"
#endif


/* macros */
#define IS_GENERICID(x) (((x) & E_COMPONENT_MASK) == MODULE_GENERIC)
#define IS_SERVERID(x)  ((((x) & E_COMPONENT_MASK) >= MODULE_SYSTEM) \
                      && (((x) & E_COMPONENT_MASK) <= MODULE_LAST_SVR))
#define IS_VALIDMODULE(x)  (IS_SERVERID(x) || IS_GENERICID(x))
/* check for alternate loaders */
#define IS_LOADERID(x)  (x == (MODULE_LOADER_SREC >> 16))

/* SAMPLE: Heap Module specific error */
/* define ER_HEAP_CORRUPT   (MODULE_HEAP   | E_FATAL   | 0x00000001L) */


#define E_MODNAME_OFFSET     99     /* offset in server stringtable for
                                       printable module name */
#define E_ERRTEXT_OFFSET    100     /* offset within server stringtable for
                                        error text */
#define E_ERRSIZE           255     /* maximum size of error text */


                       /**************************
                        *                        *
                        *    TYPE DEFINITIONS    *
                        *                        *
                        **************************/
/* These types are allowed in the 'mode' parameter for calls */
typedef enum { CHECK_MODE, FORCE_POPUP, FORCE_CLI, HERR_DUMMY = 0x7fff }
   HANDLE_ERROR;

/* Types allowed in the 'msgBoxStyle' parameter for calls */
typedef enum {MB_TYPE_OK, MB_TYPE_OKCANCEL, MB_TYPE_ABORTRETRYIGNORE,
    MB_TYPE_YESNOCANCEL, MB_TYPE_YESNO, MB_TYPE_RETRYCANCEL, MB_TYPE_TYPEMASK,
    MB_DUMMY=0x7fff } MB_TYPE;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
**
**  ErrInitDLL
**
**  Description:
**     Each server needs to register with the Error Text Server
**     (from its LibMain).
**
**  Parameters:
**     input:
**        moduleID      Handle to server DLL
**        dllName       Name of DLL file on disk
**     output:
**        none.
**
*****************************************************************************/
RETCODE EXPORT ErrInitDLL(U32 moduleID, LPSTR dllName);

/****************************************************************************
**
**  ErrGetErrorText
**
**  Description:
**     Retrieve the error text corresponding to the given errorCode.
**
**  Parameters:
**     input:
**        errorCode         retcode returned from Server call
**     output:
**        lperrString       text of error message obtained from .rc file
**
*****************************************************************************/
RETCODE EXPORT ErrGetErrorText(RETCODE errorCode, LPSTR lperrString);

/****************************************************************************
**
**  ErrDisplayString
**
**  Description:
**     For use with server- and presenter- formatted strings.  Additional
**     information can be tacked onto the end of the string retrieved
**     from the resource file.  The additional string will be in 'lpErrText'.
**
**  Parameters:
**     input:
**        errCode        retcode returned from Server call
**        lpErrText      additional text to tack on
**        mode           display mode (CLI vs. popup)
**     output:
**        none.
**
*****************************************************************************/
RETCODE EXPORT ErrDisplayString(RETCODE errCode, LPSTR lpErrText,
   HANDLE_ERROR mode);

/****************************************************************************
**
**  ErrDisplayErrorEx
**
**  Description:
**     Obtain and display the error text corresponding to the given
**     error code.
**
**  Parameters:
**     input:
**        errNumber     retcode returned from Server call
**        mode          display mode (CLI vs. popup)
**        msgBoxStyle   if popup, style of message box
**     output:
**        buttonID      button user clicked (value are ID* in Windows.h),
**                         e.g., IDCANCEL, IDOK, etc.
**
*****************************************************************************/
RETCODE EXPORT ErrDisplayErrorEx(RETCODE errNumber, HANDLE_ERROR mode,
    MB_TYPE msgBoxStyle, S16 FAR *buttonID);

/****************************************************************************
**
**  ErrDisplayError
**
**  Description:
**     Obtain and display the error text corresponding to the given
**     error code.
**
**  Parameters:
**     input:
**        errNumber     retcode returned from Server call
**        mode          display mode (CLI vs. popup)
**     output:
**        none.
**
*****************************************************************************/
RETCODE EXPORT ErrDisplayError(RETCODE errNumber, HANDLE_ERROR mode);

/****************************************************************************
**
**  ErrDisplayFormattedError
**
**  Description:
**     Obtain and display the error text corresponding to the given
**     error code, and provide a help button for context-sensitive help.
**
**  Parameters:
**     input:
**        errNumber     retcode returned from Server call
**        displayMode   display mode (CLI vs. popup)
**        arg1          first optional argument
**        arg2          second optional argument
**        arg3          third optional argument
**        style         MB_OK, MB_RETRYCANCEL, etc or 0 (defaults to MB_OK)
**     output:
**        buttonID      the id of the button (OK, Retry, Cancel, ...) pushed
**
*****************************************************************************/
RETCODE EXPORT ErrDisplayFormattedError(RETCODE errCode, 
   HANDLE_ERROR displayMode, LPSTR arg1, LPSTR arg2, LPSTR arg3,
   U16 style, S16 FAR *buttonID);

/*****************************************************************************
** ErrGetFormattedErrorText
**
** Description:
**   Retrieve error text and plug in optional arguments.  The *caller* is 
**   expected to have allocated storage for the return string of size 
**   E_ERRSIZE.
** Parameters:
**   errCode (in): encoded module, error type, and error number
**   lperrString (in): caller-allocated buffer
**   arg1 (in): optional sprintf argument
**   arg2 (in): optional sprintf argument
**   arg3 (in): optional sprintf argument
*****************************************************************************/
RETCODE EXPORT ErrGetFormattedErrorText(RETCODE errorCode, LPSTR lperrString,
   LPSTR arg1, LPSTR arg2, LPSTR arg3);

/*****************************************************************************
**
** ErrMessageBox
**
** Description:
**   Bring up a message box (including a help button) using the provided
**   caption, text, and style (buttons), and pass back the ID of the button
**   that was pressed.
**
** Parameters:
**   caption (in): caption of the dialog box
**   text (in): text of the message
**   style (in): which buttons (besides Help) to use
**   helpEntry (in): the entry point into pwrviews.hlp
**   buttonID (out): the ID of the button that was pressed
**
**
*****************************************************************************/
RETCODE EXPORT ErrMessageBox(LPSTR caption, LPSTR text, U16 style,
                             DWORD helpEntry, S16 FAR *buttonID);

/****************************************************************************
**
**  ErrGetErrorCLI
**
**  Description:
**     Print the error text corresponding to the given errorCode.
**
**  Parameters:
**     input:
**        cmdString         array of strings (two expected)
**        argc              count strings (one command, one arg)
**        argv              offset in cmdString
**
*****************************************************************************/
RETCODE EXPORT  ErrGetErrorCLI(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
**
**  ErrSaveMemoryVerifyInfo
**
**  Status:  TESTED
**
**  description:
**     Save memory verification text for later display.
**
**  input:
**     memoryVerifyString:  memory verification text string.
**
**  output:
**     none
**
*****************************************************************************/
RETCODE EXPORT ErrSaveMemoryVerifyInfo(LPSTR memoryVerifyString);

#ifdef __cplusplus
}
#endif
/******************************** E O F ***********************************/
