/*****************************************************************************
**
**  Name:  pmem.h
**
**  Description:  Defines the processor specific part of memory/IO access
**      server together with processor independent things defined in mem.h.
**
**  Status: CODED
**
**  $Log:   S:/tbird/arcm306/inc/pmem.h_v  $
** 
**    Rev 1.0   07 Sep 1995 10:26:14   gene
** Initial revision.
** 
**    Rev 1.4   26 Jul 1993 09:58:42   ernie
** Removed ER_MAP_SYNTAX.  All errors now in mkerrors.h.
** 
**    Rev 1.3   08 Sep 1992 09:44:24   john
** removed EVENT_ definitions
** 
**    Rev 1.2   14 May 1992 15:06:14   courtney
** Revised error code to 1 to distinguish from GOOD.
** 
**    Rev 1.1   27 Feb 1992 15:23:06   doug
** Simple map interface.  Full map will be implemented later.  Only one
** 256k block supported.
** 
**    Rev 1.0   15 Jan 1992 08:24:12   tom
** Initial revision.
** 
**  $Header:   S:/tbird/arcm306/inc/pmem.h_v   1.0   07 Sep 1995 10:26:14   gene  $
**
**  Copyright (C) 1991 Microtek International.	All rights reserved.
**
*****************************************************************************/

#define _PMEM_


                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASETYPE_
#include "basetype.h"
#endif
#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif
#ifndef __WINDOWS_H
#include "windows.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *          ERRORS          *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  InitServer
**
**  Description:
**     Initialize this server.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT InitServer(VOID);

/****************************************************************************
**
**  TerminateServer
**
**  Description:
**     Terminate this server.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT TerminateServer(VOID);

/****************************************************************************
**
**  InitCServer
**
**  Description:
**     Initialize the CLI commands for this server.
**
**  Parameters:
**     input:
**        cliHandle:  CLI Server Handle
**        dllHandle:  DLL Handle.
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) ;

/****************************************************************************
**
**  MapSet
**
**  Description:
**     Set the overlay map to an address.  This is a simple form for the
**     68030.  There is only one 256k overlay memory block support.  The
**     address passed in will be truncated to a 256k boundary and used.
**     If there is a map set already, the new one will override the old.
**
**     Call MapClear to clear entry and use only target memory.
**
**  Parameters:
**     input:
**        addr:  address where memory should be mapped.  This routine
**               destroys the address descriptor when done.  Use address
**               server clone function to duplicate descriptor if it is
**               still needed.
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT MapSet(DESCRIPTOR addr);

/****************************************************************************
**
**  MapGet
**
**  Description:
**     Get the current setting of the map.
**
**  Parameters:
**     input:
**        none
**     output:
**        active:  TRUE if overlay block is mapped
**        addr:  if active, address of block.  This routine creates the
**               address descriptor.  Caller must call address server to
**               destroy after using.
**
*****************************************************************************/
RETCODE EXPORT MapGet(BOOLEAN FAR *active, DESCRIPTOR FAR *addr);

/****************************************************************************
**
**  MapClear
**
**  Description:
**     Clear the memory map.  Sets all memory to target; overlay is not used.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT MapClear(VOID);

/****************************************************************************
**
**  MapCliMemoryMap
**
**  Description:
**     CLI command for "map"
**
**     Syntax:  map [<address base>|clear]
**
**     Maps one block of 256k of memory.  Truncates address base to 256k
**     boundary.
**
**  Parameters:
**     input:
**        cmdString:  command text input
**        argc:  argument count
**        argv:  argument data
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT MapCliMemoryMap(LPSTR cmdString, U32 argc, U32 argv[]) ;

/******************************** E O F ***********************************/
