/*
 * Name:  source.h
 *
 * Description:
 *    Routines to provide the source server's services.
 *
 * $Log:   S:/tbird/arcm306/inc/source.h_v  $
** 
**    Rev 1.0   14 Sep 1995 14:22:24   kevin
** Initial revision.
**  
**     Rev 1.1   21 Aug 1991 11:24:54   tom
**  Updated types, include file format.
 * 
 *    Rev 1.0   14 Jun 1991 13:36:02   jim
 * Initial revision.
 *
 * $Header:   S:/tbird/arcm306/inc/source.h_v   1.0   14 Sep 1995 14:22:24   kevin  $
 */
#define _SOURCE_

#ifndef _BASEWIND_
#include "basewind.h"
#endif

typedef U16 HANDLE;

RETCODE EXPORT SrcOpenFile(LPSTR fileName, DESCRIPTOR *fileDes);
/*
Description:
   Open the source file for source display and get the file descriptor.
Parameters:
   input:
      fileName:  the name of the source file
   output:
      fileDes:  the descriptor of the source file
*/

RETCODE EXPORT SrcCloseFile(DESCRIPTOR fileDes);
/*
Description:
   Close the source file.
Parameters:
   input:
      fileDes:  the descriptor of the source file
*/

RETCODE EXPORT SrcReadSource(DESCRIPTOR fileDes, U32 beginLine, U32 numLines,
                    HANDLE *sourceBuffer);
/*
Description:
   Get the block of source lines from the source file.
Parameters:
   input:
      fileDes:  the descriptor of the source file
      beginLine:  the beginning line number of the block
      numLines:  the numbers of lines of the block
   output:
      sourceBuffer:  the block of source lines
*/

typedef enum {
   FUNCTION_NAME, VARIABLE_NAME, LINE_NO, IGNORE
} SOURCE_TOKEN_TYPE;

RETCODE EXPORT SrcGetToken(DESCRIPTOR fileDes, U32 lineNum, U16 cursorColumn,
		  U16 *beginColumn, U16 *endColumn,
		  SOURCE_TOKEN_TYPE *tokenType);
/*
Description:
   The purpose of this call is to support the "double-click" and "<Shift>+
   double-click" operations that the Source Presenter provides. It gets the
   token position and type.
Parameters:
   input:
      fileDes:  the descriptor of the source file
      lineNum:  the number of the source line where the text cursor is located
      cursorColumn:  the column position of the text cursor
   output:
      beginColumn:  the beginning column position of the token
      endColumn:  the end column position of the token
      tokenType:  the type of the token
*/

typedef enum {
   UP, DOWN, LEFT, RIGHT
} ARROW_KEY;

RETCODE EXPORT SrcArrowToken(DESCRIPTOR fileDes, U32 lineNum, U16 cursorColumn,
		    ARROW_KEY direction, U32 *linePos, U16 *beginColumn,
		    U16 *endColumn, SOURCE_TOKEN_TYPE *tokenType);
/*
Description:
   The purpose of this call is to support the "arrow key search for token"
   operation that the Source Presenter provides. It gets the token position
   and type.
Parameters:
   input:
      fileDes:  the descriptor of the source file
      lineNum:  the number of the source line where the text cursor is located
      cursorColumn:  the column position of the text cursor
      direction :  the arrow direction
   output:
      linePos: the line number of the token
      beginColumn:  the beginning column position of the token
      endColumn:  the end column position of the token
      tokenType:  the type of the token
*/
