/****************************************************************************
**
**  Name:  LINIT.C
**
**  Description:
**      DLL main entry point.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm306/l695/linit.c_v  $
** 
**    Rev 1.0   07 Sep 1995 10:32:18   gene
** Initial revision.
** 
**    Rev 1.7   01 Mar 1994 09:03:46   marilyn
** Moved MaxInput routines to the address server. Updated interfaces.
** 
**    Rev 1.6   23 Sep 1993 11:04:44   nghia
** Added call to PROC.DLL to get max input address and use it as the default 
** address range.
** 
**    Rev 1.5   03 Aug 1993 17:41:48   nghia
** Cleanup.
** 
**    Rev 1.4   16 Jun 1993 08:28:08   mindy
** Initialize Register table and which compiler is being used - This
** is read from the pwrviews.ini - do not prompt user if NULL.
** 
**    Rev 1.3   08 Mar 1993 10:47:00   nghia
** Cleanup and added #pragma to avoid compiler warnings.
** 
**    Rev 1.2   14 Aug 1992 10:14:00   courtney
** Remove WEP.
** 
**    Rev 1.1   20 May 1992 14:11:26   courtney
** Added error text initialization.
** 
**    Rev 1.0   12 Dec 1991 13:41:38   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/l695/linit.c_v   1.0   07 Sep 1995 10:32:18   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef __LDR__
#include "ldr.h"
#endif

#ifndef _PROC_
#include "proc.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef __LPROFILE__
#include "lprofile.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* suppress inclusion of WEP (in Borland Library) */
#define _BORLANDC_

extern CHAR toolUseName[];
extern CHAR pwrViewsDir[];

/* Global handle of the server */
HANDLE hInst;
U32 startRangeNotSet = 0xFFFFFFFFL, endRangeNotSet;

#pragma argsused
/******************************************************************************
**
**  LibMain
**
******************************************************************************/
/* One-time initialization for Loader DLL */
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
                                                         LPSTR lpszCmdLine) {
	if (cbHeapSize != 0)
	   UnlockData(0);	/* allows heap to grow */
	hInst = hInstance;

   SetupXlateTable();

   // NOTES: 09/07/93 - Nghia
   // Get the maximum input address of the processor and use it for address
   // range initialize value.
   AdrGetMaxInputAddrOffset(NULL,(U32 FAR *) &startRangeNotSet);
   endRangeNotSet = startRangeNotSet - 1L;
   
   // Retrieve toolUseName   
   if (FindIniFile() == GOOD ) {
      // Need to setup frame pointer for default compiler.
      GetPrivateProfileString((LPSTR) LAPP_NAME, (LPSTR) LAPP_TOOL_USE,
         "", (LPSTR) toolUseName, MAX_STR_SIZE, (LPSTR) pwrViewsDir);
		SetToolUse();
   }      
    /* initialize with errtext dll */
   ErrInitDLL(MODULE_LOADER_695, "ld695.dll");
	return (TRUE);
}  /* LibMain */

#ifndef _BORLANDC_
/* With BCC, does not need to be exported */
/******************************************************************************
**
**  WEP - Windows Exit Procedure.
**
******************************************************************************/
BOOL EXPORT WEP(int nParameter) {
	return (1);
}  /* WEP */
#endif

/******************************** E O F ***********************************/
