/****************************************************************************
**
**  Name:  lprofile.h
**
**  Description:
**     Provides declaration and prototype of routines handling profile service.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm306/l695/lprofile.h_v  $
** 
**    Rev 1.4   20 Aug 1996 10:09:46   kevin
** support SDS 6.3
** 
**    Rev 1.3   14 Jun 1996 08:45:32   kevin
** judy's modification
** 
**    Rev 1.2   13 Sep 1995 16:53:52   kevin
** ID_HELP --> IDHELP
** 
**    Rev 1.1   13 Sep 1995 16:47:20   kevin
** define ID_HELP
** 
**    Rev 1.0   07 Sep 1995 10:32:22   gene
** Initial revision.
** 
**    Rev 1.13   29 Mar 1994 18:01:34   nghia
** Removed the unofficial name of WhiteSmiths tool - no Cosmic.
** 
**    Rev 1.12   29 Mar 1994 15:20:14   nghia
** Added SDS CrossCode Tool to the toolchain support list.
** 
**    Rev 1.11   18 Jan 1994 17:07:04   nghia
** Revised Hiware (CPU32 and HC16) and Introl toolcodes.
** 
**    Rev 1.10   26 Oct 1993 13:27:28   nghia
** Revised HIWARE toolcode.
** 
**    Rev 1.9   03 Aug 1993 17:45:40   nghia
** Moved GetSectionNames() to public.
** 
**    Rev 1.8   27 Jul 1993 22:30:16   nghia
** Revised to support wrong compiler used warning.
** - Changed TOOL_COSMIC to WhiteSmiths.
** - Reorder TOOLCHAIN_TYPE to index into toolChainsTbl[].
** - Defined UNKNOWN_TOOLCODE for unknown toolchain.
** 
**    Rev 1.7   27 Jul 1993 18:56:20   courtney
** Added HP to list of supported toolchains.
** 
**    Rev 1.6   26 Jul 1993 14:19:16   courtney
** Added enum type for toolchain support identification.
** 
**    Rev 1.5   26 Jul 1993 14:14:00   tom
** ppr 8614, 8628
** 
**    Rev 1.4   16 Jun 1993 08:27:14   mindy
** Added SetTool routine.
** 
**    Rev 1.2   16 Apr 1993 13:51:50   nghia
** Added LAPP_MERGE_SEC for MergeSections.
** 
**    Rev 1.1   18 Mar 1993 17:02:08   nghia
** Remove GetSectionsName() to make it PRIVATE.
** 
**    Rev 1.0   08 Mar 1993 10:11:00   nghia
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/l695/lprofile.h_v   1.4   20 Aug 1996 10:09:46   kevin  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LPROFILE__
#define __LPROFILE__

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define IDHELP  8

/* Application and Key names in WIN.INI for PowerViews */
#define WAPP_NAME "MICEpack/SLD"
#define WAPP_KEY  "PowerViewDir"

/* Appliation and Key names in PWRVIEWS.INI for loader */
#define LAPP_NAME "ToolChain"
#define LAPP_TOOLS_SUPPORT "Compilers"
#define LAPP_TOOL_USE  "CompilerUsed"
#define LAPP_MERGE_SEC "MergeSections"
#define DELIMITER_SET ","

#define TOOL_WHITESMITHS "Whitesmiths"
#define TOOL_UNKNOWN     "Unknown"
#define TOOL_INTROL      "Introl"
#define ARG_NONE "none"

/* Definitions for toolNames and sectionNames table */
#define MAX_NUM_SECTION_NAMES 2
#define SIZE_SECTION_NAME 15
#define SIZE_TOOL_NAME 30
#define MAX_STR_SIZE 256
#define MAX_NUM_TOOLS_SUPPORT 20

#define IDD_UNKNOWN 200
#define IDD_OK IDOK
#define IDD_CANCEL IDCANCEL

/* SECTION NAME INDEX */
#define CODE_SECT 0
#define DATA_SECT 1

/* Section Name type */
typedef CHAR SECTIONNAME[SIZE_SECTION_NAME];

/*
** Compilers supported (tool type code - refer to Appx P in 695 spec).
** Verified in Environment Part of file processing.  Appear in ATN54.
*/
#define MRI_TOOLCODE            3     /* MRI linker */
#define INTERM_TOOLCODE         210   /* Intermetrics (HP toolcode) */
#define HP_TOOLCODE             103   /* HP linker */
#define INTROL_TOOLCODE         21
#define HIWARE_CPU32_TOOLCODE   604   /* HIWARE - 695 convertor */
#define HIWARE_HC16_TOOLCODE    14
#define WHITESMITHS_TOOLCODE    4     /* WhiteSmiths 695 converter */
#define SDS_TOOLCODE            208   /* SDS Linker */
#define SDS_TOOLCODE_6          216   /* SDS Linker, for version 6.35 <judy 8/12/96> */
#define GREEN_HILLS_TOOLCODE    21    /* Green Hills toolcode <judy 4/29/96>*/
#define DIAB_DATA_TOOLCODE      224   /* Cold Fire toolcode <judy 5/27/96>*/

/********************************************************************
* Need to contact compiler/translator vendors below to get them to  *
* generate this field for their loadfile.                           *
*********************************************************************/
#define UNKNOWN_TOOLCODE  0
#define SIERRA_TOOLCODE   0

/*
** This TOOLCHAIN_TYPE is used as index into toolChainTbl[] for tool names
*/
typedef enum {
   UNKNOWN_TOOLCHAIN = 0,
   DIAB_DATA_TOOLCHAIN,       // <judy 5/27/96>
   MRI_TOOLCHAIN,
   SIERRA_TOOLCHAIN,
   INTERM_TOOLCHAIN,
   WHITESMITHS_TOOLCHAIN,
   INTROL_TOOLCHAIN,
   HIWARE_TOOLCHAIN,
   SDS_TOOLCHAIN,
   GREEN_HILLS_TOOLCHAIN,     // <judy 4/29/96>
   NUM_TOOLCHAINS  /* NUM_TOOLCHAINS is always last */
} TOOLCHAIN_TYPE;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/* LPROFILE.C routines */
/******************************************************************************
**
**  LdrGetToolUse
**
**  Status: CODED | REVIEWED | TESTED
**
**  Description:
**     Public entry to GetToolUse().
**
**  Parameters:
**     input:
**        none.
**     output:
**        none.
**
******************************************************************************/
RETCODE EXPORT LdrGetToolUse(VOID);

RETCODE FindIniFile(VOID);
RETCODE GetToolUse(VOID);
RETCODE GetToolUseDialog(VOID);
RETCODE SetToolUse(VOID);
RETCODE GetSectionNames(VOID);

/* LDLGBOX.C routine */
RETCODE CreateDlgTemplate(HANDLE *hDlgTemplate);

#endif
/******************************** E O F ***********************************/

