/****************************************************************************
**
**  Name:  LRECORD.H
**
**  Description:
**      IEEE 695 specific values
**
**	these indicate acutal byte values:
**		prefix values RP_*		indicate type of entity that follows in file
**		record types RT_*		record type values
**		section id SECID_*		section modifiers
**
**	these indicate #define lists:
**		ST_*					section type records
**		SR_*					section records
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm306/l695/lrecord.h_v  $
** 
**    Rev 1.0   07 Sep 1995 10:32:24   gene
** Initial revision.
** 
**    Rev 1.15   30 Sep 1993 14:39:34   nghia
** Revised SkipOver to handle blockSize == 0.
** 
**    Rev 1.14   13 Jul 1993 15:06:04   courtney
** Added assembly section type codes (found in BB11 blocks).
** 
**    Rev 1.13   01 Jul 1993 16:21:46   courtney
** Modified IS_NUMPREFIX macro for end-function address fetching.
** 
**    Rev 1.12   16 Jun 1993 10:43:40   mindy
** Trying to get file to compile
** 
**    Rev 1.11   06 Jun 1993 21:21:58   courtney
** Cleanup duplicate definition.
** 
**    Rev 1.10   20 Apr 1993 12:36:42   courtney
** Revise prototype for SyncTo(): preserve file position by using return
** parameter.
** 
**    Rev 1.9   12 Apr 1993 16:22:52   nghia
** Revised #define for ST record types.
** Revised old prototypes.
** 
**    Rev 1.8   23 Mar 1993 17:17:44   nghia
** Minor cleanup and changed macro is_numprefix to IS_NUMPREFIX for readability.
** 
**    Rev 1.7   08 Mar 1993 10:53:30   nghia
** Major cleanup for names and comments.
** 
**    Rev 1.6   07 Oct 1992 18:51:40   courtney
** New macro to detect numeric prefix in parsing.
** 
**    Rev 1.5   01 Jun 1992 20:16:20   courtney
** Added _SyncTo() prototype.
** 
**    Rev 1.4   03 Apr 1992 10:25:30   courtney
** Removed IEEE_IDNLEN, it now lives in ldrsvr.h so callback callers
** can use.
** 
**    Rev 1.3   24 Mar 1992 21:10:42   courtney
** Added new record type RT_ASG, and bracket types for BE/BF for parsing
** load items.
** 
**    Rev 1.2   17 Feb 1992 16:32:22   courtney
** Added code record type RT_RE (0xf1).
** 
**    Rev 1.1   09 Jan 1992 17:04:22   courtney
** Prototype for _ModBegin now takes flags parameter.
** 
**    Rev 1.0   12 Dec 1991 13:46:26   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/l695/lrecord.h_v   1.0   07 Sep 1995 10:32:24   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LRECORD__
#define __LRECORD__

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/* General limits */
#define CH_SPACE	 ' '

/* Number prefix values */
#define NP_LONG      0x80    /* get successive bytes */

/* Record prefix values */
#define RP_OFFSET    0x84    /* file offset follows (long int in 68k format) */
#define RP_SECTION   0xE2    /* section type record prefix (most) */
#define RP_ATTR      0xF1    /* attribute record prefix */

                               /* RECORD TYPES */
/* These single-byte record values correspond to actual value in file */
#define RT_ST        0xE6    /* section type */
#define RT_MB        0xE0    /* module begin */
#define RT_AD        0xEC    /* address descriptor */
#define RT_AV        0xE2D7  /* assign value (offset fields in header) */

/* found in Data Part */
#define RT_SB        0xE5    /* set current section */
#define RT_LD        0xED    /* load constant bytes (code) */
#define RT_RE        0xF7    /* repeating LD records (data) */

/* found in External Part */
#define RT_NN        0xF0    /* variable name */
#define RT_NI        0xE8    /* public symbol */
#define RT_ATI       0xF1C9  /* attribute record */
#define RT_ASI       0xE2C9  /* value record */
#define RT_NX        0xE9    /* extern record */

/* found in Debug Part */
#define RT_BB        0xF8    /* block begin */
#define RT_BE        0xF9    /* block end */
#define RT_ATN       0xF1CE  /* ATN record */
#define RT_ASN       0xE2CE  /* ASN record */
#define RT_ASN1      0xE2    /* ASN record - 1st byte of signature */
#define RT_TY        0xF2    /* TY record */
#define RT_TY2       0xCE    /* TY record - 2nd part */

/* found in Trailer Part */
#define RT_ASG       0xE2C7  /* ASG record - start PC value */
#define RT_LIBE      0xBE    /* load item - start */
#define RT_LIBF      0xBF    /* load item - end */

/* section attributes (aka modifiers) used in Section Part */
#define SECID_CODE   0xD0
#define SECID_ROM    0xD2
#define SECID_DATA   0xC4
/* MACRO */
#define IS_SEC_ATTR(x)  ((x)==SECID_CODE || (x)==SECID_ROM || (x)==SECID_DATA)

/* section types used in Section Part */
#define ST_AS	1	/* absolute section */
#define ST_C	2	/* named relocatable section */
#define ST_EA	3	/* common absolute section */
#define ST_EZ	4	/* short common section */
#define ST_ZC	5	/* short (not common) relocatable section */
#define ST_ZM	6	/* short common relocatable section */

/* other section records, used in Section Part of file */
#define SR_ASS  0xD3
#define SR_ASA  0xC1
#define SR_ASB  0xC2
#define SR_ASF  0xC6
#define SR_ASM  0xCD
#define SR_ASL  0xCC
#define SR_ASR  0xD2
/* these are section records, used in Data Part of file */
#define SR_SA   0xE7
#define SR_SB   0xE5
#define SR_ASP  0xD0

#define SR_AS_PREFIX 0xE2		  

/* load item types (MRI extension to 695) */
#define LI_EITHER   1

/* assembly section types in BB11 blocks */
#define ST_ASM_CODEDATA 0  /* Mixture of code, data, etc. */
#define ST_ASM_CODE     1  /* Code */
#define ST_ASM_RWDATA   2  /* Read/Write data */
#define ST_ASM_RDATA    3  /* Read only data (aka Rommable data) */
#define ST_ASM_STACK    4  /* Stack */
#define ST_ASM_MEM      5  /* Memory */

/* macros */
/* type fix-up macro - be sure its not a 'built-in' type */
/* note that for the first module, toffset will be 0 */
#define MAPTYPE(tindex, toffset) \
	((tindex >= 0x100) ? tindex+toffset : tindex)

/* Determine if record has number prefix (used in end-function block),
** first nibble must match 0x8.
*/
#define IS_NUMPREFIX(x)  ( (((x) & NP_LONG) >> 4) == 0x8 )

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/* prototypes for record get functions (Process Record) */
RETCODE ProcessModBegin(HANDLE, U16);
RETCODE ProcessAD(HANDLE);
RETCODE ProcessHdrOffset(HANDLE);
RETCODE ProcessATI(HANDLE, U16 *, U32 *, U16 *, U16 *);

/* Other record processing prototypes */
RETCODE SkipOver(HANDLE, U32, U32, U16);
RETCODE SyncTo(HANDLE, U16, LONG *);
#endif
/******************************** E O F ***********************************/
