/****************************************************************************
**
**  Name:  emuemul.h
**
**  Description:
**     Michelle emulation-group routines.
**     include:
**     "Read/write registers",
**     "Reset the emulator",
**     "Instruction step(s)"
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcm306/mpfw_306/emuemul.h_v  $
** 
**    Rev 1.0   07 Sep 1995 10:47:18   gene
** Initial revision.
** 
**  $Header:   S:/tbird/arcm306/mpfw_306/emuemul.h_v   1.0   07 Sep 1995 10:47:18   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_EMUL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
			*                          *
			*     LOCAL DEFINITIONS    *
			*                          *
			****************************/
#define REG86_NUMBER 14

			/****************************
			 *                          *
			 *    EXTERNAL VARIABLES    *
			 *                          *
			 ****************************/

			/****************************
			 *                          *
			 *     LOCAL PROTOTYPES     *
			 *                          *
			 ****************************/

			/****************************
			 *                          *
			 *      EXECUTABLE CODE     *
			 *                          *
			 ****************************/



/****************************************************************************
**
**  EmuReset
**
**  Description: Michelle reset routine,
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuReset(VOID);

/****************************************************************************
**
**  EmuGetReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuGetReg(REG_MODE regMode, U16 regId);

/****************************************************************************
**
**  EmuGetReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuGetAllReg(VOID);


/****************************************************************************
**
**  EmuSetReg(VOID)
**
**  Description: Michelle emulation routine, to step certain step(s).
**
**  Parameters:
**     input:
**        regId  --
**        value  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuSetReg(REG_MODE regMode, U16 regId, U32 value);


/****************************************************************************
**
**  EmuStepRange
**
**  Description: Michelle emulation routine, to set value to certain register.
**
**  Parameters:
**     input:
**        addr1 -- unsigned long,
**        addr2 -- unsignde long
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuStepRange(ADDR *addr1,ADDR *addr2);
/******************************** E O F ***********************************/

