/****************************************************************************
**
** Name: trcxlx.c
**
** Description:
**   Services for Xilinx's reprogramming and CLB-modifying
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcm306/mpfw_306/trcxlx.c_v  $
** 
**    Rev 1.0   07 Sep 1995 10:52:44   gene
** Initial revision.
**
** $Header:   S:/tbird/arcm306/mpfw_306/trcxlx.c_v   1.0   07 Sep 1995 10:52:44   gene  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

		       /****************************
			*			   *
			*      INCLUDE FILES	   *
			*			   *
			****************************/

#include <string.h>
#include <dos.h>
#include <conio.h>

#ifndef _TRCERROR_
#include "trcerror.h"
#endif

#ifndef _TRCXLX_
#include "trcxlx.h"
#endif

#ifndef _TRCLIB_
#include "trclib.h"
#endif

                       /****************************
			*			   *
			*    LOCAL DEFINITIONS	   *
			*			   *
			****************************/

#define bitStreamSizeEREC1 XC3090SIZE
#define bitStreamSizeEREC2 XC3090SIZE
#define bitStreamSizeTMAN  XC3064SIZE

#define XLX_HEADER_SIZE 40

#define MAX_XLX_TRY 5

/* I/O port address define */

#define pRpEREC1  0xF100
#define pRpEREC2  0xF108
#define pRpTMAN   0xF110

#define pEREC1    0xF130
#define pEREC2    0xF138
#define pTMAN	  0xF300

#define pTM8255A  0xF160
#define pTM8255C  0xF162

/* I/O port corresponding bit define */

#define bitNXRST1  0x01
#define bitNXRST2  0x02
#define bitNXRSTT  0x04
#define bitM0TR1   0x08
#define bitM0TR2   0x10
#define bitM0TRT   0x20
#define bitNSE     0x80

#define bitNPG_D1  0x01
#define bitNPG_D2  0x04
#define bitNPG_DT  0x20

#define bitNINIT1  0x01
#define bitNINIT2  0x02
#define bitNINITT  0x04
#define bitNRDY1   0x10
#define bitNRDY2   0x20
#define bitNRDYT   0x40

#define pMMCS      0xFFA6
#define bitR2      0x0004

U8 _based(_segname("_CODE")) EREC1XCByte[] = {
#include "trcerec1.xc"
};

U8 _based(_segname("_CODE")) EREC2XCByte[] = {
#include "trcerec2.xc"
};

U8 _based(_segname("_CODE")) EREC1DiagXCByte[] = {
#include "trcerdt1.xc"
};
U8 _based(_segname("_CODE")) EREC2DiagXCByte[] = {
#include "trcerdt2.xc"
};
U8 _based(_segname("_CODE")) TMANDiag1XCByte[] = {
#include "trctmdt1.xc"
};
U8 _based(_segname("_CODE")) TMANDiag2XCByte[] = {
#include "trctmdt2.xc"
};

/*
    U8 _based(_segname("_CODE")) ERECDummyXCByte[] = {
#include "trcerdmy.xc"
};
*/
U8 _based(_segname("_CODE")) TMANStaticXCByte[] = {
#include "trctmans.xc"
};

U8 _based(_segname("_CODE")) TMANTraceXCByte[] = {
#include "trctmant.xc"
};

U8 bitStreamBuffer1[XC3090SIZE];
U8 bitStreamBuffer2[XC3090SIZE];

U8 mpNXCONFIG;

		       /****************************
			*			   *
			*    EXTERNAL VARIABLES    *
			*			   *
			****************************/

		       /****************************
			*			   *
			*     LOCAL PROTOTYPES	   *
			*			   *
			****************************/

VOID DisableExternalRDY(VOID);
VOID EnableExternalRDY(VOID);
U16 GetXlxChipBitStreamSize(XLX_CHIP chip);
RETCODE PRIVATE ChangeOneBit(U8 *bitStreamBuffer,
			     XLX_TYPE xlxType, U16 fx, U16 ox, XLX_FUNC func,
			     U16 addr, BOOLEAN value);
RETCODE PRIVATE FindClbInfo(XLX_TYPE xlxType, U16 clb, U16 *fx, U16 *ox);

		       /****************************
			*			   *
			*     EXECUTABLE CODE	   *
			*			   *
			****************************/

VOID DisableExternalRDY(VOID) {
   outpw(pMMCS, inpw(pMMCS) | bitR2);
}

VOID EnableExternalRDY(VOID) {
   outpw(pMMCS, inpw(pMMCS) & ~bitR2);
}

U16 GetXlxChipBitStreamSize(XLX_CHIP chip) {
   switch(chip) {
      case XLX_EREC1: return(bitStreamSizeEREC1); break;
      case XLX_EREC2: return(bitStreamSizeEREC2); break;
      case XLX_TMAN:  return(bitStreamSizeTMAN);  break;
      default: return(0);
   }
}

RETCODE XlxProgram(XLX_CHIP chip) {
   U16 portReprogram, portConfig, bitStreamSize;
   U8 bitNINIT, bitNRDY, bitNPG_D, bitNXRST, *bitStreamBytes;
   register U16 count = 0;
   register U16 timeout = 0;
   U8 *bitStreamBuffer;

   switch(chip) {
      case XLX_EREC1:
	 portReprogram = pRpEREC1;
         portConfig = pEREC1;
         bitNINIT = bitNINIT1;
	 bitNRDY = bitNRDY1;
         bitNPG_D = bitNPG_D1;
         bitNXRST = bitNXRST1;
         bitStreamBuffer = bitStreamBuffer1;
	 break;
      case XLX_EREC2:
	 portReprogram = pRpEREC2;
         portConfig = pEREC2;
         bitNINIT = bitNINIT2;
	 bitNRDY = bitNRDY2;
         bitNPG_D = bitNPG_D1;
         bitNXRST = bitNXRST2;
         bitStreamBuffer = bitStreamBuffer2;
         break;
      case XLX_TMAN:
         DisableExternalRDY();
         portReprogram = pRpTMAN;
         portConfig = pTMAN;
         bitNINIT = bitNINITT;
	 bitNRDY = bitNRDYT;
         bitNPG_D = bitNPG_DT;
         bitNXRST = bitNXRSTT;
         bitStreamBuffer = bitStreamBuffer1;
	 break;
   }
   outp(pTM8255B, inp(pTM8255B) | bitENPROGX);
   outp(portReprogram, 0);
   outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRST);
   Delay(100);
   outp(pNXCONFIG, mpNXCONFIG |= bitNXRST);
   outp(pTM8255B, inp(pTM8255B) & ~bitENPROGX);
   while (((inp(pTM8255C) & bitNINIT) == 0) && (timeout++ < 30000)) Delay(9);
   if (timeout >= 30000) {
      switch(chip) {
         case XLX_EREC1:
            outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRST1);
            Delay(1000);
            outp(pNXCONFIG, mpNXCONFIG |= bitNXRST1);
            return(ERR_EREC1_INIT_CLR); /* XlX_EREC1 Initial or Clear failure */
            break;
         case XLX_EREC2:
            outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRST2);
            Delay(1000);
            outp(pNXCONFIG, mpNXCONFIG |= bitNXRST2);
            return(ERR_EREC2_INIT_CLR); /* XlX_EREC2 Initial or Clear failure */
            break;
         case XLX_TMAN:
            outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRSTT);
            Delay(1000);
            outp(pNXCONFIG, mpNXCONFIG |= bitNXRSTT);
            return(ERR_TMAN_INIT_CLR); /* XlX_TMAN Initial or Clear failure */
            break;
      }
   }
   bitStreamSize = GetXlxChipBitStreamSize(chip);
   bitStreamBytes = bitStreamBuffer;
   for (count = 1; count <= bitStreamSize; count++) {
      outp(portConfig, *bitStreamBytes);
      bitStreamBytes++;
      timeout = 0;
      while (((inp(pTM8255C) & bitNRDY) == 0) && (timeout++ < 30000)) Delay(9);
      if (timeout >= 30000) {
         switch(chip) {
            case XLX_EREC1:
               outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRST1);
               Delay(1000);
               outp(pNXCONFIG, mpNXCONFIG |= bitNXRST1);
               return(ERR_EREC1_RDY);  /* XlX_EREC1 Ready failure */
               break;
            case XLX_EREC2:
               outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRST2);
               Delay(1000);
               outp(pNXCONFIG, mpNXCONFIG |= bitNXRST2);
               return(ERR_EREC2_RDY);  /* XlX_EREC2 Ready failure */
               break;
            case XLX_TMAN:
               outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRSTT);
               Delay(1000);
               outp(pNXCONFIG, mpNXCONFIG |= bitNXRSTT);
               return(ERR_TMAN_RDY);  /* XlX_TMAN Ready failure */
               break;
         }
      }
   }
   Delay(200);
/*   outp(portConfig, 0xFF);    */
   Delay(1000);  /* wait for Done turns from low to high */
   if ((inp(pTM8255A) & bitNPG_D) == 0) {
      switch(chip) {
         case XLX_EREC1:
            outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRST1);
            Delay(1000);
            outp(pNXCONFIG, mpNXCONFIG |= bitNXRST1);
            return(ERR_EREC1_DONE);  /* XLX_EREC1 Done failure */
            break;
         case XLX_EREC2:
            outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRST2);
            Delay(1000);
            outp(pNXCONFIG, mpNXCONFIG |= bitNXRST2);
            return(ERR_EREC2_DONE);  /* XLX_EREC2 Done failure */
            break;
         case XLX_TMAN:
            outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRSTT);
            Delay(1000);
            outp(pNXCONFIG, mpNXCONFIG |= bitNXRSTT);
            return(ERR_TMAN_DONE);  /* XLX_TMAN Done failure */
            break;
      }
   }
   if (chip == XLX_TMAN) EnableExternalRDY();
   return(GOOD);
}

RETCODE XlxReprogram(XLX_CHIP chip) {
   RETCODE err;
   U8 programTime = 0;

   while (((err = XlxProgram(chip)) != GOOD) && (programTime++ < MAX_XLX_TRY));
   return(err);
}

RETCODE XlxModifyClb(U8 *bitStreamBuffer,
                     XLX_TYPE xlxType, U16 clb, XLX_FUNC func,U8 addr,
		     U8 mask, BOOLEAN value) {
   U16 fx,ox;
   U8 test;
   RETCODE err;

   if ((err = FindClbInfo(xlxType, clb, &fx, &ox)) != GOOD) return(err);
   for (test=0; test<0x10; test++) {
      if ((test&mask) == (addr&mask)) {
         if((err = ChangeOneBit(bitStreamBuffer,
                                xlxType, fx,ox,func,test,value)) != GOOD)
            return(err);
      }
   }
   return(GOOD);
}

RETCODE PRIVATE ChangeOneBit(U8 *bitStreamBuffer,
                             XLX_TYPE xlxType, U16 fx, U16 ox, XLX_FUNC func,
			     U16 addr, BOOLEAN value) {
   U16 frame, offset,bit;
   static const U16 _based(_segname("_CODE")) fFrameInc[] = {
      19,18,18,19,16,17,17,16,20,21,21,20,15,14,14,15 };
   static const U16 _based(_segname("_CODE")) gFrameInc[] = {
       2, 3, 3, 2, 5, 4, 4, 5, 1, 0, 0, 1, 6, 7, 7, 6 };
   static const S16 _based(_segname("_CODE")) fOffsetInc[] = {
       0,-1, 0,-1, 0,-1, 0,-1, 0,-1, 0,-1, 0,-1, 0,-1 };
   static const S16 _based(_segname("_CODE")) gOffsetInc[] = {
       0,-1, 0,-1, 0,-1, 0,-1, 0,-1, 0,-1, 0,-1, 0,-1 };
       
      /* Xilinx documentation starts numbering frames and offsets from 1. */
   frame = fx + ((func == XLX_F) ? fFrameInc[addr] : gFrameInc[addr]) - 1;
   offset = ox + ((func == XLX_F) ? fOffsetInc[addr] : gOffsetInc[addr]) - 1;
   switch (xlxType) {
      case XC3064: bit = XLX_HEADER_SIZE + frame*140 + offset; break;
      case XC3090: bit = XLX_HEADER_SIZE + frame*172 + offset; break;
      default: return(ERR_UNKNOW_XILINX);
   }
/*
** If desired output value is true, bit must be set to 0.
*/
   if (value) bitStreamBuffer[bit/8] &= ~(1 << (bit%8));
   else bitStreamBuffer[bit/8] |= (1 << (bit%8));
   return(GOOD);
}

RETCODE PRIVATE FindClbInfo(XLX_TYPE xlxType, U16 clb, U16 *fx, U16 *ox) {
   static const U16 _based(_segname("_CODE")) fx3064[] = {
      301,279,257,235,213,191,169,147,125,103,81,59,37,15 };
   static const U16 _based(_segname("_CODE")) fx3090[] = {
      345,323,301,279,257,235,213,191,169,147,125,103,81,59,37,15 };
   static const U16 _based(_segname("_CODE")) ox3064[] = {
      129,121,113,105,97,89,81,73,64,56,48,40,32,24,16,8 };
   static const U16 _based(_segname("_CODE")) ox3090[] = {
      161,153,145,137,129,121,113,105,97,89,80,72,64,56,48,40,32,24,16,8 };

   switch (xlxType) {
      case XC3064: *fx = fx3064[clb&0xff]; *ox = ox3064[(clb>>8)&0xff]; break;
      case XC3090: *fx = fx3090[clb&0xff]; *ox = ox3090[(clb>>8)&0xff]; break;
      default: return(ERR_UNKNOW_XILINX);
   }
   return(GOOD);
}
/********************************* EOF *************************************/
