/****************************************************************************
**
**  Name:  peridial.h
**
**  Description:
**     Include file for peripheral presenter dialogs.
**
**  $Log:   S:/tbird/arcm306/peri/peridial.h_v  $
** 
**    Rev 1.0   07 Sep 1995 09:49:18   gene
** Initial revision.
** 
**    Rev 1.6   15 Dec 1993 13:42:22   ron
** Oops!  Still included oodewcc.h, but shouldn't have.
** 
**    Rev 1.5   18 Oct 1993 08:40:34   ron
** checkpoint
** 
**    Rev 1.4   15 Oct 1993 11:15:04   ron
** ready to build and debug
** 
**    Rev 1.3   14 Oct 1993 12:41:12   ron
** checkpoint
** 
**    Rev 1.2   06 Oct 1993 13:45:08   ron
** added help entries
** 
**    Rev 1.1   04 Oct 1993 16:40:44   marilyn
** Expanded dialog classes.
** 
**    Rev 1.0   23 Sep 1993 11:02:18   marilyn
** Initial revision.
** 
**  $Header:   S:/tbird/arcm306/peri/peridial.h_v   1.0   07 Sep 1995 09:49:18   gene  $
**
**  Copyright (C) 1991-93 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _PERIDIAL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#define WIN31

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _PERIRCID_
#include "perircid.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

//#ifdef IDHELP
#undef IDHELP
#define IDHELP 8
//#endif

#ifndef _HLPENTRY_
#include "hlpentry.h"
#endif

// BorlandC includes
#ifndef __DIALOG_H
#include <dialog.h>
#endif

#ifndef __LISTBOX_H
#include <listbox.h>
#endif

#ifndef __STATIC_H
#include <static.h>
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define MAX_STATIC_TEXT 25
#define MAX_EDIT_TEXT  12
#define MAX_INFO_TEXT 512
#define MAX_BYTE_PER_LINE  8
#define MAX_BUFFER_LINES  16    // a 128 byte buffer

#define SPIN_INC 1
#define SPIN_DEC -1

typedef struct DIA_PERILIST_DATA {
   PTListBoxData  listBoxData;
   S8 staticTextData[MAX_STATIC_TEXT];
};

typedef struct DIA_PERIADDR_DATA {
   S8 addrData[ADDR_BUFF_SZ];
};

typedef S8 BYTE_TEXT[MAX_EDIT_TEXT];

typedef struct DIA_BUFFER_LINE_DATA {
   BYTE_TEXT bufferByte[MAX_BYTE_PER_LINE];
};

typedef struct DIA_BUFFER_DATA {
   S8 staticBitRangeData[MAX_STATIC_TEXT];
   DIA_BUFFER_LINE_DATA bufferData;
   S8 staticAsciiData[MAX_STATIC_TEXT];
};

typedef struct DIA_PERIEDITB_DATA {
   S8 staticAddrData[MAX_STATIC_TEXT];
   DIA_BUFFER_DATA bufferLine[MAX_BUFFER_LINES];
};


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

//-----------------------------------------------------------------------
//  TPeriListDialog
//
//  Description:
//     Simple dialog with a listbox, and 3 keys, OK, Cancel, and Help.
//     Initialized by TDialog class.
//-----------------------------------------------------------------------

_CLASSDEF(TPeriListDialog)
class TPeriListDialog : public TDialog {
public:
   TPeriListDialog(PTWindowsObject AParent,int resourceId,PTModule AModule);
   ~TPeriListDialog();

protected:
   // automatic response for click on the help button of the dialog
   virtual void Help(RTMessage Msg) = [ID_FIRST + HLP_ID] {};
   // handle notification messages from the listbox control
   virtual void HandleListBoxMsg(RTMessage Msg) =
         [ID_FIRST + LISTBOX_ID];

protected:
   PTListBox ListBox;
   PTStatic  StaticText;
};



//-----------------------------------------------------------------------
//  TGo2PeriDialog
//
//  Description:
//     Dialog for Go To Peripheral...
//-----------------------------------------------------------------------

_CLASSDEF(TGo2PeriDialog)
class TGo2PeriDialog : public TPeriListDialog {
public:
   TGo2PeriDialog(PTWindowsObject AParent,int resourceId,PTModule AModule) :
         TPeriListDialog(AParent,resourceId,AModule) {};
   ~TGo2PeriDialog() {};

protected:
   // handle the help button for this dialog
   virtual void Help(RTMessage Msg) = [ID_FIRST + HLP_ID];

};

//-----------------------------------------------------------------------
//  TGo2RegDialog
//
//  Description:
//     Dialog for Go To Register...
//-----------------------------------------------------------------------

_CLASSDEF(TGo2RegDialog)
class TGo2RegDialog : public TPeriListDialog {
public:
   TGo2RegDialog(PTWindowsObject AParent,int resourceId,PTModule AModule) :
         TPeriListDialog(AParent,resourceId,AModule) {};
   ~TGo2RegDialog() {};

protected:
   // handle the help button for this dialog
   virtual void Help(RTMessage Msg) = [ID_FIRST + HLP_ID];

};

//-----------------------------------------------------------------------
//  TGo2AddrDialog
//
//  Description:
//     Dialog for Go To Address...
//-----------------------------------------------------------------------

_CLASSDEF(TGo2AddrDialog)
class TGo2AddrDialog : public TDialog {
public:
   TGo2AddrDialog(PTWindowsObject AParent,int resourceId,PTModule AModule);
   ~TGo2AddrDialog() {};

protected:
   // handle the help button for this dialog
   virtual void Help(RTMessage Msg) = [ID_FIRST + IDHELP];
   // verify address input
   virtual void Ok(RTMessage Msg) = [ID_FIRST + IDOK];
};


//-----------------------------------------------------------------------
//  TEditPeriRegDialog
//
//  Description:
//     Dialog for Edit Register...
//-----------------------------------------------------------------------

_CLASSDEF(TEditPeriRegDialog)
class TEditPeriRegDialog : public TDialog {
public:
   TEditPeriRegDialog(PTWindowsObject AParent,int resourceId,
         PTModule AModule);
   ~TEditPeriRegDialog();
   U32 savedValue;
   U32 savedFieldVal;
   BOOLEAN WriteOnly;
   BOOLEAN ReadOnly;
   U32 getCurrentValue();
   U32 getCurrentFieldValue();
   VOID reSynch(); // peri's selected register has changed
   HWND hDlg; // our handle
   void DrawListBox(PTRegister reg);

protected:
   virtual void SetupWindow();
   // automatic response for click on the help button of the dialog
   virtual void Help(RTMessage Msg) = [ID_FIRST + IDHELP];
   // handle notification messages from the listbox control
   virtual void HandleListBoxMsg(RTMessage Msg) =
         [ID_FIRST + ER_LISTBOX_ID];
   virtual void HandleValueEdit(RTMessage Msg) =
         [ID_FIRST + ER_VALUE_ID];
   virtual void HandleFieldValueEdit(RTMessage Msg) =
         [ID_FIRST + ER_FVALUE_ID];
   virtual void HandleWriteButtonPress(RTMessage Msg) =
         [ID_FIRST + ER_WRITE_ID];
   virtual void HandleCloseButtonPress(RTMessage Msg) =
         [ID_FIRST + ER_CLOSE_ID];
   virtual void HandleNextButtonPress(RTMessage Msg) =
         [ID_FIRST + ER_NEXT_ID];
   virtual void HandlePrevButtonPress(RTMessage Msg) =
         [ID_FIRST + ER_PREV_ID];

// the following interface objects must be public in order for the
// parent window to handle regiser specific editing on the generic
// dialog object
public:
   // PTEdit          RegValue;
   // PTEdit          FieldValue;
   // PTEdit          FieldInfo;
};

//-----------------------------------------------------------------------
//  TEditPeriBufDialog
//
//  Description:
//     Dialog for Edit Register (for Buffers)...
//-----------------------------------------------------------------------

_CLASSDEF(TEditPeriBufDialog)
class TEditPeriBufDialog : public TDialog {
public:
   TEditPeriBufDialog(PTWindowsObject AParent,int resourceId,
         PTModule AModule);
   ~TEditPeriBufDialog() {};

protected:
   // automatic response for click on the help button of the dialog
   virtual void Help(RTMessage Msg) = [ID_FIRST + EB_HLP_ID];
   // handle notification messages from the listbox control

};

