/****************************************************************************
**
**  Name:  perikey.cpp
**
**  Description:
**     Keyboard and related message handling for the peripheral presenter.
**
**  $Log:   S:/tbird/arcm306/peri/perikey.cpv  $
** 
**    Rev 1.0   07 Sep 1995 09:49:20   gene
** Initial revision.
** 
**    Rev 1.2   03 Nov 1993 13:43:58   ron
** ready for 2.1 initial build
** 
**    Rev 1.1   04 Oct 1993 16:42:54   marilyn
** Added keyboard support for cursor movement.
** 
**    Rev 1.0   03 Sep 1993 15:10:32   marilyn
** Initial revision.
** 
**  $Header:   S:/tbird/arcm306/peri/perikey.cpv   1.0   07 Sep 1995 09:49:20   gene  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/


                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#define WIN31
//#define STRICT  // cliULib doesn't do STRICT


#ifndef _PERIPRES
#include "peripres.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

#ifndef _HLPENTRY_
#include "hlpentry.h"
#endif




                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define MENU_OFFSET        0x3F00
#define SOURCE_WINDOW      0
#define STACK_WINDOW       1
#define VARIABLE_WINDOW    2
#define STATUS_WINDOW      3
#define CPU_WINDOW         4
#define MEMORY_WINDOW      5
#define TRACE_WINDOW       6
#define TRIGGER_WINDOW     7
#define SHELL_WINDOW       8
#define EVENT_WINDOW       9
#define BREAKPOINT_WINDOW  10
#define TOOLBAR_WINDOW     11
#define PERIPHERAL_WINDOW  12

                       /****************************
                        *                          *
                        *       EXTERNALS          *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

//
// Pass a message off to the toolbar window
//
VOID ToolBarMsg(RTMessage Msg)   {
   HANDLE hToolBar;

   if (GetToolBarHandle((HANDLE FAR *) &hToolBar) == GOOD) {
      SendMessage(hToolBar, Msg.Message, Msg.WParam, Msg.LParam);
   }
}
//
//  WMKeyDown
//
//  Description:
//    Handle F1 button presses by registering with the Hook procedure.
//    Handle F2-F12 button presses by sending the message off to
//           the Toolbar to process
//    Handle all other WM_KEYDOWN messages by passing them along
//           to DefWndProc
//
VOID TPeriPres::WMKeyDown(RTMessage Msg)   {


   HANDLE hToolBar;
   U16 helpIndex;
   WORD helpEntry;
   static HANDLE lastHandle = 0;

   // Tell the F1 Hook procedure who we are, so it doesn't
   // get confused and pop up somebody else's help...
   if (lastHandle != Msg.Receiver) {
      lastHandle = Msg.Receiver;
      helpIndex = HI_PERIPHERAL;
      helpEntry = HE_PERIPHERAL;
      RegisterHelpEntry(helpIndex, lastHandle, helpEntry);
   }

   switch(Msg.WParam) {
      case VK_F1: /* let the Hook Procedure handle it */
         break;
      case VK_F2:
      case VK_F3:
      case VK_F4:
      case VK_F5:
      case VK_F6:
      case VK_F7:
      case VK_F8:
      case VK_F9:
      case VK_F10:
      case VK_F11:
      case VK_F12:
         if (GetToolBarHandle((HANDLE FAR *) &hToolBar) == GOOD) {
            SendMessage(hToolBar, WM_KEYDOWN, Msg.WParam, Msg.LParam);
         }
         break;
      case VK_RETURN:  // return key
      case VK_PRIOR:   // page up key
      case VK_NEXT:    // page down key
      case VK_END:     // End key
      case VK_HOME:    // Home key
      case VK_UP:      // up arrow key
      case VK_DOWN:    // down arrow key
         HandleKeyboardMessages(Msg);
         break;
      default:
         DefWndProc(Msg);
   }
}

VOID TPeriPres::CMWinBkp(RTMessage Msg)   {

   Msg.WParam = MENU_OFFSET + BREAKPOINT_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinCpu(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + CPU_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinEvt(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + EVENT_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinMem(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + MEMORY_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinPeri(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + PERIPHERAL_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinShl(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + SHELL_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinSrc(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + SOURCE_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinStk(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + STACK_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinStat(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + STATUS_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinTB(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + TOOLBAR_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinTrc(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + TRACE_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinTrg(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + TRIGGER_WINDOW;
   ToolBarMsg(Msg);

}

VOID TPeriPres::CMWinVar(RTMessage Msg)   {

   // windows menu
   Msg.WParam = MENU_OFFSET + VARIABLE_WINDOW;
   ToolBarMsg(Msg);

}


VOID TPeriPres::CMHelpInd(RTMessage Msg)  {

   // help menu
   WinHelp(Msg.Receiver, "PWRVIEWS.HLP",
      HELP_CONTEXT, HE_CONTENTS);
}

VOID TPeriPres::CMHelpHelp(RTMessage Msg)  {

   // help menu
   WinHelp(Msg.Receiver, "PWRVIEWS.HLP",
      HELP_HELPONHELP, HE_CONTENTS);
}

VOID TPeriPres::CMHelpPeri(RTMessage Msg)   {

   // help menu
   WinHelp(Msg.Receiver, "PWRVIEWS.HLP",
      HELP_CONTEXT, HE_PERIPHERAL);
}

//
// Grab the Peripheral Presenter icon out of the pwrviews.exe file
//
VOID TPeriPres::GetWindowClass(WNDCLASS& wc)   {
   HANDLE hToolBar;
   HANDLE hInstance;

   TPresenterWin::GetWindowClass(wc);
   wc.style |= CS_DBLCLKS;
   if (GetToolBarHandle((HANDLE FAR *) &hToolBar) == GOOD) {
      hInstance = ((HANDLE) GetWindowWord(hToolBar, GWW_HINSTANCE));
      wc.hIcon = LoadIcon(hInstance, "PERIPHERAL");
   }
}

