/* ============================================ */
/*   Xilinx XC4000 series fast decoder bit map  */
/*   Author : Anderneil Tsai in Hsinchu Taiwan  */
/*   Date : Oct/25/1992      version : 1.0      */
/*   Function : Support XC4003 only             */
/*  ..........................................  */
/*   Date : Jan/08/1994      version : 1.1      */
/*   Adding : Support XC4005 device             */
/*  ..........................................  */
/*   Date : Jan/12/1994      version :1.2       */
/*   Add " label byte " String to label         */
/*   definition to write at output file.        */
/*  ..........................................  */
/* ============================================ */
#include <stdio.h>
#include <dir.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#define  XLX_TOP      0
#define  XLX_RIGHT    1
#define  XLX_BOTTOM   2
#define  XLX_LEFT     3
#define  XLX_IO1      0
#define  XLX_IO2      1
#define  XLX_LOG      2
#define  XLX_HEADER_SIZE  40
#define  BITS_PER_FRAME_4003   126
#define  BITS_PER_FRAME_4005   166
#define  YES          1
#define  NO           0
#define  UNKNOW       0
#define  XC4003       1
#define  XC4005       2

typedef struct {
char   decodername[30];
int    decline;
} XDECODER;


/* ======================== */
/*  get row number of clb   */
/* ======================== */
int row(char clb[])
{
  int retcode,i;
  char *p;
  char chr[10];
  char clbrow[10];
  p = strstr (clb,"R");
  if ( p == NULL)
  { printf (" Input file format error !  \n ");
    exit (1);
  }
  strcpy (chr,p);
  for (i=0; i < 8 ; i++)   clbrow[i]=chr[i+1];
  retcode = atoi (clbrow);
  if (retcode == 0)
  { printf (" Input file format error !  \n ");
    exit (1);
  }
  return  retcode;
}

/* =========================== */
/*  get column number of clb   */
/* =========================== */
int col(char clb[])
{
  int retcode,i;
  char *p;
  char chr[10];
  char clbcol[10];
  p = strstr (clb,"C");
  if ( p == NULL)
  { printf (" Input file format error !  \n ");
    exit (1);
  }
  strcpy (chr,p);
  for (i=0; i < 8 ; i++)   clbcol[i]=chr[i+1];
  retcode = atoi (clbcol);
  if (retcode == 0)
  { printf (" Input file format error !  \n ");
    exit (1);
  }
  return  retcode;
}

/* ====================== */
/*  get the edge of clb   */
/* ====================== */
int GetEdge (char edge[])
{
 int ReturnCode;
 ReturnCode = 10;
 if (!(strcmp(edge,"T"))) ReturnCode = 0;
 if (!(strcmp(edge,"R"))) ReturnCode = 1;
 if (!(strcmp(edge,"B"))) ReturnCode = 2;
 if (!(strcmp(edge,"L"))) ReturnCode = 3;
 if (ReturnCode < 0 ||  ReturnCode > 3)
 { printf (" Input file format error ![CLB Edge code incorrect]");
   exit(1);
 }
 return ReturnCode;
}


/* ====================== */
/*  get the IO of clb     */
/* ====================== */
int GetIo (char io[])
{
int ReturnCode;
ReturnCode = 10;
if (!(strcmp(io,"IO1"))) ReturnCode = 0;
if (!(strcmp(io,"IO2"))) ReturnCode = 1;
if (!(strcmp(io,"LOG"))) ReturnCode = 2;
if (ReturnCode == 10)
 { printf (" Input file format error ![IO1/IO2 code incorrect]");
   exit(1);
 }
 return ReturnCode;
}

int SearchDecoder (FILE *flca, XDECODER decodertable[40], int *netcount)
{
char ch[260];
int flag0;
int decoderline ;
char  *flag1;
int indexc ,i ,retcode;
int indexdecoder;
char linechar;

*netcount = 0;
fgets(ch, 250,flca);
while (!feof(flca))
  {
   flag0=strncmp (ch,"Addnet ", 7);
   flag1=strstr(ch," DEC.");
   decoderline = 10;
   if (strstr(ch,".O1 ") != NULL)  decoderline = 1;
   if (strstr(ch,".O2 ") != NULL)  decoderline = 2;
   if (strstr(ch,".O3 ") != NULL)  decoderline = 3;
   if (strstr(ch,".O4 ") != NULL)  decoderline = 4;
   if (( flag0== 0) && (flag1 !=NULL) && (decoderline!=10))
      {
        indexc = 7;
        indexdecoder = 0;
        linechar = ch[indexc];
        while (indexc < 240 && linechar !=' ' && linechar != '_')
        {
          if (linechar != '/')
              {
                  decodertable[*netcount].decodername[indexdecoder] = linechar;
                  indexdecoder +=1;
               }
          else   indexdecoder = 0;
          indexc +=1;
          linechar = ch[indexc];
        }
        decodertable[*netcount].decodername[indexdecoder] = '\0'; /* End of string */
        decodertable[*netcount].decline =  decoderline;
        *netcount += 1;
      }
  fgets(ch, 250,flca);
  }
  for (i = 0 ; i < *netcount ; i++)
  {
      printf (" NetName = %s ",decodertable[i].decodername);
      printf ("    Line = %d \n ", decodertable[i].decline);
  }
  printf (" There are %d fast decoder net in this LCA file. \n",*netcount);

if (*netcount == 0)  retcode = -1; else retcode = 0;

return retcode;
}

int SearchDeviceType (FILE *flca)
{
  int inx;
  int devicetype;
  char ch[260];
  inx = 0;
  devicetype = UNKNOW;
  fgets(ch, 250,flca);
  while ( (inx <=5) && (devicetype == UNKNOW))
  {
        fgets(ch, 250,flca);
        if (strstr(ch,"Design" ) != NULL)
        {
         if (strstr(ch,"4003" ) != NULL) devicetype = XC4003;
         if (strstr(ch,"4005" ) != NULL) devicetype = XC4005;
        }
        inx += 1;
  }
  return devicetype;
}

int  Getline(char cline[],XDECODER decodertable[40],int netcount)
{
int linenumber;
int inx, cmpresult;
linenumber = 0;
for (inx = 0 ; inx < netcount ; inx++)
  {
   cmpresult = strcmp(decodertable[inx].decodername, cline);
   if(cmpresult == 0) linenumber = decodertable[inx].decline;
  }
return linenumber;
}


void SetOutputFile (char argv[],char path[MAXPATH])
{
int i;
i = 2;
while ((path [i-2] = argv[i]) != '\0')  i += 1;
}


void main(int argc, char *argv[])
{ /* Start Main Program */
  typedef struct {
  int    frame;
  int    offset;
  } XBIT;
  typedef long int Xdtype;
  XDECODER decodertable[40];
  FILE *fpi, *fpo, *filca;
  struct ffblk fi;
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];
  char *exto = ".ebp";
  char path[MAXPATH];
  char leading[30];
  char ch[260];
  char clb[10],io[10];
  char edge[10];
  char cline[30];
  int  line,nrow,ncol,nedge,nio,i,overwrite;
  long int totalbit,byte;
  long int  fx,ox,bitoffset,byteoffseth,byteoffsetl;
  long int  offsetbit0,offsetbit1;
  long int framebit0,framebit1;
  static int netcount;
  char ans;
  time_t timer;
  char *tofp;
  int device;
  static int BITS_PER_FRAME;
  int	inx_label;
  char byteLabel[40];

  XBIT logicOffset[4][4][2] = {
  /* first subscript is line number, 2= edge number, 3=bit bumber */
    /*top*/            /*right*/         /*bottom*/        /*left*/
  {{{6,4},  {6,3}},  {{1,6}, {1,7}},  {{12,4},{12,5}},  {{13,7},{13,6}}},
  {{{5,4},  {5,3}},  {{4,5}, {4,4}},  {{11,4},{11,5}},  {{19,6},{19,7}}},
  {{{11,4},{11,3}},  {{2,6}, {2,7}},  {{5,4},  {5,5}},  {{17,5},{17,4}}},
  {{{12,4},{12,3}},  {{8,7}, {8,6}},  {{6,4},  {6,5}},  {{20,6},{20,7}}}
 };

  XBIT io1Offset[4][4][2] = {
    /*top*/           /*right*/         /*bottom*/          /*left*/
  {{{ 8,3},{ 8,4}}, {{ 1,4},{ 1,5}},  {{ 14,5},{14,4}},  {{13,4},{13,5}}},
  {{{ 3,3},{ 3,4}}, {{ 6,4},{ 6,5}},  {{ 9,5}, { 9,4}},  {{19,5},{19,4}}},
  {{{9,3},  {9,4}}, {{2,5},  {2,4}},  {{3,5},   {3,4}},  {{15,4},{15,5}}},
  {{{14,3},{14,4}}, {{8,4},  {8,5}},  {{8,5},   {8,4}},  {{20,4},{20,5}}}
 };

  XBIT io2Offset[4][4][2] = {
    /*top*/         /*right*/         /*bottom*/       /*left*/
{{{ 7,3},{ 7,4}}, {{0,5}, {0,6}}, {{13,5}, {13,4}}, {{14,5}, {14,6}}},
{{{ 4,3},{ 4,4}}, {{5,6}, {5,5}}, {{10,5}, {10,4}}, {{18,6}, {18,5}}},
{{{10,3},{10,4}}, {{3,6}, {3,5}}, {{ 4,5}, { 4,4}}, {{16,6}, {16,5}}},
{{{13,3},{13,4}}, {{7,5}, {7,6}}, {{ 7,5}, { 7,4}}, {{21,5}, {21,6}}}
 };


 static  XBIT base4003[] = {
  /*  for XC4003 only  */
 {366, 104}, {330, 94},{ 294, 84},{ 258, 74},
 {222,  64}, {185, 53}, {149, 43}, {113, 33},
 { 77,  23}, { 41, 13}};

 static XBIT base4005[] = {
 {510, 144}, {474, 134}, {438, 124}, {402, 114},
 {366, 104}, {330,  94}, {294,  84}, {257,  73},
 {221,  63}, {185,  53}, {149,  43}, {113,  33},
 { 77,  23}, { 41,  13} };

 XBIT *base;


  if (argc < 3)
   {
     printf("Input argument error \n");
     printf("--------------------------------------------------- \n");
     printf("   This is a Program that can compute the position  \n");
     printf("   of XILINX XC4003/XC4005 fast decoder bit mapped. \n");
     printf("   Syntax as below :                                \n");
     printf("       DECMAP file1 file2.lca [-oOutput] [-w]       \n");
     printf("   file1 :  Control Input file                      \n");
     printf("   file2 :  XILINX LCA file                         \n");
     printf("      -o :  output file name,                       \n");
     printf("            if no specific filename,default         \n");
     printf("            output file is as file1.EBP             \n");
     printf("      -w :  the output file allow be overwritten    \n");
     printf("                                                    \n");
     printf(" Version :  V1.3                                    \n");
     printf("  author : Andy Tsai in MICROTEK  EDC/HWG           \n");
     printf("                          on May/28/1996            \n");
     printf("--------------------------------------------------- \n");
     exit(1);
   }
  printf (" Processing ......... \n");
  fnsplit(argv[1], drive, dir, file, ext);
  fnmerge(path, drive, dir, file, exto);
  if ((fpi =fopen(argv[1],"r+t")) == NULL)
  {
    printf("Can not open this %s input file ! \n \007", argv[1]);
    exit(1);
  }

  overwrite = NO;
  if (argc > 3)
     {
        for (i = 3; i < argc ; i++)
         {
            if (strstr(argv[i],"-o") != NULL )  SetOutputFile (argv[i],path);
            if (strstr(argv[i],"-O") != NULL )  SetOutputFile (argv[i],path);
            if (strstr(argv[i],"-w") != NULL )  overwrite = YES ;
            if (strstr(argv[i],"-W") != NULL )  overwrite = YES ;
         }
     }

  if (overwrite == NO)
   {
       if (findfirst(path,&fi,0x0027) == 0)
       {
           printf (" The %s file has existed, Do you want to overwrite it ?(y/n) \007",path);
           ans = getche();
           printf ("\n");
           if (ans!='y' && ans != 'Y')
               exit(1);
       }
    }
  fpo = fopen (path,"w");    /* Open Output file */

  if ((filca = fopen(argv[2],"r+t")) == NULL)  /* Open input LCA file */
  {
    printf("Can not open this %s input file ! \n \007", argv[2]);
    exit(1);
  }

  /*
  **   Search Device type xc4003/xc4005/unknow
  */
   device=SearchDeviceType (filca);
   if (device == UNKNOW)
   {
     printf("UnKnow device type in the %s input file ! \n \007",argv[2]);
     fclose(filca);
     exit(1);
   }

   if (device == XC4003)
   {
      printf (" The device XC4003 chip is selected in %s file. \n",argv[2]);
      base = base4003;
      BITS_PER_FRAME = BITS_PER_FRAME_4003;

   }

   if (device == XC4005)
   {
      printf (" The device XC4005 chip is selected in %s file. \n",argv[2]);
      base = base4005;
      BITS_PER_FRAME = BITS_PER_FRAME_4005;
   }
     fclose(filca);

  if ((filca = fopen(argv[2],"r+t")) == NULL)  /* Open input LCA file */
  {
    printf("Can not open this %s input file ! \n \007", argv[2]);
    exit(1);
  }

  if (SearchDecoder (filca,decodertable,&netcount) != 0) {
     printf(" Input  LCA file  is incorrect !!  \n");
     printf(" Please Check this %s file. \n",argv[2]);
     exit(1);}
  fclose(filca);

  /* get timer */
  time (&timer);
  tofp = ctime(&timer);

 /* Printing HEADER in  output file  */
 fprintf (fpo,"; ------------------------------------------------------------ \n");
 fprintf (fpo,";   This is a output file that is generated by DECMAP.EXE      \n");
 fprintf (fpo,";   program. This is data file for Assembly to reprogram       \n");
 fprintf (fpo,";   XILINX XC4003/XC4005 fast decoder structure.               \n");
 fprintf (fpo,";   Data Format :                                              \n");
 fprintf (fpo,";     1st byte : high byte of the address offset.              \n");
 fprintf (fpo,";     2nd byte : low byte of the address offset.               \n");
 fprintf (fpo,";     3rd byte : bit7---bit4    bit3--bit0                     \n");
 fprintf (fpo,";                                  XXXX ------   bit offset.   \n");
 fprintf (fpo,";                   0000  --------------------   IO1 driver    \n");
 fprintf (fpo,";                   1000  --------------------   IO2 driver    \n");
 fprintf (fpo,";                   0100  --------------------   LOG driver    \n");
 fprintf (fpo,";                                                (CLB driver). \n");
 fprintf (fpo,";                                                              \n");
 fprintf (fpo,";   Bit data of Xilinx :                                       \n");
 fprintf (fpo,";   1. I/O 1 to Decoder Line :     bit1   bit0                 \n");
 fprintf (fpo,";                   True        =    0  ,  0                   \n");
 fprintf (fpo,";                   Complement  =    1  ,  1                   \n");
 fprintf (fpo,";                   Don't care  =    1  ,  0                   \n");
 fprintf (fpo,";   2. I/O 2 to Decoder Line :     bit1   bit0                 \n");
 fprintf (fpo,";                   True        =    1  ,  1                   \n");
 fprintf (fpo,";                   Complement  =    0  ,  0                   \n");
 fprintf (fpo,";                   Don't care  =    0  ,  1                   \n");
 fprintf (fpo,";                                                              \n");
 fprintf (fpo,";    Output File    : %s \n",path);
 fprintf (fpo,";                                                              \n");
 fprintf (fpo,";     Input File                                               \n");
 fprintf (fpo,";    ===============                                           \n");
 fprintf (fpo,";    Control file   : %s \n",argv[1]);
 fprintf (fpo,";    Xilin LCA file : %s \n",argv[2]);
 if (device == XC4003)
 fprintf (fpo,";    Device type    : XC4003 chip \n");
 if (device == XC4005)
 fprintf (fpo,";    Device type    : XC4005 chip \n");
 fprintf (fpo,";    date/time      : %s",tofp);
 fprintf (fpo,";                                                              \n");
 fprintf (fpo,"; ------------------------------------------------------------ \n");

  fscanf (fpi, "%s",leading);
  fflush(fpi);
  while (!feof(fpi))
  {
      if (!(strcmp(leading,"#")))
      {

          fgets(ch, 250,fpi);
          fprintf (fpo,"; %s",ch);
      }
      else
      {
           if (!(strcmp(leading,":")))
           {  /* check  label */
              fscanf (fpi,"%s",byteLabel);
              fprintf(fpo,"%s label  byte \n",byteLabel);
              fgets(ch,250,fpi);
            }
            /******   check label end  *****/
            else
            {
                 if (!(strcmp(leading,"$")))
                   {
                       fgets(ch, 250,fpi);
                   }
                   else
                   {
                        fscanf (fpi, "%s %s %s %s",clb,io,edge,cline);
                        fflush(fpi);
                        nrow = row(clb) - 1 ;
                        ncol = col(clb) - 1 ;
                        nedge = GetEdge (edge);
                        nio = GetIo(io);
                        line = Getline(cline,decodertable,netcount);
                        if (line == 0) {
                           printf (" Can not find this %s net in LCA. \n", cline);
                           exit(1);
                           }
                        switch (nedge) {
                           case XLX_TOP:
                                        fx = base[ncol].frame;
                                        ox = base[0].offset + 10;
                                             break;
                           case XLX_RIGHT:
                                        fx = 4;
                                        ox = base[nrow].offset;
                                break;
                           case XLX_BOTTOM:
                                        fx = base[ncol].frame;
                                        ox = 0;
                                break;
                           case XLX_LEFT:
                                        fx = base[0].frame + 36;
                                        ox = base[nrow].offset;
                                break;
                        }

                        switch (nio) {
                         case  XLX_LOG:
                               framebit0  = fx + logicOffset[line-1][nedge][0].frame;
                               framebit1  = fx + logicOffset[line-1][nedge][1].frame;
                               offsetbit0 = ox + logicOffset[line-1][nedge][0].offset;
                               offsetbit1 = ox + logicOffset[line-1][nedge][1].offset;
                               break;
                         case  XLX_IO1:
                               framebit0  = fx + io1Offset[line-1][nedge][0].frame;
                               framebit1  = fx + io1Offset[line-1][nedge][1].frame;
                               offsetbit0 = ox + io1Offset[line-1][nedge][0].offset;
                               offsetbit1 = ox + io1Offset[line-1][nedge][1].offset;
                               break;
                         case  XLX_IO2:
                               framebit0  = fx + io2Offset[line-1][nedge][0].frame;
                               framebit1  = fx + io2Offset[line-1][nedge][1].frame;
                               offsetbit0 = ox + io2Offset[line-1][nedge][0].offset;
                               offsetbit1 = ox + io2Offset[line-1][nedge][1].offset;
                               break;
                        }
                        totalbit = (Xdtype)XLX_HEADER_SIZE + (Xdtype)framebit0 * (Xdtype)BITS_PER_FRAME + (Xdtype)offsetbit0;
                        byte = totalbit / (Xdtype)8;
                        byteoffseth = byte /(Xdtype)256;
                        byteoffsetl = byte %(Xdtype)256;
                        bitoffset = totalbit % (Xdtype)8;
                        if (nio==1) bitoffset = bitoffset + 0x80; /* for IO2 remark */
                        if (nio==2) bitoffset = bitoffset + 0x40; /* for LOGIC remark */
                        /****  print bit0 data to output filw  ****/
                          if (byteoffseth < 16)                    fprintf (fpo,"         DB      0%1xH,",byteoffseth);
                          if (byteoffseth > 0x9f)                  fprintf (fpo,"         DB     0%2xH,",byteoffseth);
                          if ((byteoffseth <= 0x9f) && (byteoffseth >=16)) fprintf (fpo,"         DB     %3xH,",byteoffseth);
                          if (byteoffsetl < 16)                    fprintf (fpo,"   0%1xH,",byteoffsetl);
                          if (byteoffsetl > 0x9f)                  fprintf (fpo,"  0%2xH,",byteoffsetl);
                          if ((byteoffsetl <= 0x9f) && (byteoffsetl >=16)) fprintf (fpo,"  %3xH,",byteoffsetl);
                          if (bitoffset < 16)                    fprintf (fpo,"   0%1xH       ; bit0 ",bitoffset);
                          if (bitoffset > 0x9f)                  fprintf (fpo,"  0%2xH       ; bit0 ",bitoffset);
                          if ((bitoffset <= 0x9f) && (bitoffset >=16))   fprintf (fpo,"  %3xH       ; bit0 ",bitoffset);
                        fprintf (fpo, "of %s Signal. \n",leading);
                        totalbit = (Xdtype)XLX_HEADER_SIZE + (Xdtype)framebit1 * (Xdtype)BITS_PER_FRAME + (Xdtype)offsetbit1;
                        byte = totalbit / (Xdtype)8;
                        byteoffseth = byte /(Xdtype)256;
                        byteoffsetl = byte % (Xdtype)256;
                        bitoffset = totalbit % (Xdtype)8;
                        if (nio==1) bitoffset = bitoffset + 0x80; /* for IO2 remark */
                        if (nio==2) bitoffset = bitoffset + 0x40; /* for LOGIC remark */
                        /****  print bit1 data to output filw  ****/
                          if (byteoffseth < 16)                    fprintf (fpo,"         DB      0%1xH,",byteoffseth);
                          if (byteoffseth > 0x9f)                  fprintf (fpo,"         DB     0%2xH,",byteoffseth);
                          if ((byteoffseth <= 0x9f) && (byteoffseth >=16)) fprintf (fpo,"         DB     %3xH,",byteoffseth);
                          if (byteoffsetl < 16)                    fprintf (fpo,"   0%1xH,",byteoffsetl);
                          if (byteoffsetl > 0x9f)                  fprintf (fpo,"  0%2xH,",byteoffsetl);
                          if ((byteoffsetl <= 0x9f) && (byteoffsetl >=16)) fprintf (fpo,"  %3xH,",byteoffsetl);
                          if (bitoffset < 16)                    fprintf (fpo,"   0%1xH       ; bit1 \n",bitoffset);
                          if (bitoffset > 0x9f)                  fprintf (fpo,"  0%2xH       ; bit1 \n",bitoffset);
                          if ((bitoffset <= 0x9f) && (bitoffset >=16))   fprintf (fpo,"  %3xH       ; bit1 \n",bitoffset);
                   }
            }
     }
  fscanf (fpi, "%s",leading);
  fflush(fpi);
  }
  fclose(fpi);
  fclose(fpo);
  printf("....... Finished ....... \n" );
 }/* End of Main Program */
