/****************************************************************************
**
** Name: trclib.c
**
** Description:
**   Services for MTAT F/W
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcm302/mpfw_302/trclib.c_v  $
** 
**    Rev 1.0   10 Jun 1996 08:51:14   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:47:44   gene
** Initial revision.
**
** $Header:   S:/tbird/arcm302/mpfw_302/trclib.c_v   1.0   10 Jun 1996 08:51:14   gene  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

		       /****************************
			*			   *
			*      INCLUDE FILES	   *
			*			   *
			****************************/

#include <string.h>
#include <dos.h>
#include <conio.h>

#ifndef _TRCLIB_
#include "trclib.h"
#endif

#ifndef _TRCXLX_
#include "trcxlx.h"
#endif

		       /****************************
			*			   *
			*    LOCAL DEFINITIONS	   *
			*			   *
			****************************/

#define MK_FP(seg, ofs) ((VOID _far *) ((((U32) seg) << 16) | ((U16) ofs)))

#define AIBOCI 0x99

/* I/O port address define */

#define pTM8255C  0xF162
#define pTM8255P  0xF163

#define pRpEREC1  0xF100

#define INIT_DATA_pTM8255B  0xEA
#define INIT_DATA_pNXCONFIG 0xB8

/* I/O port corresponding bit define */

#define bitNXRST1  0x01
#define bitNXRST2  0x02
#define bitNXRSTT  0x04

#define bitENPROGX 0x10

                       /****************************
			*			   *
			*    EXTERNAL VARIABLES    *
			*			   *
			****************************/

BOOLEAN mtatExist;
extern U8 mpNXCONFIG;

                       /****************************
			*			   *
			*     LOCAL PROTOTYPES	   *
			*			   *
			****************************/

BOOLEAN CheckXlxExist(XLX_CHIP chip);
RETCODE fmemtst(U8 _far *s, U16 len, U16 mask);

		       /****************************
			*			   *
			*     EXECUTABLE CODE	   *
			*			   *
			****************************/

VOID CheckExist(BOOLEAN *traceExist, U16 *xilinxExist) {
   U8 dataOut;
   U16 exist = 0;

   *traceExist = YES;
   mpNXCONFIG = INIT_DATA_pNXCONFIG;
   outp(pTM8255P, AIBOCI);
   for (dataOut = 1; dataOut != 0; dataOut <<= 1) {
      outp(pTM8255B, dataOut);
      Delay(10);
      if (((U8) inp(pTM8255B)) != dataOut) {
         *traceExist = NO;
         break;
      }
   }
   for (dataOut = 0xFE; dataOut != 0xFF; dataOut = (U8) ((dataOut << 1) | 1)) {
      outp(pTM8255B, dataOut);
      Delay(10);
      if (((U8) inp(pTM8255B)) != dataOut) {
         *traceExist = NO;
         break;
      }
   }
   outp(pTM8255B, INIT_DATA_pTM8255B);
   outp(pNXCONFIG, mpNXCONFIG);
   outp(pNXCONFIG, mpNXCONFIG |= 0x07);
   if (CheckXlxExist(XLX_TMAN) == TRUE) exist |= 0x0100;
   if (CheckXlxExist(XLX_EREC1) == TRUE) exist |= 0x0010;
   if (CheckXlxExist(XLX_EREC2) == TRUE) exist |= 0x0001;
   *xilinxExist = exist;
}

VOID Delay(U16 more) {
   register U16 i;

   for (i=0; i < more; i++);
}

RETCODE TestAddrOfVRAMs(VOID) {
   RETCODE err;
   U8 _far *addrDRAM = MK_FP(TMAN_SEG, 0);

   outp(pSEQENBWR, bitACTDIS);
   outp(pBANKWR, 0);
   if ((err = fmemtst(addrDRAM, 0x2000, 0x00FF)) != GOOD) return(err);
   return(GOOD);
}

RETCODE TestSeqRAMs(VOID) {
   RETCODE err;
   U8 _far *seqRAM0 = MK_FP(TMAN_SEG, SEQ_RAM0_OFFSET);
   U8 _far *seqRAM1 = MK_FP(TMAN_SEG, SEQ_RAM1_OFFSET);

   outp(pSEQENBWR, bitSEQENB);
   if ((err = fmemtst(seqRAM0, SEQ_RAM_SIZE, 0xFFFF)) != GOOD) return(0xFF00);
   if ((err = fmemtst(seqRAM1, SEQ_RAM_SIZE, 0xFFFF)) != GOOD) return(0xFF01);
   return(GOOD);
}

RETCODE fmemcmp(U8 _far *s, U8 _far *ct, U16 n) {

   return(GOOD);
}

VOID fmemcpy(U8 _far *s, U8 _far *ct, U16 n) {
   U16 srcSeg, srcOffset, dstSeg, dstOffset, count;

   srcSeg = FP_SEG(ct);
   srcOffset = FP_OFF(ct);
   dstSeg = FP_SEG(s);
   dstOffset = FP_OFF(s);
   count = n;
   _asm {
           pushf
           push  ds
           push  si
           push  es
           push  di
           push  cx
           cld
           mov   ds, srcSeg
           mov   si, srcOffset
           mov   es, dstSeg
           mov   di, dstOffset
           mov   cx, count
      rep  movsb
           pop   cx
           pop   di
           pop   es
           pop   si
           pop   ds
           popf
   }
}

BOOLEAN CheckXlxExist(XLX_CHIP chip) {
   U16 portReprogram;
   U8 bitNINIT, bitNXRST;
   BOOLEAN exist = FALSE;

   switch(chip) {
      case XLX_EREC1:
         portReprogram = pRpEREC1;
         bitNINIT = bitNINIT1;
         bitNXRST = bitNXRST1;
         break;
      case XLX_EREC2:
         portReprogram = pRpEREC2;
         bitNINIT = bitNINIT2;
         bitNXRST = bitNXRST2;
         break;
      case XLX_TMAN:
         portReprogram = pRpTMAN;
         bitNINIT = bitNINITT;
         bitNXRST = bitNXRSTT;
         break;
   }
   outp(pTM8255B, inp(pTM8255B) | bitENPROGX);
   outp(portReprogram, 0);
   outp(pNXCONFIG, mpNXCONFIG &= ~bitNXRST);
   Delay(1000);
   if ((inp(pTM8255C) & bitNINIT) == 0) exist = TRUE;
   outp(pNXCONFIG, mpNXCONFIG |= bitNXRST);
   outp(pTM8255B, inp(pTM8255B) & ~bitENPROGX);
   return(exist);
}

RETCODE fmemtst(U8 _far *s, U16 len, U16 mask) {
   U8 _far *t, data, loAddr, hiAddr;
   U16 i, bit;

   t = s;
   i = len;
   do {
      bit = 1 << (((U8) ((U32) t)) & 0x0F);
      if (mask & bit) {
         loAddr = (U8) ((U32) t);
         hiAddr = (U8) (((U16) ((U32) t)) >> 8);
         data = loAddr ^ hiAddr;
         *t = data;
         if (*t != data) return(1);
         *t = (U8) ~data;
      }
   } while ((--i != 0) && (((U16) ((U32) (++t))) != 0));
   t = s;
   i = len;
   do {
      bit = 1 << (((U8) ((U32) t)) & 0x0F);
      if (mask & bit) {
         loAddr = (U8) ((U32) t);
         hiAddr = (U8) (((U16) ((U32) t)) >> 8);
         data = loAddr ^ hiAddr;
         if (*t != (U8) ~data) return(2);
      }
   } while ((--i != 0) && (((U16) ((U32) (++t))) != 0));
   return(GOOD);
}

/********************************* EOF *************************************/
