/****************************************************************************
**
** Name: trcxlx.h
**
** Description:
**   Header file for services of Xilinx's reprogramming and CLB-modifying
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcm302/mpfw_302/trcxlx.h_v  $
** 
**    Rev 1.0   10 Jun 1996 08:51:28   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:52:50   gene
** Initial revision.
**
** $Header:   S:/tbird/arcm302/mpfw_302/trcxlx.h_v   1.0   10 Jun 1996 08:51:28   gene  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

#define _TRCXLX_
#define MAIN_BIN
//#define DIAG_BIN

		       /****************************
			*			   *
			*      INCLUDE FILES	   *
			*			   *
			****************************/

#ifdef MAIN_BIN
   #ifndef _EMU_BASE_TYPES_
   #include "emutypes.h"
   #endif
#endif

#ifdef DIAG_BIN
   #ifndef _DGT_BASE_TYPES_
   #include "dgttypes.h"
   #endif
#endif

		       /****************************
			*			   *
			*	DEFINITIONS	   *
			*			   *
			****************************/

typedef enum { XC3064, XC3090 } XLX_TYPE;
typedef enum { XLX_EREC1, XLX_EREC2, XLX_TMAN } XLX_CHIP;
typedef enum { XLX_F, XLX_G, XLX_X } XLX_FUNC;

#define XC3090SIZE  (64200 / 8)+1
#define XC3064SIZE  (46104 / 8)+1

/* I/O port address define */

#define pRpEREC1  0xF100
#define pRpEREC2  0xF108
#define pRpTMAN   0xF110

#define pEREC1    0xF130
#define pEREC2    0xF138
#define pTMAN	  0xF300

/* I/O port corresponding bit define */

#define bitNINIT1  0x01
#define bitNINIT2  0x02
#define bitNINITT  0x04
#define bitNRDY1   0x10
#define bitNRDY2   0x20
#define bitNRDYT   0x40

		       /****************************
			*			   *
			*	 PROTOTYPES	   *
			*			   *
			****************************/

RETCODE XlxReprogram(XLX_CHIP chip);
RETCODE XlxModifyClb(U8 *bitStreamBuffer,
                     XLX_TYPE xlxType, U16 clb, XLX_FUNC func,U8 addr, \
		     U8 mask, BOOLEAN value);

/********************************* EOF *************************************/
