/****************************************************************************
**
**  Name:  emullfw.h
**
**  Description:
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/hfw307/arcm/emullfw.h_v  $
** 
**    Rev 1.2   19 Sep 1996 09:43:08   gene
** added canbase
** 
**    Rev 1.1   17 Jan 1996 17:13:58   gene
** added qualify trace functions
** 
**    Rev 1.0   11 Jan 1996 10:48:36   gene
** Initial revision.
** 
**    Rev 1.0   03 Jan 1996 13:51:02   gene
** Initial revision.
** 
**    Rev 1.2   15 Nov 1995 16:24:06   kevin
** added setMapAction()
** 
**    Rev 1.0   07 Sep 1995 10:47:24   gene
** Initial revision.
** 
** Initial revision.
** 
**  $Header:   S:/tbird/hfw307/arcm/emullfw.h_v   1.2   19 Sep 1996 09:43:08   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _LLFW_


                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *      DEFINITIONS         *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *       PROTOTYPES         *
                         *                          *
                         ****************************/
#define CAN_BUFFER_NO   0x10L
#define NO_LOAD_CAN     0
#define LOAD_CAN        1
extern U16 mapBuf[0x100];
extern U32 startLogFrameOfTrcBuf[];
extern U32 endLogFrameOfTrcBuf[];
/*-----------------------LLFW COVERAGE and RBW function------------------*/
VOID InitCov(VOID);

HW_STATUS CovMapTest(VOID);

HW_STATUS CovMemTest(VOID);

HW_STATUS InitRecRam(VOID);

HW_STATUS CovBkSet(U16 seg, U16 bank);

HW_STATUS CovClear(U32 startAddr, U32 endAddr, U16 bkNumB);

HW_STATUS RbwSet(U32 startAddr, U32 endAddr, U16 bkNumB);

VOID CovCal(U32 startAddr, U32 endAddr,U16 bkNumB); // output covCnt(32)

VOID CovRbwAdr(U32 startAddr, U32 endAddr,U16 bkNumB);
//output covStart(32), covEnd(32), covStatus(8)

VOID CovEnable(VOID);

VOID RbwEnable(VOID);

VOID EnRbwBr(VOID);

VOID GlbCovRbwDis(VOID);

/*-----------------------LLFW MAP function-------------------------------*/
VOID SetDmaCount(U16 count);

HW_STATUS InitEm(VOID);

HW_STATUS MapTest(VOID);

HW_STATUS InitMapCtr(VOID);

HW_STATUS MapSet(U16 attrib, U32 mapEnd, U32 mapStart);

HW_STATUS SetMapAction(U16 attrib, U32 mapEnd, U32 mapStart, U16 action); // 10/16/95 gene

VOID SetMapTbl(VOID);

VOID EnEmRun(VOID);

VOID EnEmDisViol(VOID);

VOID DisEmStop(VOID);

VOID ClrViolFlg(VOID);

HW_STATUS RdViolFlg(VOID);

HW_STATUS RdIdCode(VOID);
/*-----------------------LLFW Memory function-------------------------------*/

HW_STATUS FillByteMem(U32 addr, U16 epSpace, U32 addrLen, U16 Len,
                      U8 *buff, U16 verifyflag,U16 loadFlag);

VOID DumpByteMem(U32 addr, U16 epSpace, U32 Len, U8 *buff,U16 loadFlag);

HW_STATUS FillWordMem(U32 addr, U16 epSpace, U32 addrLen, U16 Len,
                      U8 *buff, U16 verifyflag,U16 loadFlag);

VOID DumpWordMem(U32 addr, U16 epSpace, U32 Len, U8 *buff,U16 loadFlag);

HW_STATUS CompareMem(U32 addr, U16 epSpace, U32 addrLen, U32 addr2, U16 epSpace2, U16 Size);

HW_STATUS PreCopyMem(U32 startAddr1, U16 epSpace1, U32 addrLen,
                     U32 startAddr2, U16 epSpace2, U16 verifyFlag);

HW_STATUS PostCopyMem(U32 endAddr1, U16 epSpace1, U32 addrLen,
                      U32 endAddr2, U16 epSpace2, U16 verifyFlag);

HW_STATUS TestMem(U32 addr, U16 epSpace1, U32 addrLen,U16 size);

VOID Checksum(U32 addr, U16 epSpace1, U32 addrLen, U16 size);

HW_STATUS SearchMem(U32 addr, U16 epSpace1, U32 addrLen, U16 len, U8 *buff);

VOID InputData(U16 portAddr, U16 addrLen, U16 size);

VOID OutputData(U16 portAddr, U16 dataLen, U8 *buff, U16 size);
/*---------------------------------------------------------------------------*/
HW_STATUS InstructionStep(U32 *baseReg);

U8 CheckEpStop(VOID);

STATUS ClockSpeed(U32 cpClockNo);

VOID SetClockPhase(VOID);

VOID ExbpSet(U32 pos,U16 space, U16 execBpNo);

VOID Exbp1Enable(VOID);

VOID Exbp2Enable(VOID);

VOID Exbp1Disable(VOID);

VOID Exbp2Disable(VOID);

VOID EnableSSI(VOID);

VOID EnableSSO(VOID);

VOID DisableSSI(VOID);

VOID DisableSSO(VOID);

VOID GoEp(U32 *baseReg);

U16 GoEnd(U32 *baseReg);

HW_STATUS ExbpStatus(U32 *baseReg);

// VOID IntRegister(U16 addr, U16 rwFlag, U16 mapTable, U16 *intRegBuf);

/*------------------------------- EPM186.a00 ------------------------------*/
VOID InitCpPort(VOID);

VOID InitEpPort(VOID);

HW_STATUS Reset(U32 *baseReg);

HW_STATUS InitialReset(U32 *baseReg);

VOID DisableControl(VOID);

VOID EnableControl(VOID);

VOID GetReg(U32 *cpuReg);

VOID SetReg(U32 *cpuReg);

VOID Get187Reg(VOID);

VOID Set187Reg(VOID);

// VOID IntRegister(U16 regAddr, U16 rwFlag, U16 mapTable, U16 *buff);

VOID ControlEp(U16 signals);

VOID SignalsEp(U16 signals);

VOID DisableSSI(VOID);

VOID EnableSSI(VOID);

VOID DisableSSO(VOID);

VOID EnableSSO(VOID);

VOID ReadyInternal(VOID);

VOID ReadyExternal(VOID);

VOID WaitStates(U16 count);

HW_STATUS CanTest(VOID);

STATUS Pending(VOID);

STATUS RunAndMatch(VOID);

HW_STATUS IDCode(VOID); // 01:EA/XL 02:EB

STATUS ExecuteHalt(VOID);

VOID FwReset(VOID);
/*--------------------------------           ------------------------------*/
VOID CovStatus(U16 space);

VOID SetDmaCount(U16 count);

VOID SetExceptBreak(VOID);

VOID InterruptDisable(VOID);

VOID InterruptEnable(VOID);

HW_STATUS CheckTimeOut(VOID);

VOID HltWatchDog(VOID);

VOID SetWatchDog(U16 count);

VOID SwbpEnable(VOID);

VOID SwbpDisable(VOID);

VOID SelectBreakCode(U16 bkptOpCode);
VOID SetCanBaseAddr(U32 baseAddr,U32 *preAddr);
/*-----------------------------epm306.a00------------------------------*/
VOID ModifyRegisterCS(VOID);
VOID RestoreRegisterCS(VOID);

/*-----------------------------epm328.a00------------------------------*/
HW_STATUS IntRegister(U16 offset, U16 acc, U16 len, U32 *data);
VOID QualTrace(U32 Addr, U32 AddrMask, U16 QualStatus, U16 QualStatusMask);
VOID QualDisable(VOID);
/******************************** End of File ****************************/
