;---------------------------------------------------------------------
; $Header:   S:/tbird/arcm302/mpfw_302/asm/can302/can302.asv   1.0   04 Jun 1996 12:23:06   andy  $
; $Date:   04 Jun 1996 12:23:06  $
; $Revision:   1.0  $
; $Log:   S:/tbird/arcm302/mpfw_302/asm/can302/can302.asv  $
; 
;    Rev 1.0   04 Jun 1996 12:23:06   andy
; Initial revision.
; 
;    Rev 1.0   04 Jun 1996 12:19:28   andy
; Initial revision.
;---------------------------------------------------------------------
;*******************************************************************
;      MICEpack 68302 CAN Program
;
;   author : Yi-tsang Tsai in MICROTEK PDL on may/27/1996
;   source : MICEpack 68307 Can Program.
;*******************************************************************
;---------------------------------------------------------------------
;        GET_IF & SAVE_PC
;---------------------------------------------------------------------
;
;   EA9  EA8  EA7  EA2 |  TRIGGER  |  OFFSET
;  --------------------+-----------+---------------
;    0    0    X       | NOTHING   |   XXXX
;    0    1    1   0   | NEMFC0    |   0180H    (SOURCE,read,byte)
;                  1   | NEMFC0    |   0184H    (SOURCE,read,word)
;    1    0    1   0   | NEMFC1    |   0280H    (DESTINATION,write,byte)
;                  1   | NEMFC1    |   0284H    (DESTINATION,write,word)
;    1    1    1       | CANEND    |   0380H
;
;  note : EA7 = HIGH LEVEL, CAN RAM IS DISABLED
;         CAN END location at xxxxxx6AH address.
;--------------------------------------------------------------------
_canEndTrig:    equ  10380h
_spBuf:         equ  1006ah-4*1
_baseAdd:       equ  1006ah-4*2
canBuf1:        equ  06Ah
canBuf2:        equ  070h
souTrigOs:      equ  0180h
souTrigOsWr:    equ  0184h
desTrigOs:      equ  0280h
desTrigOsWr:    equ  0284h
wordTrigOff:    equ  04h
notReadyFlg:    equ  081h

;-----------------------------------------------------------------------
;       Set CAN RAM's bace address
;      ----------------------------
;   modify source code as below:
;  1. _canSavePc+2.3.4.5      bit31..bit10   bit9..bit0
;  2. _canSavePc+8.9.A.B            |            |
;  3. _canGetIf+2.3.4.5             |            |____ keep original code
;  4. _canGetIf+8.9.A.B             |_________________ replaced them
;                                                      with base address
;                                                      of CAN by User setting
;                                                      or default [0] value.
;                                                             
;-----------------------------------------------------------------------
                ORG  00H
canStart_P:
_canSavePc:
                movea.l _spBuf,a7               ;save ssp
                move.b  d0,_canEndTrig          ;trigger Can end
                rte
                nop
_canGetIf:      
                move.l  a7,_spBuf               ;get ssp value
                movea.l _baseAdd,a7             ;set Can's base address
                bra     _canEnnd                ;Let EPSTOP active.
                ORG  06AH
_canEnnd:             
                nop
                bra  _canSavePc                 ; &&end

                org   100000h
_canVector:
                .long  _canGetIf                ; &&end

;-----------------------------------------------------------------------
;               GET   REGISTER
;-----------------------------------------------------------------------
rgBuf:          equ     06ah-4*1
regBufA5:       equ     06ah-4*2
regBufSR:       equ     028h
                org     0100h
_getRegst:
                move    sr,regBufSR(a7)         ;get SR
                move.l  a6,rgBuf(a7)            ;get a6 register
                movea.l a7,a6                   ;set a6 is a pointer of
                adda.l  #rgBuf,a6               ;can buffer.

                movem.l a0-a5/d0-d7,-(a6)       ;get a5-a0/d7-d0 register.
                move    usp,a5
                move.l  a5,-(a6)                ;get USP 

                movea.l rgBuf(a7),a6            ;restore A6
                movea.l regBufA5(a7),a5         ;restore A5
                move    regBufSR(a7),sr         ;restore SR
                bra.b   _canEnnd1               ;Let EP stop.

                ORG     016AH
_canEnnd1:            
                nop
                bra.b _getRegst                  ; &&end

;-----------------------------------------------------------------------
;               save register
;-----------------------------------------------------------------------
rgBufSave:      equ     06ah-16*4
saveCntWord:    equ     070h
;     ----------------------------------------------------
;     save register control word : (byte)
;     bit7  bit6  bit5  bit4  bit3  bit2  bit1  bit0
;       X     X     X     X     X     X     X    |___     USP
;
;             [1] -- need to save.
;             [0] -- does not need to save.
;              X  -- unused
;     ----------------------------------------------------
                org     0200h
_saveRegst:
                movea.l a7,a6
                adda.l  #rgBufSave,a6           ;get parameter location in CAN
                btst.b  #00h,saveCntWord(a7)    ;check Save USP flag ?
                beq.b   SAVER1                  ;jump if it need not save USP.
                move.l  (a6),a5
                move    a5,usp                  ;save USP
SAVER1:
                adda.l  #04h,a6                 ;adjust pointer.
                movem.l (a6)+,a0-a5/d0-d7       ;SAVE D0-D7/A0-A5
                movea.l rgBufSave+15*4(a7),a6   ;save a6 register.
                bra.b   _canEnnd2

                org     026AH
_canEnnd2:
                nop
                bra.b   _saveRegst              ; &&end
;-----------------------------------------------------------------------
;     START OF REGISTER BUFFER     <--- 28H
;                                SR    (size : word)  
;                                  <--- 2AH            
;                                USP                   
;                                  <--- 2EH            
;                                D0                    
;                                  <--- 32H            
;                                D1                    
;                                  <--- 36H            
;                                D2                    
;                                  <--- 3AH            
;                                D3                    
;                                  <--- 3EH            
;                                D4                    
;                                  <--- 42H            
;                                D5                    
;                                  <--- 46H            
;                                D6                    
;                                  <--- 4AH            
;                                D7                    
;                                  <--- 4EH            
;                                A0                    
;                                  <--- 52H            
;                                A1                    
;                                  <--- 56H            
;                                A2                    
;                                  <--- 5AH            
;                                A3                    
;                                  <--- 5EH            
;                                A4                    
;                                  <--- 62H            
;                                A5                    
;                                  <--- 66H            
;                                A6                    
;                                  <--- 6AH            
;-----------------------------------------------------------------------
;  Command address1 LENGTH address2
;
;  A0 -- Source starting address (address1)
;        A0 --> low word : data pattern length if Fill command
;  D0 -- length (ending address - starting address, start point is 0.)
;        (length = LENGTH - 1   , size byte).
;        (length = LENGTH/2 - 1 , size word).
;  A1 -- Destination address (address2).
;  A7 -- Can RAM base address.
;  A6 -- Source Trigger.
;  A5 -- Destination Trigger.
;  A4 -- the pointer of CAN data buffer.
;  D1 -- Control word 
;        bit15 bit14 bit13 bit12 bit11 bit10  bit9  bit8
;
;
;
;        bit7  bit6  bit5  bit4  bit3  bit2   bit1  bit0
;         |                                          |____ size word[1]/byte[0]
;         |                                             
;         |_______________________________________________  Memory verify flag
;                                                           OFF[0] / ON[1]
;   A2 -- working register.                         
;   A3 -- working register.
;-----------------------------------------------------------------------
; set parameter
                org  0300h
_setParaSt:
                movea.l a7,a2
                adda.l  #canBuf1,a2
                move    -(a2),d1        ;set control word.
                movea.l -(a2),a0        ;set source starting address
                move.l  -(a2),d0        ;get LENGTH.
                btst    #00h,d1         ;check size word/byte ?
                beq.b   setParByte
                lsr.l   #01h,d0         ;LENGTH/2
setParByte:
                subq.l  #01h,d0         ;set length.
                movea.l -(a2),a1        ;set destination  address
                movea.l a7,a6           
                movea.l a7,a5
                movea.l a7,a4
                adda.l  #souTrigOs,a6   ;set source trigger point.
                adda.l  #desTrigOs,a5   ;set destination trigger point.
                btst    #00h,d1
                beq.b   setParByte0
                addq.l  #wordTrigOff,a6 ;change trigger for word.
                addq.l  #wordTrigOff,a5 ;change trigger for word.
setParByte0:
                adda.l  #canBuf1,a4    ;set Can data buffer endding point.
                bra.b   _setParaEd

                org  036Ah
_setParaEd:   
                nop
                bra     _setParaSt      ; &&end

;-----------------------------------------------------------------------
;read byte  from target/EMM
;    pattern length maximum = 44h bytes
                org  0400h
_disByteSt:     
                movea.l a4,a2
                move.l  d0,d6           ;load length, maximum 44h bytes
                                        ;d6 : loop counter
disByte1:     
                move.b  d0,(a6)         ;source trigger
                move.b  (a0)+,d5
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   notRdy1
                move.b  d5,-(a2)
                dbf     d6,disByte1
                bra.b   _disByteEd
notRdy1:
                subq.l  #01h,a0          ;compute not ready address.
                move.l  a0,canBuf2+2(a7) ;save not ready address.
                bra.b   _disByteEd

                org 046ah
_disByteEd:
                nop
                bra.b   _disByteSt      ; &&end

;-----------------------------------------------------------------------
;read word  from target/EMM
;    pattern length maximum = 44h bytes
                org  0500h
_disWordSt:     
                movea.l a4,a2           ;get the start point of Can data Buffer 
                move.l  d0,d6           ;counter max value 22h words
                                        ; d6: loop counter.
disWord1:     
                move.b  d0,(a6)         ;source trigger
                move    (a0)+,d5
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   notRdy2
                ror.w   #08h,d5          ;swap bit7-0, bit15-8
                move    d5,-(a2)
                dbf     d6,disWord1
                bra.b   _disWordEd
notRdy2:
                subq.l  #02h,a0          ;compute not ready address.
                move.l  a0,canBuf2+2(a7) ;save not ready address.
                bra.b   _disWordEd

                org 056ah
_disWordEd:
                nop
                bra.b   _disWordSt       ; &&end
;-----------------------------------------------------------------------
;write data to target/emm with size-byte.
;    pattern length maximum = 20h  (old : 22h, 11/03/1994)
;   d3 : byte,verify error data.               11/03/1994
;   d5 : byte,expectant data.                  11/03/1994
; On 11/03/1994, to support data information if verify failure.
;-----------------------------------------------------------------------
                org     0600h
_wrByteSt:                              
                movea.l a4,a2           ;get the start point of Can data Buffer 
                move.l  d0,d6           ;d6: loop counter, temp
                clr     d7              ;clear d7, pattern length counter
wrByte1:     
                move.b  -(a2),d5        ;get fill data from can buffer.
                move.b  d0,(a5)         ;trigger of destination.
                move.b  d5,(a1)         ;fill data to Target/Emm
                btst    #07h,d1         ;verify flag on ?
                beq.b   wrByte2         ;  off[0],on[1]
                move.b  d0,(a5)         ;trigger of destination.
                                        ;modified by Tsai,11/03/1994,begin.
                move.b  (a1),d3         ;verify data (read data from emm/target)
                cmp.b   d3,d5           ;verify data
                                        ;Tsai,11/03/1994,End
                bne.b   wrError
wrByte2:
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   wrNotRdy
                adda.l  #01h,a1         ;next address
                add     #01h,d7         ;pattern index increase
                cmp     a0,d7           ;check pattern pointer end ?
                bne.b   wrByte3         ;no,jump
                clr     d7              ;yes, clear index
                movea.l a4,a2           ;     reload data buffer pointer to
                                        ;     start location.
wrByte3:
                sub.l   #01h,d6         ;decrease loop counter
                cmp.l   #-1,d6          ;loop end ?
                bne.b   wrByte1         ; no,jump to loop start.
                bra.b   _wrByteEd       ; yes, go to end (for stop EP).
wrError:
                move.b  #01h,canBuf2+1(a7) ;set error flag
wrNotRdy:
                move.l  a1,canBuf2+2(a7)   ;save [error]/[not ready] address
                bra.b   _wrByteEd

                org     066ah
_wrByteEd:
                nop
                bra.b   _wrByteSt
                                           ; &&end

;-----------------------------------------------------------------------
;write data to target/emm with size-word.
;    pattern length maximum = 22h
;    pattern length maximum = 20h  (old : 22h, 11/03/1994)
;   d3 : word,verify error data.               11/03/1994
;   d5 : word,expectant data.                  11/03/1994
; On 11/03/1994, to support data information if verify failure.
;-----------------------------------------------------------------------
;
                org     0700h
_wrWordSt:                              
                movea.l a4,a2           ;get the start point of Can data Buffer 
                move.l  d0,d6           ;d6 : loop counter, temp
                clr     d7              ; pattern index (counter)
                move    d7,d4           ;d4 : even flag,even[0000]/odd[ffffh]
wrWord1:     
                lsl.w   #08h,d5         ;d5 : data buffer,temp
                                        ;     shift low byte to high byte.
                move.b  -(a2),d5        ;get pattern from can buffer.
                bra.b   _wrWord3        ;jump to adjust pattern index
wrWord1_A:
                not     d4              ;change,even flag.
                bne.b   wrWord1         ;jump if even byte.
;
                move.b  d0,(a5)         ;trigger of destination.
                move    d5,(a1)         ;fill data to Target/Emm
                btst    #07h,d1         ;verify flag on ?
                beq.b   wrWord2         ;  off[0],on[1]
                                        ;Tsai,11/03/1994,begin
                move.b  d0,(a5)         ;trigger of destination.
                move    (a1),d3         ;verify data (read data from emm/target)
                cmp     d3,d5           ;verify data
                                        ;Tsai,11/03/1994,end
                bne.b   wrError_w
wrWord2:
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   wrNotRdy_w
                adda.l  #02h,a1         ;next address
                sub.l   #01h,d6         ;decrease d6 loop counter
                cmp.l   #-1h,d6         ;loop end ?
                bne.b   wrWord1
                bra.b   _wrWordEd_w     ;go to end(for stop ep)
wrError_w:
                move.b  #01h,canBuf2+1(a7) ;set error flag
wrNotRdy_w:
                move.l  a1,canBuf2+2(a7)   ;save [error]/[not ready] address
                bra.b   _wrWordEd_w

                org     076ah
_wrWordEd_w:
                nop
                bra.b   _wrWordSt       ; go to begin of program

                org     0774h
_wrWord3:
                add     #01h,d7         ;increase pattern index (counter)
                cmp     a0,d7           ;check pattern index =  pattern length ?
                bne.b   wrWord1_A       ;no, just return
                clr     d7              ;yes, clear pattern index &
                move.l  a4,a2           ;     get pattern start location
                                        ;     for pattern accessing.
                bra.b   wrWord1_A       ; &&end

;-----------------------------------------------------------------------
; test target/emm with size byte (fill test pattern only)
                org     0800h
_tstByte1St:
                move.l  d0,d2           ;get byte length (d2:working length)
                movea.l a0,a2           ;get start address(a2:working add)
tstByte1:
                move    a2,d4           ;compute test pattern
                move    a2,d5
                lsr     #08h,d4
                eor.b   d4,d5           ;high byte/low XOR.
                move.b  d0,(a6)         ;trigger with source FC[0..2]
                move.b  d5,(a2)+        ;write test pattern to Target/emm
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   _tstNotRdy1
                sub.l   #01h,d2         ;DEC length.
                cmp.l   #-01h,d2        ;check end of loop ?
                bne.b   tstByte1
                bra.b   _tstByte1Ed
_tstNotRdy1:
                subq.l  #01h,a2
                move.l  a2,canBuf2+2(a7)   ;save [not ready] address
                bra.b   _tstByte1Ed

                org     086ah
_tstByte1Ed:
                nop
                bra.b   _tstByte1St     ; &&end

;-----------------------------------------------------------------------
;  test target/emm with size byte (verify test pattern)
;
                org     0900h
_tstByte2St:
                move    a0,d4
                move    a0,d5
                lsr     #08h,d4
                eor.b   d4,d5           ;high byte/low XOR.
                move.b  d0,(a6)         ;trigger with source FC[0..2]
                cmp.b   (a0),d5         ;compare Target/emm data with test patt
                bne.b   tstByteErr
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   tstByteErr
                not.b   d5

                move.b  d0,(a6)         ;trigger with source FC[0..2]
                move.b  d5,(a0)         ;write Complement pattern
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   tstByteErr

                move.b  d0,(a6)         ;trigger with source FC[0..2]
                cmp.b   (a0)+,d5        ;compare Target/emm data with test 
                bne.b   tstByteErr2
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   tstByteErr2
                sub.l   #01h,d0         ;DEC length.
                cmp.l   #-01h,d0        ;check end of loop ?
                bne.b   _tstByte2St
                clr.b   canBuf2+1(a7)   ;clear error flage (Pass)
                bra.b   _tstByte2Ed

tstByteErr2:
                subq.l  #01h,a0         ;adjust Error/notRdy address
tstByteErr:  
                move.l  a0,canBuf2+2(a7)   ;save [Error]/[not ready] address
                bra.b   _tstByte2Ed

                org     096ah
_tstByte2Ed:        
                nop
                bra.b   _tstByte2St      ; &&end
;-----------------------------------------------------------------------
; test target/emm with word byte (fill test pattern only)
                org     0A00h
_tstWord1St:
                move.l  d0,d2           ;get byte length (d2:working length)
                movea.l a0,a2           ;get start address(a2:working add)
                move.l  a0,d3
tstWord1:
                move    d3,d4           ;compute test pattern
                move    d3,d5
                lsr     #08h,d4
                eor.b   d4,d5           ;even byte test pattern
                lsl     #08h,d5
                andi    #ff00h,d5
                addq.l  #01h,d3         ;next byte address.

                move    d3,d4
                move    d3,d6
                lsr     #08h,d4
                eor.b   d4,d6           ;odd byte test pattern
                andi    #00ffh,d6
                or      d5,d6           ;combine even/odd test pattern.
                addq.l  #01h,d3         ;next byte address

                move.b  d0,(a6)         ;trigger with source FC[0..2]
                move    d6,(a2)+        ;write test pattern to Target/emm
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   tstNotRdy_Wr1
                sub.l   #01h,d2         ;DEC length.
                cmp.l   #-01h,d2        ;check end of loop ?
                bne.b   tstWord1
                bra.b   _tstWord1Ed
tstNotRdy_Wr1:
                subq.l  #02h,a2
                move.l  a2,canBuf2+2(a7)   ;save [not ready] address
                bra.b   _tstWord1Ed

                org     0A6ah
_tstWord1Ed:
                nop
                bra.b   _tstWord1St     ; &&end

;-----------------------------------------------------------------------
;  test target/emm with size byte (verify test pattern)
;
                org     0b00h
_tstWord2St:
                move.l  a0,d3

tstWord2_L:     move    d3,d4           ;compute test pattern
                move    d3,d5
                lsr     #08h,d4
                eor.b   d4,d5           ;even byte test pattern
                lsl     #08h,d5
                andi    #ff00h,d5
                addq.l  #01h,d3         ;next byte address.

                move    d3,d4
                move    d3,d6
                lsr     #08h,d4
                eor.b   d4,d6           ;odd byte test pattern
                andi    #00ffh,d6
                or      d5,d6           ;combine even/odd test pattern.
                addq.l  #01h,d3         ;next byte address

                move.b  d0,(a6)         ;trigger with source FC[0..2]
                cmp     (a0),d6         ;compare Target/emm data with test patt
                bne.b   _tstWordErr
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   _tstWordErr

                not     d6
                move.b  d0,(a6)         ;trigger with source FC[0..2]
                move    d6,(a0)         ;write Complement pattern

                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   _tstWordErr

                move.b  d0,(a6)         ;trigger with source FC[0..2]
                cmp     (a0)+,d6        ;compare Target/emm data with test 
                bne.b   _tstWordErr

                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   _tstWordErr
                sub.l   #01h,d0         ;DEC length.
                cmp.l   #-01h,d0        ;check end of loop ?
                bne.b   tstWord2_L
                clr.b   canBuf2+1(a7)   ;clear error flage (Pass)
                bra.b   _tstWord2Ed


                org     0b6ah
_tstWord2Ed:
                nop
                bra.b   _tstWord2St

                org     0b76h
_tstWordErr:
                sub.l   #02h,d3         ;adjust Error/notRdy address
                move.l  d3,canBuf2+2(a7)   ;save [Error]/[not ready] address
                bra.b   _tstWord2Ed     ;&&end

;-----------------------------------------------------------------------
;      READ/WRITE/TEST COMMAND  CAN PROGRAM REPLICATION
; 
;   address offset |  message       |    note
;   ---------------+----------------+-----------------------
;        70h       |   Ready Flag   |  [01h]: not_Ready
;                  |                |  [00h]: ready
;                  |                |         set it by Cp
;                  |                |         for Ep checking.
;   ---------------+----------------+-----------------------
;        71h       |  test result   |  [00h]:Pass Flag
;                  |                |  default 01h by Cp.
;                  |                |  cleared by Ep if
;                  |                |  test OK.
;   ---------------+----------------+-----------------------
;        72h       |   error        |   EA[31..24]
;        73        |   or           |   EA[23..16]
;        74        |   not ready    |   EA[15..8]
;        75        |   address      |   EA[7..0]
;                                    
;------------------------------------------------------------------------
;========================================================================
; Reset Command of MICEpack 68306
;
;  If CPU 68306 NMI can not use auto vector,
;     the H/W has to inster 01h code to
;     ED[8..15](D[0..7] of 68306,low byte)
;     during IACK cycle after reset.
;-----------------------------------------------------------------------
        org 0000h
_resSt:
        .LONG   00000060H       ;stack pointer.
        .LONG   epStart         ;PC start address
epStart:
        nop
        nop
        bra     _resEd
        nop
        nop

        org     epStart*4       ;program start if NMI is not Autovector
_nmiResSt:
        .LONG   epStart         ;PC start address


         org 006AH
_resEd:
         nop
         bra    _resSt

         org  007ch
_nmiVec: .LONG  epStart         ; &&end  NMI Auto VECTOR
;-----------------------------------------------------------------------
;       Set CAN RAM's bace address
;      ----------------------------
;   modify source code as below:
;  1. _setBaseSt+2.3.4.5      bit31..bit10   bit9..bit0
;  2. _setBaseSt+8.9.A.B            |            |
;                                   |            |____ keep original code
;                                   |_________________ replaced them
;                                                      with base address
;                                                      of CAN by User setting
;                                                      or default [0] value.
;                                                             
;-----------------------------------------------------------------------
         org  0c00h
_setBaseSt:
         move.l a7,_spBuf       ;save current A7 register to 066h
         movea.l _baseAdd,a7    ;replace new A7 register by 062h
         bra     _setBaseEd     ; to jump here location.

        org   0c6ah
_setBaseEd:
        nop
        bra     _setBaseSt      ; &&end
;-----------------------------------------------------------------------
;       Search  memory command
;     ===========================
; D0 : memory length - 1.
; A0 : search pattern length. (maximum = 28h)
; A1 : start address of memory.
; A4 : start location of search pattern,(buffer 1 pointer)
; A5 : destination trigger DFC[0..2]
; A7 : can base address.
; ................................................................
; working register
; ----------------
; D2 : memory counter.
; D3 : search pattern counter.
;
        org     0d00h
_searchSt:
;        compute address loop counter D2
;        end of searching if D2 = -2.
                move.l  d0,d2
                sub.l   a0,d2

;       compute pattern length loop counter D3
                subq    #1,a0           ;length -1 = loop counter of pattern
CANSEAR0:                               ; end at -1 for DBF instruction.
                move.l  a4,a2            ;point to canBuf1 location. (A2)
                move    a0,d3

                movea.l a1,a3   ;pointer of target/emm a3
CANSEAR1:
                move.b  d0,(a5)         ;trigger with destination FC[0..2]
                move.b  (a3)+,d5        ;read target/emm data

                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   CANSENOTRDY

                cmp.b   -(a2),d5        ;compare pattern(can buffer1).
                bne.b   CANSEAR2        ;target/emm data = can buffer1 ?
                                        ; No,jump to adjust next memory
                                        ; address.
                dbf     d3,CANSEAR1     ;check pattern end ?
                bra.b   CANSEAROK       ;jump if match.
CANSEAR2:
                adda.l  #01h,a1         ;increase address pointer.
                sub.l   #01,d2          ;decrease address loop counter.
                cmp.l   #-2,d2          ;check memory end ?
                bne.b   CANSEAR0        ;jump if it does not end ?
                bra.b   _searchEd
CANSEAROK:
                clr.b   canBuf2+1(a7)   ;clear search flag (found).
CANSENOTRDY:
                move.l  a1,canBuf2+2(a7) ;save match/NotReady address .
                bra.b   _searchEd

                org     0d6ah
_searchEd:
                nop
                bra.b   _searchSt       ;&&end
;-----------------------------------------------------------------------
;               Compare memory with size-byte
;               =============================
;  A0 -- block1 start address (source)
;  A1 -- block2 start address (destination)
;  D0 -- memory length.
;  A6 -- source trigger.
;  A5 -- destination trigger
;  .........................................
;  A2 -- reply flag pointer.
;........................................................................
                org     0e00h
_compByteSt:
                movea.l a7,a2
                adda.l  #canBuf2+1,a2   ; A2 point to reply flag.
CMPByte1:
                move.b  d0,(a6)         ;trigeer of source
                move.b  (a0)+,d5        ;read data from source area

                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   CMPNOTRDY_B1     ;Jump if not ready.

                move.b  d0,(a5)         ;trigger of destination
                move.b  (a1)+,d6        ;read data from destination (Block 2)

                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   CMPNOTRDY_B2     ;jump if not ready.

                cmp.b   d6,d5           ;compare block-1 & block-2 data.
                bne.b   COMNONEQU_B

                subq.l  #1,d0           ;descrease loop counter, D0
                cmp.l   #-1,d0          ;check,loop End ?
                bne.b   CMPByte1        ;No,jump to start of program.

                clr.b  (a2)             ;clear, reply flag [match]
                bra.b  _compByteEd      ;let EP stop.
CMPNOTRDY_B1:
                move.b  #02h,(a2)       ;set reply flag,[02]: block 1
                bra.b   COMNONEQU_B     ; Not ready.

CMPNOTRDY_B2:
                move.b  #03h,(a2)       ;set reply flag,[03]: block 2
                                        ; Not ready.
COMNONEQU_B:
;....................................................................
;               Save NotReady/NotMatch address & data
;....................................................................
                subq.l  #1,a0           ;adjust block 1 address.
                subq.l  #1,a1           ;adjust block 2 address.
                addq.l  #1,a2           ;A2 point to replay buffer
                move.l  a0,(a2)+        ;save block 1 address.
                move.b  #00,(a2)+       ;save block 1 data (dummy byte).
                move.b  d5,(a2)+        ;save block 1 data.
                move.l  a1,(a2)+        ;save Block 2 address
                move.b  #00,(a2)+       ;save Block 2 data (dummy byte).
                move.b  d6,(a2)         ;save Block 2 data.
                bra.b  _compByteEd      ;let EP stop.

                org     e6ah
_compByteEd:
                nop
                bra.b   _compByteSt     ;&&end
;-----------------------------------------------------------------------
;               Compare memory with size-Word
;               =============================
;  A0 -- block1 start address (source)
;  A1 -- block2 start address (destination)
;  D0 -- memory length.
;  A6 -- source trigger.
;  A5 -- destination trigger
;  .........................................
;  A2 -- reply flag pointer.
;........................................................................
                org     0f00h
_compWordSt:
                movea.l a7,a2
                adda.l  #canBuf2+1,a2   ; A2 point to reply flag.
CMPWord1:
                move.b  d0,(a6)         ;trigeer of source
                move    (a0)+,d5        ;read data from source area

                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   CMPNOTRDY_W1     ;Jump if not ready.

                move.b  d0,(a5)         ;trigger of destination
                move    (a1)+,d6        ;read data from destination (Block 2)

                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   CMPNOTRDY_W2     ;jump if not ready.

                cmp     d6,d5           ;compare block-1 & block-2 data.
                bne.b   COMNONEQU_W

                subq.l  #1,d0           ;descrease loop counter, D0
                cmp.l   #-1,d0          ;check,loop End ?
                bne.b   CMPWord1        ;No,jump to start of program.

                clr.b  (a2)             ;clear, reply flag [match]
                bra.b  _compWordEd      ;let EP stop.
CMPNOTRDY_W1:
                move.b  #02h,(a2)       ;set reply flag,[02]: block 1
                bra.b   COMNONEQU_W     ; Not ready.

CMPNOTRDY_W2:
                move.b  #03h,(a2)       ;set reply flag,[03]: block 2
                                        ; Not ready.
COMNONEQU_W:
;....................................................................
;               Save NotReady/NotMatch address & data
;....................................................................
                subq.l  #2,a0           ;adjust block 1 address.
                subq.l  #2,a1           ;adjust block 2 address.
                addq.l  #1,a2           ;A2 point to replay buffer
                move.l  a0,(a2)+        ;save block 1 address.
                move    d5,(a2)+        ;save block 1 data.
                move.l  a1,(a2)+        ;save Block 2 address
                move    d6,(a2)         ;save Block 2 data.
                bra.b  _compWordEd      ;let EP stop.

                org    0f6ah
_compWordEd:
                nop
                bra.b   _compWordSt     ;&&end
;-----------------------------------------------------------------------
;   Adjust Pc to Can area with can base address.
;   note: A7 -- is can base address .
;........................................................................
                org     1000h
_pcToBaseSt:
                jmp     4(a7)           ;jump to base address
                nop
                nop
                bra.b   _pcToBaseEd     ;let EP stop

                org     106ah
_pcToBaseEd:
                nop
                bra.b   _pcToBaseSt     ; &&end

;               move.l  a7,(a7)         ;set  the location what PC will
;
;   Tsai, 1/2/1993, Can't use the "addi" instruction because
;                   it may be change the SR register value.
;               addi.l  #04h,(a7)
;               move.b  #04h,3(a7)      ; jump address.
;               jmp     (a7)            ;

;-----------------------------------------------------------------------
;       check Sum with size byte
;       ========================
;  A0 -- start address (source)
;  D0 -- memory length.
;  A6 -- source trigger.
;......................................................................
;  D6 -- check Sum (word), U32 but the high word is dummy (0000h).
;  D5 -- working register
;.......................................................................
                org     1100h
_chkSByteSt:
                clr.l   d4              ;set D4 to zero,for "addx" instruction.
                clr.l   d5              ;clear data buffer.
                clr.l   d6              ;clear check
CHKSByte1:
                move.b  d0,(a6)         ;trigger of source function code.
                move.b  (a0)+,d5        ;read one byte data from tar/emm.
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   CHKSBNotRDy     ;jump if not ready.

                add     d5,d6           ;add this byte to check sum register.
                addx    d4,d6           ;add the extended bit.
                subq.l  #01h,d0
                cmp.l   #-1,d0          ;check,loop end ?
                bne.b   CHKSByte1

                move.l  d6,canBuf2+2(a7) ;save check Sum to can buffer 2.
                bra.b   _chkSByteEd
CHKSBNotRDy:
                subq.l  #1,a0
                move.l  a0,canBuf2+2(a7) ;save NotReady address .
                bra.b   _chkSByteEd

                org     116ah
_chkSByteEd:
                nop
                bra.b   _chkSByteSt     ;&&end
;-----------------------------------------------------------------------
;       check Sum with word byte
;       ========================
;  A0 -- start address (source)
;  D0 -- memory length.
;  A6 -- source trigger.
;......................................................................
;  D6 -- check Sum (word), U32 but the high word is dummy (0000h).
;  D5 -- working register
;.......................................................................
                org     1200h
_chkSWordSt:
                clr.l   d4              ;set D4 to zero,for "addx" instruction.
                clr.l   d6              ;clear check
CHKSWord1:
                move.b  d0,(a6)         ;trigger of source function code.
                move    (a0)+,d5        ;read one byte data from tar/emm.
                btst.b  #00h,notReadyFlg(a7) ;check Ep Not Ready ?
                bne.b   CHKSWNotRDy     ;jump if not ready.

                add     d5,d6           ;add this byte to check sum register.
                addx    d4,d6           ;add the extended bit.
                subq.l  #01h,d0
                cmp.l   #-1,d0          ;check,loop end ?
                bne.b   CHKSWord1

                move.l  d6,canBuf2+2(a7) ;save check Sum to can buffer 2.
                bra.b   _chkSWordEd
CHKSWNotRDy:
                subq.l  #2,a0
                move.l  a0,canBuf2+2(a7) ;save NotReady address .
                bra.b   _chkSWordEd

                org     126ah
_chkSWordEd:
                nop
                bra.b   _chkSWordSt     ;&&end
;-----------------------------------------------------------------------
;        PreCopyMem
;       ========================
;  A0 -- start address (source)
;  D0 -- memory length.
;  A1 -- destination address
;  A6 -- source trigger.
;  A5 -- destination trigger.
;  D1 -- Control word (bit7 -- verify flag, Off[0]/On[1]
;.......................................................................
;  A2 -- address of ready flag.
;  D6 -- working register
;  D5 -- working register
;.......................................................................
                org     1300h
_preCopySt:
                movea.l a7,a2
                adda.l  #notReadyFlg,a2
PRECop1:
                move.b  d0,(a6)         ; source trigger
                move.b  (a0),d6         ; read data from source
                btst.b  #00h,(a2)       ;check, ready ?
                bne.b   PRECNotRdy1     ;jump if not ready.

                move.b  d0,(a5)         ; destination trigger
                move.b  d6,(a1)         ; write data to destination
                btst.b  #00h,(a2)       ;check, ready ?
                bne.b   PRECNotRdy2     ;jump if not ready.

                btst    #07h,d1         ;verify flag on ?
                beq.b   PRECop2         ;  off[0],on[1]

                move.b  d0,(a5)         ; destination trigger
                move.b  (a1),d5         ; read Destination data
                btst.b  #00h,(a2)       ;check, ready ?
                bne.b   PRECNotRdy2     ;jump if not ready.

                cmp.b   d6,d5           ;verify data
                bne.b   PRECVriErr
PRECop2:
                addq.l  #1,a0           ;next source address
                addq.l  #1,a1           ;next destination address
                subq.l  #01h,d0         ;decrease loop counter
                cmp.l   #-1,d0          ;check, Loop End ?
                bne.b   PRECop1         ;No,jump.

                clr.b   canBuf2+1(a7)   ;clear echo flag. (OK)
                bra.b   _preCopyEd
PRECVriErr:
                move.l  a1,canBuf2+2(a7) ;save verify error address.
                bra.b   _preCopyEd

PRECNotRdy1:
                move.b  #02,canBuf2+1(a7) ; set echo flag, (source Not Ready)
                move.l  a0,canBuf2+2(a7)  ;save Not Ready address of source.
                bra.b   _preCopyEd
PRECNotRdy2:
                move.b  #03,canBuf2+1(a7) ; set echo flag,(destination
                move.l  a1,canBuf2+2(a7)  ; Not Ready), and save address.
                bra.b   _preCopyEd

                org     136ah
_preCopyEd:
                nop
                bra.b   _preCopySt      ; &&end
;-----------------------------------------------------------------------
;        PostCopyMem
;       ========================
;  A0 -- last address (source)
;  D0 -- memory length.
;  A1 -- destination last address
;  A6 -- source trigger.
;  A5 -- destination trigger.
;  D1 -- Control word (bit7 -- verify flag, Off[0]/On[1]
;.......................................................................
;  A2 -- address of ready flag.
;  D6 -- working register
;  D5 -- working register
;.......................................................................
                org     1400h
_posCopySt:
                movea.l a7,a2           ;compute a address of Ready Flag.
                adda.l  #notReadyFlg,a2
POSCop1:
                subq.l  #1,a0           ;Adjust source address.
                subq.l  #1,a1           ;Adjust destination address.
                move.b  d0,(a6)         ; source trigger
                move.b  (a0),d6         ; read data from source
                btst.b  #00h,(a2)       ;check, ready ?
                bne.b   POSCNotRdy1     ;jump if not ready.

                move.b  d0,(a5)         ; destination trigger
                move.b  d6,(a1)         ; write data to destination
                btst.b  #00h,(a2)       ;check, ready ?
                bne.b   POSCNotRdy2     ;jump if not ready.

                btst    #07h,d1         ;verify flag on ?
                beq.b   POSCop2         ;  off[0],on[1]

                move.b  d0,(a5)         ; destination trigger
                move.b  (a1),d5         ; read Destination data
                btst.b  #00h,(a2)       ;check, ready ?
                bne.b   POSCNotRdy2     ;jump if not ready.

                cmp.b   d6,d5           ;verify data
                bne.b   POSCVriErr
POSCop2:
                subq.l  #01h,d0         ;decrease loop counter
                cmp.l   #-1,d0          ;check, Loop End ?
                bne.b   POSCop1         ;No,jump.

                clr.b   canBuf2+1(a7)   ;clear echo flag. (OK)
                bra.b   _posCopyEd
POSCVriErr:
                move.l  a1,canBuf2+2(a7) ;save verify error address.
                bra.b   _posCopyEd

POSCNotRdy1:
                move.b  #02,canBuf2+1(a7) ; set echo flag, (source Not Ready)
                move.l  a0,canBuf2+2(a7)  ;save Not Ready address of source.
                bra.b   _posCopyEd
POSCNotRdy2:
                move.b  #03,canBuf2+1(a7) ; set echo flag,(destination
                move.l  a1,canBuf2+2(a7)  ; Not Ready), and save address.
                bra.b   _posCopyEd

                org     146ah
_posCopyEd:
                nop
                bra.b   _posCopySt      ; &&end

;-----------------------------------------------------------------------
; Get data information if FillByteMem command verify error
; Tsai,11/03/1994
;-----------------------------------------------------------------------
                org     1700h
_getByteInData:
                andi   #00ffh,d5        ;mask high byte,(expectant data)
                andi   #00ffh,d3        ;mask high byte,(error data)
                move   d5,canBuf2(a7)   ;save expectant data to canBuf2
                move   d3,canBuf2+2(a7) ;save error data to canBuf2+2
                bra.b  _getBIDEND

                org     176ah
_getBIDEND:
                nop
                bra.b   _getByteInData  ; &&end
;-----------------------------------------------------------------------
; Get data information if FillWordMem command verify error
; Tsai,11/03/1994.
;-----------------------------------------------------------------------
                org     1800h
_getWordInData:
                move   d5,canBuf2(a7)   ;save expectant data to canBuf2
                move   d3,canBuf2+2(a7) ;save error data to canBuf2+2
                bra.b  _getWIDEND

                org     186ah
_getWIDEND:
                nop
                bra.b   _getWordInData  ; &&end
;-----------------------------------------------------------------------
;       Restore WRR (Software Watchdog Timer)
;       input argument : WRRdata at 72h location of CAN.   nov.8 1995
;-----------------------------------------------------------------------
barAddr:        equ  0000f2h    ;68302 BAR address
WRRAddr:        equ  084ah      ;Watchdog Reference Register.
WRRdata:        equ  72h
;-------------- Working Buffer -------------------------------
A6BufWrr:       equ  72h+2              ; A6 register buffer.
A0BufWrr:       equ  72h+2+4*1          ; A0 register buffer.
D1BufWrr:       equ  72h+2+4*2          ; D1 register buffer.
SRbufWrr:       equ  6ah-2              ; SR register buffer.
                org     1900h
_restoreWrr:
                move.l  a6,A6BufWrr(a7)         ;save a6,a0,d1,sr
                move.l  a0,A0BufWrr(a7)
                move.l  d1,D1BufWrr(a7)
                move    sr,SRbufWrr(a7)

                movea.l a7,a6                   ;set source trigger = a6
                adda.l  #souTrigOsWr,a6         ;set source trigger point.

                movea.l #barAddr,a0            ;point to BAR register
                clr.l   d1                      ;clear d1
                move.b  d0,(a6)                 ;source trigger.
                move    (a0),d1                 ;read BAR register to d1
;               ...............................................
;               check SD space or UD space.
;            &   Shift bit11..bit0 --> bit23..bit12 for BAR.
;               Note: source trigger = use SD space.
;                     destination trigger = use UD space.
;                If FC[2..0] bit in BAR is not equal to 5 (SD space),
;                Set CFC bit =0 to ingore FC[2..0] comparing.
;               ...............................................
                lsl.l   #3,d1                   ; fc[2..0] --> bit[18..16]
                                                ; CFC      --> bit15
                                                ;
                swap    d1                      ; fc[2..0] --> bit[2..0]
                                                ; CFC      --> bit31

                cmpi.b  #5,d1                   ;check SD ?
                beq.b   RESTRWRRL1
                bclr.l  #31,d1                  ;clear CFC bit.
RESTRWRRL1:
                swap     d1                     ;fc[2..0],CFC --> bit[15..12]
                lsr.l    #3,d1
;               .... write BAR to enable Internal register ....
                move.b  d0,(a6)                 ;source trigger.
                move    d1,(a0)                 ;


                lsl     #4,d1                   ;bit11..bit0-->bit23..bit12
                lsl.l   #8,d1                   ;
                addi.l  #WRRAddr,d1
                movea.l d1,a0                   ;a0 = BAR +84ah = WRR address
                move    WRRdata(a7),d1          ;get WRR data
                ori     #8000h,d1               ;set WRR bit15 to high.
                move.b  d0,(a6)                 ;source trigger.
                move    d1,(a0)                 ;restore WRR
                                                ;restore a6,a0,d1
                movea.l  A6BufWrr(a7),a6
                movea.l  A0BufWrr(a7),a0
                move.l   D1BufWrr(a7),d1
                move     SRbufWrr(a7),sr
                bra.b    _restoreWrrEnd

                org     196ah
_restoreWrrEnd:
                nop
                bra.b   _restoreWrr            ; &&end
;-----------------------------------------------------------------------
;       Get & disable WRR (Software Watchdog Timer)
;       output WRR value at 72h of Can RAM              nov. 8 1995
;-----------------------------------------------------------------------
                org     2000h
_getDisWrr:
                move.l  a6,A6BufWrr(a7)         ;save a6,a0,d1,sr
                move.l  a0,A0BufWrr(a7)
                move.l  d1,D1BufWrr(a7)
                move    sr,SRbufWrr(a7)

                movea.l a7,a6                   ;set source trigger = a6
                adda.l  #souTrigOsWr,a6         ;set source trigger point.

                movea.l #barAddr,a0             ;point to BAR register
                clr.l   d1                      ;clear d1
;               ........ Read back MBAR value .................
                move.b  d0,(a6)                 ;source trigger.
                move    (a0),d1                 ;read MBAR register to d1
;               ...............................................
;               check SD space or UD space.
;            &   Shift bit11..bit0 --> bit23..bit12 for MBAR.
;                If FC[2..0] bit in BAR is not equal to 5 (SD space),
;                Set CFC bit =0 to ingore FC[2..0] comparing.
;               ...............................................
                lsl.l   #3,d1                   ; fc[2..0] --> bit[18..16]
                                                ; CFC      --> bit15
                                                ;
                swap    d1                      ; fc[2..0] --> bit[2..0]
                                                ; CFC      --> bit31

                cmpi.b  #5,d1                   ;check SD ?
                beq.b   GetDisL1
                bclr.l  #31,d1                  ;clear CFC bit.
GetDisL1:
               swap     d1                      ;fc[2..0],CFC --> bit[15..12]
               lsr.l    #3,d1
;               .... write BAR to enable Internal register ....
                move.b  d0,(a6)                 ;source trigger.
                move    d1,(a0)                 ;

                lsl     #4,d1                   ;bit11..bit0-->bit23..bit12
                lsl.l   #8,d1                   ;
                addi.l  #WRRAddr,d1             ; compute WRR's address
                movea.l d1,a0                   ;a0 = BAR +84ah = WRR address
;               ......... Read WRR data from 68302 .....
                move.b  d0,(a6)                 ;trigger.
                move    (a0),d1                 ;
;               ......... write to WRRdata buffef ..........
                move    d1,WRRdata(a7)          ; save WRR value to CAN buffer
;               .......... disable (write back) WRR .........
                bclr.l  #00,d1                  ;disable Software watchdog
                move.b  d0,(a6)                 ; trigger.
                move    d1,(a0)
                                                ;restore a6,a0,d1,sr
                movea.l  A6BufWrr(a7),a6
                movea.l  A0BufWrr(a7),a0
                move.l   D1BufWrr(a7),d1
                move     SRbufWrr(a7),sr
                bra.b   _getDisWrrEnd

                org     206ah
_getDisWrrEnd:
                nop
                bra.b   _getDisWrr              ;  &&end
;-----------------------------------------------------------------------
;               Read   68302 internal Registers
;-----------------------------------------------------------------------
;----------- input argument ----------------
addr_AIR:       equ     72h
data_AIR:       equ     72h+4*1
length_AIR:     equ     72h+4*2
;rw_AIR:         equ     72h+4*2+1
;------------ working buffer ----------------
A6Buf_AIR:      equ     6ah-4*1
A0Buf_AIR:      equ     6ah-4*2
D1Buf_AIR:      equ     6ah-4*3
SR_AIR:         equ     6ah-4*4

BYTE_AIR:       equ     1
WORD_AIR:       equ     2
;LONG_AIR:       equ     4

                org     2100h
_readIntReg:
                move.l  a6,A6Buf_AIR            ;save working registers.
                move.l  a0,A0Buf_AIR
                move.l  d1,D1Buf_AIR
                move    sr,SR_AIR

                movea.l a7,a6                   ;a6 is a trigger reg.
                adda.l  #souTrigOsWr,a6         ; and default size word
                movea.l  addr_AIR(a7),a0

                clr.l   d1                      ;clear data
                cmp.b   #BYTE_AIR,length_AIR(a7)
                bne.b   READINT1
                subq.l  #wordTrigOff,a6         ;set a6 is as byte trigger.
                move.b  d0,(a6)                 ;trigger
                move.b  (a0),d1                 ;read byte
                bra.b   READINTend
READINT1:
                move.b  d0,(a6)                 ;trigger
                move    (a0),d1                 ;read word0

                cmp.b   #WORD_AIR,length_AIR(a7)
                beq.b   READINTend
                swap    d1
                addq.l  #2,a0                   ;Jan. 10, 1996, tsai
                                                ;adjust target/emm addr.
                move.b  d0,(a6)                 ;trigger
                move    (a0),d1                 ;read word1
READINTend:
                move.l  d1,data_AIR(a7)         ;save data to can buffer.

                move.l  A6Buf_AIR,a6            ;restore working registers
                move.l  A0Buf_AIR,a0
                move.l  D1Buf_AIR,d1
                move    SR_AIR,sr
                bra.b   _readIntRegEnd           ;let EP stop.

                org     216ah
_readIntRegEnd:
                nop
                bra.b   _readIntReg              ; &&end

;-----------------------------------------------------------------------
;               Write  68302 internal Registers
;-----------------------------------------------------------------------
                org     2200h
_writeIntReg:
                move.l  a6,A6Buf_AIR            ;save working registers.
                move.l  a0,A0Buf_AIR
                move.l  d1,D1Buf_AIR
                move    sr,SR_AIR

                movea.l a7,a6                   ;a6 is a trigger reg.
                adda.l  #souTrigOsWr,a6         ; and default is size word.
                movea.l  addr_AIR(a7),a0        ;a0 : address
                move.l  data_AIR(a7),d1         ;d1 : data

                cmp.b   #BYTE_AIR,length_AIR(a7)
                bne.b   WRINT1
                subq.l  #wordTrigOff,a6         ;set a6 is as byte trigger.
                move.b  d0,(a6)                 ;trigger (source)
                move.b  d1,(a0)                 ; write byte
                bra.b   WRINTend
WRINT1:
                cmp.b   #WORD_AIR,length_AIR(a7) ;check, length = long ?
                beq.b   WRINT2                  ;yes, jump.
                addq.l  #2,a0                   ;Jan. 10, 1996, tsai
                move.b  d0,(a6)                 ;trigger (source)
                move    d1,(a0)                 ; write  (low word)
                swap    d1
                subq.l  #2,a0                   ;Jan. 10, 1996, tsai
WRINT2:
                move.b  d0,(a6)                 ;trigger (source)
                move    d1,(a0)                 ; write  (high word)
WRINTend:
                move.l  A6Buf_AIR,a6            ;restore working registers
                move.l  A0Buf_AIR,a0
                move.l  D1Buf_AIR,d1
                move    SR_AIR,sr
                bra.b   _writeIntRegEnd

                org     226ah
_writeIntRegEnd:
                nop
                bra.b   _writeIntReg            ; &&end
;-----------------------------------------------------------------------
;               Ignore Fc[0..2] of CS comparing and Get
;               the CFC bits of OR[0..3] registers.
;-----------------------------------------------------------------------
OR3add_IGF:     equ     72h
CFCbuf_IGF:     equ     72h+4h
;----------working register buffer---------------
A0buf_IGF:      equ     6ah-4
A6buf_IGF:      equ     6ah-4*2
D1buf_IGF:      equ     6ah-4*2-2
D2buf_IGF:      equ     6ah-4*2-2*2
SRbuf_IGF:      equ     6ah-4*2-2*3

                org     2300h
_ignoreFc:
                move.l  a6,A6buf_IGF            ;save working registers
                move.l  a0,A0buf_IGF
                move    d1,D1buf_IGF
                move    d2,D2buf_IGF
                move    sr,SRbuf_IGF
                movea.l a7,a6                   ; set a6 is as trigger pointer
                adda.l  #souTrigOsWr,a6         ; and is a size word trigger.
                clr.b   CFCbuf_IGF(a7)          ; clear CFC buffer (defualt)
                movea.l OR3add_IGF(a7),a0       ; Get OR3 address.
                move    #3,d1                   ; length = 4 of counter
IGNFC0:
                move.b  d0,(a6)                 ;read OR[3..0] register
                move    (a0),d2

                bclr.l  #00,d2                  ;check CFC bit and clear it.
                beq.b   IGNFC1
                bset.b  d1,CFCbuf_IGF(a7)       ;if CFC=1, set the value=1 in
                                                ;   CFCbuf_IGF.
IGNFC1:
                move.b  d0,(a6)                 ;write back OR[3..0] register
                move    d2,(a0)

                subq.l  #4,a0                   ;next OR register address.
                dbf     d1,IGNFC0               ;check loop end ?

                move.l  A6buf_IGF,a6            ;restore working registers
                move.l  A0buf_IGF,a0
                move    D1buf_IGF,d1
                move    D2buf_IGF,d2
                move    SRbuf_IGF,sr
                bra.b  _ignoreFcEnd

                org     236ah
_ignoreFcEnd:
                nop
                bra.b   _ignoreFc               ; &&end

;-----------------------------------------------------------------------
;               restore CFC value of CS register
;
;-----------------------------------------------------------------------
                org     2400h
_restoreFc:
                move.l  a6,A6buf_IGF            ;save working registers
                move.l  a0,A0buf_IGF
                move    d1,D1buf_IGF
                move    d2,D2buf_IGF
                move    sr,SRbuf_IGF
                movea.l a7,a6                   ; set a6 is as trigger pointer
                adda.l  #souTrigOsWr,a6         ; and is a size word trigger.
                movea.l OR3add_IGF(a7),a0       ; Get OR3 address.
                move    #3,d1                   ; length = 4 of counter
RESTOREFC0:
                move.b  d0,(a6)                 ;read OR[3..0] register
                move    (a0),d2

                btst.b  d1,CFCbuf_IGF(a7)
                beq.b   RESTOREFC1
                bset.l  #00,d2                  ;set CFC=1
RESTOREFC1:
                move.b  d0,(a6)                 ;write back OR[3..0] register
                move    d2,(a0)

                subq.l  #4,a0                   ;next OR register address.
                dbf     d1,RESTOREFC0           ; check loop end ?

                move.l  A6buf_IGF,a6            ;restore working registers
                move.l  A0buf_IGF,a0
                move    D1buf_IGF,d1
                move    D2buf_IGF,d2
                move    SRbuf_IGF,sr
                bra.b   _restoreFcEnd

                org     246ah
_restoreFcEnd:
                nop
                bra.b   _restoreFc              ; &&end
;-----------------------------------------------------------------------
               .end
