;-----------------------------------------------------------------------
; test target/emm with size byte (fill test pattern only)
_canEndTrig:    equ  10380h
_spBuf:         equ  1006ah-4*1
_baseAdd:       equ  1006ah-4*2
canBuf1:        equ  06Ah
canBuf2:        equ  070h
souTrigOs:      equ  0180h
desTrigOs:      equ  0280h
                org     0400h
_tstByte1St:
                move.l  d0,d2           ;get byte length (d2:working length)
                movea.l a0,a2           ;get start address(a2:working add)
tstByte1:
                move    a2,d4           ;compute test pattern
                move    a2,d5
                lsr     #08h,d4
                eor.b   d4,d5           ;high byte/low XOR.
                move.b  d0,(a6)         ;trigger with source FC[0..2]
                move.b  d5,(a2)+        ;write test pattern to Target/emm
                cmp.b   #01h,canBuf2(a7) ;check ready ?
                beq.b   _tstNotRdy1
                sub.l   #01h,d2         ;DEC length.
                cmp.l   #-01h,d2        ;check end of loop ?
                bne.b   tstByte1
                bra.b   _tstByte1Ed
_tstNotRdy1:
                subq.l  #01h,a2
                move.l  a2,canBuf2+2(a7)   ;save [not ready] address
                bra.b   _tstByte1Ed

                org     046ah
_tstByte1Ed:
                nop
                bra.b   _tstByte1St     ; &&end

;-----------------------------------------------------------------------
;  test target/emm with size byte (verify test pattern)
;
                org     0500h
_tstByte2St:
                move    a0,d4
                move    a0,d5
                lsr     #08h,d4
                eor.b   d4,d5           ;high byte/low XOR.
                move.b  d0,(a6)         ;trigger with source FC[0..2]
                cmp.b   (a0),d5         ;compare Target/emm data with test patt
                bne.b   tstByteErr
                cmp.b   #01h,canBuf2(a7) ;check ready ?
                beq.b   tstByteErr
                not.b   d5

                move.b  d0,(a6)         ;trigger with source FC[0..2]
                move.b  d5,(a0)         ;write Complement pattern
                cmp.b   #01h,canBuf2(a7) ;check ready ?
                beq.b   tstByteErr

                move.b  d0,(a6)         ;trigger with source FC[0..2]
                cmp.b   (a0)+,d5        ;compare Target/emm data with test 
                bne.b   tstByteErr2
                cmp.b   #01h,canBuf2(a7) ;check ready ?
                beq.b   tstByteErr2
                sub.l   #01h,d0         ;DEC length.
                cmp.l   #-01h,d0        ;check end of loop ?
                bne.b   _tstByte2St
                clr.b   canBuf2+1(a7)   ;clear error flage (Pass)
                bra.b   _tstByte2Ed

tstByteErr2:
                subq.l  #01h,a0         ;adjust Error/notRdy address
tstByteErr:  
                move.l  a0,canBuf2+2(a7)   ;save [Error]/[not ready] address
                bra.b   _tstByte2Ed

                org     056ah
_tstByte2Ed:        
                nop
                bra.b   _tstByte2St      ; &&end
;-----------------------------------------------------------------------
