/***************************************************************************
**
** File name : abidef.h
**
**      Description: definitions of variables and constants
**
**
** Changing :
**
** A. Date -- 10/29/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**     3. Created from define.c and other .h files.
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#define _ABI_DEF_

#ifndef _BASE_TYPE_
#include "basetype.h"
#endif

#ifndef __STRING_H
#include <string.h>
#endif

#ifndef  _ADDR_
#include "addr.h"
#endif

#define test_bit(msk,num)        (msk & (1L<<(num)))

/*****************************************************************/
/* Define status codes                                           */
/*****************************************************************/
#define FLAG_I          0x01    /* break on instruction fetch */
#define FLAG_R          0x02    /* break on read */
#define FLAG_W          0x04    /* break on write */

#define MAP_END_RECORD      0xaa55
#define BUFF_LEN               512
#define MAX_COMM_BUFF         1534
#define streamMaxLen           100  /* Maximum Stream Length */


typedef S16            STATUS;
#define ACK            0x6
#define NACK           0x15
#define ESC            0x1b


typedef struct{
   U32 pos;
   U16 space;
}ADDR;

typedef enum {
   NORMAL_RUN = 0,FREE_RUN,FLY_RUN,MONITOR_RUN,TEST_RUN
}RUN_MODE;

/*
typedef enum {
   I80C188XL = 1, I80C188EA, I80C188EB, I80C188EC,
   I80C186XL,     I80C186EA, I80C186EB, I80C186EC,
   I80166, I80167, I80195, I80196, I80197, M68000, M68302, M68306
}CPU_MODULE;
*/

typedef enum {
   END_TEST, MCE16A, EMM1, EMM2, EMM3, EMM4, COV_RBW_MEMORY, TRACE_BOARD, START_TEST
}FUNCTION_TEST_CMD;

typedef struct{
   U16 portAddr,
       idFlag,
       buffSize,
       testResult;
   U8  testFlag,
       timeOut,
       fileName[80];
}INITIAL_INFO;

typedef enum {
   FIRMWARE_TYPE,
   FIRMWARE_VER,
   CPU_MODEL,
   CPU_VER,
   TRACE_EXIST,
   INIT_HW_STATUS,
   RESERVE2,
   MAX_ID
}ID_INFO;

/* define the command ID od the Michelle firmware function */
typedef enum {
   COMMAND_START,          /* 0  -- 0x0  */
   GET_ID,                 /* 1  -- 0x1  */ // special command, must place 1st.
   CHECKSUM,               /* 2  -- 0x2  */
   CLR_EVENT,              /* 3  -- 0x3  */
   CLR_TRIG,               /* 4  -- 0x4  */
   COMPARE,                /* 5  -- 0x5  */
   COPY,                   /* 6  -- 0x6  */
   FUNCTION_TEST,          /* 7  -- 0x7  */
   ESC_COMMAND,            /* 8  -- 0x8  */
   FILL_COMMAND,           /* 9  -- 0x9  */
   GET_ALL_CO_REG,         /* 10 -- 0xa  */
   GET_ALL_INTERNAL_REG,   /* 11 -- 0xb  */
   GET_ALL_REG,            /* 12 -- 0xc  */
   GET_CO_COVERAGE,        /* 13 -- 0xd  */
   GET_CO_REG,             /* 14 -- 0xe  */
   GET_CONTROL,            /* 15 -- 0xf  */
   GET_DEPTH,              /* 16 -- 0x10 */ // new add
   GET_EVENT,              /* 17 -- 0x11 */ // new add
   GET_MAP,                /* 18 -- 0x12 */
   GET_MAP_SIZE,           /* 19 -- 0x13 */
   GET_MODE,               /* 20 -- 0x14 */
   GET_READY,              /* 21 -- 0x15 */
   GET_REG,                /* 22 -- 0x16 */
   GET_SIZE,               /* 23 -- 0x17 */
   GET_STAT,               /* 24 -- 0x18 */
   GET_SYNC,               /* 25 -- 0x19 */
   GET_VERIFY,             /* 26 -- 0x1a */
   GET_WAIT,               /* 27 -- 0x1b */
   GO_COMMAND,             /* 28 -- 0x1c */
   HALT,                   /* 29 -- 0x1d */
   INPUT,                  /* 30 -- 0x1e */
   LIST_TRACE,             /* 31 -- 0x1f */
   OUTPUT,                 /* 32 -- 0x20 */
   READ_MEM_N,             /* 33 -- 0x21 */
   RESET,                  /* 34 -- 0x22 */
   SEARCH,                 /* 35 -- 0x23 */
   SET_TRACE_BUFF,         /* 36 -- 0x24 */
   SET_CONTROL,            /* 37 -- 0x25 */
   SET_CO_COVERAGE,        /* 38 -- 0x26 */
   SET_CO_REG,             /* 39 -- 0x27 */
   SET_EVENT,              /* 40 -- 0x28 */
   SET_EX_BKPT,            /* 41 -- 0x29 */
   SET_ID,                 /* 42 -- 0x2a */
   SET_MEM_N,              /* 43 -- 0x2b */
   SET_MAP,                /* 44 -- 0x2c */
   SET_MODE,               /* 45 -- 0x2d */
   SET_REG,                /* 46 -- 0x2e */
   SET_READY,              /* 47 -- 0x2f */
   SET_SIZE,               /* 48 -- 0x20 */
   SET_SYNC,               /* 49 -- 0x31 */
   SET_TRACE_BREAK,        /* 50 -- 0x32 */ // new add
   SET_TRIG,               /* 51 -- 0x33 */
   SET_TIMER_COUNTER,      /* 52 -- 0x34 */
   SET_VERIFY,             /* 53 -- 0x35 */
   SET_WAIT,               /* 54 -- 0x36 */
   STEP,                   /* 55 -- 0x37 */
   STEP_ONE,               /* 56 -- 0x38 */
   TEST,                   /* 57 -- 0x39 */
   SET_EXT_EVENT,          /* 58 -- 0x3a */
   SET_ALL_EVENT,          /* 59 -- 0x3b */
   SET_TIMER_REG,          /* 60 -- 0x3c */
   GET_CPU_STATUS,         /* 61 -- 0x3d */
   ABORT,                  /* 62 -- 0x3e */
   GET_TRIG,               /* 63 -- 0x3f */
   GET_LAST_BUFF,          /* 64 -- 0x40 */
   DIAGNOSTIC,             /* 65 -- 0x41 */
   ENABLE_SW_BKPT,         /* 66 -- 0x42 */
   DISABLE_SW_BKPT,        /* 67 -- 0x43 */
   SET_BKPT_CODE,          /* 68 -- 0x44 */
   SET_INT_REG,            /* 69 -- 0x45 */
   GET_INT_REG,            /* 70 -- 0x46 */
   SET_QUAL_TRACE,         /* 71 -- 0x47 */
   DISABLE_QUAL,           /* 72 -- 0x48 */
   CORE_TYPE,              /* 73 -- 0x49 */
   SET_CANBASE,              /* 74 -- 0x4A */
   MAX_COMMAND          /* All new command must add before this command. */
} COMMAND_ID;

/* define the command ID od the Michelle firmware function */
typedef enum {
   DIAG_START,             /* 0  -- 0x0  */
   D_GET_ID,               /* 1  -- 0x1  */ // special command, must place 1st.
   INITIAL_TEST,           /* 2  -- 0x2  */
   MCE_OPEN_SHORT_TEST,    /* 3  -- 0x3  */
   MCE_PULL_HIGH_TEST,     /* 4  -- 0x4  */
   MCE_MAP_TEST,           /* 5  -- 0x5  */
   MCE_MEMORY_TEST,        /* 6  -- 0x6  */
   PROGRAM_XLX,            /* 7  -- 0x7  */
   EREC1_SHORT_TEST,       /* 8  -- 0x8  */
   EREC2_SHORT_TEST,       /* 9  -- 0x9  */
   TMAN_SHORT_TEST,        /* 10 -- 0xa  */
   VRAM_SAM_TEST,          /* 11 -- 0xb  */
   T74AS575_BUS_TEST,      /* 12 -- 0xc  */
   EXTERNAL_BUS_TEST,      /* 13 -- 0xd  */
   SEQ_RAM_TEST,           /* 14 -- 0xe  */
   VRAM_DRAM0_TEST,        /* 15 -- 0xf  */
   VRAM_DRAM1_TEST,        /* 16 -- 0x10 */
   VRAM_DRAM2_TEST,        /* 17 -- 0x11 */
   VRAM_DRAM3_TEST,        /* 18 -- 0x12 */
   VRAM_DRAM4_TEST,        /* 19 -- 0x13 */
   VRAM_DRAM5_TEST,        /* 20 -- 0x14 */
   VRAM_DRAM6_TEST,        /* 21 -- 0x15 */
   VRAM_DRAM7_TEST,        /* 22 -- 0x16 */
   VRAM_DRAM8_TEST,        /* 23 -- 0x17 */
   VRAM_DRAM9_TEST,        /* 24 -- 0x18 */
   VRAM_DRAMA_TEST,        /* 25 -- 0x19 */
   VRAM_DRAMB_TEST,        /* 26 -- 0x1a */
   VRAM_DRAMC_TEST,        /* 27 -- 0x1b */
   VRAM_DRAMD_TEST,        /* 28 -- 0x1c */
   VRAM_DRAME_TEST,        /* 29 -- 0x1d */
   VRAM_DRAMF_TEST,        /* 30 -- 0x1e */
   MCE_CONNECT_TEST,       /* 31 -- 0x1f */
   REPEAT_DIAG,            /* 32 -- 0x20 */
   END_DIAG,               /* All new command must add before this command. */
} DIAG_ID;

typedef enum {
   MCE_8255_FAIL        = 0x01,
   DOWNLOAD_4003_FAIL   = 0x02,
   DATA_MEMORY_FAIL     = 0x04,
   MTAT_EXIST           = 0x10,
   TMAN_EXIST           = 0x20,
   EREC1_EXIST          = 0x40,
   EREC2_EXIST          = 0x80
} DIAG_INIT_MSG;

typedef enum {
   S_BYTE = 0, /* bit 0 */
   S_WORD = 1, /* bit 1 */
   S_LONG = 2  /* bit 2 */
} ABI_SIZE;

#define TIMER_BUFFER       5
/*****************************************************************************/
/* Return codes     */
/*****************************************************************************/

#define ICE_DIFF_FOUND                0    /* difference data found at comparison */
#define ICE_MATCH                     0    /* Search match */
#define ICE_OK                        0    /* Normal return */
#define ICE_MICE_HALT              ( -1)   /* Target CPU halted */
#define ICE_MEM_GUARD              ( -2)   /* Access the guarded memory */
#define ICE_MEM_PROTECT            ( -3)   /* Access the protected memory */
#define ICE_ERROR_READ             ( -4)   /* Memory read failure */
#define ICE_ERROR_WRITE            ( -5)   /* Memory write failure */
#define ICE_STEP_ERROR             ( -6)   /* Target cnnot step */
#define ICE_NO_DIFF                ( -7)   /* No difference in memory compare */
#define ICE_NO_FOUND               ( -8)   /* Not found in memory search */
#define ICE_BREAK                  ( -9)   /* Break on memory access */
#define ICE_BREAK_I                (-10)   /* Break on instruction fetch */
#define ICE_BAD_REG                (-11)   /* Bad register number encountered */
#define ICE_BAD_IN                 (-12)   /* Error encountered on user input */
#define ICE_HALT_USER              (-13)   /* user pressed ^C */
#define ICE_ERROR_COM              (-14)   /* communication error */
#define ICE_ERROR_MICE             (-15)   /* linking incorrect MICE model */
#define ICE_MICE_LIMIT             (-16)   /* MICE limitation */
#define ICE_BUS_REQUEST            (-17)   /* Bus request */
#define ICE_BAD_FRAME              (-18)   /* invalid frame number */
#define ICE_ERROR_BOUN             (-19)   /* error map boundary */
#define ICE_MAP_FAIL               (-20)   /* memory map fail */
#define ICE_ABS_OVERFLOW           (-21)   /* abs address overflow */
#define ICE_TEST_FAIL              (-22)   /* test failure */
#define ICE_CPU_RUN                (-23)   /* CPU free running */
#define ICE_BROKE                  (-24)   /* CPU stop */
#define ICE_NOT_READY              (-25)   /* target is not ready */
#define ICE_COMMAND_ERROR          (-26)   /*  */
#define ICE_TIME_OUT               (-27)   /*  */
#define ICE_NO_TRACE_MODULE        (-28)   /*  */
#define ICE_BKPT1_HALT             (-29)   /*  */
#define ICE_BKPT2_HALT             (-30)   /*  */
#define ICE_VIOL_HALT              (-31)   /*  */
#define ICE_RBW_HALT               (-32)   /*  */
#define ICE_TRIG_HALT              (-33)   /*  */
#define ICE_LINK_MICE_FAIL         (-34)   /*  */
#define ICE_WARN_START             (-35)   /*  */
#define ICE_BANK_FULL              (-36)
#define ICE_ADDR_RANGE_OVERFLOW    (-37)
#define ICE_ATTRIBUTE_MISMATCH     (-38)
#define ICE_BANK_MISMATCH          (-39)
#define ICE_SPACE_MISMATCH         (-40)
#define ICE_ADDR_MISMATCH          (-41)
#define ICE_NO_VCC                 (-42) /* No target VCC */
#define ICE_USER_CC                (-43)
#define ICE_TARGET_RESET           (-44)
#define ICE_NO_EMM                 (-45)
#define ICE_CNT_ERROR              (-46)
#define ICE_TIMER_ERROR            (-47)
#define ICE_EVENT_FULL             (-48)
#define ICE_BUFFER_EMPTY           (-49)
#define ICE_EMM_SET_ERROR          (-50)
#define ICE_EP_PENDING             (-51)
#define ICE_REC_TIME_OUT           (-52)
#define ICE_INVALID_CPU            (-53) // only usd at sw.
#define ICE_MCE16A_FAIL            (-54)
#define ICE_EMM_FAIL               (-55)
#define ICE_TRACE_BOARD_FAIL       (-56)
#define ICE_COV_RBW_FAIL           (-57)
#define ICE_CPU_FLY                (-58)
#define ICE_INVALID_FLY_COMMAND    (-59)
#define ICE_INVALID_FIRMWARE       (-60) // only used at sw.
#define ICE_SW_BKPT_HIT            (-61)
#define ICE_FILE_NOT_FOUND         (-62) // only used at sw.

typedef enum{
   TRACE_HARDWARE_ERROR  = 0x01,
   MCE16A_HARDWARE_ERROR = 0x02,
   NO_TARGET_VCC         = 0x04,
   EMM_CONTROL_RAM_ERROR = 0x08,
   DOWNLOAD4003_FAILURE  = 0x10
}HW_ERROR_NO;


#define NUM_REGS 20

#define maskBit 1

#define mapNo   33
#define BASE_TIME                0xFF  // communication time out
#define M128K                    0x20000L

typedef struct {
   U32 addr;
   U8  stat;
   U16 data;
   U8  tstamp,
       tbit;
}MP_TRACE_DATA;

typedef struct{
   U32 addr;
   U16 space;
   U16 actual;
   U32 addr_dummy;
   U16 space_dummy;
   U16 expected;
}RET_ADDR;

typedef struct {
   U32 addr1;
   U32 addr2;
   U16 attr;
}MAP_INFO;

typedef struct{
   U16 defined; /* 1=trigger is defined, 0=not defined */
   U16 evNo[11]; /* 1 ~ 3 for MICE-III, 1 ~ 5 for MICE-IIIS */
        /* 1~11 for Michelle, 1~8 is ev#, 9 ic cnt0, 10 is cnt1, 11 is external */
        /* if the most significant bit is 1, NOT is prefixed the event */
        /* 0=end of event_sequence */
   U16 op[5]; /* 1=OR, 2=AND, 3=THEN, 0=end of sequence */
        /* this field is not used in Michelle */
   U16 arm[7]; /* arm other triggers, 0=end of arms. it is for MICE-IIIS only */
   U16 act[11]; /* action in Michelle can be multi-defined */
        /* the bit position for relative action are as below: */
        /* bit-0=BREAK< bit-1=RESET, bit-2=SEQ, bit-3=TROFF, bit-4=NEXT */
        /* bit-5=INC0, bit-6=RST0, bit-7=INC1, bit-8=RST1, bit-9=EXT */
        /* bit-10=TRON, bit-11=TMON, bit-12=TMOFF */
   U16 mode; /* 0=backward, 1=forward, 2=center, 3=delay */
   U16 delay; /* delay count */
}MP_TRIGGER;

// typedef struct {
//     int defined; /* 1=event is defined, 0=not defined */
//     int addrSpec; /* */
//     U32 addrLo;
//     U32 addrHi;
//     int dataSpec;
//     U32 dataLo;
//     U32 dataHi;
//     U32 stat;
//     U16 count;
// }BUS_EVENT;

typedef enum { UNDEFINE_ADDR, SINGLE_ADDR, RANGE_ADDR, MASK_ADDR } ADDR_SPEC;
typedef enum { UNDEFINE_DATA = 0, SINGLE_DATA = 1, MASK_DATA = 3 } DATA_SPEC;

typedef U32 EP_ADDR;
typedef U32 EP_DATA;
typedef U16 EP_SPARE;

typedef struct {
   U16 statusFc;           // bit  0  1  2  3  4  5  6
                           //     sp,up,sr,sw,ur,uw,ak  0 = Don't care
   U8 statusDsLow,         // LowByte = 2, HighByte = 1, Word = 0.
      statusDsHigh;        // 0 = Don't care, 0xff : set one.
   U16 statusCsLow,        // bit    8    7   6   5   4   3   2   1   0
       statusCsHigh;       //     DRAM  CS7 CS6 CS5 CS4 CS3 CS2 CS1 CS0
                           // 0 = Don't care , 0xffff select one
}EP_STATUS;

typedef struct {
   U32 status2Low,
       status2High;
}EP_STATUS2;

typedef struct {
   U16 enable;
   ADDR_SPEC addrSpec;
   EP_ADDR addrLow;
   EP_ADDR addrHigh;
   EP_SPARE spareLow,     // 8 bit spare, High byte is not used.
            spareHigh;    // 0: don't care  1: set.
   DATA_SPEC dataSpec;
   EP_DATA dataLow;
   EP_DATA dataHigh;
   U16 statusFlag;
   EP_STATUS status;
   EP_STATUS2 status2;
}BUS_EVENT;

typedef struct{
    int defined; /* 1=event is defined, 0=not defined */
    U32 addr;
}EXEC_EVENT;

typedef struct {
    long startFrame;
    long endFrame;
}BUFFER_DEPTH;

typedef enum {
   MP_QUALIFY_OFF, MP_QUALIFY_ON
   } MP_QUALIFY;

typedef struct {
   MP_QUALIFY  qFlag;
   U32     startAddr,
           endAddr;
   U16     status;
   U16     traceBitData,
           traceBitWild;
}QUALIFY_LIST;

typedef struct {
   U32 frameNo;
   U32 addr;
   U16 stat;
   U16 data;
   U16 data2;
   U8  tstamp;
   U8  spare;
   U32 misc;
} MP_TRACE_INFO;

typedef struct {
   STATUS WorkingError;
   U8 EpAddress[4];
   U8 EpData[4];
   U8 EpStatus[2];
}ERROR_MCE_WORK_TEST;

typedef struct {
   STATUS ConnectorError;
   ERROR_MCE_WORK_TEST Working[96];
}ERROR_MCE_CONN_TEST;

typedef  struct {
   ADDR_SPACE space;
   U32   offset;
   U32   actual;
   U32   expected;
   }  BAD_MEMORY;

typedef  enum {
   A_LINE = 0xa0,
   F_LINE = 0xf0
   } BKPT_OP_68K;

#ifndef  _MP_CPU_TYPE_
typedef enum {CPU16,CPU32,NA1,NA2,CPU306,CPU302,CPU307,CPU328} CPU_TYPE;
#define  _MP_CPU_TYPE_
#endif
/**************************** End of File **********************************/
