/****************************************************************************
**
**  Name:  dq306.c
**
**  Description:
**     This is a dequeuer for Motorola 68306
**
**
**  Status:
**
**
**  $Header:
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _DAD_SERVER_
#include "dasm.h"
#endif

#ifndef _DAD_DEFINE_
#include "daddef.h"
#endif

#ifndef _DQ306_
#include "dq306.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

//#ifndef _STRING_
//#include "strlib.h"
//#endif

#ifndef _SSHARED_
#include "sshared.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _SDNUM_
#include "sdnum.h"
#endif


#ifndef _TRACE_
#include "trace.h"
#endif

#ifndef __STDIO_H
#include <stdio.h>
#endif

#include "string.h"

                        /****************************
                         *                          *
                         *     DEFINITIONS          *
                         *                          *
                         ****************************/
#define FRAME_LEN      0x40 // Read 64 frames data each times.
                        /****************************
                         *                          *
                         *     EXTERNALS            *
                         *                          *
                         ****************************/

extern HANDLE cliServerHandle;

                        /****************************
                         *                          *
                         *     LOCAL VARIABLES      *
                         *                          *
                         ****************************/
U8 *spaceString[] = {"","UW",  "",  "",  "","SW",  "","AK",
                     "","UR",  "","UP",  "","SR","SP",  ""};

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

/////////////////////// Temporal function of trace //////////////////////////
VOID OutputStringToFile(LPSTR buffer,U16 textLen){
FILE *fStream;
U16 count;

   fStream = fopen("dqstring.log","w");
   count = fwrite(buffer, textLen, 1, fStream);
   fclose(fStream);
}

                        /****************************
                         *                          *
                         *     EXECUTABLE           *
                         *                          *
                         ****************************/


/****************************************************************************
**
** Name:  AdddqStateTable
**
****************************************************************************/
RETCODE AddDqStateTable(DESCRIPTOR dqStateId,S32 startReadFrame) {
DQ_STATE *dqState;
S32 curFrame;
U32 lp,numGotten;
U16 index;
RETCODE err;
LPSTR tempBuf;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   curFrame = startReadFrame-dqState->frameStart;
   //TrcReadFrameSet(dqState->traceId,(curFrame/MAX_FRAME_READ)*MAX_FRAME_READ+startFrameNo);
   TrcReadFrameSet(dqState->traceId,startReadFrame);
   index = curFrame / MAX_FRAME_READ;

   if ((err = TrcTraceReadRaw(dqState->traceId,64L,&numGotten,
             &tempBuf)) != GOOD) return(err);
   for (lp = 0; lp < numGotten; lp++) {
      memcpy(&(dqState->frameArray[index*MAX_FRAME_READ+lp]),
             (tempBuf+lp*TRACE_FRAME_WIDTH),TRACE_FRAME_WIDTH);
   }
   TrcReadFrameSet(dqState->traceId,startReadFrame);
   TFree(tempBuf);
   dqState->frameMap[index] = ON;

//   if (err = TempSdnReadPartialMember(
//  READ_FRAMES_DATA,
//   0,
//   64*sizeof(TRC_FRAME),
//   (U8 FAR *)&dqState->frameArray[index*MAX_FRAME_READ]) != GOOD) return(err);
//   dqState->frameMap[index] = ON;
   return(GOOD);
}

/****************************************************************************
**
** Name:  CreatedqStateTable // Create Dis-continue Table
**
****************************************************************************/
RETCODE CreateDqStateTable (DESCRIPTOR dqStateId) {
DQ_STATE  *dqState;
S32 curFrame, oldest, youngest, trigger;
U16 lp, tempBuffId;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   for (lp = 0; lp < MAX_FRAME_MAP_NO; lp++)
      dqState->frameMap[lp] = 0;
   TrcReadBufferGet(dqState->traceId,(U16 FAR *)&tempBuffId); // read current buffer ID
   dqState->traceBufId = tempBuffId; // read current buffer ID
   TrcTraceBufferInfoGet(dqState->traceId,&oldest,&youngest,&trigger);
   TrcReadFrameGet(dqState->traceId,&curFrame);
   dqState->frameStart = oldest - ((curFrame - oldest) / MAX_FRAME_NO) * MAX_FRAME_NO;
   AddDqStateTable(dqStateId,curFrame);

   return(GOOD);
}

/****************************************************************************
**
** Name:  DestroydqStateTable // Create
**
****************************************************************************/
RETCODE DestroyDqStateTable(DESCRIPTOR id) {
DQ_STATE *dqState;
RETCODE err;

   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   if ((err = TFree((LPSTR)dqState)) != GOOD)
      return err;
   return(GOOD);
}

/****************************************************************************
**
** Name:  ReCreatedqStateTable // Create Dis-continue Table
**
****************************************************************************/
RETCODE ReCreateDqStateTable (DESCRIPTOR dqStateId,S32 curFrame) {
DQ_STATE  *dqState;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   AddDqStateTable(dqStateId,curFrame);
   return(GOOD);
}


/****************************************************************************
**
** Name:  CheckSpaceType
**
****************************************************************************/
RETCODE CheckSpaceType(SPACE_TYPE spaceType, U16 fcPin) {
   switch (spaceType) {
      case S_PROGRAM :
         if ((fcPin == F_SP) | (fcPin == F_UP)) return(GOOD);
         break;
      case S_DATA :
         if ((fcPin == F_UD) | (fcPin == F_SD) | (fcPin == F_CPU))
            return(GOOD);
         break;
      case S_DONT_CARE :
         return(GOOD);
      default :
         return(!GOOD);
   }
   return(!GOOD);
}
/****************************************************************************
**
** Name:  SkipTraceFrame
**
****************************************************************************/
RETCODE SkipTraceFrame
        (DESCRIPTOR dqStateId,
         S8 dataLen,
         S32 startSkipFrame,
         SPACE_TYPE spaceType){
DQ_STATE FAR *dqState;
S32 curOffset;
U8 count = 0;
U16 traceBuf;
S32 oldest, newest, trig;
RETCODE err;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadBufferGet(dqState->traceId,&traceBuf);
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);

//   if ((traceBuf != dqState->traceBufId) ||  // different buffer ID.
//       ((startSkipFrame/MAX_FRAME_NO) != (dqState->frameStart/MAX_FRAME_NO))) // Over 2K buffer.
     if ((startSkipFrame/MAX_FRAME_NO) != (dqState->frameStart/MAX_FRAME_NO)) // Over 2K buffer.
      ReCreateDqStateTable(dqStateId,startSkipFrame);
   curOffset = (startSkipFrame  - dqState->frameStart) % MAX_FRAME_NO;
   if (!dqState->frameMap[(U16)(curOffset/MAX_FRAME_READ)])
      AddDqStateTable(dqStateId,startSkipFrame); // read trace frames from hardware.
   if (dataLen > 0) {
      count = 0;
      do {
         if (CheckSpaceType
             (spaceType, dqState->frameArray[(U16)curOffset].fcPin) == GOOD) {
            count++;
         }
         curOffset++;
         if (!dqState->frameMap[(U16)(curOffset/MAX_FRAME_READ)])
            AddDqStateTable(dqStateId,startSkipFrame+curOffset); // read trace frames from hardware.
         if (startSkipFrame+curOffset >= newest)
            return(!GOOD); // not find enough program frame.
      }while (count < dataLen);
   }
   else {
      count = 0;
      do {
         if (CheckSpaceType
             (spaceType, dqState->frameArray[(U16)curOffset].fcPin) == GOOD) {
            count--;
         }
         curOffset--;
         if (!dqState->frameMap[(U16)(curOffset/MAX_FRAME_READ)])
            AddDqStateTable(dqStateId,startSkipFrame+curOffset); // read trace frames from hardware.
         if (startSkipFrame+curOffset <= oldest)
            return(!GOOD); // not find enough program frame.
      }while (count > dataLen);
   }
   return(GOOD);


}

/****************************************************************************
**
** Name:  ReadTraceFrame
**
****************************************************************************/
RETCODE ReadTraceFrame
        (DESCRIPTOR dqStateId,
         S8 dataLen,
         S32 startReadFrame,
         DQ_FRAME *dqFrame,
         SPACE_TYPE spaceType){
DQ_STATE FAR *dqState;
S32 curOffset;
U8 count,frameCount;
U16 traceBuf;
S32 oldest, newest, trig;
RETCODE err;


   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadBufferGet(dqState->traceId,&traceBuf);
   memset(dqFrame,0x7f,sizeof(DQ_FRAME)); /* initialize struct */
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);

//   if ((traceBuf != dqState->traceBufId) ||  // different buffer ID.
//       ((startReadFrame/MAX_FRAME_NO) != (dqState->frameStart/MAX_FRAME_NO))) // Over 2K buffer.
     if ((startReadFrame/MAX_FRAME_NO) != (dqState->frameStart/MAX_FRAME_NO)) // Over 2K buffer.
      ReCreateDqStateTable(dqStateId,startReadFrame);
   curOffset = (startReadFrame - dqState->frameStart) % MAX_FRAME_NO;
   if (!dqState->frameMap[(U16)(curOffset/MAX_FRAME_READ)])
      AddDqStateTable(dqStateId,startReadFrame); // read trace frames from hardware.
   count = frameCount = 0;
   do {
      if (CheckSpaceType
          (spaceType, dqState->frameArray[(U16)curOffset].fcPin) == GOOD) {
         dqFrame->frameNo[count] = dqState->frameArray[(U16)curOffset].frameNo;
         dqFrame->addr[count] = dqState->frameArray[(U16)curOffset].addr;
         dqFrame->data[count] = dqState->frameArray[(U16)curOffset].data;
         dqFrame->fcPin[count] = dqState->frameArray[(U16)curOffset].fcPin;
         dqFrame->rwPin[count] = dqState->frameArray[(U16)curOffset].rwPin;
         count++;
      }
      frameCount++;
      curOffset++;
      if (!dqState->frameMap[(U16)(curOffset/MAX_FRAME_READ)])
         AddDqStateTable(dqStateId,startReadFrame+frameCount); // read trace frames from hardware.
      if (startReadFrame+frameCount >= newest)
         return(!GOOD); // not find enough program frame.
   }while (count < dataLen);
   return(GOOD);
}

/****************************************************************************
**
** Name:  ReadInstDataAndAddress
**
****************************************************************************/
RETCODE ReadInstDataAndAddress(DESCRIPTOR dqStateId,DQ_FRAME *dqFrame) {
DQ_STATE FAR *dqState;
S32 curFrame;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadFrameGet(dqState->traceId,&curFrame);
   ReadTraceFrame(dqStateId,MAX_INST_LEN + 2,curFrame,dqFrame,S_PROGRAM);
   return(GOOD);
}

/****************************************************************************
**
** Name:  CheckInterrupt
**
****************************************************************************/
INST_TYPE CheckInterrupt(DESCRIPTOR dqStateId, S32 nextFrame) {
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   ReadTraceFrame(dqState,6,nextFrame,&dqFrame,S_DATA);

   if ((dqState->frameArray[dqFrame.frameNo[0] % MAX_FRAME_NO].rwPin == 0) &&
       (dqState->frameArray[dqFrame.frameNo[1] % MAX_FRAME_NO].fcPin == F_CPU) &&
       (dqState->frameArray[dqFrame.frameNo[2] % MAX_FRAME_NO].rwPin == 0) &&
       (dqState->frameArray[dqFrame.frameNo[3] % MAX_FRAME_NO].rwPin == 0) &&
       (dqState->frameArray[dqFrame.frameNo[4] % MAX_FRAME_NO].rwPin == 1) &&
       (dqState->frameArray[dqFrame.frameNo[5] % MAX_FRAME_NO].rwPin == 1))
       return(HW_INT);
   else return(NORMAL_INST);

}
/***************************************************************************
**
**  Name: FrameNoStr(Frame)
**
**  Description:
**     convert frame# to signed-number string
**
**  Input : frame#
**
**  Return: pointer to converted string
**
****************************************************************************/
VOID FrameNoStr(S32 frame, U8 *tempStr)
{
   if (frame >= 0)  sprintf(tempStr,"+%04lX", frame);
   else             sprintf(tempStr,"-%04lX", -frame);
}  /* end of FrameNoStr() */

/****************************************************************************
**
** Name:  CheckInterrupt
**
****************************************************************************/
VOID PrintRemainsFrame(DESCRIPTOR dqStateId,
                       S32 startFrame,S32 endFrame, LPSTR string) {
S32 offset,lp;
DQ_FRAME printFrame;
U8 tempBuffer[80],tempStr[10];

   offset = endFrame - startFrame;
   ReadTraceFrame(dqStateId,offset,startFrame,&printFrame,S_DONT_CARE);
   for (lp = 0; lp < offset; lp++){
      FrameNoStr(printFrame.frameNo[lp],tempStr);
      sprintf(tempBuffer,"%05s    %08lX    %04X    %2s \n",
              tempStr,
              printFrame.addr[lp],
              printFrame.data[lp],
              spaceString[(printFrame.rwPin[lp] << 3) + printFrame.fcPin[lp]]);
      strcat((LPSTR)string,(LPSTR)tempBuffer);
   }
}

/****************************************************************************
**
** Name:  DqInst
**
****************************************************************************/
RETCODE DqInst(DESCRIPTOR id,U32 numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen) {
BOOLEAN dasmSym;
U16 trcBuffer,lp,bufferDepth;
DASM_INFO dasmInfo;
S32 oldest,newest,trig,firstFrame,nextFrame;
U32 numFrames, instNo = numInst;
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame;
RETCODE err;
LPSTR bufferPtr;
U8 tempBuffer[80],tempStr[12];


   *textLen = 0;
   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   bufferDepth = MAX_LINE_LENGTH*instNo*2;

   if ((*buffer = TMalloc(bufferDepth)) == NULL)
      return(ER_OUT_OF_MEMORY);

   bufferPtr = *buffer;
   memset(bufferPtr,'\0',bufferDepth); /* initialize string */
   if ((err = TrcFrameDisplayModeSet(dqState->traceId,TRIGGER_ALIGN))
         != GOOD) {
      TFree(*buffer);
      return err;
   }

   if ((err = DadGetDasmSymbol(&dasmSym)) != GOOD) return(err);
   *startFrame = *endFrame = 0;
   if((err=TrcNumFramesGet(dqState->traceId, &numFrames))!=GOOD)
      return(err);
   if( !numFrames ) return(GOOD); /* no frames just get out! */
   
/*
** Retrieve information about trace buffer limits and requested range
*/
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);
   if ((err = TrcReadFrameGet(dqState->traceId, &firstFrame)) != GOOD)
      return(err);
   if ((err = TrcReadBufferGet(dqState->traceId, &trcBuffer)) != GOOD)
      return(err);

   dasmInfo.bytesUsed = 0;
   for ( lp = 0; lp < instNo; lp++) {
      ReadInstDataAndAddress(id,&dqFrame);
      if (!lp) *startFrame = dqFrame.frameNo[0]; // start frame at first inst.
      FrameNoStr(dqFrame.frameNo[0],tempStr);
      sprintf(tempBuffer,"%5s    %08lX    %04X    %2s \n",
              tempStr,
              dqFrame.addr[0],
              dqFrame.data[0],
              spaceString[(dqFrame.rwPin[0] << 3) + dqFrame.fcPin[0]]);
      strcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);
      if (TraceBufInst((U16 FAR *)dqFrame.data,dqFrame.addr[0],
                       dasmSym,bufferPtr,&dasmInfo) != GOOD) break;
      else {
         wsprintf(bufferPtr+strlen(bufferPtr),"\n");
         nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
         //Read the instruction that numbers of R/W cycle
         switch (dasmInfo.instType) {
            case MODIFY_SR :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case BRANCH :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRAP :
            case ILLEGAL :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case RETURN :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRANSFER_INST :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            default :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
               if (nextFrame > newest) break;
               if (CheckInterrupt(id,nextFrame) == HW_INT) {
               // if prev inst length =2 then delete prev inst
               }
               break;
         }
         {
             // put frameNo address data status.
             // put dasm inst string.
             // bufferPtr,tempBuffer,dqFrame); // out the executed instruction.
         }

         if (nextFrame > newest) break;
         if (nextFrame > (dqFrame.frameNo[0]+1))
            PrintRemainsFrame(id,dqFrame.frameNo[0]+1,nextFrame,bufferPtr);
         TrcReadFrameSet(dqState->traceId,nextFrame);
      }
   }
   *endFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
   numInst = instNo;
   //GetStartEndFrame(startFrame,endFrame);
   *textLen = lstrlen(*buffer);
   OutputStringToFile(*buffer,*textLen);
   return(GOOD);

}

/****************************************************************************
**
** Name:  DadForwardDqInst
**
****************************************************************************/
RETCODE EXPORT DadForwardDqInst(DESCRIPTOR id,U32 numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen) {
BOOLEAN dasmSym;
U16 trcBuffer,lp,bufferDepth;
DASM_INFO dasmInfo;
S32 oldest,newest,trig,firstFrame,nextFrame;
U32 numFrames;
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame;
RETCODE err;
LPSTR bufferPtr;
U8 tempBuffer[80],tempStr[12];


   *textLen = 0;
   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   bufferDepth = MAX_LINE_LENGTH*numInst*2;

   if ((*buffer = TMalloc(bufferDepth)) == NULL)
      return(ER_OUT_OF_MEMORY);

   bufferPtr = *buffer;
   memset(bufferPtr,'\0',bufferDepth); /* initialize string */
   if ((err = TrcFrameDisplayModeSet(dqState->traceId,TRIGGER_ALIGN))
         != GOOD) {
      TFree(*buffer);
      return err;
   }

   if ((err = DadGetDasmSymbol(&dasmSym)) != GOOD) return(err);
   *startFrame = *endFrame = 0;
   if((err=TrcNumFramesGet(dqState->traceId, &numFrames))!=GOOD)
      return(err);
   if( !numFrames ) return(GOOD); /* no frames just get out! */
   
/*
** Retrieve information about trace buffer limits and requested range
*/
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);
   if ((err = TrcReadFrameGet(dqState->traceId, &firstFrame)) != GOOD)
      return(err);
   if ((err = TrcReadBufferGet(dqState->traceId, &trcBuffer)) != GOOD)
      return(err);

   dasmInfo.bytesUsed = 0;
   for ( lp = 0; lp < numInst; lp++) {
      ReadInstDataAndAddress(id,&dqFrame);
      if (!lp) *startFrame = dqFrame.frameNo[0]; // start frame at first inst.
      FrameNoStr(dqFrame.frameNo[0],tempStr);
      sprintf(tempBuffer,"%5s    %08lX    %04X    %2s \n",
              tempStr,
              dqFrame.addr[0],
              dqFrame.data[0],
              spaceString[(dqFrame.rwPin[0] << 3) + dqFrame.fcPin[0]]);
      strcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);
      if (TraceBufInst((U16 FAR *)dqFrame.data,dqFrame.addr[0],
                       dasmSym,bufferPtr,&dasmInfo) != GOOD) break;
      else {
         wsprintf(bufferPtr+strlen(bufferPtr),"\n");
         nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
         //Read the instruction that numbers of R/W cycle
         switch (dasmInfo.instType) {
            case MODIFY_SR :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case BRANCH :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRAP :
            case ILLEGAL :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case RETURN :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRANSFER_INST :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            default :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
               if (nextFrame > newest) break;
               if (CheckInterrupt(id,nextFrame) == HW_INT) {
               // if prev inst length =2 then delete prev inst
               }
               break;
         }
         {
             // put frameNo address data status.
             // put dasm inst string.
             // bufferPtr,tempBuffer,dqFrame); // out the executed instruction.
         }

         if (nextFrame > newest) break;
         if (nextFrame > (dqFrame.frameNo[0]+1))
            PrintRemainsFrame(id,dqFrame.frameNo[0]+1,nextFrame,bufferPtr);
         TrcReadFrameSet(dqState->traceId,nextFrame);
      }
   }
   *endFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
   //GetStartEndFrame(startFrame,endFrame);
   *textLen = lstrlen(*buffer);
   OutputStringToFile(*buffer,*textLen);
   return(GOOD);

}
/****************************************************************************
**
** Name:  DadBackwardDqInst
**
****************************************************************************/
RETCODE EXPORT DadBackwardDqInst(DESCRIPTOR id,U32 numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen) {
// dataLen;
//_STATE FAR *dqState;
//2 startSkipFrame;
//TCODE err;
//
// if ((dqState = (DQ_STATE FAR *)id) == NULL)
//    return (ER_DAD_INVALID_ID_DESCRIPTOR);
// if ((err = TrcReadFrameGet(dqState->traceId, &startSkipFrame)) != GOOD)
//    return(err);
// dataLen = -(U8)(AVG_INST_LEN * numInst);
// SkipTraceFrame(id,dataLen,startSkipFrame,S_PROGRAM);
// return(DqInst(id,&numInst,startFrame,endFrame,*buffer,textLen));
BOOLEAN dasmSym;
U16 trcBuffer,lp,bufferDepth;
DASM_INFO dasmInfo;
S32 oldest,newest,trig,startSkipFrame,nextFrame;
U32 numFrames;
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame;
RETCODE err;
LPSTR bufferPtr;
U8 tempBuffer[80],tempStr[12];
S8 dataLen;


   *textLen = 0;
   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   bufferDepth = MAX_LINE_LENGTH*numInst*2;

   if ((*buffer = TMalloc(bufferDepth)) == NULL)
      return(ER_OUT_OF_MEMORY);

   bufferPtr = *buffer;
   memset(bufferPtr,'\0',bufferDepth); /* initialize string */
   if ((err = TrcFrameDisplayModeSet(dqState->traceId,TRIGGER_ALIGN))
         != GOOD) {
      TFree(*buffer);
      return err;
   }

   if ((err = DadGetDasmSymbol(&dasmSym)) != GOOD) return(err);
   *startFrame = *endFrame = 0;
   if((err=TrcNumFramesGet(dqState->traceId, &numFrames))!=GOOD)
      return(err);
   if( !numFrames ) return(GOOD); /* no frames just get out! */
   
/*
** Retrieve information about trace buffer limits and requested range
*/
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);
   startSkipFrame = -3;
   if ((err = TrcReadFrameSet(dqState->traceId, startSkipFrame)) != GOOD)
      return(err);
   if ((err = TrcReadFrameGet(dqState->traceId, &startSkipFrame)) != GOOD)
      return(err);
   if ((err = TrcReadBufferGet(dqState->traceId, &trcBuffer)) != GOOD)
      return(err);
   dataLen = -(U8)(AVG_INST_LEN * numInst);
   SkipTraceFrame(id,dataLen,startSkipFrame,S_PROGRAM);

   dasmInfo.bytesUsed = 0;
   for ( lp = 0; lp < numInst; lp++) {
      ReadInstDataAndAddress(id,&dqFrame);
      if (!lp) *startFrame = dqFrame.frameNo[0]; // start frame at first inst.
      FrameNoStr(dqFrame.frameNo[0],tempStr);
      sprintf(tempBuffer,"%5s    %08lX    %04X    %2s \n",
              tempStr,
              dqFrame.addr[0],
              dqFrame.data[0],
              spaceString[(dqFrame.rwPin[0] << 3) + dqFrame.fcPin[0]]);
      strcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);
      if (TraceBufInst((U16 FAR *)dqFrame.data,dqFrame.addr[0],
                       dasmSym,bufferPtr,&dasmInfo) != GOOD) break;
      else {
         wsprintf(bufferPtr+strlen(bufferPtr),"\n");
         nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
         //Read the instruction that numbers of R/W cycle
         switch (dasmInfo.instType) {
            case MODIFY_SR :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case BRANCH :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRAP :
            case ILLEGAL :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case RETURN :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRANSFER_INST :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            default :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
               if (nextFrame > newest) break;
               if (CheckInterrupt(id,nextFrame) == HW_INT) {
               // if prev inst length =2 then delete prev inst
               }
               break;
         }
         {
             // put frameNo address data status.
             // put dasm inst string.
             // bufferPtr,tempBuffer,dqFrame); // out the executed instruction.
         }

         if (nextFrame > newest) break;
         if (nextFrame > (dqFrame.frameNo[0]+1))
            PrintRemainsFrame(id,dqFrame.frameNo[0]+1,nextFrame,bufferPtr);
         TrcReadFrameSet(dqState->traceId,nextFrame);
      }
   }
   *endFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
   //GetStartEndFrame(startFrame,endFrame);
   *textLen = lstrlen(*buffer);
   OutputStringToFile(*buffer,*textLen);
   return(GOOD);

}


/****************************************************************************
**
**  DadDqFlush
**
****************************************************************************/
#pragma argsused
RETCODE EXPORT DadDqFlush(DESCRIPTOR id) {
   return(GOOD);
}

