/****************************************************************************
**
**  Name:  heapcli.c
**
**  Description:
**     Malloc CLI commands
**
**  Status:  TESTED
**
**  $Log:   S:/tbird/arcm306/malloc/heapcli.c_v  $
** 
**    Rev 1.0   07 Sep 1995 10:41:44   gene
** Initial revision.
** 
**    Rev 1.6   13 Jul 1993 19:10:00   doug
** Errors consolidated to errtext/mkerrors.h
** 
**    Rev 1.5   05 Jan 1993 15:45:54   courtney
** Removed MemAlloc and related macros (no longer used).
** 
**    Rev 1.4   04 Dec 1992 07:29:56   doug
** added _debugHeap command support
** 
**    Rev 1.3   12 Oct 1992 10:01:24   doug
** Clean up to remove compiler warning
** 
**    Rev 1.2   30 Aug 1992 11:47:16   doug
** Now prints stats in decimal rather than in hex.
** 
**    Rev 1.1   29 Aug 1992 16:52:38   kend
** Update for Sanity Checks
** 
**    Rev 1.0   29 Aug 1992 12:13:36   doug
** Initial revision.
** 
**
**  $Header:   S:/tbird/arcm306/malloc/heapcli.c_v   1.0   07 Sep 1995 10:41:44   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef __STRING_H
#include "string.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _HEAPERRS_
#include "heaperrs.h"
#endif

#ifndef _MALDEBUG_
#include "maldebug.h"
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
STATIC HANDLE cliServerHandle = (HANDLE)NULL;  /* force definition here */

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern U32 amountAllocated;
extern U32 amountFreed;
extern BOOLEAN dynamicVerify;
extern BOOLEAN debugHeap;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/***************************************************************************
**
**  InitCServer
**
*****************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) {
   CSERVER_NEW_REGISTRATION FAR * msgBufPtr;

   cliServerHandle = cliHandle;
   msgBufPtr =
      (CSERVER_NEW_REGISTRATION FAR *)TMalloc(sizeof(CSERVER_VARIABLE_VALUE));
   if (msgBufPtr == NULL) {
      return(ER_OUT_OF_MEMORY);
   }

   msgBufPtr->stringResourceHandle = dllHandle;

   msgBufPtr->serverNameIndex = 30;
   msgBufPtr->dllNameIndex = 31;
   msgBufPtr->numberOfCommandsIndex = 32;
   msgBufPtr->commandStartIndex = 33;
   SendMessage(cliHandle, CLI_NEW_SVR_REGISTRATION, CLI_NEW_SVR_REGISTRATION,
      (DWORD)msgBufPtr);
   return(GOOD);
}

/***************************************************************************
**
**  HeapCliVerify
**
*****************************************************************************/
#pragma argsused
RETCODE EXPORT HeapCliVerify(LPSTR cmdString, U32 argc, U32 argv[]) {

   if(argc==1) {
      SendMessageToCli( (dynamicVerify ? (LPSTR)"verify on" 
	                               : (LPSTR)"verify off") ) ;
   } else if(argc==2) {
      /* set */
      if(strncmpi(&cmdString[(int)argv[1]], "on",
            strlen(&cmdString[(int)argv[1]]))==0) {
	 dynamicVerify = TRUE ;
         SendMessageToCli( (LPSTR)"verify on" );
         return(GOOD);
      } else if(strncmpi(&cmdString[(int)argv[1]], "off",
            strlen(&cmdString[(int)argv[1]]))==0) {
	 dynamicVerify = FALSE ;
         SendMessageToCli( (LPSTR)"verify off" );
         return(GOOD);
      } else if(strncmpi(&cmdString[(int)argv[1]], "now",
            strlen(&cmdString[(int)argv[1]]))==0) {
        SendMessageToCli( (dynamicVerify ? (LPSTR)"verify on" 
		                         : (LPSTR)"verify off") );
	return(GOOD);
      } else return(ER_CLI_SYNTAX);
   } else return(ER_CLI_SYNTAX);
   return(GOOD);
}

/***************************************************************************
**
**  HeapCliDebug
**
*****************************************************************************/
#pragma argsused
RETCODE EXPORT HeapCliDebug(LPSTR cmdString, U32 argc, U32 argv[]) {

   if(argc==1) {
      SendMessageToCli( (debugHeap ? (LPSTR)"debug on" 
                                   : (LPSTR)"debug off") ) ;
   } else if(argc==2) {
      /* set */
      if(strncmpi(&cmdString[(int)argv[1]], "on",
            strlen(&cmdString[(int)argv[1]]))==0) {
         debugHeap = TRUE ;
         SendMessageToCli( (LPSTR)"debug on" );
         return(GOOD);
      } else if(strncmpi(&cmdString[(int)argv[1]], "off",
            strlen(&cmdString[(int)argv[1]]))==0) {
         debugHeap = FALSE ;
         SendMessageToCli( (LPSTR)"debug off" );
         return(GOOD);
      } else return(ER_CLI_SYNTAX);
   } else return(ER_CLI_SYNTAX);
   return(GOOD);
}

/***************************************************************************
**
**  HeapCliDump
**
*****************************************************************************/
#pragma argsused
RETCODE EXPORT HeapCliDump(LPSTR cmdString, U32 argc, U32 argv[]) {
   S8 buff[80];
   
   if(argc!=1) return(ER_CLI_SYNTAX);
   wsprintf((LPSTR)buff, (LPSTR)"Allocated: %ld, Freed: %ld, Active: %ld",
      amountAllocated, amountFreed, amountAllocated-amountFreed);
   SendMessageToCli((LPSTR)buff);
   if (HeapVerify() != SUCCESS)
        SendMessageToCli((LPSTR)">>>>>The heap is corrupted.<<<<<");	   
   return(GOOD);
}

/****************************************************************************
**
**  SendMessageToCli
**
*****************************************************************************/
RETCODE SendMessageToCli(LPSTR msgPtr) {
   GLOBALHANDLE msgBufHandle;
   CSERVER_RESULTS FAR  *msgBufPtr;
   U16 msgTextSize;
   LOOP_VAR loop;

   msgTextSize = lstrlen(msgPtr);
   msgBufHandle = GlobalAlloc(GMEM_MOVEABLE, (sizeof(CSERVER_RESULTS)
     + msgTextSize + 2));
   if (msgBufHandle == (HANDLE)NULL) {
	  return(ER_OUT_OF_MEMORY);
   }
   else if((msgBufPtr=(CSERVER_RESULTS FAR *)GlobalLock(msgBufHandle)) == NULL) {
	  return(ER_WINDOWS_MEMLOCK);
   }
   /* Initialize message buffer */
   msgBufPtr->target               = 0;
   msgBufPtr->variantCode          = CLI_SERVER_RESULTS;
   msgBufPtr->resultTextLength     = msgTextSize; /* message string length */
   for (loop = 0; loop < msgTextSize; loop++ ) {
      msgBufPtr->messageText[loop]  =  *msgPtr++;
   }
   msgBufPtr->messageText[loop]  =  '\0' ;

   /* output message to memBufPtr->messageText[] */
   /*
   *** CLI Server will consume the handle when it done.
    */
   SendMessage(cliServerHandle, CLI_SERVER_RESULTS, msgBufHandle,
         (DWORD)CLI_SERVER_RESULTS );
   return (GOOD);
}

/******************************** E O F ***********************************/
