/****************************************************************************
**
**  Name:  LXLATE.C
**
**  Description:
**      Register translation services for 695 Loader (xlates 695 to TBird
**      register indices).
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm306/l695/lxlate.c_v  $
** 
**    Rev 1.0   07 Sep 1995 10:32:28   gene
** Initial revision.
** 
**    Rev 1.15   03 Aug 1993 17:49:54   nghia
** Removed LERR_xxxx to use standard error codes.
** 
**    Rev 1.14   16 Jun 1993 12:22:40   mindy
** Fixed compile problem
** 
**    Rev 1.13   16 Jun 1993 08:35:12   mindy
** Register table created differently now.  No longer allocated memory.
** Also now support register pairs.
** 
**    Rev 1.10   08 Mar 1993 11:06:54   nghia
** Cleanup for names.
** 
**    Rev 1.9   21 Oct 1992 16:39:24   courtney
** Cleaned up error reporting to use string resource.
** 
**    Rev 1.8   04 Aug 1992 09:20:32   courtney
** Do not warn for each symbol loaded that the register translation
** table is not present (warn once at start of load).
** 
**    Rev 1.7   31 Jul 1992 19:19:04   courtney
** Configuration file (register translation table) depends on processor.
**
**    Rev 1.6   22 Jul 1992 16:43:00   doug
** conversion to generic shared data
** 
**    Rev 1.5   22 Jun 1992 15:41:46   courtney
** Removed redundant include.
** 
**    Rev 1.3   15 Apr 1992 14:27:40   courtney
** Better error checking in _Rxlate.  (for PPR #5512).
** 
**    Rev 1.2   05 Feb 1992 13:24:06   courtney
** Added casts on usage of rtable; global unlock and free on table,
** not local!
** 
**    Rev 1.1   27 Jan 1992 15:51:50   courtney
** Register mapping functions now use U16 for register index type.
** 
**    Rev 1.0   15 Jan 1992 14:34:36   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arcm306/l695/lxlate.c_v   1.0   07 Sep 1995 10:32:28   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#include <stdio.h>
#include <string.h>
#include "ldr.h"

#ifndef _CPU_
#include "cpu.h"
#endif
#ifndef _LDRSVR_
#include "ldrsvr.h"
#endif
#ifndef _PROC_
#include "proc.h"
#endif
#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#include "err.h"

#define MAX_REGISTER_SUPPORTED 32
#define MAX_LINE 128
static U16 regTable[MAX_REGISTER_SUPPORTED];
static U16 nRegisters=0;

RETCODE SetupXlateTable(VOID) {
   RETCODE err;
   S8 ldrConfigFilename[32];
   FILE *ifp;  /* cpu configuration file */
   static char item[20];
   S8 cline[MAX_LINE];
   LOOP_VAR i;
   if ((err = ProcInsertCpu("ldr%s.cfg",ldrConfigFilename)) != GOOD)
       return(err);
   if ((ifp = fopen(ldrConfigFilename, "r")) == NULL) {
      WarningEx(ER_NOT_FOUND, (LPSTR)ldrConfigFilename);
      return(ER_NOT_FOUND); /* Global error code */
   }

    /* skip ahead to nRegs line in config file */
   do {
      if (fgets(cline, MAX_LINE, ifp) == NULL) return(ER_CONFIG_FILE_FORMAT);
   } while (strstr(cline, "nRegs") == NULL);
    
   /* read in number of registers */
   sscanf(cline, "%5s = %d", item, &nRegisters);
   if (nRegisters > MAX_REGISTER_SUPPORTED)
      nRegisters = MAX_REGISTER_SUPPORTED;
   for (i=0; i<nRegisters; i++) {
      REG_ID list[2], curIndex;
      if (fgets(cline, MAX_LINE, ifp) == NULL) return(ER_CONFIG_FILE_FORMAT);
      if( sscanf(cline, "%d %d", &list[0], &list[1]) == 2 ) {
         // if more than one index than we are defining a pair
         if((err=CpuRegisterMultipleRegisters(list,&curIndex))!=GOOD)
            return(err);
         list[0] = curIndex;
      }
      regTable[i] = list[0];
   }
   return(GOOD);
}

RETCODE Rxlate(U16 r695, U16 FAR *cpuRegId) {
   if( r695 > nRegisters ) {
      Warning(ER_BAD_REG_INDEX);
      return(ER_BAD_REG_INDEX);
   }
   *cpuRegId = regTable[r695];
   return(GOOD);
}

RETCODE CheckRegisterIndex(U16 r695) {
   if( r695 > nRegisters ) {
      Warning(ER_BAD_REG_INDEX);
      return(ER_BAD_REG_INDEX);
   }
   return(GOOD);
}


/******************
* End of LXLATE.C *
*******************/
