/****************************************************************************
**
** Name: trcevent.h
**
** Description:
**   Bus event setting services header file
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcm306/mpfw_306/trcevent.h_v  $
** 
**    Rev 1.0   07 Sep 1995 10:47:44   gene
** Initial revision.
**
** $Header:   S:/tbird/arcm306/mpfw_306/trcevent.h_v   1.0   07 Sep 1995 10:47:44   gene  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

#define _TRCEVENT_

		       /****************************
			*			   *
			*      INCLUDE FILES	   *
			*			   *
			****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif
#ifndef _TRCXLX_
#include "trcxlx.h"
#endif

		       /****************************
			*			   *
			*	DEFINITIONS	   *
			*			   *
			****************************/

		       /****************************
			*			   *
			*	 PROTOTYPES	   *
			*			   *
			****************************/

/******************************************************************************
**
**  SelectExternalTraceBit
**
**  Description:
**    Select one of the eight Trace-Bits to be the EXT trigger signal
**
**  Parameters:
**    input:
**      selection: identification of which one is selected
**    output:
**      <none>
**
*******************************************************************************/
VOID SelectExternalTraceBit(U8 selection);

/******************************************************************************
**
**  SetAllBusEvent
**
**  Description:
**    Modify the corresponding CLB of all bus event and reprogram Xilinx
**
**  Parameters:
**    input:
**      busEvent: pointer to event 0 structure and the following should
**              contain bus event 1, 2, 3, ... structure
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetAllBusEvent(BUS_EVENT *busEvent);

/******************************************************************************
**
**  SetAllBusEventP
**
**  Description:
**    Modify the corresponding CLB of all bus event and reprogram Xilinx
**    with PowerPack status protocal
**
**  Parameters:
**    input:
**      busEvent: pointer to event 0 structure and the following should
**              contain bus event 1, 2, 3, ... structure
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetAllBusEventP(BUS_EVENT *busEvent);

/********************************* EOF *************************************/
