/***************************************************************************
**
**  Name:  dgtlib.c
**
**  Description:
**     Michelle library routines.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/diag68k/dgtlib.c_v  $
** 
**    Rev 1.0   18 Mar 1997 15:13:14   gene
** Initial revision.
** 
**    Rev 1.0   14 Jan 1997 10:39:20   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 16:11:42   jacky
** Get file from ATL. V1.3
** 
** 
**  $Header:   S:/tbird/arcmtat2/diag68k/dgtlib.c_v   1.0   18 Mar 1997 15:13:14   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _DGT_BASE_TYPES_
#include "dgttypes.h"
#endif

#ifndef _DGT_LIB_
#include "dgtlib.h"
#endif

#ifndef _DGT_LLFW_
#include "dgtllfw.h"
#endif

#ifndef _DGT_EXTERNAL_
#include "dgtext.h"
#endif

#include <string.h>
#include <dos.h>
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/****************************************************************************
**
**  OutData
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutData(U8 dataLen, VOID *data, BOOLEAN lenFlag) {
   if (lenFlag) outputStream[outputStreamLen++] = dataLen;
   memcpy(&outputStream[outputStreamLen],data,dataLen);
   outputStreamLen += dataLen;
}

/****************************************************************************
**
**  OutMultipleData
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutMultipleData(U8 dataLen, VOID *data, U8 times) {
   outputStream[outputStreamLen++] = dataLen;
   memcpy(&outputStream[outputStreamLen],data,dataLen*times);
   outputStreamLen += dataLen*times;
}


/****************************************************************************
**
**  AddSegAddr
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
U32 AddSegAddr(U32 addr, U32 len) {
U32 segment,offset,modLen,count,segLen = 0xffff;

   count = len / segLen;
   modLen = len % segLen;
   segment = addr & 0xffff0000;
   segment += 0x10000000 * count;
   offset =  (addr & 0x0000ffff) + modLen;
   addr = segment + (offset & 0x0000ffff);
   if (offset >= 0x10000) addr += 0x10000000;
   return(addr);
}


U32 AddSegAddr2(U32 addr, U16 len) {
U32 segment,offset;

   segment = addr & 0xffff0000;
   offset =  (addr & 0x0000ffff) + len;
   addr = segment + (offset & 0x0000ffff);
   if (offset >= 0x10000) addr += 0x10000000;
   return(addr);
}
/****************************************************************************
**
**  OutputStatus
**
**  Description: output the status of executive FW to outputStream
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutputStatus(STATUS status,U8 endData) {

   outputStreamLen = sizeof(status);
   memcpy (&outputStream[0],&status,outputStreamLen);
   if (endData == ON)
      outputStream[outputStreamLen++] = 0x00;/* Output stream length */
}

/***************************************************************************
**
**  OutputErrorMessage
**
**  Description:
**
**  Parameters:
**     input:
**     output:
**
****************************************************************************/
VOID OutputErrorMessage(VOID *errorData, U8 len) {
U8 dataLen;
U16 retCode;

   retCode = *(U16 *)errorData;
   OutputStatus(retCode,OFF);
   dataLen = len;
   outputStream[outputStreamLen] = len;
   memcpy (&outputStream[outputStreamLen+1],errorData,len);
   outputStreamLen += (len+1);
   outputStream[outputStreamLen++] = 0x00; /* Output stream length */

}

/****************************************************************************
*
*  GetBits
*
*  Description:
*
*  Parameters:
*    input:
*      value     :
*      bitStart  :
*      length    :
*    output:
*      return value :
*
*****************************************************************************/
U16 GetBits(U16 value, U8 bitStart,U8 length)
{
   U16 buffer, mask;

   buffer = value >> bitStart;
   mask = 0xffff;
   mask = (mask >> (16-length));
   buffer &= mask;
   return (buffer);
}

/****************************************************************************
*
*  BitNo
*
*  Description:
*
*  Parameters:
*    input:
*      sizeNo:
*    output:
*      return:
*
*****************************************************************************/
U8 BitNo(U8 sizeNo) {
U8 bitPos,loop,bit = 0x01;

   loop = 0;
   while ((loop < 8) && ((sizeNo & (bit << loop)) <= 0)) {
      loop++;
   }
   if (loop >= 8) bitPos = 0;
   else bitPos = ++loop;
   return(bitPos);
}

/******************************** E O F ***********************************/

