/****************************************************************************
**
**  Name:  dgttypes.h
**
**  Description:
**     Primary type declarations for "Michelle" project.
**     NOTE:  This should not be included explicitly
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcmtat2/diag68k/dgttypes.h_v  $
** 
**    Rev 1.0   18 Mar 1997 15:13:24   gene
** Initial revision.
** 
**    Rev 1.1   23 Jan 1997 11:40:24   gene
** 
**    Rev 1.0   14 Jan 1997 10:39:30   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 16:11:48   jacky
** Get file from ATL. V1.3
**
**
**
**  $Header:   S:/tbird/arcmtat2/diag68k/dgttypes.h_v   1.0   18 Mar 1997 15:13:24   gene  $
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _DGT_BASE_TYPES_


		   /****************************
		    *                          *
		    *        DEFINITIONS       *
		    *                          *
		    ****************************/

#define COMMAND_ERROR              (-1)   /*  */
#define NO_TRACE_MODULE            (-2)   /*  */
#define NO_VCC                     (-3)
#define NO_EMM                     (-45)
#define DIAGNOSTIC_END             (-5)   /*  */

/* basic definitions */

#define ACK                 0x6
#define NACK                0x15
#define SPACE               0x20
#define FALSE               0x00000000
#define TRUE                !FALSE
#define YES                 TRUE
#define NO                  FALSE
#define ON                  TRUE
#define OFF                 FALSE
#define SUCCESS             0
#define GOOD                SUCCESS
#define OK                  GOOD
#define MAP_END_RECORD      0xaa55
#define BUFF_LEN             512
#define NULL                 0


/* Microsoft-style keywords */
#define PASCAL         pascal
#define EXPORT         FAR PASCAL
#define STATIC         static
#define CONST          const
#define PRIVATE        STATIC

/* primary typedef's */
typedef void           VOID;
typedef char           CHAR;
typedef far            FAR;
typedef near           NEAR;
typedef unsigned char  U8;
typedef signed   char  S8;
typedef unsigned int   U16;
typedef signed   int   S16;
typedef unsigned long  U32;
typedef signed   long  S32;
typedef unsigned int   LOOP_VAR;  /* used only as a loop index */
typedef U8             BOOLEAN;
typedef unsigned char  *STRING;
typedef S16            STATUS;
typedef U8             HW_STATUS;
typedef STATUS         ERROR;
typedef STATUS         RETCODE;
#define streamMaxLen    100  /* Maximum Stream Length */

typedef enum {
   FIRMWARE_TYPE,
   FIRMWARE_VER,
   RESERVE1,
   RESERVE2,
   RESERVE3,
   RESERVE4,
   RESERVE5,
   MAX_ID
}ID_INFO;


/* define the command ID od the Michelle firmware function */
typedef enum {
   COMMAND_START,          /* 0  -- 0x00 */
   GET_ID,                 /* 1  -- 0x1  */ // special command, must place 1st.
   INITIAL_TEST,           /* 2  -- 0x02 */
   MCE_OPEN_SHORT_TEST,    /* 3  -- 0x03 */
   MCE_PULL_HIGH_TEST,     /* 4  -- 0x04 */
   MCE_MAP_TEST,           /* 5  -- 0x05 */
   MCE_MEMORY_TEST,        /* 6  -- 0x06 */
   TEST_BC_RDATA_BUS,      /* 7  -- 0x07 */
   TEST_BC_SDATA_BUS,      /* 8  -- 0x08 */
   TEST_BC_TDATA_BUS,      /* 9  -- 0x09 */
   TEST_BC_UDATA_BUS,      /* 10 -- 0x0A */
   TEST_BC_VDATA_BUS,      /* 11 -- 0x0B */
   TEST_BC_WDATA_BUS,      /* 12 -- 0x0C */
   TEST_BC_RADDR_BUS,      /* 13 -- 0x0D */
   TEST_BC_SADDR_BUS,      /* 14 -- 0x0E */
   TEST_BC_TADDR_BUS,      /* 15 -- 0x0F */
   TEST_BC_UADDR_BUS,      /* 16 -- 0x10 */
   TEST_BC_VADDR_BUS,      /* 17 -- 0x11 */
   TEST_BC_WADDR_BUS,      /* 18 -- 0x12 */
   TEST_TB_RSDATA_BUS,     /* 19 -- 0x13 */
   TEST_TB_TUDATA_BUS,     /* 20 -- 0x14 */
   TEST_TB_TPDATA_BUS,     /* 21 -- 0x15 */
   TEST_TB_VWDATA_BUS,     /* 22 -- 0x16 */
   TEST_TB_TSDATA_BUS,     /* 23 -- 0x17 */
   TEST_TB_EVDATA_BUS,     /* 24 -- 0x18 */
   TEST_TB_RSADDR_BUS,     /* 25 -- 0x19 */
   TEST_TB_TUADDR_BUS,     /* 26 -- 0x1A */
   TEST_TB_TPADDR_BUS,     /* 27 -- 0x1B */
   TEST_TB_VWADDR_BUS,     /* 28 -- 0x1C */
   TEST_TB_TSADDR_BUS,     /* 29 -- 0x1D */
   TEST_TB_EVADDR_BUS,     /* 30 -- 0x1E */
   TEST_SEQ_RAM,           /* 31 -- 0x1F */
   MCE_CONNECT_TEST,       /* 32 -- 0x20 */  // not support
   REPEAT_DIAG,            /* All new command must add before this command. */
   END_DIAG                /* All new command must add before this command. */
} COMMAND_ID;

typedef enum {
   S_BYTE = 0, /* bit 0 */
   S_WORD = 1, /* bit 1 */
   S_LONG = 2  /* bit 2 */
} SIZE;

typedef struct {
   U8 EpAddress[4],
      EpData[2],
      EpStatus[2];
} MtatConnSignals;

typedef enum {
       MCE_8255_FAIL        = 0x01,
       DOWNLOAD_4003_FAIL   = 0x02,
       DATA_MEMORY_FAIL     = 0x04,
       MTAT_EXIST           = 0x10,
       TMAN_EXIST           = 0x20,
       EREC1_EXIST          = 0x40,
       EREC2_EXIST          = 0x80
};

/******************************* E O F ***********************************/
