/****************************************************************************
**
** Name: trclib.h
**
** Description:
**   Header file for services of MTAT
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcmtat2/diag68k/trclib.h_v  $
** 
**    Rev 1.0   18 Mar 1997 15:13:28   gene
** Initial revision.
** 
**    Rev 1.0   14 Jan 1997 10:39:34   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 16:11:04   jacky
** Get file from ATL. V1.3
**
** $Header:   S:/tbird/arcmtat2/diag68k/trclib.h_v   1.0   18 Mar 1997 15:13:28   gene  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

#define _TRCLIB_
//#define MAIN_BIN
#define DIAG_BIN

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#ifdef MAIN_BIN
   #ifndef _EMU_BASE_TYPES_
   #include "emutypes.h"
   #endif
#endif

#ifdef DIAG_BIN
   #ifndef _DGT_BASE_TYPES_
   #include "dgttypes.h"
   #endif
#endif

                       /****************************
                        *                          *
                        *       DEFINITIONS        *
                        *                          *
                        ****************************/

#define Rport       0x00
#define Sport       0x01
#define Tport       0x02
#define Uport       0x03
#define Vport       0x04
#define Wport       0x05

#define TB32K_SIZE   0x7FFF
#define TB64K_SIZE   0xFFFF
#define TB128K_SIZE  0x1FFFF

/* P0-P3 control port corresponding bit define */

#define nOEA           0x10
#define nOEX           0x08
#define nOEY           0x04
#define FSld           0x01

#define WriteP0Byte1    0xF300
#define WriteP0Byte2    0xF301
#define WriteP0Byte3    0xF302
#define WriteP0Byte4    0xF303
#define ReadP0CtrlPort  0xF304
#define P0CtrlPort      0xF307

/* P1 port address define */

#define WriteP1Byte1    0xF308
#define WriteP1Byte2    0xF309
#define WriteP1Byte3    0xF30A
#define WriteP1Byte4    0xF30B
#define ReadP1CtrlPort  0xF30C
#define P1CtrlPort      0xF30F

/* P2 port address define */

#define WriteP2Byte1    0xF310
#define WriteP2Byte2    0xF311
#define WriteP2Byte3    0xF312
#define WriteP2Byte4    0xF313
#define ReadP2CtrlPort  0xF314
#define P2CtrlPort      0xF317

/* P3 port address define */

#define WriteP3Byte1    0xF318
#define WriteP3Byte2    0xF319
#define WriteP3Byte3    0xF31A
#define WriteP3Byte4    0xF31B
#define ReadP3CtrlPort  0xF31C
#define P3CtrlPort      0xF31F

/* P4 port address define */

#define P4CtrlAX   0xF325
#define P4CtrlAY   0xF326
#define P4CtrlB    0xF327


/* MN port address define */

#define SetLo      0xF328
#define SetHi      0xF329
#define MaskLo     0xF32A
#define MaskHi     0xF32B
#define MNCtrlAX   0xF32D
#define MNCtrlAY   0xF32E

/* CPIO port address define */

#define ChgWr      0xF338

/* I/O corresponding bit define */

#define EnBCWr     0x20
#define Done       0x80

#define ERR_TRIG       0x4000
#define ERR_PIPE_DONE  0x4001
#define ERR_P4_DONE    0x4002
#define ERR_MN_DONE    0x4003
#define ERR_BC_BUS     0x4004
#define ERR_TRCBUF_BUS 0x4005

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

VOID Delay(U16 more);
VOID InitialMTAT2(VOID) ;
VOID WrBCOneAddr(U8 port,U16 addr,U16 bit,U16 data,U8 eventID) ;
VOID WrBCMaskAddr(U8 port,U16 addrmask,U16 addrset,U16 datamask,U16 dataset,
                  U16 fcnt) ;

/********************************* EOF *************************************/
