/**********************************************************************/
/*        MICEpack 68306 CAN Program Compiler                         */
/*  input : 68306 source code list file that is generated by          */
/*          2500AD 68000 S/W. ( *.LST file)                           */
/*                                                                    */
/*  output : *.DB file.                                               */
/*           for MICEpack Data file of F/W of Controller Processor    */
/*           with .DB ( define byte ) format  of Intel-86 .           */
/*                                                                    */
/*  tool :  Borland C++ v2.0                                          */
/*                                                                    */
/*  Author : Yi-tsang Tsai in Hsinchu, Taiwan 30077, R.O.C.           */
/*                         on NOV/30/1993.                            */
/*                         TEL : 1.(035) 782771                       */
/*                               2.(035) 772155 EXT. 291  (MICROTEK)  */
/**********************************************************************/
#include <stdio.h>
#include <dir.h>
#define Invalid  0
#define Valid 99
#define ERROR 9999
#define YES 0
#define NO 1
#define EMPTY -1
#define NOTFOUND -1

typedef  struct
  {
     int lenSeg;
     int nextSeg;
  } CanSeg;

/* =================================================================== */
int GetString (char inString [],int start, int end, char outString[])
{
int endOfString;
int outlength;
int inx, inx_out;

outlength = 0;
outString [0] = '\0'; /* set empty string */
endOfString = StringLength (inString) - 1;
if (endOfString < 0) return outlength;
if  (end > endOfString ) end = endOfString ;
if (start < 0 ) start = 0;
if (end < start) return outlength;
inx_out = 0;
for (inx = start ; inx <= end  ; inx += 1)
  {
      outString [inx_out] = inString [inx];
      inx_out += 1;
   }
outString [inx_out] = '\0';
outlength = inx_out;
return outlength;
}  /* End of GetString */

/* =================================================================== */

int StringLength (char string[])
{
  int length;
  length = 0;
  while (string[length] != '\0' && string[length] != '\x0A') length +=1;
  return length;
}
/* =================================================================== */
int ValidLine (char string[])
{
  int check;
  int beginChr;
  check = Invalid;

  beginChr = GetNonSpace (string);  /* get start of NonSpace char */
  if (beginChr == ERROR)  return Invalid;
  if (beginChr < 5) check = AllNum(string,beginChr);
  if (check == ERROR) check = Invalid;
  return check;
}
/* =================================================================== */
int GetNonSpace (char string[])
{
  int inxLen;
  int inx;
  inx = 0;
  inxLen = StringLength (string);
  if (inxLen == 0) return ERROR;
  while (string[inx] == ' ' &&  inx < inxLen) inx += 1;
  if ( inx == inxLen) return ERROR;
  return inx;
}
/* =================================================================== */
int AllNum(char string[],int begin)
{
   int inxLen;
   int inx;
   int retcode;

   inxLen = StringLength (string);
   if (inxLen == 0) return Invalid;
   if (inxLen < begin) return Invalid;
   retcode = Valid;
   for (inx = begin ; inx < inxLen  ; inx += 1)
   {
      if (string[inx] < '0' || string[inx] > '9') retcode = Invalid;
   }
   return retcode;
}
/* =================================================================== */
/*   Get line address of a line.                                       */
void GetLineAdd(char line[],char lineAdd[])
{
  int space;
  if (GetString (line,8,15,lineAdd) != 8) lineAdd[0] ='\0';
  space = SpaceString (lineAdd);
  if (space == YES)  lineAdd[0] ='\0';

}

/* =================================================================== */
int SpaceString (char string[])
{
  int  length;
  int  inx, space;
  length = StringLength (string);
  if (length == 0)
  {
      space = YES;
      return space;
   }
  space = YES;
  inx = 0;
  for (inx = 0; inx < length ; inx +=1)
  {
     if (string[inx] != ' ') space = NO;
   }
   return space;

}
/* =================================================================== */
void   GetLineData1(char line[],char lineData[])
{
  int space;
  if (GetString (line,19,22,lineData) != 4) lineData[0] ='\0';
  space = SpaceString (lineData);
  if (space == YES)  lineData[0] ='\0';
}
/* =================================================================== */
void   GetLineData2(char line[],char lineData[])
{
  int space;
  if (GetString (line,24,27,lineData) != 4) lineData[0] ='\0';
    space = SpaceString (lineData);
    if (space == YES)  lineData[0] ='\0';
}
/* =================================================================== */
void   GetLineData3(char line[],char lineData[])
{
  int space;
  if (GetString (line,29,32,lineData) != 4) lineData[0] ='\0';
    space = SpaceString (lineData);
    if (space == YES)  lineData[0] ='\0';
}
/* =================================================================== */
void  GetLineData4(char line[],char lineData[])
{
  int space;
  if (GetString (line,34,37,lineData) != 4) lineData[0] ='\0';
    space = SpaceString (lineData);
    if (space == YES)  lineData[0] ='\0';
}
/* =================================================================== */
void  GetRemark (char sourceCode[],char remark[])
{
    int location;
    location = SearchString (sourceCode,"\x3B") ; /* \x3B = ';' */
    if (location == NOTFOUND)
         remark[0] = '\0';                       /* set empty string.*/
    else
         GetString (sourceCode,location,512,remark);
 }

/* =================================================================== */
void GetAsm (char sourceCode[],char asmCode[])
{
    int location;
    location = SearchString (sourceCode,"\x3B") ; /* \x3B = ';' */
    if (location == NOTFOUND)
        GetString (sourceCode,0,79,asmCode);   /* all asmCode */
    else if (location == 0 )
             asmCode[0] = '\0';
         else
              {
                location -=1;
                GetString (sourceCode,0,location,asmCode);
              }
}
/* =================================================================== */
void  GetLabel (char asmCode[],char label[])
{
    int location;
    int startLocation;
    location = SearchString (asmCode,":");
    if (location == NOTFOUND) label[0] = '\0';
    else if (location == 0)
                 label[0] = '\0'; /* set Empty string */
         else
             {
                 startLocation = SearchNonSpace(asmCode,0);
                 if (startLocation != NOTFOUND)
                       GetString (asmCode,startLocation,location,label);
                 else
                       label[0] = '\0'; /* set empty string */
             }
}
/* =================================================================== */
/*       begin : start point of searching  [0..n]                     */
int SearchNonSpace (char string[],int begin)
{
  int location;
  int inx, length;
  int loopEnd;
  length = StringLength (string);
  if (length == 0 || length < (begin + 1))
     {   location = NOTFOUND;
         return location;
     }
   while ((string[begin] == ' ') && (begin < length )) begin +=1;
   if ((begin == length) && (string[begin-1] == ' '))
         location = NOTFOUND;
   else
         location = begin;
   return location;
}
/* =================================================================== */
void  GetInstruction (char asmCode[],char instruction[], char operand[])
{
  int location;
  int insBegin;
  char workString[80];
  int endins, endop;
  int opBegin;

  location = SearchString (asmCode,":");
  if (location != NOTFOUND)
     {
         location +=1;
         insBegin = SearchNonSpace(asmCode,location);
     }
  else
         insBegin = SearchNonSpace(asmCode,0);

  if (insBegin == NOTFOUND)
     {
         instruction[0] = '\0';
         operand[0] = '\0';
     }
  else
     {
         GetString(asmCode,insBegin,80,workString);
         endins = SearchString (workString," ");
         if (endins == NOTFOUND)
            {
              GetString(workString,0,80,instruction);
              operand[0] = '\0';
            }
          else
            {
                GetString(workString,0,endins-1,instruction);
                opBegin = SearchNonSpace(workString,endins);
                if (opBegin == NOTFOUND)
                       operand[0] = '\0';
                 else
                     {
                         GetString(workString,opBegin,80,operand);
                      }
            }
     }
     CutEndSpace(instruction);
     CutEndSpace(operand);
}
/* =================================================================== */
int CutEndSpace (char inString[])
{
  int length;
  int location;
  length = StringLength (inString);
  if ( length == 0)  inString[0] = '\0';
  else
      {

        location = length -1;
        while ((inString[location] == ' ' || inString[location] == '\n') && (location >= 0)) location -=1;
        if ((location >= 0) && (inString[location] != ' '&& inString[location]!='\n')) inString[location+1] = '\0';
      }
  return 0;
}
/* =================================================================== */
int SearchString (char string1[], char string2 [])
{
  int length1, length2;
  int location;
  int found;
  int maxLoop;
  int inx1,inx2;
  found = NO;
  location = NOTFOUND;
  length1 = StringLength(string1);
  length2 = StringLength(string2);
  if (length1 == 0) return location;
  if (length2 == 0) return location;
  if (length1 < length2 ) return  location;
  maxLoop = length1 - length2 + 1;
  inx1 = 0;
  while (maxLoop > 0 && found == NO)
  {
        found = YES;
        for (inx2=0; inx2 < length2 ; inx2 += 1)
           {
            if (string2 [inx2] != string1 [inx2+inx1])  found = NO;
           }
        if (found == NO) inx1 +=1;
        maxLoop -= 1;
  } /* while loop */
  if (found == YES) location = inx1;
  return location;
}    /* End of SearchString */


/* =================================================================== */
int  CapitalString (char input[], char output[])
{
  int length;
  int inx;
  length = StringLength (input);
  if (length == 0)
     {
       output[0] = '\0';
       return 0;
     }
  for (inx = 0 ; inx < length ; inx +=1)
  {
     if (input[inx] >= 'a' && input[inx] <= 'z')
         output[inx] = input[inx] - 'a' +'A';   /* get Capital character */
     else
         output[inx] = input[inx];
     output[length] = '\0'; /* set end of string */
  }
   return 0;
}
/* =================================================================== */
int GetHexAdd(char address[])
{
 char add[4];
 char strZero[] ="0";
 char strH[]= "H";
 if (SpaceString(address) == YES) return -1;
 GetString (address,6,7,add);
 AddString (strZero,add,address);
 AddString (address,strH,address);
 return 0;
}
/* =================================================================== */
int GetHexData(char word[])
{
 char strZero[] = "0";
 char strH1[] = "H, 0";
 char strH2[] = "H";
 char byte1[4];
 char byte2[4];
 if (SpaceString(word) == YES) return -1;
 GetString (word,0,1,byte1);
 GetString (word,2,3,byte2);
 AddString (strZero,byte1,word);
 AddString (word,strH1,word);
 AddString (word,byte2,word);
 AddString (word,strH2,word);
 return 0;
}
/* =================================================================== */
/*     OutStr[] = OutStr[] + InStr[]                                   */
/*                                                                     */
/*    note : \x0A = Line Feed (new Line)  ASCII code                   */
/*                                                                     */
int AddString(char InStr1[], char InStr2[], char OutStr[])
{
int i,j;
i=0;
j=0;
while (InStr1[i] != '\0' && InStr1[i] != '\x0A')
      {
         OutStr[i] = InStr1[i];
         i += 1;
      }
while (InStr2[j] != '\0' && InStr2[i] != '\x0A')
      {
        OutStr[i] = InStr2[j];
        i+= 1;
        j+= 1;
      }
OutStr[i] ='\0';
return i;
} /* End Of AddString */

/* =================================================================== */
int ChkData(char lineData1[],char lineData2[],char lineData3[],char lineData4[], int *dataNum)
{
  int data;
  data = YES; /* Data Space = Empty */
  *dataNum = 0;
  if (SpaceString (lineData1) == NO)
     {
         data = NO;
         *dataNum +=2;
     }
  if (SpaceString (lineData2) == NO)
     {
         data = NO;
         *dataNum +=2;
     }
  if (SpaceString (lineData3) == NO)
     {
         data = NO;
         *dataNum +=2;
     }
  if (SpaceString (lineData4) == NO)
     {
         data = NO;
         *dataNum +=2;
     }
  return data;
}

/* =================================================================== */
int FindString (char string1[],char string2[])
{
 char string1Cap[512];
 char string2Cap[512];
 int retCode;
 CapitalString (string1,string1Cap);
 CapitalString (string2,string2Cap);
 retCode = SearchString (string1Cap,string2Cap);
 return retCode;
}
/* =================================================================== */
int ChkLevelTemp(char line[])
{
  int location1;
  int location2;
  location1 = SearchString (line,":");
  location2 = SearchString (line,";");
  if (location1 == NOTFOUND) return NO;
  if (location2 == NOTFOUND)
      if (location1 > 0 && location1 < 31)
          {                             /* Tsai, Dec/30/1993           */
               line[location1] = ' ';   /* replace ":" character with  */
               return YES;              /*  " " space character.       */
           }
  else
      {
        if (location2 <= location1) return NO;
        else if (location1 > 0 && location1 < 31)
              {                            /* Tsai, Dec/30/1993           */
                    line[location1] = ' '; /* replace ":" character with  */
                    return YES;            /*  " " space character.       */
              }
      }
  return NO;
}

/* =================================================================== */
int Lprintf(FILE *lpo,char string[],int size)
{
  int length;
  int inx;

  length = StringLength (string);
  fprintf (lpo,"%s",string);
  if (length >= size) return 0;

  for ( inx = length+1 ;inx <= size ; inx+=1)
      fprintf (lpo," ");
  return length;
}
/***********************************************************************/
/*            Main   Program                                           */
/***********************************************************************/
void main(int argc, char *argv[])
{ /* Start Main Program */
  FILE *fpi, *fpo,*ftmp;
  struct ffblk fi;
  CanSeg canProg[500];
  char canInx;
  char driveInput[MAXDRIVE];
  char dirInput[MAXDIR];
  char fileInput[MAXFILE];
  char extInput[MAXEXT];
  char *dbOutput = ".DB";
  char *extTemp = ".TMP";
  char tempPath[MAXPATH];
  char outputPath[MAXPATH];
  char driveInf2[MAXDRIVE];
  char dirInf2[MAXDIR];
  char fileInf2[MAXFILE];
  char extInf2[MAXEXT];
  char line[600];
  char lineNum[10];
  char lineAdd[10];
  char lineData1[10];
  char lineData2[10];
  char lineData3[10];
  char lineData4[10];
  char sourceCode[600];
  char remark[600];
  char asmCode[80];
  char label[80];
  char instruction[10];
  char operand[80];
  int chkLineNum;
  char space;
  int noAsm;
  int noRem;
  int noData;
  int dataNum;
  int startSeg;
  int endSeg;
  int chkUnderLine;
  int underLabel;
  int equCode;
  int noOutputFileName;


  chkUnderLine = NO;
  space = ' ';
  /* --------------------------------------------------------- */
  /*     Check  Input  argument                                */
  /* --------------------------------------------------------- */
  if (argc < 2)
  {
     printf(" =================================================  \n");
     printf("   MICEpack 68306 CAN Program Compiler              \n");
     printf(" -------------------------------------------------  \n");
     printf("   Syntax as below :                                \n");
     printf("       CAN306  <Input.lst> <Output.db> <option/U>   \n");
     printf("                                                    \n");
     printf("   Input.lst : This file is generated by 2500AD     \n");
     printf("               X68000.                              \n");
     printf("   Output.db : This file is for MICEpack 68306      \n");
     printf("               CAN Program with *.db (define byte)  \n");
     printf("               format. Default  <Input.db> if       \n");
     printf("               Input argument is without output     \n");
     printf("               file name.                           \n");
     printf("    option   :  </U> ;                              \n");
     printf("                If the first character of label     \n");
     printf("                is under-line '_'.                  \n");
     printf("    Example :   CAN306 xcan306.lst /u  [enter]      \n");
     printf("                output file --> xcan306.db          \n");
     printf("  author : Yi-tsang Tsai  in MICROTEK  PDL          \n");
     printf("                          on NOV/30/1993            \n");
     printf(" =================================================  \n");
     exit(1);
  }
  noOutputFileName = NO;
  if (argc == 3)
     if (FindString(argv[2],"/U") == 0)
     {
        chkUnderLine = YES;
        noOutputFileName = YES;
     }
  if (argc == 4)
     {
        if (FindString(argv[3],"/U") == 0) chkUnderLine = YES;
      }
  /*-------------------------------------------------------------*/
  /*    GET INPUT FILE LOCATION                                  */
  /*-------------------------------------------------------------*/
  fnsplit(argv[1], driveInput, dirInput, fileInput , extInput);
  fnmerge(tempPath,driveInput, dirInput, fileInput , extTemp);
  fnmerge(outputPath,driveInput, dirInput, fileInput , dbOutput);
  if ((fpi =fopen(argv[1],"r+t")) == NULL)
  {
    printf("Can not open this %s input file ! \n \007", argv[1]);
    exit(1);
  }
  if (argc > 2 && noOutputFileName != YES)
  {
     fnsplit(argv[2], driveInf2, dirInf2, fileInf2 , extInf2);
     fnmerge(outputPath, driveInf2, dirInf2, fileInf2 , extInf2);
  }
  printf ("... Reading the %s file... \n",argv[1]);

  ftmp= fopen (tempPath,"w");    /* Open Output file  */
  canInx = -1;
  fgets (line,512,fpi); /* read a line message from input file */
  while (!feof(fpi))
  {
      chkLineNum = Invalid;
      if (GetString (line,0,4,lineNum) ==  5)
         chkLineNum = ValidLine (lineNum);
      if (chkLineNum == Valid)
      {
         GetLineAdd(line,lineAdd);
         GetLineData1(line,lineData1);
         GetLineData2(line,lineData2);
         GetLineData3(line,lineData3);
         GetLineData4(line,lineData4);
         GetString (line,40,512,sourceCode);/* get sourceCode */
         GetRemark (sourceCode,remark);
         GetAsm (sourceCode,asmCode);
         GetLabel (asmCode,label);
         GetInstruction (asmCode,instruction,operand);
         noAsm = SpaceString (asmCode);
         noRem = SpaceString (remark);
         if ((noAsm == YES) && (noRem == NO))
             fprintf(ftmp,"%s\n",remark);

         noData = ChkData(lineData1,lineData2,lineData3,lineData4,&dataNum);

         endSeg = NO;

         if(FindString (remark,"&&end") != NOTFOUND) endSeg = YES;
         startSeg = NO;

         /* don't care EQU instruction */
         equCode = NO;
         if (FindString (instruction,"equ") !=NOTFOUND)
         {
              equCode = YES;
              dataNum = 0;
              fprintf (ftmp,"; ");
              Lprintf(ftmp,label,20);
              Lprintf(ftmp,instruction,10);
              Lprintf(ftmp,operand,10);
              Lprintf(ftmp,remark,40);
              fprintf(ftmp,"\n");
         }

         if (noAsm == NO && equCode ==NO )
         {
                 underLabel = YES;
                 if ((chkUnderLine == YES) && (SearchString(label,"_") !=0))
                         underLabel =NO;

                 if (underLabel == YES) Lprintf(ftmp,label,21);
                    else   fprintf (ftmp,"%21c",space);

                 if ((StringLength (lineAdd) != 0) && (SpaceString (label) != 0) && (underLabel == YES))
                              {
                                 startSeg = YES;
                                 GetHexAdd (lineAdd);
                                 fprintf(ftmp,"DB  %4s", lineAdd);
                                 if (noData == NO)
                                     fprintf(ftmp,"\n%20c DB ",space);
                                 printf(".");
                              }
                      else  if (noData == NO )
                                 fprintf(ftmp,"DB ");
                            else fprintf(ftmp,"   ");

                 GetHexData (lineData1);
                 if  (StringLength (lineData1) != 0)
                                 fprintf(ftmp,"%11s",lineData1);
                       else
                                 fprintf(ftmp,"%11c",space);
                 GetHexData (lineData2);
                 if  (StringLength (lineData2) != 0)
                                 fprintf(ftmp,",%11s",lineData2);
                       else
                                 fprintf(ftmp,"%12c",space);
                 GetHexData (lineData3);
                 if  (StringLength (lineData3) != 0)
                                 fprintf(ftmp,",%11s",lineData3);
                       else
                                 fprintf(ftmp,"%12c",space);
                 GetHexData (lineData4);
                 if  (StringLength (lineData4) != 0)
                                 fprintf(ftmp,",%11s",lineData4);
                       else
                                 fprintf(ftmp,"%12c",space);
                 if  (StringLength(instruction) !=0)
                                 {
                                     fprintf(ftmp,"; ");
                                     Lprintf(ftmp,instruction,10);
                                 }
                       else     if (SpaceString(operand)==NO)
                                    fprintf(ftmp,";%10c ",space);
                  Lprintf(ftmp,operand,20);
                  fprintf(ftmp,"\n");
          }
        if (startSeg == YES)
            {
              canInx +=1;
              canProg[canInx].lenSeg =  dataNum;
              canProg[canInx].nextSeg = YES;
             }
         if (endSeg == YES)
            {
               if (startSeg == NO)  canProg[canInx].lenSeg +=  dataNum;
               canProg[canInx].nextSeg = NO;
             }
        if (endSeg == NO && startSeg == NO)
            canProg[canInx].lenSeg +=  dataNum;
      }

      fgets (line,512,fpi); /* read a line message from input file */
  }

  fclose(fpi);
  fclose(ftmp);

  printf ("\n......Write data to %s file ....... \n",outputPath);
  /******************************************************************/
  /*      Add the Segment & Next Segment Flag to output file        */
  /******************************************************************/
  fpo = fopen (outputPath,"w");    /* Open Output file  */
  ftmp= fopen (tempPath,"r+t");    /* Open Output file  */
  fgets (line,512,ftmp); /* read a line message from temp file */
  canInx = 0;
  while (!feof(ftmp))
  {

    if (ChkLevelTemp(line) == YES)
       {
          printf("*");
          CutEndSpace(line);
          fprintf (fpo,"%s,",line);
          if (canProg[canInx].lenSeg > 15)
               fprintf (fpo," 0%2xH,",canProg[canInx].lenSeg);
          else
               fprintf (fpo," 00%1xH,",canProg[canInx].lenSeg);

          if (canProg[canInx].nextSeg == YES)
               fprintf (fpo," 001H");
           else
               fprintf (fpo," 000H");
           fprintf (fpo,"%29c ; Address offset,length,next :Yes[1]/No[0]\n",space);
           canInx +=1;
       }

    else
        fprintf (fpo,"%s",line);
   fgets (line,512,ftmp); /* read a line message from temp file */
   }
  fclose(ftmp);
  fclose(fpo);
  remove(tempPath); /* remove temp file */
  printf(" \n Finished !!" );
} /* End of Main Program */
