/****************************************************************************
**
**  Name:  emucomm.h
**
**  Description:
**     Michelle MICE data/command communication routines.
**     include:
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/m302/emucomm.h_v  $
** 
**    Rev 1.0   12 Feb 1997 14:21:32   gene
** Initial revision.
** 
**    Rev 1.0   10 Jun 1996 08:50:26   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:47:16   gene
** Initial revision.
** 
** Initial revision.
** 
**  $Header:   S:/tbird/arcmtat2/m302/emucomm.h_v   1.0   12 Feb 1997 14:21:32   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_COMM_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *      DEFINITIONS         *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *       PROTOTYPES         *
                         *                          *
                         ****************************/

/****************************************************************************
**
**  ReceiveByte
**
**  Description: Receive one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
U8 ReceiveByte(VOID);


/****************************************************************************
**
**  CommRecover
**
**  Description: Initialize communication point and size.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID CommRecover(VOID);

/****************************************************************************
**
**  TransmitByte
**
**  Description: Transmit one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID TransmitByte(U8 c);

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID ReceiveStream(VOID);

/****************************************************************************
**
**  TransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID TransmitStream(VOID);

/****************************************************************************
**
**  ReceiveEsc
**
**  Description: Receive ESC from communication
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
STATUS ReceiveEsc(VOID);
/******************************** E O F ***********************************/
